/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.geom.RoundRectangle2D;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.AbstractBorder;
import lombok.Generated;
import se.prediktera.breeze.frontend.common.swing.BreezeTheme;
import se.prediktera.breeze.frontend.common.util.ImageHelper;

public class RoundedTitledBorder
extends AbstractBorder {
    private String title;
    private ImageIcon icon = null;
    private boolean isActive;
    private final int cornerRadius;

    public RoundedTitledBorder(String string, int n) {
        this.title = string;
        this.cornerRadius = n;
    }

    @Override
    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        super.paintBorder(component, graphics, n, n2, n3, n4);
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int n5 = graphics2D.getFontMetrics().getHeight() / 2 + 2;
        BreezeTheme breezeTheme = BreezeTheme.getInstance();
        graphics2D.setColor(breezeTheme.getPanelBackground());
        graphics2D.setFont(new Font("Tahoma", 0, 12));
        graphics2D.fill(new RoundRectangle2D.Double(n + 3, n2 + n5 + 3, n3 - 7, n4 - 7 - n5, this.cornerRadius, this.cornerRadius));
        if (this.isActive) {
            graphics2D.setColor(breezeTheme.getActiveGlow());
            graphics2D.setStroke(new BasicStroke(6.0f));
            graphics2D.setFont(graphics2D.getFont().deriveFont(1));
        } else {
            graphics2D.setColor(breezeTheme.getLabelForegroundMoreDifuse());
        }
        graphics2D.draw(new RoundRectangle2D.Double(n, n2 + n5, n3 - 1, n4 - 1 - n5, this.cornerRadius, this.cornerRadius));
        int n6 = graphics2D.getFontMetrics().stringWidth(this.title) + 10;
        int n7 = graphics2D.getFontMetrics().getHeight() + 4;
        int n8 = this.icon != null ? this.icon.getIconWidth() + 5 : 0;
        int n9 = this.cornerRadius * 2;
        graphics2D.setColor(breezeTheme.getPanelBackground());
        graphics2D.fillRoundRect(n + 10, n2, n6 + n8, n7, n9, n9);
        graphics2D.setColor(breezeTheme.getLabelForeground());
        if (this.icon != null) {
            int n10 = n2 + (n7 - this.icon.getIconHeight()) / 2 + 4;
            this.icon.paintIcon(component, graphics2D, n + 10 + 4, n10);
            FontMetrics fontMetrics = graphics2D.getFontMetrics();
            int n11 = n2 + (n7 + fontMetrics.getAscent() - fontMetrics.getDescent()) / 2 + 4;
            graphics2D.drawString(this.title, n + 10 + this.icon.getIconWidth() + 8, n11);
        } else {
            FontMetrics fontMetrics = graphics2D.getFontMetrics();
            int n12 = n2 + (n7 + fontMetrics.getAscent() - fontMetrics.getDescent()) / 2 + 4;
            graphics2D.drawString(this.title, n + 10 + 4, n12);
        }
        graphics2D.dispose();
    }

    @Override
    public Insets getBorderInsets(Component component) {
        return new Insets(25, 10, 10, 10);
    }

    static void main() {
        SwingUtilities.invokeLater(() -> {
            JFrame jFrame = new JFrame("Rounded Titled Border Test");
            jFrame.setDefaultCloseOperation(3);
            jFrame.setSize(400, 300);
            jFrame.setLayout(new BorderLayout());
            JPanel jPanel = new JPanel();
            jPanel.setPreferredSize(new Dimension(350, 200));
            jPanel.setOpaque(false);
            jPanel.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
            JPanel jPanel2 = new JPanel();
            RoundedTitledBorder roundedTitledBorder = new RoundedTitledBorder("Test Title", 6);
            roundedTitledBorder.setIcon(ImageHelper.getResourceIcon("material/report"));
            roundedTitledBorder.setActive(true);
            jPanel2.setOpaque(false);
            jPanel2.setBorder(roundedTitledBorder);
            jPanel2.setPreferredSize(new Dimension(300, 150));
            jPanel.add(jPanel2);
            jFrame.add((Component)jPanel, "Center");
            jFrame.pack();
            jFrame.setLocationRelativeTo(null);
            jFrame.setVisible(true);
        });
    }

    @Generated
    public void setTitle(String string) {
        this.title = string;
    }

    @Generated
    public void setIcon(ImageIcon imageIcon) {
        this.icon = imageIcon;
    }

    @Generated
    public void setActive(boolean bl) {
        this.isActive = bl;
    }
}

