/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import lombok.Generated;
import se.prediktera.breeze.common.util.Time;
import se.prediktera.breeze.frontend.FilledRoundedBorder;
import se.prediktera.breeze.frontend.common.swing.BreezeTheme;
import se.prediktera.breeze.frontend.common.util.ImageHelper;
import se.prediktera.map.common.error.Logg;

public class Toast
extends JDialog {
    private final boolean windowTranslucencySupported;
    private final String msg;
    private final Map<String, Integer> toastStackLocations;
    private static final ImageIcon INFO_ICON = ImageHelper.getResourceIcon("information", false);
    private static final ImageIcon SUCCESS_ICON = ImageHelper.getResourceIcon("confirm", false);
    private static final ImageIcon ERROR_ICON = ImageHelper.getResourceIcon("error", false);
    private static final ImageIcon WARNING_ICON = ImageHelper.getResourceIcon("warning", false);
    public static final Time DURATION = new Time.Seconds(2.0);
    private int stackLocation;
    private transient Timer moveTimer;
    private boolean clicked;

    private Toast(JFrame jFrame, String string, IconType iconType, Map<String, Integer> map, boolean bl) {
        super((Frame)jFrame, false);
        this.msg = string;
        this.toastStackLocations = map;
        this.stackLocation = map.getOrDefault(string, 0);
        this.setUndecorated(true);
        this.setLayout(new GridBagLayout());
        this.setAlwaysOnTop(true);
        this.setBackground(new Color(0, 0, 0, 0));
        JLabel jLabel = new JLabel();
        jLabel.setIcon(Toast.getIcon(iconType));
        JLabel jLabel2 = new JLabel(string + "  ");
        jLabel2.setForeground(Color.black);
        jLabel2.setFont(new Font("Tahoma", 0, 12));
        JPanel jPanel = (JPanel)this.getContentPane();
        jPanel.setLayout(new GridBagLayout());
        jPanel.setBorder(new FilledRoundedBorder(this.getColor(iconType), 2, 12));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.fill = 1;
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        jPanel.add((Component)jLabel2, gridBagConstraints);
        this.pack();
        this.setFocusableWindowState(false);
        this.setNewLocation();
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice graphicsDevice = graphicsEnvironment.getDefaultScreenDevice();
        this.windowTranslucencySupported = graphicsDevice.isWindowTranslucencySupported(GraphicsDevice.WindowTranslucency.TRANSLUCENT);
        if (!bl && this.windowTranslucencySupported) {
            this.setOpacity(0.9f);
        }
        this.setCursor(new Cursor(12));
    }

    @Override
    public void dispose() {
        final float f = this.getOpacity();
        final Timer timer = new Timer(16, null);
        final int n = this.clicked ? 100 : 300;
        timer.addActionListener(new ActionListener(){
            private final long startTime = System.currentTimeMillis();
            final /* synthetic */ Toast this$0;
            {
                this.this$0 = toast;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                long l = System.currentTimeMillis() - this.startTime;
                float f4 = Math.min(1.0f, (float)l / (float)n);
                if (this.this$0.windowTranslucencySupported) {
                    float f2 = 1.0f - (float)Math.pow(1.0f - f4, 3.0);
                    float f3 = f * (1.0f - f2);
                    this.this$0.setOpacity(Math.max(0.0f, Math.min(1.0f, f3)));
                }
                if (f4 >= 1.0f) {
                    timer.stop();
                    this.this$0.setVisible(false);
                    Toast.super.dispose();
                }
            }
        });
        timer.setInitialDelay(0);
        timer.start();
    }

    public void updateStackLocation() {
        Integer n;
        int n2 = this.getStackLocation();
        if (n2 > (n = this.toastStackLocations.get(this.msg))) {
            this.setStackLocation(n);
            int n3 = this.getOwner().getY();
            final int n4 = n3 + 109 + 65 * n2;
            final int n5 = n3 + 109 + 65 * n;
            int n6 = n2 - n;
            final int n7 = 160 * n6;
            if (this.moveTimer != null) {
                this.moveTimer.stop();
            }
            this.moveTimer = new Timer(16, new ActionListener(){
                private final long startTime = System.currentTimeMillis();
                final /* synthetic */ Toast this$0;
                {
                    this.this$0 = toast;
                }

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    long l = System.currentTimeMillis() - this.startTime;
                    float f = Math.min(1.0f, (float)l / (float)n7);
                    double d = 1.0 - Math.pow(1.0f - f, 3.0);
                    int n = n4 + (int)((double)(n5 - n4) * d);
                    this.this$0.setLocation(this.this$0.getLocation().x, n);
                    if (f >= 1.0f) {
                        this.this$0.setLocation(this.this$0.getLocation().x, n5);
                        this.this$0.moveTimer.stop();
                    }
                }
            });
            this.moveTimer.setInitialDelay(0);
            this.moveTimer.start();
        }
    }

    private void setNewLocation() {
        try {
            Window window = this.getOwner();
            this.setLocation(window.getX() + window.getWidth() - this.getWidth() - 12, window.getY() + 109 + 65 * this.getStackLocation());
        }
        catch (Exception exception) {
            Logg.error((String)"Error setting location on toaster", (Throwable)exception);
        }
    }

    public void setClicked() {
        this.clicked = true;
    }

    public static Toast createAndDisplayToast(JFrame jFrame, String string, IconType iconType, Map<String, Integer> map, boolean bl) {
        Toast toast = new Toast(jFrame, string, iconType, map, bl);
        SwingUtilities.invokeLater(() -> toast.setVisible(true));
        return toast;
    }

    private static ImageIcon getIcon(IconType iconType) {
        return switch (iconType.ordinal()) {
            case 2 -> ERROR_ICON;
            case 1 -> WARNING_ICON;
            case 3 -> SUCCESS_ICON;
            default -> INFO_ICON;
        };
    }

    private Color getColor(IconType iconType) {
        return switch (iconType.ordinal()) {
            case 1 -> BreezeTheme.getInstance().getWarningBackgroundColor();
            case 2 -> BreezeTheme.getInstance().getErrorBackgroundColor();
            case 3 -> BreezeTheme.getInstance().getSuccessBackgroundColor();
            default -> BreezeTheme.getInstance().getInfoBackgroundColor();
        };
    }

    @Generated
    public boolean isWindowTranslucencySupported() {
        return this.windowTranslucencySupported;
    }

    @Generated
    public String getMsg() {
        return this.msg;
    }

    @Generated
    public Map<String, Integer> getToastStackLocations() {
        return this.toastStackLocations;
    }

    @Generated
    public int getStackLocation() {
        return this.stackLocation;
    }

    @Generated
    public Timer getMoveTimer() {
        return this.moveTimer;
    }

    @Generated
    public boolean isClicked() {
        return this.clicked;
    }

    @Generated
    private void setStackLocation(int n) {
        this.stackLocation = n;
    }

    public static enum IconType {
        Info,
        Warning,
        Error,
        Success;

    }
}

