/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import javax.swing.JFrame;
import net.jodah.expiringmap.ExpirationPolicy;
import net.jodah.expiringmap.ExpiringMap;
import se.prediktera.breeze.common.util.Time;
import se.prediktera.breeze.common.util.thread.ThreadUtil;
import se.prediktera.breeze.frontend.BreezeFrame;
import se.prediktera.breeze.frontend.Toast;
import se.prediktera.breeze.frontend.common.entry.EntryMainHelper;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.common.error.Logg;

public class ToastHandler {
    private static ToastHandler instance;
    private ExpiringMap<String, Toast> toasts = null;
    private final Map<String, Integer> toastStackLocations = Collections.synchronizedMap(new HashMap());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void allocateStackIndexAndPut(String string) {
        Map<String, Integer> map = this.toastStackLocations;
        synchronized (map) {
            HashSet<Integer> hashSet = new HashSet<Integer>(this.toastStackLocations.values());
            int n = 0;
            while (hashSet.contains(n)) {
                ++n;
            }
            this.toastStackLocations.put(string, n);
        }
    }

    private ToastHandler() {
        this.toasts = ExpiringMap.builder().expirationListener((string, toast) -> {
            Map<String, Integer> map = this.toastStackLocations;
            synchronized (map) {
                Object object = this.toastStackLocations.remove(string);
                for (Map.Entry<String, Integer> entry : this.toastStackLocations.entrySet()) {
                    if (entry.getValue() <= (Integer)object) continue;
                    entry.setValue(entry.getValue() - 1);
                }
            }
            toast.dispose();
            if (this.toasts.isEmpty()) {
                return;
            }
            for (Object object : this.toasts.entrySet()) {
                ((Toast)object.getValue()).updateStackLocation();
            }
        }).maxSize(10).expirationPolicy(ExpirationPolicy.CREATED).variableExpiration().build();
    }

    public static synchronized ToastHandler getInstance() {
        if (instance == null) {
            instance = new ToastHandler();
        }
        return instance;
    }

    public void showToast(String string) {
        this.showToast(BreezeFrame.getInstance(), string, Toast.IconType.Info, Toast.DURATION);
    }

    public void showToast(String string, Toast.IconType iconType) {
        this.showToast(BreezeFrame.getInstance(), string, iconType, Toast.DURATION);
    }

    public void showToast(String string, Time time) {
        this.showToast(BreezeFrame.getInstance(), string, Toast.IconType.Info, time);
    }

    public void showToast(String string, Toast.IconType iconType, Time time) {
        this.showToast(BreezeFrame.getInstance(), string, iconType, time);
    }

    public void showToast(JFrame jFrame, String string) {
        this.showToast(jFrame, string, Toast.IconType.Info, Toast.DURATION);
    }

    public void showToast(JFrame jFrame, String string, Toast.IconType iconType, Time time) {
        this.showToast(jFrame, string, iconType, time, null);
    }

    public void showToast(JFrame jFrame, final String string, Toast.IconType iconType, Time time, final EntryMainHelper.ClickCallBack clickCallBack) {
        if (jFrame == null || this.toasts.containsKey((Object)string)) {
            return;
        }
        try {
            this.allocateStackIndexAndPut(string);
            final Toast toast = Toast.createAndDisplayToast(jFrame, string, iconType, this.toastStackLocations, clickCallBack != null);
            toast.addMouseListener(new MouseAdapter(this){
                final /* synthetic */ ToastHandler this$0;
                {
                    this.this$0 = toastHandler;
                }

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    toast.setClicked();
                    this.this$0.toasts.setExpiration((Object)string, 0L, TimeUnit.MILLISECONDS);
                    if (clickCallBack != null) {
                        clickCallBack.doClick();
                    }
                }
            });
            this.toasts.put((Object)string, (Object)toast, time.ms + 100L, TimeUnit.MILLISECONDS);
        }
        catch (Throwable throwable) {
            Logg.error((String)"Error showing toast", (Throwable)throwable);
        }
    }

    private static Toast.IconType getType(int n) {
        return switch (n) {
            case 1 -> Toast.IconType.Warning;
            case 2 -> Toast.IconType.Error;
            case 3 -> Toast.IconType.Success;
            default -> Toast.IconType.Info;
        };
    }

    public void clearToast(String string) {
        if (this.toasts.containsKey((Object)string)) {
            ((Toast)this.toasts.get((Object)string)).setClicked();
            this.toasts.setExpiration((Object)string, 0L, TimeUnit.MILLISECONDS);
        }
    }

    public static void main(String[] stringArray) {
        Random random = new Random();
        JFrame jFrame = new JFrame("JFrame Example");
        jFrame.setDefaultCloseOperation(3);
        jFrame.setSize(600, 600);
        jFrame.setLocationRelativeTo(null);
        jFrame.setVisible(true);
        new Thread(() -> {
            int n = 0;
            while (true) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(n);
                stringBuilder.append(".");
                int n2 = 0;
                while ((double)n2 < random.nextDouble() * 100.0) {
                    stringBuilder.append("A");
                    ++n2;
                }
                ToastHandler.getInstance().showToast(jFrame, stringBuilder.toString(), ToastHandler.getType(random.nextInt(4)), new Time.Seconds((double)(2 + random.nextInt(4))));
                ThreadUtil.sleep(500L);
                if (random.nextBoolean()) {
                    ToastHandler.getInstance().clearToast(stringBuilder.toString());
                    System.out.println("Clear Toast - " + n);
                }
                ++n;
            }
        }).start();
    }

    public static class ToasterMessageException
    extends ErrorHandler.InformationMessageException {
        private final Toast.IconType type;

        public ToasterMessageException(String string) {
            this(string, Toast.IconType.Info);
        }

        public ToasterMessageException(String string, Toast.IconType iconType) {
            super(string, "");
            this.type = iconType;
        }

        public void showToast(BreezeFrame breezeFrame) {
            ToastHandler.getInstance().showToast(breezeFrame, this.getMessage(), this.type, Toast.DURATION);
        }
    }
}

