/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.client;

import java.util.ArrayList;
import java.util.List;
import se.prediktera.breeze.BreezeClient;
import se.prediktera.breeze.common.entry.BreezeType;
import se.prediktera.breeze.common.util.BreezeProgress;
import se.prediktera.breeze.entry.application.status.StatusList;
import se.prediktera.breeze.entry.workflow.Workflow;
import se.prediktera.breeze.frontend.BreezeFrame;
import se.prediktera.breeze.frontend.client.RecordingsPanel;
import se.prediktera.breeze.frontend.client.select.RuntimeWorkflowSelectionPanel;
import se.prediktera.breeze.frontend.client.select.active.ActiveRuntimeWorkflowPanel;
import se.prediktera.breeze.frontend.common.entry.EntryMainPanel;
import se.prediktera.breeze.frontend.common.util.BreezeProperties;
import se.prediktera.breeze.frontend.main.MainClass;
import se.prediktera.breeze.frontend.main.MainPanel;
import se.prediktera.breeze.frontend.main.settings.MaintenancePanel;
import se.prediktera.breeze.hardware.Camera;
import se.prediktera.breeze.hardware.HardwareRegistry;
import se.prediktera.breeze.hardware.tcp.TcpManager;
import se.prediktera.map.common.update.UpdateHelper;

public class ClientMainPanel
extends MainPanel {
    private final boolean includeObjectShape;
    private boolean breezeClientIsMaster = false;

    public ClientMainPanel(BreezeFrame breezeFrame, BreezeClient.CommandLineClientArgs commandLineClientArgs) {
        super(breezeFrame);
        this.includeObjectShape = commandLineClientArgs.isIncludeObjectShape();
    }

    @Override
    protected void updateTheme() {
        super.updateTheme();
    }

    @Override
    public EntryMainPanel createEntryMainPanel(BreezeProgress breezeProgress, BreezeType breezeType, Workflow workflow) {
        return switch (breezeType) {
            case BreezeType.Recordings -> new RecordingsPanel(breezeProgress, this.frame);
            case BreezeType.Connect -> this.connectAndCreatePanel(breezeProgress);
            case BreezeType.Settings -> new MaintenancePanel(breezeProgress, this.frame);
            default -> null;
        };
    }

    private EntryMainPanel connectAndCreatePanel(BreezeProgress breezeProgress) {
        breezeProgress.setInfoText("Connecting to Breeze Runtime");
        List<StatusList.CameraStatus> list = this.checkStatusAndInitializeRemoteCameras(breezeProgress);
        List<Camera> list2 = ClientMainPanel.getCameras(list);
        if (!this.breezeClientIsMaster && !list.isEmpty() && list.getFirst().status().hasLoadedWorkflow()) {
            return new ActiveRuntimeWorkflowPanel(this.frame, list2, TcpManager.getInstance().getWorkflowSetup(), this.breezeClientIsMaster, this.includeObjectShape);
        }
        this.breezeClientIsMaster = true;
        return new RuntimeWorkflowSelectionPanel(this.frame, TcpManager.getInstance().getWorkflows(), list2, this.includeObjectShape);
    }

    public List<StatusList.CameraStatus> checkStatusAndInitializeRemoteCameras(BreezeProgress breezeProgress) {
        int n = TcpManager.getInstance().getPropertyInt("NumberOfCameras");
        if (n > 0) {
            ArrayList<StatusList.CameraStatus> arrayList = new ArrayList<StatusList.CameraStatus>();
            for (int i = 0; i < n; ++i) {
                arrayList.add(TcpManager.getInstance().checkStatusAndInitializeRemoteCamera(breezeProgress, i));
            }
            return arrayList;
        }
        ArrayList<StatusList.CameraStatus> arrayList = new ArrayList<StatusList.CameraStatus>();
        List<Camera> list = HardwareRegistry.getInstance().getCamerasForRecord();
        for (Camera camera : list) {
            if (camera == null) continue;
            arrayList.add(TcpManager.getInstance().checkStatusAndInitializeRemoteCamera(breezeProgress, camera.getId()));
        }
        return arrayList;
    }

    private static List<Camera> getCameras(List<StatusList.CameraStatus> list) {
        if (list.size() > 1) {
            Camera.MultiCameraMode multiCameraMode = Camera.MultiCameraMode.parse(TcpManager.getInstance().getProperty("MultiCameraMode"));
            if (multiCameraMode.equals((Object)Camera.MultiCameraMode.SeparateFiles)) {
                ArrayList<Camera> arrayList = new ArrayList<Camera>();
                for (StatusList.CameraStatus cameraStatus : list) {
                    arrayList.add(cameraStatus.camera());
                }
                return arrayList;
            }
            if (multiCameraMode.isMulti()) {
                return List.of(list.getFirst().camera());
            }
            if (multiCameraMode.isSingle()) {
                Camera.MultiCameraSetting multiCameraSetting = BreezeProperties.getInstance().getMultiCameraSetting();
                return List.of(list.get(multiCameraSetting.index()).camera());
            }
        } else if (list.size() == 1) {
            return List.of(list.getFirst().camera());
        }
        return new ArrayList<Camera>();
    }

    @Override
    protected UpdateHelper.Product getProduct() {
        return UpdateHelper.Product.BreezeRuntimeClient;
    }

    @Override
    protected List<MainClass> createMainList() {
        ArrayList<MainClass> arrayList = new ArrayList<MainClass>();
        arrayList.add(new MainClass(BreezeType.Connect, "Connect to Runtime"));
        arrayList.add(new MainClass(BreezeType.Recordings, "View runtime recordings"));
        return arrayList;
    }
}

