/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.client;

import java.awt.Image;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import javax.swing.ImageIcon;
import se.prediktera.breeze.backend.WorkspaceManager;
import se.prediktera.breeze.backend.realtime.RtFramePredictor;
import se.prediktera.breeze.common.entry.BasicEntry;
import se.prediktera.breeze.common.entry.BreezeType;
import se.prediktera.breeze.common.util.BreezeProgress;
import se.prediktera.breeze.common.util.FileHelper;
import se.prediktera.breeze.common.util.xmlproperties.XmlParserHelper;
import se.prediktera.breeze.entry.group.Group;
import se.prediktera.breeze.entry.measurement.Measurement;
import se.prediktera.breeze.entry.workflow.Workflow;
import se.prediktera.breeze.frontend.BreezeFrame;
import se.prediktera.breeze.frontend.BreezeMainPanel;
import se.prediktera.breeze.frontend.common.entry.EntryMainHelper;
import se.prediktera.breeze.frontend.common.entry.EntryMainItemPanel;
import se.prediktera.breeze.frontend.common.entry.EntryMainPanel;
import se.prediktera.breeze.frontend.common.entry.EntryOverviewPanel;
import se.prediktera.breeze.frontend.common.entry.OpenEntryProgressAction;
import se.prediktera.breeze.frontend.common.swing.BreezeButton;
import se.prediktera.breeze.frontend.common.swing.BreezeComboBoxInputField;
import se.prediktera.breeze.frontend.common.swing.BreezeLabelField;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressDialog;
import se.prediktera.breeze.frontend.common.view.MeasurementViewPanel;
import se.prediktera.breeze.frontend.common.view.ViewClass;
import se.prediktera.breeze.frontend.common.view.preview.MeasurementPopup;
import se.prediktera.breeze.frontend.main.record.measurement.panel.MetaPanel;
import se.prediktera.breeze.frontend.main.record.measurement.panel.PixelExplorePanel;
import se.prediktera.breeze.frontend.main.record.measurement.panel.SpectralPanel;
import se.prediktera.breeze.test.stubs.GroupWithoutIO;

public class RecordingsPanel
extends EntryMainItemPanel {
    private final Workflow workflow;

    public RecordingsPanel(BreezeProgress breezeProgress, BreezeFrame breezeFrame) {
        super(breezeFrame, BreezeType.Recordings, "Recordings", true, true);
        ArrayList<ViewClass> arrayList = new ArrayList<ViewClass>();
        arrayList.add(new ViewClass("Overview", new RecordingsOverviewPanel(this)));
        File file = WorkspaceManager.getInstance().getWorkspace().getRuntimeMeasurementsPath();
        this.workflow = new Workflow(this, "root", file){

            @Override
            public void save() {
            }
        };
        this.workflow.setModellingExplorePixel(false);
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            for (File file2 : fileArray) {
                if (!file2.isDirectory()) continue;
                GroupWithoutIO groupWithoutIO = new GroupWithoutIO(file2.getName(), this.workflow);
                groupWithoutIO.getEntryData().setCreatedDate(FileHelper.getCreationDate(file2));
                groupWithoutIO.getEntryData().setModifiedDate(new Date(file2.lastModified()));
                groupWithoutIO.setFolder(file2);
                this.workflow.addChild(groupWithoutIO);
                for (File file3 : file2.listFiles()) {
                    try {
                        groupWithoutIO.addChild(new Measurement(file3, (Group)groupWithoutIO));
                    }
                    catch (XmlParserHelper.XmlFileNotFoundException xmlFileNotFoundException) {
                        // empty catch block
                    }
                }
            }
        }
        this.workflow.setReferenceConvertTo(this.workflow.getDefaultReferenceConvertTo());
        this.setLists(arrayList, this.workflow.getChildList(), "Recordings2_big");
    }

    @Override
    protected boolean canAddEntry() {
        return false;
    }

    @Override
    protected boolean canOpenEntry() {
        return true;
    }

    @Override
    protected void openButtonClicked(Object object) {
        if (this.entry != null) {
            BreezeProgressDialog.startProgress(this.getFrame(), new OpenEntryProgressAction(this.getFrame()){

                @Override
                protected EntryMainPanel createOpenPanel() {
                    return new RecordingsMeasurementPanel(this.getProgressManager(), RecordingsPanel.this.getFrame(), (Group)RecordingsPanel.this.entry);
                }
            }, "Opening...", 0);
        }
    }

    @Override
    public void rightClickOnSelected(MouseEvent mouseEvent) {
        MeasurementPopup.showMeasurementsPopup(this, this.getSelectedEntries(), mouseEvent);
    }

    public static class RecordingsOverviewPanel
    extends EntryOverviewPanel {
        private final BreezeButton applyChangesButton;
        private final BreezeLabelField measurementLabelField = this.addLabelField("Measurements");
        private Group group;
        private final BreezeComboBoxInputField convertToInputField;

        public RecordingsOverviewPanel(EntryMainPanel entryMainPanel) {
            super(entryMainPanel);
            this.applyChangesButton = EntryMainHelper.createApplyButton(entryMainPanel);
            this.convertToInputField = new BreezeComboBoxInputField<RtFramePredictor.ReferenceConvertTo>("Convert To", Arrays.asList(RtFramePredictor.ReferenceConvertTo.values()), RtFramePredictor.ReferenceConvertTo.None, referenceConvertTo -> this.group.getParent().setReferenceConvertTo((RtFramePredictor.ReferenceConvertTo)((Object)referenceConvertTo)));
            this.convertToInputField.setValueWidth(200);
            this.addComponentToFieldNoFill(this.convertToInputField);
        }

        @Override
        public void addComponent(BreezeMainPanel breezeMainPanel) {
            breezeMainPanel.addRightButton(this.applyChangesButton);
        }

        @Override
        protected Image getDefaultImage() {
            return new ImageIcon(this.getClass().getResource("/images/Recordings2_big.png")).getImage();
        }

        @Override
        protected void setListsToField(BasicEntry basicEntry) {
            this.group = (Group)basicEntry;
            this.measurementLabelField.setValue(this.group.getChildCount());
            this.convertToInputField.setSelectedItem(this.group.getParent().getReferenceConvertTo());
        }
    }

    public class RecordingsMeasurementPanel
    extends EntryMainItemPanel {
        public RecordingsMeasurementPanel(BreezeProgress breezeProgress, BreezeFrame breezeFrame, Group group) {
            super(breezeFrame, BreezeType.Recordings, "Measurements", true, true);
            ArrayList<ViewClass> arrayList = new ArrayList<ViewClass>();
            final BreezeButton breezeButton = EntryMainHelper.createApplyButton(this);
            arrayList.add(new ViewClass("Table", new MeasurementViewPanel(this, this, RecordingsPanel.this.workflow){
                final /* synthetic */ RecordingsMeasurementPanel this$1;
                {
                    this.this$1 = recordingsMeasurementPanel;
                    super(entryMainPanel, workflow);
                }

                @Override
                public void addComponent(BreezeMainPanel breezeMainPanel) {
                    breezeMainPanel.addRightButton(breezeButton);
                }
            }));
            arrayList.add(new ViewClass("Pixel Explore", new PixelExplorePanel(this, RecordingsPanel.this.workflow, PixelExplorePanel.PixelExploreType.Recordings)));
            arrayList.add(new ViewClass("References", new SpectralPanel(this)));
            arrayList.add(new ViewClass("Metadata", new MetaPanel(this)));
            this.setLists(arrayList, group.getChildList(), "RecordSmall2");
        }

        @Override
        protected String getSortName() {
            return "sortMeasurement";
        }

        @Override
        protected void entryDoubleClicked(Object object) {
        }

        @Override
        protected void openButtonClicked(Object object) {
            FileHelper.openExplorerOnPath(((Measurement)object).getFolder());
        }

        @Override
        protected boolean canAddEntry() {
            return false;
        }

        @Override
        protected boolean canOpenEntry() {
            return true;
        }

        @Override
        public void rightClickOnSelected(MouseEvent mouseEvent) {
            MeasurementPopup.showMeasurementsPopup(this, this.getSelectedEntries(), mouseEvent);
        }
    }
}

