/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.client.select;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import se.prediktera.breeze.common.entry.BasicEntry;
import se.prediktera.breeze.common.entry.BreezeType;
import se.prediktera.breeze.common.entry.analyse.BasicAnalyse;
import se.prediktera.breeze.common.entry.factor.category.CategoryFactor;
import se.prediktera.breeze.entry.application.RuntimeObjectFormat;
import se.prediktera.breeze.entry.application.RuntimeWorkflow;
import se.prediktera.breeze.frontend.common.entry.EntryMainPanel;
import se.prediktera.breeze.frontend.common.entry.EntryOverviewPanel;
import se.prediktera.breeze.frontend.common.swing.BreezeLabel;
import se.prediktera.breeze.frontend.common.swing.BreezeLabelField;
import se.prediktera.breeze.frontend.common.swing.BreezeListReadOnlyField;
import se.prediktera.breeze.frontend.common.swing.BreezeTabListField;
import se.prediktera.breeze.frontend.common.swing.BreezeTextArea;
import se.prediktera.breeze.frontend.common.swing.GridBagHelper;

public class RuntimeWorkflowOverviewPanel
extends EntryOverviewPanel {
    private final BreezeListReadOnlyField propertiesListField = new BreezeListReadOnlyField("Properties", this.getClickCallbackAddNewVariableOrId(1));
    private final BreezeTabListField categoriesTabListField;
    private final BreezeListReadOnlyField descriptorListField = new BreezeListReadOnlyField("Descriptors", this.getClickCallbackAddNewVariableOrId(0));
    private final BreezeListReadOnlyField fieldsListField = new BreezeListReadOnlyField("Fields", 250, null);
    private final BreezeTextAreaInfoField descriptionListField = new BreezeTextAreaInfoField("Description");
    private final BreezeLabelField modeLabelField;
    private final BreezeLabelField additionalLabelField;

    public RuntimeWorkflowOverviewPanel(EntryMainPanel entryMainPanel) {
        super(entryMainPanel);
        this.categoriesTabListField = new BreezeTabListField("Categories", entryMainPanel.getPageColor(), this.getClickCallbackAddNewVariableOrId(2));
        this.modeLabelField = this.addLabelField("Mode");
        this.additionalLabelField = this.addLabelField("");
        this.addComponentToField(this.propertiesListField);
        this.addComponentToField(this.categoriesTabListField);
        this.addComponentToField(this.descriptorListField);
        this.addComponentToField(this.fieldsListField);
        this.addComponentToField(this.descriptionListField);
    }

    @Override
    protected Image getDefaultImage() {
        URL uRL = this.getClass().getResource("/images/" + (this.mainpanel.getPageType().equals((Object)BreezeType.Project) ? "Recordings2_big.png" : "Workflow_big.png"));
        ImageIcon imageIcon = new ImageIcon(uRL);
        return imageIcon.getImage();
    }

    @Override
    protected void setListsToField(BasicEntry basicEntry) {
        RuntimeWorkflow runtimeWorkflow = (RuntimeWorkflow)basicEntry;
        this.modeLabelField.setValue(runtimeWorkflow.getPredictionMode().toString());
        if (runtimeWorkflow.isIncludeChildObjects()) {
            this.additionalLabelField.setValue("Include child objects");
        } else {
            this.additionalLabelField.setValue("");
        }
        this.addVariables(runtimeWorkflow.getAnalyseList());
        RuntimeObjectFormat runtimeObjectFormat = runtimeWorkflow.getObjectFormat();
        if (runtimeObjectFormat != null && runtimeObjectFormat.getSegmentationLevel() != null) {
            this.descriptorListField.setList(runtimeObjectFormat.getSegmentationLevel().getDescriptors().getList());
        } else {
            this.descriptorListField.setEmptyList();
        }
        this.fieldsListField.setList(runtimeWorkflow.getRuntimeParameters());
        String string = runtimeWorkflow.getDescription();
        this.descriptionListField.setText(string);
        this.descriptionListField.setVisible(!string.isEmpty());
        if (this.mainpanel.getPageType().equals((Object)BreezeType.Workflow)) {
            this.propertiesListField.setVisibleIfItems();
            this.categoriesTabListField.setVisibleIfItems();
            this.descriptorListField.setVisibleIfItems();
            this.fieldsListField.setVisibleIfItems();
        }
    }

    private void addVariables(List<BasicAnalyse> list) {
        ArrayList arrayList = new ArrayList();
        ArrayList<CategoryFactor> arrayList2 = new ArrayList<CategoryFactor>();
        for (BasicAnalyse basicAnalyse : list) {
            if (basicAnalyse.getModelMethod().isQuantification()) {
                arrayList.addAll(basicAnalyse.getPropertyFactors().getList());
                continue;
            }
            arrayList2.addAll(basicAnalyse.getCategoryFactors().getList());
        }
        this.propertiesListField.setList(arrayList);
        this.categoriesTabListField.setList(arrayList2);
    }

    public class BreezeTextAreaInfoField
    extends JPanel {
        private final BreezeTextArea textArea;

        public BreezeTextAreaInfoField(String string) {
            super(new GridBagLayout());
            this.setOpaque(false);
            BreezeLabel breezeLabel = new BreezeLabel(string);
            breezeLabel.setFont(new Font("Tahoma", 0, 18));
            breezeLabel.setForeground(new Color(150, 150, 150));
            this.add((Component)breezeLabel, GridBagHelper.create(0, new Insets(0, 0, 0, 0)));
            this.textArea = new BreezeTextArea(4, false);
            this.add((Component)this.textArea, GridBagHelper.createLast(1, new Insets(12, 6, 0, 0)));
            this.textArea.hideVerticalScrollBar();
            this.textArea.setBorder(BorderFactory.createEmptyBorder());
            this.textArea.setEditable(false);
        }

        public void setText(String string) {
            this.textArea.setText(string);
        }
    }
}

