/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.client.select;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JPanel;
import se.prediktera.breeze.backend.WorkspaceManager;
import se.prediktera.breeze.common.entry.BreezeType;
import se.prediktera.breeze.common.util.BreezeProgressImpl;
import se.prediktera.breeze.common.util.FileHelper;
import se.prediktera.breeze.entry.application.RuntimeWorkflow;
import se.prediktera.breeze.entry.cache.BreezeMasterCache;
import se.prediktera.breeze.frontend.BreezeFrame;
import se.prediktera.breeze.frontend.client.select.RuntimeWorkflowOverviewPanel;
import se.prediktera.breeze.frontend.client.select.active.ActiveRuntimeWorkflowPanel;
import se.prediktera.breeze.frontend.client.select.active.RuntimeGraphPanel;
import se.prediktera.breeze.frontend.common.entry.EntryMainHelper;
import se.prediktera.breeze.frontend.common.entry.EntryMainItemPanel;
import se.prediktera.breeze.frontend.common.entry.EntryMainPanel;
import se.prediktera.breeze.frontend.common.entry.OpenEntryProgressAction;
import se.prediktera.breeze.frontend.common.swing.contextmenu.BreezeContextMenu;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressManager;
import se.prediktera.breeze.frontend.common.view.ViewClass;
import se.prediktera.breeze.hardware.Camera;
import se.prediktera.breeze.hardware.tcp.TcpManager;
import se.prediktera.map.common.swing.filechooser.jopensaveDialog;

public class RuntimeWorkflowSelectionPanel
extends EntryMainItemPanel {
    private final boolean includeObjectShape;
    private final List<Camera> cameras;

    public RuntimeWorkflowSelectionPanel(BreezeFrame breezeFrame, List<RuntimeWorkflow> list, List<Camera> list2, boolean bl) {
        super(breezeFrame, BreezeType.Workflow, "Workflows", true, true);
        this.includeObjectShape = bl;
        this.cameras = list2;
        ArrayList<ViewClass> arrayList = new ArrayList<ViewClass>();
        arrayList.add(new ViewClass("Overview", new RuntimeWorkflowOverviewPanel(this)));
        arrayList.add(new ViewClass("Analyse Tree", new RuntimeGraphPanel(this, false)));
        this.setLists(arrayList, list, "Workflow_big");
        this.buttonsPanel.getAddButton().setDesc("Import workflow(s)");
        this.setStatusPanel(this.createStatusPanel());
    }

    @Override
    protected void addVerticalButtons(boolean bl) {
        this.nextButton = EntryMainHelper.createColorNextButton("Open", "material/folder_open", () -> this.openButtonClicked(this.getSelectedEntry()), BreezeType.Workflow.getColor());
        this.verticalButtons.addComponent(this.nextButton);
        super.addVerticalButtons(bl);
    }

    @Override
    protected void openButtonClicked(final Object object) {
        BreezeProgressDialog.startProgress(this.getFrame(), new OpenEntryProgressAction(this, this.getFrame()){
            final /* synthetic */ RuntimeWorkflowSelectionPanel this$0;
            {
                this.this$0 = runtimeWorkflowSelectionPanel;
                super(breezeFrame);
            }

            @Override
            protected EntryMainPanel createOpenPanel() {
                BreezeProgressManager breezeProgressManager = this.getProgressManager();
                breezeProgressManager.setInfoText("Loading workflow");
                RuntimeWorkflow runtimeWorkflow = (RuntimeWorkflow)object;
                BreezeMasterCache.setMasterCache(runtimeWorkflow);
                RuntimeWorkflow runtimeWorkflow2 = TcpManager.getInstance().loadWorkflow(runtimeWorkflow, this.this$0.cameras.getFirst());
                return new ActiveRuntimeWorkflowPanel(this.this$0.frame, this.this$0.cameras, runtimeWorkflow2, true, this.this$0.includeObjectShape);
            }
        }, "Opening...", 0);
    }

    @Override
    protected void setCurrentPanel(ViewClass viewClass, Object object) {
        if (object instanceof RuntimeWorkflow) {
            RuntimeWorkflow runtimeWorkflow = (RuntimeWorkflow)object;
            BreezeMasterCache.setMasterCache(runtimeWorkflow);
        }
        super.setCurrentPanel(viewClass, object);
    }

    @Override
    protected boolean canDuplicateEntry() {
        return false;
    }

    @Override
    protected boolean canOpenEntry() {
        return false;
    }

    @Override
    public String getEntryName() {
        return "Workflow";
    }

    @Override
    public void rightClickOnSelected(MouseEvent mouseEvent) {
        BreezeFrame breezeFrame = this.getFrame();
        BreezeContextMenu breezeContextMenu = new BreezeContextMenu(breezeFrame, Color.red);
        breezeContextMenu.addButtonCloseClick("Open in File Browser", () -> FileHelper.openExplorerOnPath(this.getSelectedEntry()));
        breezeContextMenu.addSeparator();
        breezeContextMenu.addButtonCloseClick("Select all", () -> this.getEntryList().selectAll());
        breezeContextMenu.addButtonCloseClick("Delete", () -> this.entryDeleteClicked(this.getSelectedEntry()));
        if (breezeContextMenu.resize()) {
            breezeFrame.addPage((JPanel)((Object)breezeContextMenu));
            breezeContextMenu.setPositionLater(mouseEvent);
        }
    }

    @Override
    protected void createLocal() {
        File file = WorkspaceManager.getInstance().getWorkspace().getRuntimePath();
        jopensaveDialog jopensaveDialog2 = new jopensaveDialog("Select Breeze Runtime workflow(s)", (Component)this.frame);
        jopensaveDialog2.setMultiSelectionEnabled(true);
        jopensaveDialog2.setCurrentDirectory(file);
        jopensaveDialog2.addExtension("xml", "Breeze Runtime workflow (*.xml)");
        if (jopensaveDialog2.openshow()) {
            FileHelper.copyFiles(BreezeProgressImpl.createEmpty(), Arrays.asList(jopensaveDialog2.getSelectedFiles()), file);
            List<RuntimeWorkflow> list = TcpManager.getInstance().getWorkflows();
            this.setEntryListModel(list);
            this.selectFirstItem(true);
        }
    }

    @Override
    public String getEmptyPageMessage() {
        return "This workspace contains no workflows. You can import one using the Import button below, or use 'Export to Runtime' for a project in Breeze desktop.";
    }
}

