/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.client.select.active;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JScrollBar;
import javax.swing.SwingUtilities;
import lombok.Generated;
import se.prediktera.breeze.backend.entry.RtPredictionMode;
import se.prediktera.breeze.backend.measure.MeasurementTaker;
import se.prediktera.breeze.backend.measure.state.TcpPredictSession;
import se.prediktera.breeze.common.realtime.descriptor.usgs.DepthRegistrationPanel;
import se.prediktera.breeze.common.realtime.variable.RtBasicVariable;
import se.prediktera.breeze.common.realtime.variable.RtRenderModeVariable;
import se.prediktera.breeze.common.util.BreezeProgressImpl;
import se.prediktera.breeze.common.util.Time;
import se.prediktera.breeze.common.util.average.AverageSpectrumViewPanel;
import se.prediktera.breeze.common.util.thread.ThreadUtil;
import se.prediktera.breeze.common.util.type.FrameCount;
import se.prediktera.breeze.common.util.type.PixelWidth;
import se.prediktera.breeze.entry.application.RuntimeObjectFormat;
import se.prediktera.breeze.entry.application.RuntimeWorkflow;
import se.prediktera.breeze.entry.measurement.Measurement;
import se.prediktera.breeze.entry.workflow.Workflow;
import se.prediktera.breeze.evince.DataSetCache;
import se.prediktera.breeze.frontend.BreezeFrame;
import se.prediktera.breeze.frontend.BreezeMainPanel;
import se.prediktera.breeze.frontend.client.select.active.RuntimeWorkflowRealtimePanel;
import se.prediktera.breeze.frontend.client.select.active.RuntimeWorkflowRealtimeVisualizationPanel;
import se.prediktera.breeze.frontend.client.select.active.RuntimeWorkflowTablePanel;
import se.prediktera.breeze.frontend.client.workflow.RuntimeWorkflowTable;
import se.prediktera.breeze.frontend.common.entry.EntryMainHelper;
import se.prediktera.breeze.frontend.common.entry.EntryMainPanel;
import se.prediktera.breeze.frontend.common.entry.EntrySettingsPanel;
import se.prediktera.breeze.frontend.common.swing.BreezeButton;
import se.prediktera.breeze.frontend.common.swing.BreezeScrollPane;
import se.prediktera.breeze.frontend.common.swing.dialog.AbstractBreezeCustomPanel;
import se.prediktera.breeze.frontend.common.swing.dialog.AbstractBreezeDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeOptionDialog;
import se.prediktera.breeze.frontend.common.util.BreezeProperties;
import se.prediktera.breeze.frontend.common.view.ViewPanelCustomPanel;
import se.prediktera.breeze.frontend.common.view.preview.VisualisationToolbar;
import se.prediktera.breeze.frontend.common.view.visualization.camerastream.PushbroomStreamImage;
import se.prediktera.breeze.frontend.main.settings.testscan.RulePanel;
import se.prediktera.breeze.frontend.main.settings.testscan.TestScanButtons;
import se.prediktera.breeze.hardware.Camera;
import se.prediktera.breeze.hardware.HardwareRegistry;
import se.prediktera.breeze.hardware.camera.capture.RuntimeWorkflowFrameStack;
import se.prediktera.breeze.hardware.tcp.TcpManager;
import se.prediktera.breeze.recorder.BreezeRecorder;
import se.prediktera.map.common.SwingTimer;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.common.update.UpdateHelper;
import se.prediktera.map.register.RegInfo;

public class ActiveRealtimePanel
extends RuntimeWorkflowRealtimePanel {
    private final RuntimeWorkflowRealtimeVisualizationPanel realtimePanelAddOn;
    private RuntimeWorkflow application;
    private boolean tableVisible = true;
    private final Camera camera;
    private PixelWidth cameraWidth;
    private final boolean measurementRecordMode;
    private boolean updatingPreferredSize;
    private Long firstFrameNumber;
    private boolean reRendering = false;
    private Measurement measurement;
    private final TestScanButtons testScanButtons;
    private final List<TestScanButtons.BreezeToggleButtonRenderMode> renderToggles = new ArrayList<TestScanButtons.BreezeToggleButtonRenderMode>();
    private BreezeButton viewButton;
    private BreezeProgressImpl progress;
    private BreezeButton depthButton;
    private final MeasurementTaker taker;
    public static boolean InReRenderMode;
    private final RulePanel rulePanel;

    public ActiveRealtimePanel(BreezeMainPanel breezeMainPanel, MeasurementTaker measurementTaker, Workflow workflow, Camera camera, RuntimeWorkflow runtimeWorkflow, BreezeRecorder.RecordMode recordMode, RtBasicVariable rtBasicVariable) {
        super(breezeMainPanel, recordMode, camera);
        boolean bl;
        this.taker = measurementTaker;
        this.camera = camera;
        this.measurementRecordMode = recordMode.isMeasurement();
        this.setMinimumSize(new Dimension(300, 300));
        this.setPreferredSize(new Dimension(300, 300));
        this.realtimePanelAddOn = this.getRealtimePanelAddOn();
        this.realtimePanelAddOn.setDoPostProcessing(recordMode.doPostProcessing());
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                if (ActiveRealtimePanel.this.realtimePanelAddOn.getImage() != null) {
                    ActiveRealtimePanel.this.reRendering = false;
                    ActiveRealtimePanel.this.updatePreferredSize();
                }
            }
        });
        this.rulePanel = new RulePanel(this.realtimePanelAddOn);
        if (recordMode.isTestScan()) {
            boolean bl2 = this.rulePanel.setDefaultOrientation();
            this.realtimePanelAddOn.add(this.rulePanel, bl2 ? "West" : "South");
        }
        VisualisationToolbar visualisationToolbar = this.getToolbar();
        int n = 10;
        boolean bl3 = bl = UpdateHelper.Product.isRunningProductBreeze() || UpdateHelper.Product.isRunningProductBreezeClient() && runtimeWorkflow != null && runtimeWorkflow.getPredictionMode().getMode() == RtPredictionMode.PredictionMode.Rgb;
        if (bl) {
            this.setChangeCallback(this::reRender);
            this.testScanButtons = new TestScanButtons(rtRenderModeVariable -> visualisationToolbar.getComboBox().setSelectedItemAndTrigger(rtRenderModeVariable), true);
            this.testScanButtons.updateFromCamera(camera);
            Component[] componentArray = this.testScanButtons.getComponents();
            int n2 = 0;
            while (n2 < componentArray.length) {
                componentArray[n2].setPreferredSize(new Dimension(80, 25));
                componentArray[n2].setMinimumSize(new Dimension(80, 25));
                visualisationToolbar.addWithIndex(componentArray[n2], n);
                Component component = componentArray[n2];
                if (component instanceof TestScanButtons.BreezeToggleButtonRenderMode) {
                    TestScanButtons.BreezeToggleButtonRenderMode breezeToggleButtonRenderMode = (TestScanButtons.BreezeToggleButtonRenderMode)component;
                    this.renderToggles.add(breezeToggleButtonRenderMode);
                }
                ++n2;
                ++n;
            }
            this.setVariables(new ArrayList<RtBasicVariable>(), this.renderToggles, rtBasicVariable, camera);
        } else {
            this.testScanButtons = null;
        }
        if (this.measurementRecordMode) {
            this.viewButton = EntryMainHelper.createTextButton("Spectral Viewer", () -> BreezeOptionDialog.showDialog(this.getFrame(), this.getPageColor(), AbstractBreezeDialog.MessageType.NO_BUTTON_OPTION, "Spectral Viewer: " + this.measurement.getName(), "", (AbstractBreezeCustomPanel)new ViewPanelCustomPanel(new AverageSpectrumViewPanel(new EntryMainPanel(){

                @Override
                public BreezeFrame getFrame() {
                    return ActiveRealtimePanel.this.getMainPanel().getFrame();
                }
            }, this.measurement, ""), workflow, 0.9), null, breezeActionEvent -> DataSetCache.clear(this.measurement)));
            visualisationToolbar.addWithIndex(this.viewButton, n++);
            this.viewButton.setPreferredAndMinimumSize(120, 25);
            this.viewButton.setTextFontSize(12);
            this.viewButton.setEnabled(false);
            if (recordMode.equals((Object)BreezeRecorder.RecordMode.Measurement) && RegInfo.isGeoFeature() && workflow != null && workflow.getDepthRegistration()) {
                this.depthButton = EntryMainHelper.createTextButton("Depth", "depthButton", () -> BreezeOptionDialog.showDialog(this.getFrame(), this.getPageColor(), AbstractBreezeDialog.MessageType.NO_BUTTON_OPTION, "Depth registration " + Camera.getCameraTypeName(camera), "", (AbstractBreezeCustomPanel)new ViewPanelCustomPanel(new DepthRegistrationPanel(this.getMainPanel(), workflow), this.measurement, 0.9), null, breezeActionEvent -> DataSetCache.clear(this.measurement)));
                visualisationToolbar.addWithIndex(this.depthButton, n);
                this.depthButton.setTextFontSize(12);
                this.depthButton.setEnabled(false);
            }
        }
        if (recordMode.isTestScan()) {
            visualisationToolbar.showComboBox(false);
        }
        if (runtimeWorkflow != null) {
            this.setApplication(runtimeWorkflow, null, null);
        }
    }

    public PixelWidth getCameraWidth() {
        if (this.cameraWidth == null && this.camera.isConnected()) {
            this.cameraWidth = new PixelWidth(HardwareRegistry.getInstance().getActualWidth(this.camera));
        }
        return this.cameraWidth;
    }

    public void setApplication(RuntimeWorkflow runtimeWorkflow, RtBasicVariable rtBasicVariable, FrameCount frameCount) {
        this.application = runtimeWorkflow;
        this.setApplication(this.camera, runtimeWorkflow, this.renderToggles, rtBasicVariable, frameCount, this.getCameraWidth());
        this.setImageDirection(this.tableVisible);
        this.getToolbar().initBlending(runtimeWorkflow.getPredictionMode());
    }

    @Override
    public void setVariables(List<RtBasicVariable> list, List<TestScanButtons.BreezeToggleButtonRenderMode> list2, RtBasicVariable rtBasicVariable, Camera camera) {
        super.setVariables(list, list2, rtBasicVariable, camera);
        this.setTestScanVariable(rtBasicVariable);
    }

    public void start() {
    }

    public void stop() {
        if (!this.measurementRecordMode) {
            for (TestScanButtons.BreezeToggleButtonRenderMode breezeToggleButtonRenderMode : this.renderToggles) {
                breezeToggleButtonRenderMode.setEnabled(false);
            }
            this.getToolbar().getComboBox().setEnabled(false);
        }
    }

    public void reset() {
        if (this.progress != null) {
            this.progress.abortNoThrow();
            ThreadUtil.awaitOrThrow(() -> this.progress == null, new Time.Seconds(20.0));
        }
        this.firstFrameNumber = null;
        this.reRendering = false;
        this.setMeasurement(null);
        this.updatePreferredSize();
        this.getRealtimePanelAddOn().reset();
    }

    public void clear() {
        this.reRendering = true;
        this.getRealtimePanelAddOn().clear();
    }

    public synchronized void reRender() {
        final RuntimeWorkflowRealtimePanel.VariableBreezeComboBox variableBreezeComboBox = this.getVariableComboBox();
        RtBasicVariable rtBasicVariable = (RtBasicVariable)variableBreezeComboBox.getSelectedItem();
        if (rtBasicVariable == null) {
            return;
        }
        String string = rtBasicVariable.getNameAndId();
        boolean bl = this.setTestScanVariable(rtBasicVariable);
        if (this.measurementRecordMode && this.measurement != null && this.firstFrameNumber != null) {
            if (!this.taker.getStatus().equals((Object)MeasurementTaker.MeasurementStatus.Finished)) {
                throw new ErrorHandler.InformationMessageException("Please wait until all cameras are finished and try again");
            }
            variableBreezeComboBox.setEnabled(false);
            if (this.progress != null) {
                this.progress.abortNoThrow();
                ThreadUtil.awaitOrThrow(() -> this.progress == null, new Time.Seconds(20.0));
            }
            this.progress = BreezeProgressImpl.createEmpty();
            new Thread(() -> {
                try {
                    if (InReRenderMode) {
                        ThreadUtil.awaitOrThrow(() -> !InReRenderMode, new Time.Minutes(5.0), "Timeout waiting for re-render");
                    }
                    if (this.progress.isAborted()) {
                        return;
                    }
                    InReRenderMode = true;
                    this.realtimePanelAddOn.setDoPostProcessing(false);
                    this.clear();
                    new TcpPredictSession(this, this, this.measurement.rawFile().header().frameCount(), null, this.application, BreezeProperties.getInstance().getDataStreamPort()){
                        final /* synthetic */ ActiveRealtimePanel this$0;
                        {
                            this.this$0 = activeRealtimePanel;
                            super(activeRealtimePanel2, frameCount, measurementCallback, runtimeWorkflow, n);
                        }

                        @Override
                        public void stop() {
                            super.stop();
                            variableBreezeComboBox.setEnabled(true);
                            this.this$0.realtimePanelAddOn.setDoPostProcessing(this.this$0.recordMode.doPostProcessing());
                            InReRenderMode = false;
                        }
                    };
                    TcpManager.getInstance().ReRender(this.progress, this.application.getXml(), this.measurement, string, this.isBlend(), this.getFirstFrameNumber(), !bl);
                }
                finally {
                    this.progress = null;
                }
            }).start();
        } else if (bl) {
            TcpManager.getInstance().setProperty("VisualizationVariable", string, this.camera.getId());
        }
    }

    private boolean setTestScanVariable(RtBasicVariable rtBasicVariable) {
        boolean bl = rtBasicVariable instanceof RtRenderModeVariable;
        if (this.testScanButtons != null) {
            if (bl) {
                this.testScanButtons.select(this.renderToggles, rtBasicVariable);
            } else {
                this.testScanButtons.clearSelection();
            }
        }
        return bl;
    }

    private void setImageDirection(boolean bl) {
        this.tableVisible = bl;
        this.realtimePanelAddOn.setImageDirection(this.getImageDirection());
        BreezeScrollPane breezeScrollPane = this.getScrollPane();
        if (breezeScrollPane != null) {
            boolean bl2;
            boolean bl3 = bl2 = this.application == null || this.application.isDirectionVertical();
            if (bl2) {
                breezeScrollPane.setHorizontalScrollBarPolicy(31);
                breezeScrollPane.setVerticalScrollBarPolicy(22);
            } else {
                breezeScrollPane.setHorizontalScrollBarPolicy(32);
                breezeScrollPane.setVerticalScrollBarPolicy(21);
            }
        }
    }

    private PushbroomStreamImage.ImageDirection getImageDirection() {
        boolean bl = this.application == null || this.application.isDirectionVertical();
        boolean bl2 = this.application == null || this.application.isHorizontalDirectionRight();
        boolean bl3 = this.application == null || this.application.isVerticalDirectionUp();
        return bl ? PushbroomStreamImage.ImageDirection.getDefaultVertical(this.measurementRecordMode, bl3) : PushbroomStreamImage.ImageDirection.getDefaultHorizontal(this.measurementRecordMode, bl2);
    }

    @Override
    public void showEntry(Object object, Object object2) {
        super.showEntry(object, object2);
    }

    public void apply(RuntimeWorkflowFrameStack runtimeWorkflowFrameStack) {
        this.realtimePanelAddOn.apply(runtimeWorkflowFrameStack);
        if (this.firstFrameNumber == null) {
            this.firstFrameNumber = runtimeWorkflowFrameStack.getFrameNumber();
        }
        if (!this.updatingPreferredSize && !this.reRendering) {
            this.updatingPreferredSize = true;
            SwingUtilities.invokeLater(() -> {
                this.updatePreferredSize();
                this.updatingPreferredSize = false;
            });
        }
    }

    private void updatePreferredSize() {
        PixelWidth pixelWidth = this.getCameraWidth();
        BreezeScrollPane breezeScrollPane = this.getScrollPane();
        if (pixelWidth != null && pixelWidth.value > 0 && breezeScrollPane != null) {
            boolean bl = false;
            Dimension dimension = this.realtimePanelAddOn.getPreferredSize();
            long l = this.realtimePanelAddOn.getCapturedFramesCount();
            long l2 = Math.min(l, (long)this.realtimePanelAddOn.getMaxSize());
            if (this.realtimePanelAddOn.getImageDirection().isVertical()) {
                int n = (int)((double)this.realtimePanelAddOn.getWidth() / (double)pixelWidth.value * (double)l2);
                boolean bl2 = bl = dimension.height != n;
                if (bl) {
                    this.realtimePanelAddOn.setPreferredSize(new Dimension(100, n));
                    JScrollBar jScrollBar = breezeScrollPane.getVerticalScrollBar();
                    jScrollBar.setValue(jScrollBar.getMaximum());
                }
            } else {
                int n = (int)((double)this.realtimePanelAddOn.getHeight() / (double)pixelWidth.value * (double)l2);
                boolean bl3 = bl = dimension.width != n;
                if (bl) {
                    this.realtimePanelAddOn.setPreferredSize(new Dimension(n, 100));
                    JScrollBar jScrollBar = breezeScrollPane.getHorizontalScrollBar();
                    jScrollBar.setValue(jScrollBar.getMaximum());
                }
            }
            if (bl) {
                this.realtimePanelAddOn.revalidate();
            }
            this.rulePanel.repaint();
        }
    }

    public void addObject(RuntimeObjectFormat.DescriptorValues descriptorValues) {
        this.application.addObject(descriptorValues, 100);
        this.addTrack(descriptorValues);
    }

    public void addTrack(RuntimeObjectFormat.DescriptorValues descriptorValues) {
        if (descriptorValues.hasSelectionPath()) {
            long l = descriptorValues.getStartLine();
            long l2 = descriptorValues.getEndLine();
            this.realtimePanelAddOn.getPostProcessor().add(descriptorValues.createSampleTrack(this.application.getDescriptors(), l, l2));
        }
    }

    @Override
    public String getType() {
        return "RealtimeViewPanel";
    }

    public void setMeasurement(Measurement measurement) {
        this.measurement = measurement;
        if (this.viewButton != null) {
            this.viewButton.setEnabled(measurement != null);
        }
        if (this.depthButton != null) {
            this.depthButton.setEnabled(measurement != null);
        }
    }

    @Override
    protected void cleanUpChild() {
        super.cleanUpChild();
        if (this.realtimePanelAddOn != null) {
            this.realtimePanelAddOn.cleanUp();
        }
    }

    @Generated
    public Camera getCamera() {
        return this.camera;
    }

    @Generated
    public Long getFirstFrameNumber() {
        return this.firstFrameNumber;
    }

    @Generated
    public Measurement getMeasurement() {
        return this.measurement;
    }

    public static class ActiveTablePanel
    extends EntrySettingsPanel.SettingsSidePanel {
        private final RuntimeWorkflowTablePanel tablePanel;
        private final SwingTimer updateTableTimer;
        private boolean tableNeedUpdate = false;

        public ActiveTablePanel(BreezeMainPanel breezeMainPanel) {
            super(new BorderLayout());
            this.tablePanel = new RuntimeWorkflowTablePanel(breezeMainPanel);
            this.tablePanel.showEntry(null, null);
            this.add((Component)((Object)this.tablePanel), "Center");
            this.updateTableTimer = new SwingTimer(250, actionEvent -> {
                if (this.tableNeedUpdate) {
                    this.tablePanel.updateTable();
                    this.tableNeedUpdate = false;
                }
            }, true);
            this.setPreferredSize(new Dimension(300, 0));
            this.setMinimumSize(new Dimension(300, 0));
        }

        @Override
        public String getDescription() {
            return "Samples";
        }

        public void start() {
            this.updateTableTimer.start();
        }

        public void stop() {
            this.updateTableTimer.stop();
        }

        public void needUpdate() {
            this.tableNeedUpdate = true;
        }

        public void setApplication(RuntimeWorkflow runtimeWorkflow, RuntimeWorkflowTable.RTableConfig rTableConfig) {
            this.tablePanel.setApplication(runtimeWorkflow, rTableConfig);
        }
    }
}

