/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.client.select.active;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.apache.commons.lang3.StringUtils;
import se.prediktera.breeze.DiagnosticPanel;
import se.prediktera.breeze.common.entry.BreezeType;
import se.prediktera.breeze.common.realtime.frame.FrameStack;
import se.prediktera.breeze.common.util.BreezeProgress;
import se.prediktera.breeze.common.util.StringHelper;
import se.prediktera.breeze.common.util.thread.ExceptionHandlingThread;
import se.prediktera.breeze.common.util.type.FrameCount;
import se.prediktera.breeze.entry.application.RuntimeObjectFormat;
import se.prediktera.breeze.entry.application.RuntimeWorkflow;
import se.prediktera.breeze.entry.application.status.StatusList;
import se.prediktera.breeze.frontend.BreezeFrame;
import se.prediktera.breeze.frontend.client.select.RuntimeWorkflowOverviewPanel;
import se.prediktera.breeze.frontend.client.select.active.ActiveRealtimePanel;
import se.prediktera.breeze.frontend.client.select.active.RuntimeGraphPanel;
import se.prediktera.breeze.frontend.client.select.active.RuntimeSpectralPanel;
import se.prediktera.breeze.frontend.client.select.active.RuntimeWorkflowStatusPanel;
import se.prediktera.breeze.frontend.client.workflow.RuntimeWorkflowTable;
import se.prediktera.breeze.frontend.common.entry.EntryComponents;
import se.prediktera.breeze.frontend.common.entry.EntryMainHelper;
import se.prediktera.breeze.frontend.common.entry.EntryMainPanel;
import se.prediktera.breeze.frontend.common.entry.EntrySettingsPanel;
import se.prediktera.breeze.frontend.common.swing.BreezeCheckBox;
import se.prediktera.breeze.frontend.common.swing.BreezeDescriptionButton;
import se.prediktera.breeze.frontend.common.swing.BreezeExternalLinkPanel;
import se.prediktera.breeze.frontend.common.swing.BreezeInfoPanel;
import se.prediktera.breeze.frontend.common.swing.BreezeInputField;
import se.prediktera.breeze.frontend.common.swing.BreezeInputFieldHelper;
import se.prediktera.breeze.frontend.common.swing.BreezeLabel;
import se.prediktera.breeze.frontend.common.swing.BreezeSeparator;
import se.prediktera.breeze.frontend.common.swing.dialog.AbstractBreezeCustomPanel;
import se.prediktera.breeze.frontend.common.swing.dialog.AbstractBreezeDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeOptionDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.ProgressAction;
import se.prediktera.breeze.frontend.common.util.BreezeProperties;
import se.prediktera.breeze.frontend.common.util.ImageHelper;
import se.prediktera.breeze.frontend.common.view.ViewClass;
import se.prediktera.breeze.frontend.common.view.ViewContainer;
import se.prediktera.breeze.frontend.main.settings.measurement.ReferenceHelper;
import se.prediktera.breeze.hardware.Camera;
import se.prediktera.breeze.hardware.camera.StateCamera;
import se.prediktera.breeze.hardware.camera.capture.BufferedTcpStream;
import se.prediktera.breeze.hardware.camera.capture.RuntimeEvent;
import se.prediktera.breeze.hardware.camera.capture.RuntimeWorkflowFrameStack;
import se.prediktera.breeze.hardware.camera.capture.RuntimeWorkflowHandleFrame;
import se.prediktera.breeze.hardware.camera.capture.TcpStreamCaptureSession;
import se.prediktera.breeze.hardware.tcp.TcpManager;
import se.prediktera.breeze.recorder.BreezeRecorder;
import se.prediktera.map.common.SwingTimer;
import se.prediktera.map.common.error.Logg;

public class ActiveRuntimeWorkflowPanel
extends EntryMainPanel {
    private final EventInformationPanel informationPanel = new EventInformationPanel();
    private final boolean master;
    private final BreezeDescriptionButton captureInPredictButton = new BreezeDescriptionButton();
    private final BreezeFrame.OnCloseCallback onCloseCallback;
    private final SessionViewContainer sessionViewContainer;

    public ActiveRuntimeWorkflowPanel(final BreezeFrame breezeFrame, List<Camera> list, RuntimeWorkflow runtimeWorkflow, boolean bl, boolean bl2) {
        super(breezeFrame, BreezeType.Workflow, "Workflow", true, true);
        this.master = bl;
        this.sessionViewContainer = new SessionViewContainer(this, list, runtimeWorkflow, bl2);
        ArrayList<ViewClass> arrayList = new ArrayList<ViewClass>();
        arrayList.add(new ViewClass("Overview", new RuntimeWorkflowOverviewPanel(this)));
        arrayList.add(new ViewClass("Realtime", this.sessionViewContainer));
        arrayList.add(new ViewClass("Analyse Tree", new RuntimeGraphPanel(this, true)));
        arrayList.add(new ViewClass("References", new RuntimeSpectralPanel(this)));
        arrayList.add(new ViewClass("Status", new RuntimeWorkflowStatusPanel(this, () -> TcpManager.getInstance().getStatus())));
        arrayList.add(new ViewClass("Diagnostic", new DiagnosticPanel(this)));
        this.setLists(arrayList, new ArrayList<RuntimeWorkflow>(List.of(runtimeWorkflow)), "Workflow_big");
        this.setStatusPanel(this.createStatusPanel(false));
        this.toggleTreePanel.toggleTree(EntryComponents.ToggleTreePanel.ToggleMode.Minimum);
        this.nextButton.setVisible(bl);
        this.captureInPredictButton.setDescription("Record data");
        this.captureInPredictButton.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ ActiveRuntimeWorkflowPanel this$0;
            {
                this.this$0 = activeRuntimeWorkflowPanel;
            }

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (this.this$0.captureInPredictButton.isToggled()) {
                    this.this$0.stopCaptureOnPredict();
                } else {
                    this.this$0.startCaptureOnPredict(breezeFrame);
                }
            }
        });
        this.onCloseCallback = breezeProgressManager -> this.stopCaptureOnPredictWhenClose();
        breezeFrame.addOnCloseCallback(this.onCloseCallback);
        this.entryTabPanel.setSelectedTabNoEvent("Realtime");
    }

    @Override
    protected void addVerticalButtons(boolean bl) {
        this.nextButton = EntryMainHelper.createColorNextButton("Start", "PlayIconSmall", () -> this.sessionViewContainer.toggle(), BreezeType.Workflow.getColor());
        this.verticalButtons.addComponent(this.nextButton);
        super.addVerticalButtons(bl);
    }

    private void startCaptureOnPredict(BreezeFrame breezeFrame) {
        if (TcpManager.getInstance().getStatus().isPredicting()) {
            BreezeOptionDialog.showDialog(breezeFrame, BreezeType.Workflow.getColor(), AbstractBreezeDialog.MessageType.CONFIRM_OPTION, "Record Runtime data", "", (AbstractBreezeCustomPanel)new CaptureInputPanel(), null, breezeActionEvent -> {
                CaptureInputPanel captureInputPanel = (CaptureInputPanel)breezeActionEvent.getBreezeCustomPanel();
                TcpManager.getInstance().startCaptureOnPredict(captureInputPanel.getFolderName(), BreezeProperties.getInstance().getMaxFrameCount(), captureInputPanel.SaveObject(), captureInputPanel.SavePredictionData(), captureInputPanel.SaveThumbnail());
                this.captureInPredictButton.setToggled(true);
            });
        } else {
            BreezeOptionDialog.showDialog(breezeFrame, BreezeType.Workflow.getColor(), AbstractBreezeDialog.MessageType.INFORMATION_OPTION, "Not predicting", "Start predicting before starting recording data");
        }
    }

    private void stopCaptureOnPredict() {
        TcpManager.getInstance().stopCaptureOnPredict();
        this.captureInPredictButton.setToggled(false);
    }

    private void stopCaptureOnPredictWhenClose() {
        if (this.captureInPredictButton.isToggled()) {
            this.stopCaptureOnPredict();
        }
    }

    @Override
    protected void addCustomButton() {
        this.addRightButton(this.captureInPredictButton);
        this.addRightButton(new BreezeSeparator.Vertical());
        this.addRightButton(this.informationPanel);
    }

    @Override
    public void backButtonClicked() {
        this.frame.removeOnCloseCallback(this.onCloseCallback);
        this.stopCaptureOnPredictWhenClose();
        this.sessionViewContainer.disconnect(this.master);
        super.backButtonClicked();
    }

    private static class EventInformationPanel
    extends BreezeLabel {
        private final SwingTimer timer = new SwingTimer(5000, actionEvent -> {
            this.setIcon(null);
            this.setText("");
        });

        public EventInformationPanel() {
            this.setBackground(new Color(249, 175, 178));
            this.setFontSize(BreezeLabel.FontSize.H3);
        }

        public void showEvent(RuntimeEvent runtimeEvent) {
            if (runtimeEvent.isError() || runtimeEvent.isWarning()) {
                this.setIcon(ImageHelper.getResourceIcon("warningSmall"));
                this.setText(StringHelper.formatLabel(runtimeEvent.getMessageError()));
            } else {
                this.setIcon(ImageHelper.getResourceIcon("informationSmall"));
                this.setText(StringHelper.formatLabel(runtimeEvent.getMessage()));
            }
            this.timer.restart();
        }
    }

    public static class SessionViewContainer
    extends ViewContainer {
        private final List<ActiveViewSession> sessions = new ArrayList<ActiveViewSession>();
        private final ActiveViewSession primarySession;
        private final boolean includeObjectShape;
        private final ActiveRuntimeWorkflowPanel mainPanel;
        private final ActiveRealtimePanel.ActiveTablePanel activeTablePanel;
        private final List<Camera> cameras;

        public SessionViewContainer(ActiveRuntimeWorkflowPanel activeRuntimeWorkflowPanel, List<Camera> list, RuntimeWorkflow runtimeWorkflow, boolean bl) {
            this.mainPanel = activeRuntimeWorkflowPanel;
            this.cameras = list;
            this.includeObjectShape = bl;
            this.activeTablePanel = new ActiveRealtimePanel.ActiveTablePanel(activeRuntimeWorkflowPanel);
            this.activeTablePanel.setApplication(runtimeWorkflow, new RuntimeWorkflowTable.RTableConfig(false, list.size() > 1));
            this.activeTablePanel.start();
            HashMap<Integer, ActiveRealtimePanel> hashMap = new HashMap<Integer, ActiveRealtimePanel>();
            boolean bl2 = BreezeProperties.getInstance().getVisualisationDirection().equalsIgnoreCase("vertical");
            for (int i = 0; i < list.size(); ++i) {
                ActiveViewSession activeViewSession = new ActiveViewSession(this, list.get(i), runtimeWorkflow, i);
                this.addViewPanel((Component)((Object)activeViewSession.panel), bl2 ? i : 0, bl2 ? 0 : i);
                this.sessions.add(activeViewSession);
                hashMap.put(list.get(i).getId(), activeViewSession.panel);
            }
            this.primarySession = this.sessions.getFirst();
            TcpManager.getInstance().setListener(runtimeEvent -> {
                if (runtimeEvent.isObject()) {
                    RuntimeObjectFormat.DescriptorValues descriptorValues = RuntimeObjectFormat.DescriptorValues.fromJSON(runtimeEvent.getMessage());
                    ActiveRealtimePanel activeRealtimePanel = (ActiveRealtimePanel)hashMap.get(descriptorValues.getCameraId());
                    activeRealtimePanel.addObject(descriptorValues);
                    this.activeTablePanel.needUpdate();
                } else if (runtimeEvent.isWorkflowLoaded()) {
                    activeRuntimeWorkflowPanel.backButtonClicked();
                    BreezeOptionDialog.showDialog(activeRuntimeWorkflowPanel.getFrame(), BreezeType.Project.getColor(), AbstractBreezeDialog.MessageType.INFORMATION_OPTION, "Workflow loaded", "A new workflow has been loaded by the server\n\nPlease reconnect");
                } else {
                    activeRuntimeWorkflowPanel.informationPanel.showEvent(runtimeEvent);
                }
            });
        }

        @Override
        public EntrySettingsPanel.SettingsComponent getRightSettingsPanel(EntrySettingsPanel entrySettingsPanel) {
            return this.activeTablePanel;
        }

        @Override
        public boolean showRightSettingsPanel() {
            return true;
        }

        public void toggle() {
            this.mainPanel.nextButton.setEnabled(false);
            SwingUtilities.invokeLater(() -> {
                if (this.primarySession.tcpStreamCaptureSession != null) {
                    if (TcpManager.getInstance().getStatus().isPredicting()) {
                        TcpManager.getInstance().stopPredict(null);
                    }
                } else if (this.cameras.stream().anyMatch(Camera::useReferencesWhenRecordingWithThisCamera)) {
                    BreezeProgressDialog.startProgress(this.mainPanel.getFrame(), new ProgressAction(){

                        @Override
                        public void runAction() {
                            for (ActiveViewSession activeViewSession : sessions) {
                                activeViewSession.takeReferences(this.getProgressManager());
                            }
                        }

                        @Override
                        public void actionComplete() {
                            if (!TcpManager.getInstance().getStatus().isPredicting()) {
                                TcpManager.getInstance().startPredict(FrameCount.Continuously, includeObjectShape);
                            }
                        }
                    }, "Start predict");
                }
            });
        }

        public void disconnect(boolean bl) {
            for (ActiveViewSession activeViewSession : this.sessions) {
                activeViewSession.panel.stop();
                activeViewSession.disconnect();
            }
            if (bl && TcpManager.getInstance().getStatus().isPredicting()) {
                try {
                    TcpManager.getInstance().stopPredict(null);
                }
                catch (Exception exception) {
                    Logg.debug((String)"Error stopping prediction", (Object[])new Object[]{exception});
                }
            }
            TcpManager.getInstance().setListener(null);
            this.activeTablePanel.stop();
        }
    }

    public static interface OnStatusCallback {
        public StatusList getStatus();
    }

    public static class CaptureInputPanel
    extends AbstractBreezeCustomPanel {
        private String measurementName;
        private final BreezeCheckBox saveObjectCheckBox = new BreezeCheckBox("Only record data when objects are identified", false);
        private final BreezeCheckBox saveThumbnailCheckBox = new BreezeCheckBox("Save thumbnail images (png/jpg)", false);
        private final BreezeCheckBox savePredictionDataCheckBox = new BreezeCheckBox("Save output prediction data", false);

        public CaptureInputPanel() {
            this.setOpaque(false);
            this.setLayout(new GridBagLayout());
            int n = 0;
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 1;
            gridBagConstraints.gridy = n++;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = new Insets(10, 10, 10, 10);
            BreezeLabel breezeLabel = new BreezeLabel("Record camera data and save measurements to disk.");
            BreezeExternalLinkPanel breezeExternalLinkPanel = new BreezeExternalLinkPanel(breezeLabel, "recording-runtime-data", true);
            this.add((Component)breezeExternalLinkPanel, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridy = n++;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(10, 10, 10, 10);
            this.add((Component)new BreezeInputField("Measurement name template:", "Measurement", "", textActionEvent -> {
                this.measurementName = textActionEvent.getText();
            }, BreezeInputFieldHelper.Format.TwoRows), gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridy = n++;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = new Insets(10, 10, 0, 10);
            this.add((Component)this.saveObjectCheckBox, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridy = n++;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(10, 10, 0, 10);
            this.add((Component)this.saveThumbnailCheckBox, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridy = n++;
            gridBagConstraints.insets = new Insets(10, 10, 0, 10);
            gridBagConstraints.fill = 2;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.anchor = 18;
            this.add((Component)this.savePredictionDataCheckBox, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 1;
            gridBagConstraints.gridy = n;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = new Insets(10, 10, 10, 10);
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.setOpaque(false);
            jPanel.add((Component)new BreezeInfoPanel(BreezeInfoPanel.InfoType.Warning, "Recording can affect workflow prediction performance", false), "Center");
            this.add((Component)jPanel, gridBagConstraints);
        }

        public boolean SaveObject() {
            return this.saveObjectCheckBox.isSelected();
        }

        public boolean SavePredictionData() {
            return this.savePredictionDataCheckBox.isSelected();
        }

        public boolean SaveThumbnail() {
            return this.saveThumbnailCheckBox.isSelected();
        }

        public String getFolderName() {
            if (StringUtils.isNotBlank((CharSequence)this.measurementName)) {
                return this.measurementName;
            }
            return "Measurement";
        }

        @Override
        public Object getResult() {
            return this.getFolderName();
        }
    }

    public static class ActiveViewSession
    extends Camera.DefaultCaptureCallback
    implements TcpStreamCaptureSession.CameraCallbacks {
        private final BufferedTcpStream tcpStream;
        private TcpStreamCaptureSession tcpStreamCaptureSession;
        private Camera.CaptureControl control;
        private final ActiveRealtimePanel panel;
        private final Camera camera;
        private final ActiveRuntimeWorkflowPanel mainPanel;

        public ActiveViewSession(SessionViewContainer sessionViewContainer, Camera camera, RuntimeWorkflow runtimeWorkflow, int n) {
            this.mainPanel = sessionViewContainer.mainPanel;
            this.camera = camera;
            this.panel = new ActiveRealtimePanel(this.mainPanel, null, null, camera, runtimeWorkflow, BreezeRecorder.RecordMode.Play, null);
            this.tcpStream = new BufferedTcpStream(new RuntimeWorkflowHandleFrame(runtimeWorkflow, camera.getWidth()), BreezeProperties.getInstance().getBreezeRuntimeConnectHost(), BreezeProperties.getInstance().getDataStreamPort() + n, new BufferedTcpStream.StreamCallback(){

                @Override
                public void onStop() {
                    this.stopCaptureSession();
                }

                @Override
                public void onStart() {
                    this.startCaptureSession();
                }
            }, null);
            this.tcpStream.connect();
            if (TcpManager.getInstance().getStatus().isPredicting()) {
                this.startCaptureSession();
            }
        }

        public void takeReferences(BreezeProgress breezeProgress) {
            if (!ReferenceHelper.isDarkReferenceValid(this.camera)) {
                ReferenceHelper.takeDarkReference(breezeProgress, this.camera);
            }
            if (this.camera instanceof StateCamera && ((StateCamera)this.camera).hasWhiteReference() && !ReferenceHelper.isWhiteReferenceValid(this.camera)) {
                ReferenceHelper.takeWhiteReference(breezeProgress, this.camera);
            }
        }

        @Override
        public void startCapture(FrameCount frameCount) {
            this.mainPanel.nextButton.setEnabled(true);
            this.mainPanel.nextButton.setResourceIcon("material/stop");
            this.mainPanel.nextButton.setDesc("Stop");
        }

        @Override
        public void stopCapture() {
            this.mainPanel.nextButton.setEnabled(true);
            this.mainPanel.nextButton.setResourceIcon("PlayIconSmall");
            this.mainPanel.nextButton.setDesc("Start");
        }

        @Override
        public void onStart(Camera.CaptureControl captureControl) {
            this.control = captureControl;
        }

        @Override
        public void onFrame(FrameStack frameStack, Camera.CaptureControl captureControl) {
            if (frameStack != null) {
                this.panel.apply((RuntimeWorkflowFrameStack)frameStack);
            }
        }

        @Override
        public void onError(Camera.CaptureControl captureControl, Exception exception) {
            Logg.error((String)"Capture error", (Throwable)exception);
            BreezeOptionDialog.showErrorDialog(this.mainPanel.getFrame(), "Error", exception);
        }

        private void stopCaptureSession() {
            if (this.tcpStreamCaptureSession != null) {
                if (this.control != null) {
                    this.control.stop();
                }
                this.tcpStreamCaptureSession.stop();
                this.tcpStreamCaptureSession = null;
            }
        }

        private void startCaptureSession() {
            if (this.tcpStreamCaptureSession == null) {
                this.panel.start();
                ExceptionHandlingThread exceptionHandlingThread = new ExceptionHandlingThread("CameraStreamGrabber", () -> {
                    this.tcpStreamCaptureSession = new TcpStreamCaptureSession(this.tcpStream, FrameCount.Continuously, this, this);
                    this.tcpStreamCaptureSession.runBlocking();
                });
                exceptionHandlingThread.start();
            }
        }

        public void disconnect() {
            this.stopCaptureSession();
            this.tcpStream.disconnect();
        }
    }
}

