/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.client.select.active;

import com.mxgraph.model.mxCell;
import com.mxgraph.swing.mxGraphComponent;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import javax.swing.BorderFactory;
import javax.swing.SwingUtilities;
import se.prediktera.breeze.backend.entry.RtPredictionMode;
import se.prediktera.breeze.common.entry.analyse.BasicAnalyse;
import se.prediktera.breeze.common.entry.tree.evaluatetree.impl.NoneEvaluate;
import se.prediktera.breeze.common.entry.tree.functiontree.AbstractBreezeFunction;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionTreeNode;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionTreeNodeWithId;
import se.prediktera.breeze.common.realtime.descriptor.model.PlsPredClassificationDescriptor;
import se.prediktera.breeze.common.realtime.descriptor.spatial.expression.ExpressionUpdateClassificationDescriptor;
import se.prediktera.breeze.common.realtime.segmentation.AbstractHolderSegmentation;
import se.prediktera.breeze.common.util.RtDataFormat;
import se.prediktera.breeze.common.util.StringHelper;
import se.prediktera.breeze.entry.analyse.model.ModelProperties;
import se.prediktera.breeze.entry.application.RuntimeWorkflow;
import se.prediktera.breeze.frontend.common.entry.EntryMainPanel;
import se.prediktera.breeze.frontend.common.graphcollection.FunctionTreePanel;
import se.prediktera.breeze.frontend.common.pp.DefaultSettingsPanel;
import se.prediktera.breeze.frontend.common.swing.BreezeInputField;
import se.prediktera.breeze.frontend.common.swing.BreezeLabel;
import se.prediktera.breeze.frontend.common.swing.BreezeTheme;
import se.prediktera.breeze.frontend.common.view.AbstractViewPanel;
import se.prediktera.breeze.frontend.wizard.model.panel.EvaluatePanelStep;
import se.prediktera.breeze.hardware.tcp.TcpManager;

public class RuntimeGraphPanel
extends AbstractViewPanel {
    private final FunctionTreePanel graphManager;
    private RuntimeGraphSettingsPanel graphSettingsPanel;
    private FunctionTreeNode selectedTreeNode;
    private RuntimeWorkflow application;

    public RuntimeGraphPanel(EntryMainPanel entryMainPanel, boolean bl) {
        super(entryMainPanel);
        this.setLayout(new GridBagLayout());
        BreezeTheme breezeTheme = BreezeTheme.getInstance();
        this.setBackground(breezeTheme.getPanelBackground());
        this.graphManager = new FunctionTreePanel(true, true);
        this.graphManager.setEnabled(false);
        this.graphManager.setBackground(breezeTheme.getPanelBackground());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)((Object)this.graphManager), gridBagConstraints);
        final mxGraphComponent mxGraphComponent2 = this.graphManager.getGraphComponent();
        mxGraphComponent2.setBackground(breezeTheme.getPanelBackground());
        mxGraphComponent2.setPageBackgroundColor(breezeTheme.getPanelBackground());
        mxGraphComponent2.getViewport().setBackground(breezeTheme.getPanelBackground());
        mxGraphComponent2.setBorder(BorderFactory.createEmptyBorder());
        if (bl) {
            mxGraphComponent2.getGraphControl().addMouseListener((MouseListener)new MouseAdapter(this){
                final /* synthetic */ RuntimeGraphPanel this$0;
                {
                    this.this$0 = runtimeGraphPanel;
                }

                @Override
                public void mouseReleased(MouseEvent mouseEvent) {
                    if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                        mxCell mxCell2 = (mxCell)mxGraphComponent2.getCellAt(mouseEvent.getX(), mouseEvent.getY());
                        if (mxCell2 != null && FunctionTreePanel.supportSelection(mxCell2.getValue())) {
                            this.this$0.selectedTreeNode = (FunctionTreeNode)mxCell2.getValue();
                            mxGraphComponent2.selectCellForEvent((Object)mxCell2, mouseEvent);
                        } else {
                            mxGraphComponent2.getGraph().clearSelection();
                            this.this$0.selectedTreeNode = null;
                        }
                    }
                    this.this$0.graphSettingsPanel.update(this.this$0.application, this.this$0.selectedTreeNode);
                    mouseEvent.consume();
                }
            });
            mxGraphComponent2.getGraphControl().addMouseMotionListener((MouseMotionListener)new MouseMotionAdapter(this){
                final /* synthetic */ RuntimeGraphPanel this$0;
                {
                    this.this$0 = runtimeGraphPanel;
                }

                @Override
                public void mouseMoved(MouseEvent mouseEvent) {
                    mxCell mxCell2 = (mxCell)mxGraphComponent2.getCellAt(mouseEvent.getX(), mouseEvent.getY());
                    if (mxCell2 != null && (FunctionTreePanel.supportSelection(mxCell2.getValue()) || mxCell2.getValue() instanceof FunctionTreePanel.AddNewFunction)) {
                        this.this$0.setCursor(Cursor.getPredefinedCursor(12));
                    } else {
                        this.this$0.setCursor(Cursor.getDefaultCursor());
                    }
                }
            });
            this.graphSettingsPanel = new RuntimeGraphSettingsPanel(this);
            this.setRightSettingsPanel(this.graphSettingsPanel);
        }
    }

    @Override
    public boolean showRightSettingsPanel() {
        return true;
    }

    @Override
    public String getType() {
        return "GraphOverview";
    }

    @Override
    public void showEntry(Object object, Object object2) {
        this.application = (RuntimeWorkflow)object;
        this.graphManager.setWorkflowGraph(this.application.getAnalyseTree());
    }

    public static class RuntimeGraphSettingsPanel
    extends DefaultSettingsPanel {
        private final DefaultSettingsPanel.SectionPanel parametersSection = this.addSection("Settings");

        public RuntimeGraphSettingsPanel(RuntimeGraphPanel runtimeGraphPanel) {
        }

        public void update(RuntimeWorkflow runtimeWorkflow, FunctionTreeNode functionTreeNode) {
            AbstractBreezeFunction abstractBreezeFunction;
            this.parametersSection.clear();
            if (functionTreeNode instanceof FunctionTreeNodeWithId) {
                FunctionTreeNodeWithId functionTreeNodeWithId = (FunctionTreeNodeWithId)functionTreeNode;
                AbstractBreezeFunction abstractBreezeFunction2 = functionTreeNode.getFunction();
                String string = functionTreeNodeWithId.getUid();
                if (abstractBreezeFunction2 instanceof PlsPredClassificationDescriptor) {
                    BasicAnalyse basicAnalyse = ((PlsPredClassificationDescriptor)abstractBreezeFunction2).getAnalyse();
                    if (basicAnalyse != null && basicAnalyse.getModelMethod().supportCutOff()) {
                        this.parametersSection.addComponentVertical(new BreezeLabel("Confidence Level"));
                        EvaluatePanelStep.ModelCutOff modelCutOff = new EvaluatePanelStep.ModelCutOff();
                        modelCutOff.update(new RuntimeCriticalValues(basicAnalyse, string));
                        modelCutOff.addModelSettings(this.parametersSection, criticalValues -> {}, false);
                    }
                } else if (abstractBreezeFunction2 instanceof ExpressionUpdateClassificationDescriptor) {
                    this.parametersSection.addComponentVertical(new BreezeLabel("Variables"));
                    String string2 = TcpManager.getInstance().getProperty(string, "Variables");
                    if (string2.length() > 0) {
                        for (String string3 : string2.split(";")) {
                            String[] stringArray = string3.split(":");
                            this.parametersSection.addComponentVertical(new BreezeInputField.Number(StringHelper.formatLabel(stringArray[0]), RtDataFormat.toNumber(stringArray[1]), "", textActionEvent -> TcpManager.getInstance().setPropertyKeyValue(string, stringArray[0], RtDataFormat.toString(textActionEvent.getValue()))));
                        }
                    }
                } else if (abstractBreezeFunction2 instanceof AbstractHolderSegmentation) {
                    for (String string4 : new String[]{"MinArea", "MaxArea", "Shrink"}) {
                        String string5 = TcpManager.getInstance().getProperty(string, string4);
                        this.parametersSection.addComponentVertical(new BreezeInputField.Number(StringHelper.formatLabel(string4), RtDataFormat.toNumber(string5), "", textActionEvent -> TcpManager.getInstance().setProperty(string, string4, RtDataFormat.toString(textActionEvent.getValue()))));
                    }
                }
            } else if (functionTreeNode != null && (abstractBreezeFunction = functionTreeNode.getFunction()) instanceof NoneEvaluate && runtimeWorkflow.getPredictionMode().getMode().equals((Object)RtPredictionMode.PredictionMode.ObjectToPixelsPipeline)) {
                for (String string : new String[]{"RawValueThreshold"}) {
                    String string6 = TcpManager.getInstance().getProperty(string);
                    this.parametersSection.addComponentVertical(new BreezeInputField.Number(StringHelper.formatLabel(string), RtDataFormat.toNumber(string6), "", textActionEvent -> TcpManager.getInstance().setProperty(string, RtDataFormat.toString(textActionEvent.getValue()))));
                }
            }
            this.parametersSection.update();
        }
    }

    private static class RuntimeCriticalValues
    extends ModelProperties.CriticalValues {
        private final String nodeId;

        public RuntimeCriticalValues(BasicAnalyse basicAnalyse, String string) {
            super(basicAnalyse);
            this.nodeId = string;
        }

        @Override
        public double getCutOffLow() {
            return RtDataFormat.toNumber(TcpManager.getInstance().getProperty(this.nodeId, "CutOffLow"));
        }

        @Override
        public double getCutOffHigh() {
            return RtDataFormat.toNumber(TcpManager.getInstance().getProperty(this.nodeId, "CutOffHigh"));
        }

        @Override
        public void setCutOffHigh(double d) {
            TcpManager.getInstance().setProperty(this.nodeId, "CutOffHigh", RtDataFormat.valueOf(d));
        }

        @Override
        public void setCutOffLow(double d) {
            TcpManager.getInstance().setProperty(this.nodeId, "CutOffLow", RtDataFormat.valueOf(d));
        }
    }
}

