/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.client.select.active;

import java.awt.Component;
import javax.swing.JFrame;
import se.prediktera.breeze.Breeze;
import se.prediktera.breeze.common.util.measure.SpectralReference;
import se.prediktera.breeze.common.util.type.MaxSignal;
import se.prediktera.breeze.entry.application.RuntimeWorkflow;
import se.prediktera.breeze.entry.measurement.Measurement;
import se.prediktera.breeze.frontend.BreezeMainPanel;
import se.prediktera.breeze.frontend.common.entry.EntryMainPanel;
import se.prediktera.breeze.frontend.main.record.measurement.panel.SpectralPanel;
import se.prediktera.breeze.frontend.main.settings.measurement.ReferenceHelper;
import se.prediktera.breeze.hardware.Camera;
import se.prediktera.breeze.hardware.HardwareRegistry;
import se.prediktera.map.common.error.Logg;

public class RuntimeSpectralPanel
extends SpectralPanel {
    public RuntimeSpectralPanel(BreezeMainPanel breezeMainPanel) {
        super(breezeMainPanel);
    }

    @Override
    protected boolean isRuntime() {
        return true;
    }

    @Override
    protected void updatePlotTitles() {
        Camera camera = HardwareRegistry.getInstance().getActiveCamera();
        if (camera != null) {
            this.updatePlotTile(this.getWhiteRefLinePlot(), this.getWhiteReference(camera));
            this.updatePlotTile(this.getDarkRefLinePlot(), this.getDarkReference(camera));
        } else {
            this.updatePlotTile(this.getWhiteRefLinePlot(), null);
            this.updatePlotTile(this.getDarkRefLinePlot(), null);
        }
    }

    protected SpectralReference.DarkReference getDarkReference(Camera camera) {
        return ReferenceHelper.getDarkReference(camera);
    }

    protected SpectralReference.WhiteReference getWhiteReference(Camera camera) {
        return ReferenceHelper.getWhiteReference(camera);
    }

    private void updatePlotTile(SpectralPanel.ReferenceLineAverage referenceLineAverage, SpectralReference spectralReference) {
        if (spectralReference != null && !spectralReference.isEmpty()) {
            referenceLineAverage.setTitle(referenceLineAverage.getOrigTitle() + "  (" + sdf.format(spectralReference.getDate()) + ")");
        } else {
            referenceLineAverage.setTitle(referenceLineAverage.getOrigTitle());
        }
    }

    @Override
    protected MaxSignal getMaxSignal(Measurement measurement) {
        try {
            Camera camera = HardwareRegistry.getInstance().getActiveCamera();
            if (camera != null && camera.isConnected()) {
                return camera.getMaxsignal();
            }
        }
        catch (Exception exception) {
            Logg.debug((String)"Cannot get max signal from camera", (Object[])new Object[]{exception});
        }
        return new MaxSignal(65000.0f);
    }

    public static void main(String[] stringArray) {
        Breeze.initForTest();
        JFrame jFrame = new JFrame("Test");
        jFrame.setDefaultCloseOperation(3);
        EntryMainPanel entryMainPanel = new EntryMainPanel(){};
        RuntimeSpectralPanel runtimeSpectralPanel = new RuntimeSpectralPanel(entryMainPanel);
        runtimeSpectralPanel.showEntry(new RuntimeWorkflow(), null);
        jFrame.getContentPane().add((Component)((Object)runtimeSpectralPanel));
        jFrame.setSize(800, 800);
        jFrame.setLocationRelativeTo(null);
        jFrame.setVisible(true);
    }
}

