/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.client.select.active;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import se.prediktera.breeze.common.realtime.variable.RtBasicVariable;
import se.prediktera.breeze.common.realtime.variable.RtCategoryVariable;
import se.prediktera.breeze.common.realtime.variable.RtRenderModeVariable;
import se.prediktera.breeze.common.util.type.FrameCount;
import se.prediktera.breeze.common.util.type.PixelWidth;
import se.prediktera.breeze.entry.application.RuntimeWorkflow;
import se.prediktera.breeze.entry.workflow.VisualisationNode;
import se.prediktera.breeze.frontend.BreezeMainPanel;
import se.prediktera.breeze.frontend.client.select.active.RuntimeWorkflowRealtimeVisualizationPanel;
import se.prediktera.breeze.frontend.common.swing.BreezeComboBox;
import se.prediktera.breeze.frontend.common.swing.BreezeScrollPane;
import se.prediktera.breeze.frontend.common.swing.BreezeSplitPane;
import se.prediktera.breeze.frontend.common.view.AbstractViewPanel;
import se.prediktera.breeze.frontend.common.view.preview.VisualisationToolbar;
import se.prediktera.breeze.frontend.common.view.visualization.camerastream.CameraPanelInfoText;
import se.prediktera.breeze.frontend.main.play.realtime.LegendPanel;
import se.prediktera.breeze.frontend.main.settings.testscan.TestScanButtons;
import se.prediktera.breeze.hardware.Camera;
import se.prediktera.breeze.hardware.tcp.TcpManager;
import se.prediktera.breeze.recorder.BreezeRecorder;
import se.prediktera.map.common.update.UpdateHelper;

public class RuntimeWorkflowRealtimePanel
extends AbstractViewPanel {
    private final VariableBreezeComboBox variableComboBox;
    private final RuntimeWorkflowRealtimeVisualizationPanel realtimeVisualizationPanelAddOn;
    private final VisualisationToolbar toolbar;
    private final LegendPanel legend = new LegendPanel();
    private BreezeScrollPane scrollPane;
    private VisualisationNode.ColorScale colorScale = new VisualisationNode.ColorScale("jet", false);
    private VisualizationCallback onChangeCallback;
    private final BreezeSplitPane.BreezeLegendSplitPane legendSplitPane;
    private static boolean BoundingBoxSelected = true;
    private static boolean BorderSelected = false;
    private boolean legendVisible;
    protected final BreezeRecorder.RecordMode recordMode;

    public RuntimeWorkflowRealtimePanel(BreezeMainPanel breezeMainPanel, BreezeRecorder.RecordMode recordMode, final Camera camera) {
        super(breezeMainPanel);
        this.recordMode = recordMode;
        this.setOpaque(false);
        this.setLayout(new BorderLayout());
        this.realtimeVisualizationPanelAddOn = new RuntimeWorkflowRealtimeVisualizationPanel(recordMode);
        this.realtimeVisualizationPanelAddOn.setInfoText(new CameraPanelInfoText(""));
        this.variableComboBox = new VariableBreezeComboBox();
        this.toolbar = new VisualisationToolbar(Camera.getCameraTypeName(camera), this.variableComboBox, new VisualisationToolbar.ToolbarCallback(){
            final /* synthetic */ RuntimeWorkflowRealtimePanel this$0;
            {
                this.this$0 = runtimeWorkflowRealtimePanel;
            }

            @Override
            public void itemChanged(Object object) {
                if (!this.this$0.variableComboBox.isUpdating() && object instanceof RtBasicVariable) {
                    RtBasicVariable rtBasicVariable = (RtBasicVariable)object;
                    this.this$0.realtimeVisualizationPanelAddOn.setRealtimeVariable(rtBasicVariable);
                    this.updateLegend(this.this$0.colorScale, rtBasicVariable);
                    String string = rtBasicVariable.getNameAndId();
                    TcpManager.getInstance().setProperty("VisualizationVariable", string, camera.getId());
                    if (this.this$0.onChangeCallback != null) {
                        this.this$0.onChangeCallback.onChange();
                    }
                }
            }

            public void updateLegend(VisualisationNode.ColorScale colorScale, RtBasicVariable rtBasicVariable) {
                if (rtBasicVariable != null && rtBasicVariable.supportLegend()) {
                    this.this$0.legendSplitPane.showLegend(this.this$0.legendVisible);
                    this.this$0.legend.setTitle(rtBasicVariable.toString());
                    if (rtBasicVariable instanceof RtCategoryVariable) {
                        this.this$0.legend.setClassTypes(null, ((RtCategoryVariable)rtBasicVariable).getFactor(), null);
                    } else {
                        this.this$0.legend.setContinuesType(colorScale, null, rtBasicVariable.getFactor(), null, rtBasicVariable.getMinMax(), null, rtBasicVariable);
                    }
                } else {
                    this.this$0.legendSplitPane.showLegend(false);
                }
                this.this$0.legend.repaint();
            }

            @Override
            public void blend(boolean bl) {
                this.this$0.realtimeVisualizationPanelAddOn.setBlending(bl);
                TcpManager.getInstance().setProperty("VisualizationBlend", String.valueOf(bl), camera.getId());
                if (this.this$0.onChangeCallback != null) {
                    this.this$0.onChangeCallback.onChange();
                }
            }

            @Override
            public void legend(boolean bl) {
                this.this$0.legendVisible = bl;
                this.this$0.legendSplitPane.showLegend(this.this$0.legendVisible);
            }
        });
        this.add(this.toolbar, "North");
        if (!recordMode.isTestScan()) {
            this.toolbar.addButton("", "objecttrack", "Show object tracking box", BoundingBoxSelected, bl -> {
                BoundingBoxSelected = bl;
                this.realtimeVisualizationPanelAddOn.setShowTrackBox(BoundingBoxSelected);
            }, 98);
            this.toolbar.addButton("", "objectborder", "Mark object borders", BorderSelected, bl -> {
                BorderSelected = bl;
                this.realtimeVisualizationPanelAddOn.setShowTrackBorder(BorderSelected);
            }, 99);
        }
        this.realtimeVisualizationPanelAddOn.setShowTrackBox(BoundingBoxSelected);
        this.realtimeVisualizationPanelAddOn.setShowTrackBorder(BorderSelected);
        this.realtimeVisualizationPanelAddOn.setBlending(this.toolbar.isBlend());
        this.legendSplitPane = new BreezeSplitPane.BreezeLegendSplitPane(120);
        this.add(this.legendSplitPane, "Center");
        if (recordMode.isMeasurement()) {
            this.realtimeVisualizationPanelAddOn.showFps = false;
        }
        this.scrollPane = new BreezeScrollPane((Component)((Object)this.realtimeVisualizationPanelAddOn));
        this.legendSplitPane.setLeftComponent(this.scrollPane);
        this.legendSplitPane.setLegend(this.legend);
    }

    public void setChangeCallback(VisualizationCallback visualizationCallback) {
        this.onChangeCallback = visualizationCallback;
    }

    public void setApplication(Camera camera, RuntimeWorkflow runtimeWorkflow, List<TestScanButtons.BreezeToggleButtonRenderMode> list, RtBasicVariable rtBasicVariable, FrameCount frameCount, PixelWidth pixelWidth) {
        this.colorScale = runtimeWorkflow.getStreamFormat().getColorScale();
        List<RtBasicVariable> list2 = runtimeWorkflow.createVariables();
        this.realtimeVisualizationPanelAddOn.init(camera, runtimeWorkflow, list2.isEmpty() ? null : list2.get(0), frameCount, pixelWidth);
        this.setVariables(list2, list, rtBasicVariable, camera);
    }

    public void setVariables(List<RtBasicVariable> list, List<TestScanButtons.BreezeToggleButtonRenderMode> list2, RtBasicVariable rtBasicVariable, Camera camera) {
        this.variableComboBox.setVariables(list, list2, rtBasicVariable, camera);
    }

    public RtBasicVariable getSelectedVariable() {
        return (RtBasicVariable)this.variableComboBox.getSelectedItem();
    }

    public boolean isBlend() {
        return this.toolbar.isBlend();
    }

    @Override
    public String getType() {
        return "RealtimePanel";
    }

    public RuntimeWorkflowRealtimeVisualizationPanel getRealtimePanelAddOn() {
        return this.realtimeVisualizationPanelAddOn;
    }

    public BreezeScrollPane getScrollPane() {
        return this.scrollPane;
    }

    @Override
    public void showEntry(Object object, Object object2) {
    }

    public void showToolbar(boolean bl) {
        this.toolbar.setVisible(bl);
    }

    public VisualisationToolbar getToolbar() {
        return this.toolbar;
    }

    public VariableBreezeComboBox getVariableComboBox() {
        return this.variableComboBox;
    }

    @Override
    public boolean contentReady() {
        return true;
    }

    public static class VariableBreezeComboBox
    extends BreezeComboBox {
        private boolean updating = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setVariables(List<RtBasicVariable> list, List<TestScanButtons.BreezeToggleButtonRenderMode> list2, RtBasicVariable rtBasicVariable, Camera camera) {
            RtBasicVariable rtBasicVariable2 = null;
            try {
                this.updating = true;
                String string = rtBasicVariable != null ? rtBasicVariable.getNameAndId() : TcpManager.getInstance().getProperty(camera, "VisualizationVariable", false);
                this.removeAllItems();
                for (RtBasicVariable object : list) {
                    if (string != null && string.equals(object.getNameAndId())) {
                        rtBasicVariable2 = object;
                    }
                    this.addItem(object);
                }
                if (list2.size() > 0) {
                    this.addSeparator();
                    for (TestScanButtons.BreezeToggleButtonRenderMode breezeToggleButtonRenderMode : list2) {
                        RtRenderModeVariable rtRenderModeVariable = breezeToggleButtonRenderMode.getVariable();
                        if (string != null && string.equals(rtRenderModeVariable.getNameAndId())) {
                            rtBasicVariable2 = rtRenderModeVariable;
                        }
                        this.addItem(rtRenderModeVariable);
                    }
                }
            }
            finally {
                this.updating = false;
            }
            if (this.getItemCount() > 0) {
                this.setSelectedItem(null);
                if (rtBasicVariable2 != null) {
                    this.setSelectedItem(rtBasicVariable2);
                } else if ((rtBasicVariable != null || UpdateHelper.Product.isRunningProductBreezeClient()) && !this.setSelectedString("Rgb")) {
                    this.setSelectedIndex(this.getItemCount() - 1);
                }
            }
        }

        public boolean isUpdating() {
            return this.updating;
        }

        public int getItemIndex(String string) {
            for (int i = 0; i < this.getItemCount(); ++i) {
                RtBasicVariable rtBasicVariable;
                Object e = this.getItemAt(i);
                if (!(e instanceof RtBasicVariable) || !(rtBasicVariable = (RtBasicVariable)e).toString().equals(string)) continue;
                return i;
            }
            return -1;
        }
    }

    public static interface VisualizationCallback {
        public void onChange();
    }
}

