/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.client.select.active;

import se.prediktera.breeze.backend.realtime.VisualizationAddOn;
import se.prediktera.breeze.common.frame.ByteFrame;
import se.prediktera.breeze.common.frame.RawFrame;
import se.prediktera.breeze.common.realtime.frame.FrameStack;
import se.prediktera.breeze.common.realtime.variable.RtBasicVariable;
import se.prediktera.breeze.common.util.type.FrameCount;
import se.prediktera.breeze.common.util.type.PixelWidth;
import se.prediktera.breeze.entry.application.RuntimeWorkflow;
import se.prediktera.breeze.frontend.common.view.visualization.camerastream.CameraStreamPanel;
import se.prediktera.breeze.frontend.common.view.visualization.camerastream.PushbroomStreamImage;
import se.prediktera.breeze.frontend.main.play.realtime.SampleTrackRenderer;
import se.prediktera.breeze.hardware.Camera;
import se.prediktera.breeze.recorder.BreezeRecorder;

public class RuntimeWorkflowRealtimeVisualizationPanel
extends CameraStreamPanel
implements VisualizationAddOn {
    private int[][] colorIndex;
    private RtBasicVariable variable;
    private RtBasicVariable rootVariable;
    private int backGroundIndex;

    public RuntimeWorkflowRealtimeVisualizationPanel(BreezeRecorder.RecordMode recordMode) {
        this.getPostProcessor().setRecordMode(recordMode);
    }

    public void init(Camera camera, RuntimeWorkflow runtimeWorkflow, RtBasicVariable rtBasicVariable, FrameCount frameCount, PixelWidth pixelWidth) {
        this.rootVariable = rtBasicVariable;
        this.colorIndex = runtimeWorkflow.getStreamFormat().getColorScale().create().createColorIndex();
        this.init(camera, frameCount, pixelWidth);
    }

    public void setRealtimeVariable(RtBasicVariable rtBasicVariable) {
        this.variable = rtBasicVariable;
        this.getPostProcessor().setVariable(rtBasicVariable);
    }

    public void setBlending(boolean bl) {
        this.getPostProcessor().setBlending(bl);
    }

    public void setShowTrackBox(boolean bl) {
        this.getPostProcessor().setShowTrackBox(bl);
    }

    public void setShowTrackBorder(boolean bl) {
        this.getPostProcessor().setShowTrackBorder(bl);
    }

    @Override
    protected CameraStreamPanel.RgbFrameRasterer createFrameRasterer() {
        return new RealtimeCameraStreamRenderer();
    }

    @Override
    protected CameraStreamPanel.ImagePostProcessor createPostProcessor() {
        return new SampleTrackRenderer();
    }

    @Override
    public SampleTrackRenderer getPostProcessor() {
        return (SampleTrackRenderer)super.getPostProcessor();
    }

    private class RealtimeCameraStreamRenderer
    implements CameraStreamPanel.RgbFrameRasterer {
        private RealtimeCameraStreamRenderer() {
        }

        @Override
        public void rasterIntoRgbFrame(PushbroomStreamImage.RgbFrame rgbFrame, FrameStack frameStack) {
            block6: {
                RawFrame rawFrame;
                block5: {
                    rawFrame = frameStack.getFrame();
                    if (!rawFrame.rgbFrame) break block5;
                    rgbFrame.copyFrame((ByteFrame)rawFrame);
                    break block6;
                }
                if (RuntimeWorkflowRealtimeVisualizationPanel.this.variable.isObjectOnly()) break block6;
                if (RuntimeWorkflowRealtimeVisualizationPanel.this.variable == RuntimeWorkflowRealtimeVisualizationPanel.this.rootVariable) {
                    for (int i = 0; i < rgbFrame.columns; ++i) {
                        this.setTargetFrame(rgbFrame, i, RuntimeWorkflowRealtimeVisualizationPanel.this.variable.getValue(frameStack, i, RuntimeWorkflowRealtimeVisualizationPanel.this.colorIndex, 255));
                    }
                } else {
                    for (int i = 0; i < rgbFrame.columns; ++i) {
                        if (rawFrame.getFrameValue(0, i) == (float)RuntimeWorkflowRealtimeVisualizationPanel.this.backGroundIndex) {
                            this.setTargetFrame(rgbFrame, i, 0);
                            continue;
                        }
                        if (RuntimeWorkflowRealtimeVisualizationPanel.this.variable == null) continue;
                        this.setTargetFrame(rgbFrame, i, RuntimeWorkflowRealtimeVisualizationPanel.this.variable.getValue(frameStack, i, RuntimeWorkflowRealtimeVisualizationPanel.this.colorIndex, 255));
                    }
                }
            }
        }

        private void setTargetFrame(PushbroomStreamImage.RgbFrame rgbFrame, int n, int n2) {
            int n3 = n * 3;
            rgbFrame.origframe[n3] = (byte)n2;
            rgbFrame.origframe[n3 + 1] = (byte)n2;
            rgbFrame.origframe[n3 + 2] = (byte)n2;
        }

        private void setTargetFrame(PushbroomStreamImage.RgbFrame rgbFrame, int n, int[] nArray) {
            int n2 = n * 3;
            rgbFrame.origframe[n2] = (byte)nArray[0];
            rgbFrame.origframe[n2 + 1] = (byte)nArray[1];
            rgbFrame.origframe[n2 + 2] = (byte)nArray[2];
        }
    }
}

