/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.client.select.active;

import java.awt.Component;
import javax.swing.JScrollBar;
import javax.swing.table.TableModel;
import se.prediktera.breeze.common.util.Time;
import se.prediktera.breeze.common.util.thread.ThreadUtil;
import se.prediktera.breeze.entry.application.RuntimeObjectFormat;
import se.prediktera.breeze.entry.application.RuntimeWorkflow;
import se.prediktera.breeze.entry.workflow.Workflow;
import se.prediktera.breeze.frontend.BreezeMainPanel;
import se.prediktera.breeze.frontend.client.workflow.RuntimeWorkflowTable;
import se.prediktera.breeze.frontend.common.entry.EntryMainHelper;
import se.prediktera.breeze.frontend.common.swing.table.BreezeInteractionTable;
import se.prediktera.breeze.frontend.common.swing.table.BreezeTablePanel;
import se.prediktera.breeze.frontend.common.swing.table.SortedTableModel;
import se.prediktera.breeze.frontend.common.util.BreezeProperties;
import se.prediktera.breeze.frontend.common.view.ViewContainer;
import se.prediktera.breeze.frontend.common.view.visualization.TableViewPanel;
import se.prediktera.map.common.SwingTimer;
import se.prediktera.map.data.AbstractTable;

public class RuntimeWorkflowTablePanel
extends ViewContainer {
    private TableViewPanel viewPanel;
    private RuntimeWorkflow application;
    private boolean shouldDisabledProgressBar = true;
    private final SwingTimer onContentReadyTimer = new SwingTimer(100, actionEvent -> {
        BreezeInteractionTable breezeInteractionTable = this.getTable();
        if (this.application != null && breezeInteractionTable != null && breezeInteractionTable.getInnerTable() != null) {
            breezeInteractionTable.getInnerTable().setTableList(this.application.getObjectValues(), null);
        }
        if (this.viewPanel != null) {
            this.viewPanel.selectFirstRowIfNoSelection();
        }
    });
    private RuntimeWorkflowTable measurementTable;

    public RuntimeWorkflowTablePanel(BreezeMainPanel breezeMainPanel) {
        super(breezeMainPanel, false);
        this.viewPanel = new TableViewPanel(this.mainpanel, "", "ApplicationWorkflowTable", "xtraining"){

            @Override
            public boolean hasInteraction(boolean bl) {
                return true;
            }

            @Override
            public void tableSetup(AbstractTable abstractTable) {
                RuntimeWorkflowTablePanel.this.measurementTable = (RuntimeWorkflowTable)abstractTable;
                RuntimeWorkflowTablePanel.this.measurementTable.setScrollToVisible(true);
                BreezeTablePanel breezeTablePanel = RuntimeWorkflowTablePanel.this.measurementTable.getInnerTable();
                TableModel tableModel = breezeTablePanel.getTable().getModel();
                if (tableModel instanceof SortedTableModel) {
                    ((SortedTableModel)tableModel).sortByColumn(0, false);
                }
                breezeTablePanel.setRowHeight(BreezeProperties.getInstance().getTableCellHeight());
                breezeTablePanel.setColumnWidth(BreezeProperties.getInstance().getTableCellWidth());
                breezeTablePanel.setAbstractViewPanel(RuntimeWorkflowTablePanel.this);
            }
        };
        this.addViewPanel((Component)((Object)this.viewPanel), 0, 0, 1, 1);
        this.viewPanel.setName("measurementTable");
        this.viewPanel.addComponent(EntryMainHelper.createButton("Table height", "material/height", () -> this.getTable().getInnerTable().showCellHeightDialog(this.mainpanel)));
        this.viewPanel.addComponent(EntryMainHelper.createButton("Table width", "material/width", () -> this.getTable().getInnerTable().showCellWidthDialog(this.mainpanel)));
        this.viewPanel.addComponent(EntryMainHelper.createButton("Table auto-fit", "material/fit_width", () -> {
            this.getTable().getInnerTable().setColumnWidth(0);
            BreezeProperties.getInstance().setTableCellWidth(0);
        }));
        this.viewPanel.addComponent(EntryMainHelper.createApplyButton(this.mainpanel));
    }

    public void setApplication(RuntimeWorkflow runtimeWorkflow, RuntimeWorkflowTable.RTableConfig rTableConfig) {
        this.application = runtimeWorkflow;
        ThreadUtil.awaitOrThrow(() -> this.measurementTable != null, new Time.Seconds(30.0));
        this.measurementTable.setApplication(runtimeWorkflow, rTableConfig);
        this.onContentReady(() -> this.onContentReadyTimer.restart());
    }

    @Override
    public void setData(boolean bl) {
        this.mainpanel.setDirty(true);
    }

    @Override
    public void showEntry(Object object, Object object2) {
        super.showEntry(object, object2);
        if (this.shouldDisabledProgressBar) {
            this.disableProgressBar();
            this.shouldDisabledProgressBar = false;
        }
        this.onContentReady(() -> this.onContentReadyTimer.restart());
    }

    public void setVisualisationNode(Workflow workflow) {
        BreezeInteractionTable breezeInteractionTable = this.getTable();
        if (breezeInteractionTable != null) {
            BreezeTablePanel breezeTablePanel = breezeInteractionTable.getInnerTable();
            breezeTablePanel.setVisualisationNode(workflow, workflow);
        }
    }

    public void updateTable() {
        BreezeInteractionTable breezeInteractionTable = this.getTable();
        if (breezeInteractionTable != null && breezeInteractionTable.getInnerTable() != null) {
            int n = this.application.getObjectValues().size();
            BreezeTablePanel breezeTablePanel = breezeInteractionTable.getInnerTable();
            JScrollBar jScrollBar = breezeTablePanel.getScrollPane().getHorizontalScrollBar();
            int n2 = jScrollBar.getValue();
            RuntimeObjectFormat.DescriptorValues descriptorValues = n > 0 ? this.application.getObjectValues().get(n - 1) : null;
            breezeTablePanel.updateTable(descriptorValues, false);
            jScrollBar.setValue(n2);
        }
    }

    private BreezeInteractionTable getTable() {
        if (this.viewPanel != null) {
            return (BreezeInteractionTable)this.viewPanel.getVisualization();
        }
        return null;
    }
}

