/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.client.workflow;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.ImageIcon;
import se.prediktera.breeze.common.entry.tree.analysistree.SegmentationIdentifier;
import se.prediktera.breeze.entry.application.RuntimeObjectFormat;
import se.prediktera.breeze.entry.application.RuntimeWorkflow;
import se.prediktera.breeze.entry.group.Group;
import se.prediktera.breeze.entry.measurement.Measurement;
import se.prediktera.breeze.entry.sample.Sample;
import se.prediktera.breeze.evince.data.VisualizationDataHelper;
import se.prediktera.breeze.frontend.client.workflow.RuntimeWorkflowObject;
import se.prediktera.breeze.frontend.common.swing.table.BreezeInteractionTable;
import se.prediktera.breeze.frontend.common.swing.table.BreezeTablePanelInterface;
import se.prediktera.breeze.frontend.common.swing.table.DefaultBreezeTableImpl;
import se.prediktera.breeze.frontend.main.record.measurement.panel.MeasurementTableModel;
import se.prediktera.breeze.hardware.camera.capture.BufferedTcpStream;
import se.prediktera.map.common.wizard.AbstractInit;
import se.prediktera.map.data.DataInit;
import se.prediktera.map.data.tablegenerator.AbstractTableInfo;
import se.prediktera.map.datasetcontainer.DataTreeInterface;
import se.prediktera.map.main.window.AbstractWindow;
import se.prediktera.map.main.window.AbstractWindow_GUI;

public class RuntimeWorkflowTable
extends BreezeInteractionTable {
    private RuntimeWorkflow application;
    private final List<RuntimeWorkflow.AnalyseFactor> analyseList = new ArrayList<RuntimeWorkflow.AnalyseFactor>();
    private ApplicationWorkflowTableModel workflowTableModel;

    public RuntimeWorkflowTable(DataInit dataInit) {
        super(dataInit, 1);
    }

    @Override
    public String getGUI_Name() {
        return "ApplicationWorkflowTable";
    }

    @Override
    protected BreezeTablePanelInterface createTableModel() {
        this.workflowTableModel = new ApplicationWorkflowTableModel(this);
        return this.workflowTableModel;
    }

    public void setApplication(RuntimeWorkflow runtimeWorkflow, RTableConfig rTableConfig) {
        this.application = runtimeWorkflow;
        this.analyseList.clear();
        this.analyseList.addAll(runtimeWorkflow.createDescriptorAnalyseList());
        if (this.workflowTableModel != null) {
            this.workflowTableModel.setApplication(rTableConfig);
        }
    }

    public class ApplicationWorkflowTableModel
    extends DefaultBreezeTableImpl {
        private RTableConfig config;

        public ApplicationWorkflowTableModel(BreezeInteractionTable breezeInteractionTable) {
        }

        public ApplicationWorkflowTableModel() {
        }

        public void setApplication(RTableConfig rTableConfig) {
            this.config = rTableConfig;
        }

        @Override
        public Vector createVOVector(Object object) {
            Vector<Object> vector;
            block8: {
                vector = new Vector<Object>();
                if (!(object instanceof RuntimeObjectFormat.DescriptorValues)) break block8;
                RuntimeObjectFormat.DescriptorValues descriptorValues = (RuntimeObjectFormat.DescriptorValues)object;
                Sample sample = descriptorValues.getSample();
                if (sample != null) {
                    Measurement measurement = sample.measurement();
                    vector.add(measurement.getTimestamp());
                    if (this.config.showCameraId) {
                        vector.add(this.getCamera(descriptorValues.getCameraId()));
                    }
                    vector.add(measurement.getName());
                    Group group = measurement.getParent();
                    return MeasurementTableModel.addSampleDescriptors(vector, sample, this.config.addThumbnail, measurement, group, MeasurementTableModel.TableSource.Table, new SegmentationIdentifier(sample.getSegmentationLevel(), null));
                }
                BufferedTcpStream.HeaderTime headerTime = descriptorValues.getStartTime();
                vector.add(headerTime.toTimestamp());
                if (this.config.showCameraId) {
                    vector.add(this.getCamera(descriptorValues.getCameraId()));
                }
                int n = 0;
                float[] fArray = descriptorValues.getValues();
                if (RuntimeWorkflowTable.this.application != null) {
                    for (RuntimeObjectFormat.DescriptorTuple descriptorTuple : RuntimeWorkflowTable.this.application.getDescriptors()) {
                        if (descriptorTuple.isResult()) {
                            vector.add(new RuntimeWorkflowObject(fArray[n], this.getAnalyseFactor(n)));
                        }
                        ++n;
                    }
                } else {
                    for (float f : fArray) {
                        vector.add(new RuntimeWorkflowObject(f, this.getAnalyseFactor(n++)));
                    }
                }
            }
            return vector;
        }

        private Object getCamera(int n) {
            return n + 1;
        }

        private RuntimeWorkflow.AnalyseFactor getAnalyseFactor(int n) {
            if (n < RuntimeWorkflowTable.this.analyseList.size()) {
                return RuntimeWorkflowTable.this.analyseList.get(n);
            }
            return null;
        }

        @Override
        public List<Object> getTableHeader(List list) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            arrayList.add("Timestamp");
            if (this.config.showCameraId) {
                arrayList.add("Camera");
            }
            if (this.config.addThumbnail) {
                arrayList.add("Measurement");
            }
            if (RuntimeWorkflowTable.this.application != null) {
                for (RuntimeObjectFormat.DescriptorTuple descriptorTuple : RuntimeWorkflowTable.this.application.getDescriptors()) {
                    if (this.config.addThumbnail && descriptorTuple.isThumbnail()) {
                        arrayList.add(descriptorTuple.getName());
                    }
                    if (!descriptorTuple.isResult()) continue;
                    arrayList.add(descriptorTuple.getName());
                }
            }
            return arrayList;
        }
    }

    public static class RTableConfig {
        public final boolean addThumbnail;
        public final boolean showCameraId;

        public RTableConfig(boolean bl, boolean bl2) {
            this.addThumbnail = bl;
            this.showCameraId = bl2;
        }
    }

    public static class Info
    extends AbstractTableInfo {
        public AbstractWindow createWindow(AbstractWindow_GUI abstractWindow_GUI, AbstractInit abstractInit) {
            return new RuntimeWorkflowTable((DataInit)abstractInit);
        }

        public ImageIcon getWizardImage() {
            return null;
        }

        public String getWizardInfo() {
            return "Creates a table per entries";
        }

        public boolean supportData(DataTreeInterface dataTreeInterface) {
            return VisualizationDataHelper.isBreezeMatrix(dataTreeInterface);
        }

        public String toString() {
            return "Application Workflow Table";
        }
    }
}

