/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common;

import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.JList;
import se.prediktera.breeze.frontend.common.util.ListHelper;

public class ArrayListModel
extends AbstractListModel {
    private final List list;

    public ArrayListModel(List list) {
        this.list = list;
    }

    public void addElement(Object object) {
        int n = this.list.size();
        this.list.add(object);
        this.fireIntervalAdded(this, n, n);
    }

    @Override
    public Object getElementAt(int n) {
        if (n >= 0 && n < this.list.size()) {
            return this.list.get(n);
        }
        return null;
    }

    public List getList() {
        return this.list;
    }

    @Override
    public int getSize() {
        if (this.list != null) {
            return this.list.size();
        }
        return 0;
    }

    public void insertElement(Object object) {
        this.list.add(0, object);
        this.fireIntervalAdded(this, 0, 0);
    }

    public int removeElement(Object object) {
        int n = this.list.indexOf(object);
        boolean bl = this.list.remove(object);
        if (bl && n >= 0) {
            this.fireIntervalRemoved(this, n, n);
        }
        return n;
    }

    public void sort(JList jList, ListHelper.SortType sortType, boolean bl) {
        Object e = jList.getSelectedValue();
        ListHelper.sort(this.list, sortType, bl);
        jList.setSelectedValue(e, true);
    }

    public void swapElement(int n, int n2) {
        Object e = this.list.get(n);
        this.list.set(n, this.list.get(n2));
        this.list.set(n2, e);
        this.fireContentsChanged(this, n, n2);
    }
}

