/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import se.prediktera.breeze.common.entry.ObjectWithChildrenAndParent;
import se.prediktera.breeze.common.entry.util.BasicTreeParentInterface;
import se.prediktera.breeze.entry.group.Group;
import se.prediktera.breeze.entry.measurement.Measurement;
import se.prediktera.breeze.entry.workflow.Workflow;
import se.prediktera.breeze.evince.DataSetCache;
import se.prediktera.breeze.frontend.common.swing.BreezeTree;
import se.prediktera.breeze.frontend.common.util.BreezeFilter;
import se.prediktera.breeze.frontend.common.util.ListHelper;

public class ArrayTreeModel
extends DefaultTreeModel {
    private final BasicTreeNode rootnode;
    private ListHelper.SortType type = ListHelper.SortType.Created;
    private boolean accending = true;
    private final List list;
    private final BreezeFilter[] filters = new BreezeFilter[2];

    public ArrayTreeModel(List list) {
        super(null);
        this.list = list;
        this.rootnode = new BasicTreeNode(new RootList(list));
        this.setRoot(this.rootnode);
        this.update(null);
    }

    public void cleanUp() {
        this.cleanUp(this.rootnode);
        this.rootnode.purgeRoot();
    }

    public void cleanUp(TreeNode treeNode) {
        for (int i = 0; i < treeNode.getChildCount(); ++i) {
            this.cleanUp(treeNode.getChildAt(i));
        }
        if (treeNode instanceof DefaultMutableTreeNode) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treeNode;
            Object object = defaultMutableTreeNode.getUserObject();
            if (object instanceof Measurement) {
                DataSetCache.clear((Measurement)object);
            } else if (object instanceof Group) {
                DataSetCache.clear((Group)object);
            } else if (object instanceof Workflow) {
                DataSetCache.clear((Workflow)object);
            }
            defaultMutableTreeNode.setUserObject(null);
        }
    }

    public List getList() {
        return this.list;
    }

    public void insertElement(BreezeTree breezeTree, Object object) {
        this.list.add(0, object);
        this.sort(breezeTree);
    }

    @Override
    public void reload() {
        this.rootnode.purgeRoot();
        this.update(null);
        this.reload(this.rootnode);
    }

    public boolean removeElement(BreezeTree breezeTree, Object object) {
        if (object instanceof ObjectWithChildrenAndParent) {
            Object object2;
            Object object3;
            ObjectWithChildrenAndParent objectWithChildrenAndParent = (ObjectWithChildrenAndParent)object;
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.getRoot();
            DefaultMutableTreeNode defaultMutableTreeNode2 = this.getTreeNode(defaultMutableTreeNode, object);
            if (!this.remove(objectWithChildrenAndParent) && (object3 = defaultMutableTreeNode.getUserObject()) instanceof RootList) {
                object2 = (RootList)object3;
                ((RootList)object2).remove(objectWithChildrenAndParent);
            }
            if (defaultMutableTreeNode2 != null) {
                object2 = defaultMutableTreeNode2.getPreviousSibling();
                if (object2 != null) {
                    breezeTree.setSelectionPath(new TreePath(((DefaultMutableTreeNode)object2).getPath()));
                } else {
                    object2 = defaultMutableTreeNode2.getNextSibling();
                    if (object2 != null) {
                        breezeTree.setSelectionPath(new TreePath(((DefaultMutableTreeNode)object2).getPath()));
                    } else {
                        object3 = (DefaultMutableTreeNode)defaultMutableTreeNode2.getParent();
                        if (object3 != null) {
                            breezeTree.setSelectionPath(new TreePath(((DefaultMutableTreeNode)object3).getPath()));
                        }
                    }
                }
            }
            this.update(null);
        } else {
            int n = this.list.indexOf(object);
            if (n >= 0) {
                this.list.remove(n);
                this.update(null);
                int n2 = this.list.size();
                if (n < n2) {
                    breezeTree.setSelectedIndex(n);
                } else if (n2 > 0) {
                    breezeTree.setSelectedIndex(n2 - 1);
                }
                return true;
            }
        }
        return false;
    }

    private boolean remove(ObjectWithChildrenAndParent objectWithChildrenAndParent) {
        ObjectWithChildrenAndParent objectWithChildrenAndParent2 = (ObjectWithChildrenAndParent)objectWithChildrenAndParent.getParent();
        if (objectWithChildrenAndParent2 != null) {
            objectWithChildrenAndParent2.removeChild(objectWithChildrenAndParent);
            return true;
        }
        return false;
    }

    public BasicTreeNode setFilter(BreezeFilter breezeFilter, Object object, int n) {
        this.filters[n] = breezeFilter;
        this.rootnode.purgeRoot();
        BasicTreeNode basicTreeNode = this.update(object);
        this.reload(this.rootnode);
        return basicTreeNode;
    }

    public void sort(BreezeTree breezeTree) {
        this.sort(breezeTree, this.type, this.accending);
    }

    public void sort(BreezeTree breezeTree, ListHelper.SortType sortType, boolean bl) {
        this.type = sortType;
        this.accending = bl;
        Object object = breezeTree.getSelectedValue();
        try {
            ListHelper.sort(this.list, sortType, bl);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.reload();
        breezeTree.setSelectedValue(object);
    }

    public BasicTreeNode update(Object object) {
        return this.rootnode.update(null, new HashSet(), object);
    }

    private DefaultMutableTreeNode getTreeNode(DefaultMutableTreeNode defaultMutableTreeNode, Object object) {
        Object object2 = defaultMutableTreeNode.getUserObject();
        if (object2 == object) {
            return defaultMutableTreeNode;
        }
        for (int i = 0; i < defaultMutableTreeNode.getChildCount(); ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = this.getTreeNode((DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i), object);
            if (defaultMutableTreeNode2 == null) continue;
            return defaultMutableTreeNode2;
        }
        return null;
    }

    private boolean matches(Object object) {
        for (BreezeFilter breezeFilter : this.filters) {
            if (breezeFilter == null || breezeFilter.matches(object)) continue;
            return false;
        }
        return true;
    }

    public int indexOf(Object object) {
        return this.list.indexOf(object);
    }

    public Object swapElement(List list, int n, int n2) {
        Object e = list.get(n);
        list.set(n, list.get(n2));
        list.set(n2, e);
        this.reload();
        return e;
    }

    public int getSize() {
        return this.list.size();
    }

    private class BasicTreeNode
    extends DefaultMutableTreeNode {
        public BasicTreeNode(Object object) {
            super(object);
        }

        public void purgeRoot() {
            int n = this.getChildCount();
            Object[] objectArray = new TreeNode[n];
            int[] nArray = new int[n];
            for (int i = this.getChildCount() - 1; i >= 0; --i) {
                BasicTreeNode basicTreeNode = (BasicTreeNode)this.getChildAt(i);
                basicTreeNode.clearUserObjectRecursive();
                objectArray[i] = basicTreeNode;
                nArray[i] = i;
            }
            this.removeAllChildren();
            ArrayTreeModel.this.nodesWereRemoved(this, nArray, objectArray);
        }

        public final BasicTreeNode update(List list, HashSet hashSet, Object object) {
            Object object2 = this.getUserObject();
            BasicTreeNode basicTreeNode = null;
            if ((list == null || hashSet.contains(object2)) && ArrayTreeModel.this.matches(object2)) {
                HashSet<Object> hashSet2;
                ArrayList<Node> arrayList = null;
                if (object2 instanceof BasicTreeParentInterface) {
                    hashSet2 = (BasicTreeParentInterface)object2;
                    arrayList = hashSet2.getChildren();
                }
                if (object2 instanceof Node) {
                    hashSet2 = (Node)object2;
                    arrayList = new ArrayList<Node>();
                    NodeList nodeList = hashSet2.getChildNodes();
                    for (int i = 0; i < nodeList.getLength(); ++i) {
                        arrayList.add(nodeList.item(i));
                    }
                }
                hashSet2 = new HashSet<Object>();
                if (arrayList != null && arrayList.size() > 0) {
                    this.checkInsertChildren(arrayList, hashSet2);
                }
                if (!this.isRoot()) {
                    basicTreeNode = this;
                }
                for (int i = this.getChildCount() - 1; i >= 0; --i) {
                    Object object3;
                    BasicTreeNode basicTreeNode2 = (BasicTreeNode)this.getChildAt(i);
                    BasicTreeNode basicTreeNode3 = basicTreeNode2.update(arrayList, hashSet2, object);
                    if (basicTreeNode3 == null || (object3 = basicTreeNode3.getUserObject()) == null || !object3.equals(object)) continue;
                    basicTreeNode = basicTreeNode3;
                }
            } else {
                this.clearUserObjectRecursive();
                ArrayTreeModel.this.removeNodeFromParent(this);
            }
            return basicTreeNode;
        }

        private HashSet checkInsertChildren(List list, HashSet<Object> hashSet) {
            HashMap<Object, BasicTreeNode> hashMap = new HashMap<Object, BasicTreeNode>();
            int n = this.getChildCount();
            for (int i = 0; i < n; ++i) {
                BasicTreeNode basicTreeNode = (BasicTreeNode)this.getChildAt(i);
                hashMap.put(basicTreeNode.getUserObject(), basicTreeNode);
            }
            for (BasicTreeNode basicTreeNode : list) {
                boolean bl = ArrayTreeModel.this.matches(basicTreeNode);
                if (basicTreeNode instanceof Node) {
                    Node node = (Node)((Object)basicTreeNode);
                    NodeList nodeList = node.getChildNodes();
                    bl = false;
                    for (int i = 0; i < nodeList.getLength(); ++i) {
                        if (nodeList.item(i).getNodeType() == 3) continue;
                        bl = true;
                    }
                }
                if (bl && !hashMap.containsKey(basicTreeNode)) {
                    int n2 = this.getChildCount();
                    ArrayTreeModel.this.insertNodeInto(new BasicTreeNode(basicTreeNode), this, n2);
                }
                hashSet.add(basicTreeNode);
            }
            return hashSet;
        }

        private void clearUserObjectRecursive() {
            int n = this.getChildCount();
            for (int i = 0; i < n; ++i) {
                BasicTreeNode basicTreeNode = (BasicTreeNode)this.getChildAt(i);
                basicTreeNode.clearUserObjectRecursive();
            }
            this.setUserObject(null);
        }
    }

    public static class RootList
    implements BasicTreeParentInterface {
        private final List list;

        public RootList(List list) {
            this.list = list;
        }

        @Override
        public List getChildren() {
            return this.list;
        }

        public void remove(Object object) {
            this.list.remove(object);
        }

        public String toString() {
            return "Root";
        }
    }
}

