/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.entry;

import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import se.prediktera.breeze.common.entry.BasicEntry;
import se.prediktera.breeze.common.entry.BasicMasterCache;
import se.prediktera.breeze.common.entry.BreezeType;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionTreeNode;
import se.prediktera.breeze.entry.Entry;
import se.prediktera.breeze.entry.analyse.Analyse;
import se.prediktera.breeze.entry.cache.BreezeMasterCache;
import se.prediktera.breeze.entry.workflow.Workflow;
import se.prediktera.breeze.frontend.common.entry.EntryMainPanel;
import se.prediktera.breeze.frontend.common.swing.BreezeButton;
import se.prediktera.breeze.frontend.common.swing.BreezeCheckBox;
import se.prediktera.breeze.frontend.common.swing.BreezeScrollPane;
import se.prediktera.breeze.frontend.common.swing.BreezeTextArea;
import se.prediktera.breeze.frontend.common.swing.BreezeTheme;
import se.prediktera.breeze.frontend.common.swing.GridBagHelper;
import se.prediktera.breeze.frontend.common.swing.dialog.AbstractBreezeCustomPanel;

public class DeleteEntryCustomPanel
extends AbstractBreezeCustomPanel {
    private final Entry workflowOrAnalyse;
    private final StringBuffer sb = new StringBuffer();
    private final List<DependantList> lists = new ArrayList<DependantList>();
    private final TextArea middleArea = new TextArea("");
    private final BreezeCheckBox forceDelete = new BreezeCheckBox("Force delete", false);
    private BreezeButton okButton;

    public DeleteEntryCustomPanel(Entry entry, String string, String string2) {
        this.workflowOrAnalyse = entry;
        this.setLayout(new GridBagLayout());
        this.setOpaque(false);
        TextArea textArea = new TextArea(string, "topText");
        textArea.setRows(2);
        this.add((Component)textArea, GridBagHelper.create(this.getComponentCount(), new Insets(12, 12, 0, 12)));
        BreezeScrollPane breezeScrollPane = new BreezeScrollPane(this.middleArea);
        breezeScrollPane.setHorizontalScrollBarPolicy(31);
        breezeScrollPane.setVerticalScrollBarPolicy(20);
        this.add((Component)breezeScrollPane, GridBagHelper.create(0, this.getComponentCount(), 1.0, 1.0, 1, new Insets(12, 12, 0, 12)));
        this.forceDelete.setName("cofirmDelete");
        this.forceDelete.setText(string2);
        this.forceDelete.setFont(new Font("Tahoma", 0, 16));
        this.forceDelete.addItemListener(itemEvent -> this.okButton.setEnabled(this.forceDelete.isSelected()));
        this.add((Component)this.forceDelete, GridBagHelper.create(this.getComponentCount(), new Insets(12, 12, 0, 12)));
    }

    @Override
    public void customButton(BreezeButton breezeButton, BreezeButton breezeButton2, BreezeButton breezeButton3) {
        this.okButton = breezeButton2;
        breezeButton2.setEnabled(false);
    }

    @Override
    public Object getResult() {
        return null;
    }

    public void add(Collection<? extends BasicEntry> collection, BreezeType breezeType) {
        if (collection.size() > 0) {
            if (this.sb.length() > 0) {
                this.sb.append("\n");
            }
            for (BasicEntry basicEntry : collection) {
                if (this.sb.length() > 0) {
                    this.sb.append("\n");
                }
                this.sb.append(breezeType.getDesc() + ": " + basicEntry.toString());
            }
            this.middleArea.setText(this.sb.toString());
            this.middleArea.setCaretPosition(0);
            this.lists.add(new DependantList(collection, breezeType));
        }
    }

    public boolean isForceDelete() {
        return this.forceDelete.isSelected();
    }

    public void delete(EntryMainPanel entryMainPanel) {
        if (this.workflowOrAnalyse instanceof Workflow) {
            BreezeMasterCache breezeMasterCache = BreezeMasterCache.getInstance();
            for (DependantList dependantList : this.lists) {
                for (BasicEntry basicEntry : dependantList.dependantList) {
                    ((Entry)basicEntry).delete(true);
                    this.removeFromBreezeMasterCache(breezeMasterCache, basicEntry);
                }
            }
        } else {
            Entry entry = this.workflowOrAnalyse;
            if (entry instanceof Analyse) {
                Analyse analyse = (Analyse)entry;
                for (DependantList dependantList : this.lists) {
                    for (BasicEntry basicEntry : dependantList.dependantList) {
                        Workflow workflow = (Workflow)basicEntry;
                        this.removeAnalyse(workflow.getRoot(), analyse);
                        workflow.save();
                    }
                }
            }
        }
        this.workflowOrAnalyse.delete(true);
        entryMainPanel.getEntryList().removeItem(this.workflowOrAnalyse);
        entryMainPanel.showFirstTab();
    }

    private void removeFromBreezeMasterCache(BasicMasterCache.MasterCacheInterface masterCacheInterface, BasicEntry basicEntry) {
        if (basicEntry instanceof Analyse) {
            masterCacheInterface.getAnalyseList().remove(basicEntry);
        } else if (basicEntry instanceof Workflow) {
            masterCacheInterface.getWorkflowList().remove(basicEntry);
        }
    }

    private boolean removeAnalyse(FunctionTreeNode functionTreeNode, Analyse analyse) {
        Iterator<FunctionTreeNode> iterator = functionTreeNode.getChildList().iterator();
        while (iterator.hasNext()) {
            if (!this.removeAnalyse(iterator.next(), analyse)) continue;
            iterator.remove();
        }
        return analyse.getUid().equals(functionTreeNode.getAnalyseUid());
    }

    public static class TextArea
    extends BreezeTextArea {
        public TextArea(String string, String string2) {
            this(string);
            this.setName(string2);
        }

        public TextArea(String string) {
            super(string, true);
            this.setEditable(false);
            this.setColumns(20);
            this.setRows(1);
            this.setFont(new Font("Tahoma", 0, 18));
            this.setBorder(BorderFactory.createEmptyBorder());
            this.setTextBackground(BreezeTheme.getInstance().getDialogBackground());
        }
    }

    private static class DependantList {
        private final Collection<? extends BasicEntry> dependantList;

        public DependantList(Collection<? extends BasicEntry> collection, BreezeType breezeType) {
            this.dependantList = collection;
        }
    }
}

