/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.entry;

import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.EventListener;
import javax.swing.JComponent;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;

public class DragMoverListener
extends MouseInputAdapter
implements MouseMotionListener {
    private final Cursor dc;
    private final Cursor hc = Cursor.getPredefinedCursor(12);
    private final Rectangle rect = new Rectangle();
    private final JComponent comp;
    private final JViewport vport;
    private final Point startPt = new Point();
    private final Point move = new Point();
    private final MouseListener[] ml;
    private int totaldistance = 0;

    public DragMoverListener(JViewport jViewport, JComponent jComponent) {
        this.vport = jViewport;
        this.comp = jComponent;
        this.dc = jComponent.getCursor();
        MouseMotionListener[] mouseMotionListenerArray = jComponent.getMouseMotionListeners();
        for (MouseMotionListener eventListener : mouseMotionListenerArray) {
            jComponent.removeMouseMotionListener(eventListener);
        }
        this.ml = jComponent.getMouseListeners();
        for (EventListener eventListener : this.ml) {
            jComponent.removeMouseListener((MouseListener)eventListener);
        }
        jComponent.addMouseListener(this);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        this.comp.setCursor(this.dc);
        if (this.totaldistance < 10) {
            for (MouseListener mouseListener : this.ml) {
                mouseListener.mouseClicked(mouseEvent);
            }
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        this.move.setLocation(point.x - this.startPt.x, point.y - this.startPt.y);
        this.totaldistance += Math.abs(point.y - this.startPt.y);
        Rectangle rectangle = this.vport.getViewRect();
        int n = rectangle.width;
        int n2 = rectangle.height;
        Point point2 = SwingUtilities.convertPoint(this.vport, 0, 0, this.comp);
        this.rect.setRect(point2.x - this.move.x, point2.y - this.move.y, n, n2);
        this.comp.scrollRectToVisible(this.rect);
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.totaldistance = 0;
        this.comp.setCursor(this.hc);
        this.startPt.setLocation(mouseEvent.getPoint());
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.comp.setCursor(this.dc);
        if (this.totaldistance < 10) {
            for (MouseListener mouseListener : this.ml) {
                mouseListener.mousePressed(mouseEvent);
            }
        }
    }
}

