/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.entry;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import se.prediktera.breeze.entry.Entry;
import se.prediktera.breeze.entry.WorkflowOrGroup;
import se.prediktera.breeze.entry.group.Group;
import se.prediktera.breeze.entry.workflow.Workflow;
import se.prediktera.breeze.frontend.common.swing.BreezeCheckBox;
import se.prediktera.breeze.frontend.common.swing.BreezeLabel;
import se.prediktera.breeze.frontend.common.swing.BreezeTextField;
import se.prediktera.breeze.frontend.common.swing.GridBagHelper;
import se.prediktera.breeze.frontend.common.swing.dialog.AbstractBreezeCustomPanel;

public class DuplicateEntryCustomPanel
extends AbstractBreezeCustomPanel {
    private final BreezeTextField inputTextField;
    private final BreezeCheckBox copyDataCheckBox = new BreezeCheckBox("Include measurements and data", false, null);
    private final BreezeCheckBox copyAnalysisCheckBox = new BreezeCheckBox("Include models", false, null);

    public DuplicateEntryCustomPanel(String string, String string2, Entry entry) {
        this.inputTextField = new BreezeTextField();
        this.setOpaque(false);
        this.setLayout(new GridBagLayout());
        this.add((Component)new BreezeLabel("Enter name for the duplicated " + string + ":"), GridBagHelper.create(this.getComponentCount(), new Insets(80, 0, 0, 0)));
        this.inputTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    DuplicateEntryCustomPanel.this.okPressed(false);
                }
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = this.getComponentCount();
        gridBagConstraints.anchor = 11;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.add((Component)this.inputTextField, gridBagConstraints);
        this.inputTextField.setMinlength(1);
        this.inputTextField.setName("input");
        if (string2 != null) {
            this.inputTextField.setText(string2);
            this.inputTextField.requestFocusAndSelectAll();
        }
        if (entry instanceof WorkflowOrGroup) {
            this.copyDataCheckBox.setSelected(entry instanceof Group);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridy = this.getComponentCount();
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(40, 0, 0, 0);
            this.add((Component)this.copyDataCheckBox, gridBagConstraints);
        }
        if (entry instanceof Workflow) {
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridy = this.getComponentCount();
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(6, 0, 0, 0);
            this.add((Component)this.copyAnalysisCheckBox, gridBagConstraints);
            this.copyAnalysisCheckBox.setEnabled(false);
            this.copyDataCheckBox.addCallback(bl -> this.copyAnalysisCheckBox.setEnabled(bl));
        }
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = this.getComponentCount();
        gridBagConstraints.weighty = 1.0;
        this.add((Component)new BreezeLabel(""), gridBagConstraints);
    }

    @Override
    public Object getResult() {
        return this.inputTextField.getText();
    }

    public boolean copyData() {
        return this.copyDataCheckBox.isSelected();
    }

    public boolean copyAnalysis() {
        return this.copyAnalysisCheckBox.isEnabled() && this.copyAnalysisCheckBox.isSelected();
    }
}

