/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.entry;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JPanel;
import se.prediktera.breeze.entry.Entry;
import se.prediktera.breeze.entry.workflow.Workflow;
import se.prediktera.breeze.frontend.BreezeFrame;
import se.prediktera.breeze.frontend.common.ArrayTreeModel;
import se.prediktera.breeze.frontend.common.entry.DuplicateEntryCustomPanel;
import se.prediktera.breeze.frontend.common.entry.EntryMainHelper;
import se.prediktera.breeze.frontend.common.entry.EntryMainItemPanel;
import se.prediktera.breeze.frontend.common.entry.EntryMainPanel;
import se.prediktera.breeze.frontend.common.swing.BreezeButton;
import se.prediktera.breeze.frontend.common.swing.BreezeGradientPanel;
import se.prediktera.breeze.frontend.common.swing.BreezeTheme;
import se.prediktera.breeze.frontend.common.swing.dialog.AbstractBreezeCustomPanel;
import se.prediktera.breeze.frontend.common.swing.dialog.AbstractBreezeDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeOptionDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.ProgressAction;
import se.prediktera.breeze.frontend.main.record.RecordGroupPanel;
import se.prediktera.map.common.error.ErrorHandler;

public class EntryButtonsPanel
extends BreezeGradientPanel {
    private final JPanel leftButton2Panel = new JPanel(new GridBagLayout());
    private final JPanel leftButtonPanel = new JPanel(new GridBagLayout());
    private final BreezeButton removeButton;
    private final EntryMainItemPanel mainPanel;
    private final BreezeButton addButton;

    public EntryButtonsPanel(EntryMainItemPanel entryMainItemPanel) {
        this.mainPanel = entryMainItemPanel;
        this.leftButtonPanel.setOpaque(false);
        BreezeTheme breezeTheme = BreezeTheme.getInstance();
        this.setBackground(breezeTheme.getPanelGradientBackground1());
        this.setForeground(breezeTheme.getPanelGradientBackground2());
        int n = EntryMainHelper.DEFAULT_SPACE;
        this.addButton = EntryMainHelper.createButton("addEntry", "Add", "material/create_new_folder", entryMainItemPanel::createLocal);
        this.addButton.setVisible(entryMainItemPanel.canAddEntry());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, n, 0, 0);
        this.leftButtonPanel.add((Component)this.addButton, gridBagConstraints);
        BreezeButton breezeButton = EntryMainHelper.createButton("duplicateEntry", "Duplicate", entryMainItemPanel.getDuplicateIcon(), () -> this.duplicateEntryClicked(entryMainItemPanel.getSelectedEntry()));
        breezeButton.setVisible(entryMainItemPanel.canDuplicateEntry());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, n, 0, 0);
        this.leftButtonPanel.add((Component)breezeButton, gridBagConstraints);
        this.removeButton = EntryMainHelper.createButton("removeEntry", "Remove", "material/delete", () -> entryMainItemPanel.entryDeleteClicked(entryMainItemPanel.getSelectedEntry()));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.insets = new Insets(0, n, 0, 0);
        this.leftButtonPanel.add((Component)this.removeButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(20, 0, 20, 0);
        this.add((Component)this.leftButtonPanel, gridBagConstraints);
        this.leftButton2Panel.setOpaque(false);
        BreezeButton breezeButton2 = EntryMainHelper.createButton("openEntry", "Open", "material/folder_open", () -> entryMainItemPanel.openButtonClicked(entryMainItemPanel.getSelectedEntry()));
        breezeButton2.setVisible(entryMainItemPanel.canOpenEntry());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.insets = new Insets(0, 20, 0, 0);
        this.leftButton2Panel.add((Component)breezeButton2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.insets = new Insets(20, 0, 20, 20);
        this.add((Component)this.leftButton2Panel, gridBagConstraints);
        this.setVisible(EntryMainHelper.hasVisibleComponents(this.leftButtonPanel) || EntryMainHelper.hasVisibleComponents(this.leftButton2Panel));
    }

    public void addLeft2Button(JComponent jComponent) {
        EntryMainHelper.addComponent(this.leftButton2Panel, jComponent);
    }

    public void addLeftButton(JComponent jComponent) {
        EntryMainHelper.addComponent(this.leftButtonPanel, jComponent);
    }

    public void duplicateEntryClicked(Object object) {
        String string = this.mainPanel.getEntryName();
        if (object == null || object instanceof ArrayTreeModel.RootList) {
            throw new EntryMainPanel.NoEntrySelectedException(string);
        }
        if (this.mainPanel instanceof RecordGroupPanel && object instanceof Workflow) {
            throw new ErrorHandler.InformationMessageException("To duplicate study, please go to main screen, right click and choose duplicate");
        }
        if (object instanceof Entry) {
            Entry entry = (Entry)object;
            EntryButtonsPanel.duplicateEntry(this.mainPanel, entry, string);
        }
    }

    public static void duplicateEntry(final EntryMainItemPanel entryMainItemPanel, final Entry entry, String string) {
        BreezeFrame breezeFrame = entryMainItemPanel.getFrame();
        BreezeOptionDialog.showDialog(breezeFrame, entryMainItemPanel.getPageType().getColor(), AbstractBreezeDialog.MessageType.CONFIRM_OPTION, "Duplicate " + string, "", (AbstractBreezeCustomPanel)new DuplicateEntryCustomPanel(string, EntryMainHelper.getUniqueName(entry.getName(), entryMainItemPanel.getEntryList().getList()), entry), null, breezeActionEvent -> {
            final DuplicateEntryCustomPanel duplicateEntryCustomPanel = (DuplicateEntryCustomPanel)breezeActionEvent.getBreezeCustomPanel();
            BreezeProgressDialog.startProgressWithCancel(breezeFrame, new ProgressAction(){

                @Override
                public void runAction() throws Exception {
                    entryMainItemPanel.addEntry(entryMainItemPanel.duplicateEntry(this.getProgressManager(), entry, duplicateEntryCustomPanel.getResult().toString(), duplicateEntryCustomPanel.copyData(), duplicateEntryCustomPanel.copyAnalysis()));
                    entryMainItemPanel.showFirstTab();
                }
            }, "Duplicating");
        });
    }

    public void setRemovedEnabled(boolean bl) {
        this.removeButton.setEnabled(bl);
    }

    public BreezeButton getAddButton() {
        return this.addButton;
    }
}

