/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.entry;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import lombok.Generated;
import se.prediktera.breeze.common.entry.BreezeType;
import se.prediktera.breeze.frontend.BreezeFrame;
import se.prediktera.breeze.frontend.BreezeMainPanel;
import se.prediktera.breeze.frontend.BreezeViewStack;
import se.prediktera.breeze.frontend.common.entry.EntryListPanel;
import se.prediktera.breeze.frontend.common.entry.EntryMainHelper;
import se.prediktera.breeze.frontend.common.entry.EntryMainItemPanel;
import se.prediktera.breeze.frontend.common.entry.EntryMainPanel;
import se.prediktera.breeze.frontend.common.entry.EntryMainSwitchPanel;
import se.prediktera.breeze.frontend.common.entry.EntryMeasurementPanel;
import se.prediktera.breeze.frontend.common.swing.BreezeButton;
import se.prediktera.breeze.frontend.common.swing.BreezeGradientPanel;
import se.prediktera.breeze.frontend.common.swing.BreezeLabel;
import se.prediktera.breeze.frontend.common.swing.BreezeSeparator;
import se.prediktera.breeze.frontend.common.swing.BreezeTheme;
import se.prediktera.breeze.frontend.common.swing.contextmenu.BreezeContextMenu;
import se.prediktera.breeze.frontend.common.util.BreezeProperties;
import se.prediktera.breeze.frontend.common.util.ListHelper;

public class EntryComponents {

    public static class EntryContentPanel
    extends JPanel {
        private final int entryWidth;
        private final EntryMainPanel mainPanel;

        public EntryContentPanel(EntryMainPanel entryMainPanel, int n, EntryListPanel entryListPanel) {
            super(new BorderLayout());
            this.mainPanel = entryMainPanel;
            this.entryWidth = n;
            this.setDefaultWidth();
            this.add((Component)entryListPanel, "Center");
        }

        public void setDefaultWidth() {
            this.setWidth(this.entryWidth);
        }

        public void setWidth(int n) {
            this.setMinimumSize(new Dimension(n, 23));
            this.setPreferredSize(new Dimension(n, 100));
            this.setMaximumSize(new Dimension(n, 100));
            this.mainPanel.revalidate();
            this.mainPanel.repaint();
        }
    }

    public static class SortButton
    extends BreezeButton {
        public SortButton(final EntryMainItemPanel entryMainItemPanel) {
            this.setResourceIcon("material/swap_vert");
            this.addMouseListener(new MouseAdapter(this){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    BreezeContextMenu breezeContextMenu = new BreezeContextMenu(entryMainItemPanel.getFrame(), null);
                    breezeContextMenu.addButtonCloseClick("Sort by date (newest)", () -> this.changeSort(ListHelper.SortType.Created, false));
                    breezeContextMenu.addButtonCloseClick("Sort by date (oldest)", () -> this.changeSort(ListHelper.SortType.Created, true));
                    breezeContextMenu.addButtonCloseClick("Sort by alphabet (A-Z)", () -> this.changeSort(ListHelper.SortType.Name, true));
                    breezeContextMenu.addButtonCloseClick("Sort by alphabet (Z-A)", () -> this.changeSort(ListHelper.SortType.Name, false));
                    breezeContextMenu.show(mouseEvent);
                }

                private void changeSort(ListHelper.SortType sortType, boolean bl) {
                    entryMainItemPanel.getEntryList().sort(sortType, bl);
                    BreezeProperties.getInstance().setSort(entryMainItemPanel.getSortName(), sortType, bl);
                }
            });
        }
    }

    public static class ToggleTreePanel
    extends JPanel {
        private final EntryMainPanel mainPanel;
        private ToggleMode mode = ToggleMode.All;

        public ToggleTreePanel(EntryMainPanel entryMainPanel) {
            super(new GridBagLayout());
            this.mainPanel = entryMainPanel;
            BreezeTheme breezeTheme = BreezeTheme.getInstance();
            this.setBackground(breezeTheme.getPanelBackground150());
            this.setMinimumSize(new Dimension(15, 65));
            this.setPreferredSize(new Dimension(15, 65));
            final ToggleMode toggleMode = entryMainPanel instanceof EntryMeasurementPanel ? ToggleMode.Thumbnail : ToggleMode.Minimum;
            ToggleButton toggleButton = new ToggleButton(toggleMode);
            toggleButton.addMouseListener(new MouseAdapter(this){
                final /* synthetic */ ToggleTreePanel this$0;
                {
                    this.this$0 = toggleTreePanel;
                }

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    this.this$0.toggleTree(this.this$0.mode == ToggleMode.All ? toggleMode : ToggleMode.All);
                }
            });
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.insets = new Insets(0, 0, 5, 0);
            this.add((Component)toggleButton, gridBagConstraints);
        }

        public void toggleTree(ToggleMode toggleMode) {
            JComponent jComponent;
            EntryMainPanel entryMainPanel;
            this.mode = toggleMode;
            boolean bl = toggleMode.equals((Object)ToggleMode.Minimum) || toggleMode.equals((Object)ToggleMode.Thumbnail);
            this.mainPanel.leftPanel.setVisible(!toggleMode.equals((Object)ToggleMode.Minimum));
            if (this.mainPanel.showLeftPanel) {
                this.mainPanel.topLeftPanel.setVisible(!bl);
                this.mainPanel.topRightPanel.setVisible(bl);
            }
            if ((entryMainPanel = this.mainPanel) instanceof EntryMainSwitchPanel) {
                jComponent = (EntryMainSwitchPanel)entryMainPanel;
                ((EntryMainSwitchPanel)jComponent).buttonsPanel.setVisible(!bl);
            }
            if (!this.mainPanel.showLeftPanel) {
                this.mainPanel.verticalLabelPanel.topPanel.setVisible(false);
            }
            jComponent = this.mainPanel.entryListPanel;
            if (toggleMode.equals((Object)ToggleMode.Thumbnail)) {
                ((JScrollPane)jComponent).setVerticalScrollBarPolicy(22);
                int n = (int)((double)this.mainPanel.getMainHeight() * 1.05);
                this.mainPanel.entryPanel.setWidth(n + 20);
            } else if (toggleMode.equals((Object)ToggleMode.All)) {
                ((JScrollPane)jComponent).setVerticalScrollBarPolicy(20);
                this.mainPanel.entryPanel.setDefaultWidth();
            }
        }

        public static enum ToggleMode {
            Minimum,
            Thumbnail,
            All;

        }

        private class ToggleButton
        extends JPanel {
            public ToggleButton(ToggleMode toggleMode) {
                this.setCursor(Cursor.getPredefinedCursor(12));
                this.setPreferredSize(new Dimension(15, 36));
            }

            @Override
            public void paint(Graphics graphics) {
                Graphics2D graphics2D = (Graphics2D)graphics;
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                graphics2D.setColor(BreezeTheme.getInstance().getIconBackground());
                graphics2D.setStroke(new BasicStroke(3.0f, 1, 0, 10.0f));
                if (ToggleTreePanel.this.mode.equals((Object)ToggleMode.All)) {
                    graphics2D.drawLine(4, 7, 9, 2);
                    graphics2D.drawLine(4, 7, 9, 12);
                } else {
                    graphics2D.drawLine(9, 7, 4, 2);
                    graphics2D.drawLine(9, 7, 4, 12);
                }
            }
        }
    }

    public static class VerticalLabelPanel
    extends JPanel {
        public final BreezeGradientPanel topPanel = new BreezeGradientPanel();
        public final JPanel labelPanel = new JPanel(new GridBagLayout());
        private final BreezeLabel titleVerticalLabel = new BreezeLabel("", false, 26);

        public VerticalLabelPanel(JPanel jPanel) {
            super(new GridBagLayout());
            this.setMinimumSize(new Dimension(60, 0));
            this.setPreferredSize(new Dimension(60, 0));
            this.topPanel.setPreferredSize(new Dimension(10, 55));
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridy = this.getComponentCount();
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 11;
            gridBagConstraints.weightx = 1.0;
            this.add((Component)this.topPanel, gridBagConstraints);
            this.labelPanel.setOpaque(false);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridy = this.getComponentCount();
            gridBagConstraints.anchor = 11;
            gridBagConstraints.insets = new Insets(10, 0, 0, 0);
            this.add((Component)this.labelPanel, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridy = this.labelPanel.getComponentCount();
            gridBagConstraints.fill = 2;
            this.labelPanel.add((Component)new BreezeSeparator(0, Color.lightGray), gridBagConstraints);
            this.titleVerticalLabel.setForeground(Color.white);
            this.titleVerticalLabel.setDirection(BreezeLabel.Direction.VERTICAL_UP);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridy = this.labelPanel.getComponentCount();
            gridBagConstraints.anchor = 11;
            gridBagConstraints.insets = new Insets(15, 0, 10, 0);
            this.labelPanel.add((Component)this.titleVerticalLabel, gridBagConstraints);
            if (jPanel != null) {
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridy = this.getComponentCount();
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.anchor = 11;
                gridBagConstraints.fill = 1;
                gridBagConstraints.insets = new Insets(10, 0, 0, 0);
                this.add((Component)jPanel, gridBagConstraints);
                jPanel.setBorder(BorderFactory.createMatteBorder(0, 0, 0, 1, BreezeTheme.getInstance().getLabelForegroundMoreDifuse()));
            }
        }

        public void setColorAndTitle(Color color, String string) {
            this.setBackground(color);
            this.topPanel.setForeground(color.brighter());
            this.topPanel.setBackground(color);
            this.titleVerticalLabel.setText(string);
        }
    }

    public static class SwitchButton
    extends JPanel {
        private final BreezeButton button;
        private BreezeType type = BreezeType.Project;

        public SwitchButton(final EntryMainSwitchPanel entryMainSwitchPanel, final boolean bl) {
            super(new GridBagLayout());
            this.setPreferredSize(new Dimension(55, 75));
            this.setMinimumSize(new Dimension(55, 75));
            this.setCursor(new Cursor(12));
            this.addMouseListener(new MouseAdapter(this){
                final /* synthetic */ SwitchButton this$0;
                {
                    this.this$0 = switchButton;
                }

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    SwitchButton.apply(entryMainSwitchPanel, bl);
                }

                @Override
                public void mouseEntered(MouseEvent mouseEvent) {
                    this.this$0.setBackground(this.this$0.type.getColor().brighter());
                }

                @Override
                public void mouseExited(MouseEvent mouseEvent) {
                    this.this$0.setBackground(this.this$0.type.getColor());
                }
            });
            this.button = new BreezeButton(){

                @Override
                protected void mouseEnteredLocal() {
                    this.setBackground(type.getColor().brighter());
                }

                @Override
                protected void mouseExitedLocal() {
                    super.mouseExitedLocal();
                    this.setBackground(type.getColor());
                }
            };
            this.button.setName("switch" + (bl ? "Right" : "Left"));
            this.button.setDesc("Analyse");
            this.button.setResourceIcon(bl ? "next2" : "back2");
            this.button.addClickCallBack(() -> SwitchButton.apply(entryMainSwitchPanel, bl));
            this.button.setDescForegroundReal(Color.white);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weightx = 1.0;
            this.add((Component)this.button, gridBagConstraints);
        }

        private static void apply(EntryMainSwitchPanel entryMainSwitchPanel, boolean bl) {
            Object object = entryMainSwitchPanel.getSelectedEntry();
            BreezeType breezeType = entryMainSwitchPanel.getPageType();
            BreezeFrame breezeFrame = entryMainSwitchPanel.getFrame();
            breezeFrame.switchPage(object, entryMainSwitchPanel, bl ? breezeType.getNext() : breezeType.getPrev());
        }

        public void setType(BreezeType breezeType) {
            this.type = breezeType;
            this.setVisible(breezeType != null);
            if (breezeType != null) {
                this.setBackground(breezeType.getColor());
                this.button.setDesc(breezeType.getDesc());
            }
        }
    }

    public static class BackButton
    extends JPanel {
        private final BreezeButton button;
        private final Runnable runnable;

        public BackButton(BreezeMainPanel breezeMainPanel, Runnable runnable) {
            super(new GridBagLayout());
            this.runnable = runnable;
            this.setOpaque(false);
            this.setCursor(new Cursor(12));
            this.setMinimumSize(new Dimension(60, 65));
            this.setPreferredSize(new Dimension(60, 65));
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    this.executeRunnable();
                }
            });
            boolean bl = this.isUpHomeScreen(breezeMainPanel);
            this.button = EntryMainHelper.createButton("up", bl ? "Home" : "Back", bl ? "material/home" : "material/navigate_before", this::executeRunnable, true);
            this.button.setDescForegroundReal(Color.white);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.anchor = 11;
            gridBagConstraints.insets = new Insets(15, 0, 0, 0);
            this.add((Component)this.button, gridBagConstraints);
        }

        private boolean isUpHomeScreen(BreezeMainPanel breezeMainPanel) {
            BreezeViewStack breezeViewStack = breezeMainPanel.getFrame().getViewStack();
            if (breezeViewStack != null) {
                return breezeViewStack.isUpHomeScreen();
            }
            return false;
        }

        public void executeRunnable() {
            this.runnable.run();
        }

        @Generated
        public BreezeButton getButton() {
            return this.button;
        }
    }
}

