/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.entry;

import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreePath;
import org.w3c.dom.Node;
import se.prediktera.breeze.backend.entry.RtWorkflow;
import se.prediktera.breeze.entry.Entry;
import se.prediktera.breeze.frontend.common.entry.EntryMainPanel;
import se.prediktera.breeze.frontend.common.swing.BreezeScrollPane;
import se.prediktera.breeze.frontend.common.swing.BreezeTheme;
import se.prediktera.breeze.frontend.common.swing.BreezeTree;
import se.prediktera.breeze.frontend.common.util.ListHelper;

public class EntryListPanel
extends BreezeScrollPane {
    public final BreezeTree list = new BreezeTree();
    public boolean updatingEntryList = false;

    public EntryListPanel(final EntryMainPanel entryMainPanel) {
        this.setViewportView((Component)((Object)this.list));
        this.list.setName("entryList");
        BreezeTheme breezeTheme = BreezeTheme.getInstance();
        this.list.setForeground(breezeTheme.getLabelForeground());
        this.list.setBackground(breezeTheme.getPanelBackground());
        this.list.setSelectionForeground(breezeTheme.getLabelForeground());
        this.list.setSelectionBackground(breezeTheme.getEntrySelectionBackground());
        this.list.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ EntryListPanel this$0;
            {
                this.this$0 = entryListPanel;
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (!this.this$0.updatingEntryList && SwingUtilities.isRightMouseButton(mouseEvent)) {
                    SwingUtilities.invokeLater(() -> {
                        int n = this.this$0.list.getRowForLocation(mouseEvent.getX(), mouseEvent.getY());
                        if (n == -1 || n > this.this$0.list.getItemCount()) {
                            return;
                        }
                        if (this.this$0.getSelectedEntries().size() <= 1) {
                            this.this$0.selectItem(this.this$0.list.getFilteredList().get(n), true);
                        }
                        entryMainPanel.rightClickOnSelected(mouseEvent);
                    });
                }
            }
        });
        this.list.addTreeSelectionListener(treeSelectionEvent -> {
            TreePath treePath = treeSelectionEvent.getNewLeadSelectionPath();
            if (!(this.updatingEntryList || treePath != null && treePath.equals(treeSelectionEvent.getOldLeadSelectionPath()))) {
                SwingUtilities.invokeLater(() -> entryMainPanel.showSelectedEntry(false));
            }
        });
        this.list.setScrollPane(this);
        this.list.addScroll();
        this.setHorizontalScrollBarPolicy(31);
        new ListHelper.DoubleClickedClass(this.list, actionEvent -> entryMainPanel.entryDoubleClicked(actionEvent.getSource()));
        this.list.addMouseListener(new MouseAdapter(this){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() == 4) {
                    entryMainPanel.backButtonClicked();
                }
            }
        });
    }

    public <T> List<T> getSelectedEntries() {
        ArrayList arrayList = new ArrayList();
        Object[] objectArray = this.list.getSelectedValues();
        if (objectArray != null) {
            Collections.addAll(arrayList, objectArray);
        }
        return arrayList;
    }

    public boolean selectItem(Object object, boolean bl) {
        if (this.list.getItemCount() > 0) {
            if (object != null) {
                this.list.setSelectedValue(object);
            } else {
                this.list.setSelectedIndex(0);
            }
            if (bl) {
                SwingUtilities.invokeLater(() -> this.list.requestFocus());
            }
            return true;
        }
        return false;
    }

    public void setEntryListModel(List<?> list, ListHelper.SortType sortType, boolean bl) {
        this.updatingEntryList = true;
        this.list.setModel(list);
        if (list != null && !list.isEmpty() && (list.getFirst() instanceof Entry || list.getFirst() instanceof RtWorkflow)) {
            this.list.sort(sortType, bl);
        }
        this.updatingEntryList = false;
    }

    public void addEntry(Object object) {
        this.list.insertElement(object);
        this.list.clearSelection();
        this.list.setSelectedValue(object, true);
    }

    public void expandTo(Node node) {
        int[] nArray;
        if (node.getChildNodes().getLength() > 1 && (nArray = this.list.getSelectionRows()) != null && nArray.length > 0 && !this.list.isExpanded(nArray[0])) {
            this.list.expandRow(nArray[0]);
        }
    }
}

