/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.entry;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.util.List;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import se.prediktera.breeze.backend.measure.applychanges.ApplyChanges;
import se.prediktera.breeze.common.entry.BreezeType;
import se.prediktera.breeze.common.entry.ThingWithName;
import se.prediktera.breeze.common.util.BreezeProgress;
import se.prediktera.breeze.common.util.RtDataFormat;
import se.prediktera.breeze.entry.analyse.Analyse;
import se.prediktera.breeze.entry.group.Group;
import se.prediktera.breeze.entry.measurement.Measurement;
import se.prediktera.breeze.entry.sample.Sample;
import se.prediktera.breeze.entry.workflow.Workflow;
import se.prediktera.breeze.evince.datasource.MeasurementDataSource;
import se.prediktera.breeze.frontend.BreezeFrame;
import se.prediktera.breeze.frontend.BreezeMainPanel;
import se.prediktera.breeze.frontend.common.entry.EntryComponents;
import se.prediktera.breeze.frontend.common.entry.EntryMainItemPanel;
import se.prediktera.breeze.frontend.common.entry.EntryMainPanel;
import se.prediktera.breeze.frontend.common.entry.EntryMainPanelInterface;
import se.prediktera.breeze.frontend.common.entry.OpenEntryProgressAction;
import se.prediktera.breeze.frontend.common.swing.BreezeButton;
import se.prediktera.breeze.frontend.common.swing.BreezeTheme;
import se.prediktera.breeze.frontend.common.swing.dialog.AbstractBreezeDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeOptionDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.ProgressAction;
import se.prediktera.breeze.frontend.common.util.ImageHelper;
import se.prediktera.breeze.frontend.common.view.visualization.PlotViewPanel;
import se.prediktera.breeze.frontend.main.model.edit.EditModelPanel;
import se.prediktera.breeze.frontend.main.play.edit.EditWorkflowPanel;
import se.prediktera.breeze.frontend.main.record.RecordGroupPanel;
import se.prediktera.breeze.frontend.main.record.edit.EditGroupPanel;
import se.prediktera.breeze.frontend.main.record.edit.common.AbstractEditEntryMainPanel;
import se.prediktera.breeze.frontend.main.settings.MaintenancePanel;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.common.error.Logg;
import se.prediktera.map.common.interaction.InteractionArray;
import se.prediktera.map.datasetcontainer.Case;
import se.prediktera.map.datasetcontainer.dataset.DataSet;
import se.prediktera.map.main.script.EvinceScriptCommands;
import se.prediktera.map.plot.axisplot.AbstractAxisPlot;

public class EntryMainHelper {
    public static int DEFAULT_SPACE = 12;

    public static void addComponent(JPanel jPanel, JComponent jComponent) {
        EntryMainHelper.addComponent(jPanel, jComponent, false);
    }

    public static void addComponent(JPanel jPanel, JComponent jComponent, boolean bl) {
        EntryMainHelper.addComponent(jPanel, jComponent, bl, jPanel.getComponentCount());
    }

    public static void addComponent(JPanel jPanel, JComponent jComponent, boolean bl, int n) {
        EntryMainHelper.addComponent(jPanel, jComponent, bl, n, DEFAULT_SPACE);
    }

    public static void addComponent(JPanel jPanel, JComponent jComponent, boolean bl, int n, int n2) {
        EntryMainHelper.addComponent(jPanel, jComponent, bl, n, n2, 0, 0);
    }

    public static void addComponent(JPanel jPanel, JComponent jComponent, boolean bl, int n, int n2, int n3, int n4) {
        int n5 = n2;
        int n6 = 0;
        if (jPanel.getComponentCount() == 0) {
            if (bl) {
                n6 = n2;
            }
        } else if (bl) {
            n5 = 0;
        }
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = n3;
        gridBagConstraints.weighty = n4;
        gridBagConstraints.fill = 3;
        gridBagConstraints.insets = new Insets(0, n5, 0, n6);
        jPanel.add((Component)jComponent, gridBagConstraints);
    }

    public static void addComponentVertical(JPanel jPanel, JComponent jComponent, boolean bl, int n, int n2) {
        EntryMainHelper.addComponentVertical(jPanel, jComponent, bl, n, n2, 0, 0);
    }

    public static void addComponentVertical(JPanel jPanel, JComponent jComponent, boolean bl, int n, int n2, int n3, int n4) {
        int n5 = n2;
        int n6 = 0;
        if (jPanel.getComponentCount() == 0) {
            if (bl) {
                n6 = n2;
            }
        } else if (bl) {
            n5 = 0;
        }
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = n3;
        gridBagConstraints.weighty = n4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(n5, 0, n6, 0);
        gridBagConstraints.gridwidth = 0;
        jPanel.add((Component)jComponent, gridBagConstraints);
    }

    public static void showEditPanel(BreezeMainPanel breezeMainPanel, boolean bl) {
        EntryMainHelper.showEditPanel(breezeMainPanel, bl, null);
    }

    public static void showEditPanel(final BreezeMainPanel breezeMainPanel, final boolean bl, final Object object) {
        BreezeProgressDialog.startProgress(breezeMainPanel.getFrame(), new OpenEntryProgressAction.OpenEntryDialogProgressAction(breezeMainPanel.getFrame()){

            @Override
            protected EntryMainPanel createOpenPanel() {
                Object object2 = breezeMainPanel.getSelectedEntry();
                if (bl) {
                    object2 = Workflow.getWorkflow(object2);
                } else if (breezeMainPanel instanceof RecordGroupPanel) {
                    object2 = breezeMainPanel.getFrame().getViewStack().getStudyContext();
                }
                if (object2 instanceof Workflow) {
                    Workflow workflow = (Workflow)object2;
                    return new EditWorkflowPanel(this.getProgressManager(), breezeMainPanel.getFrame(), breezeMainPanel.getPageType(), workflow, bl);
                }
                if (object2 instanceof Analyse) {
                    Analyse analyse = (Analyse)object2;
                    return new EditModelPanel(this.getProgressManager(), breezeMainPanel.getFrame(), breezeMainPanel.getPageType(), analyse);
                }
                Group group = Group.getGroup(object2);
                if (group == null) {
                    throw new EntryMainPanel.NoEntrySelectedException(((EntryMainPanel)breezeMainPanel).getEntryName());
                }
                return new EditGroupPanel(breezeMainPanel.getFrame(), breezeMainPanel.getPageType(), group);
            }

            @Override
            public void actionComplete() {
                super.actionComplete();
                if (object != null) {
                    AbstractEditEntryMainPanel abstractEditEntryMainPanel = (AbstractEditEntryMainPanel)this.getOpenPanel();
                    abstractEditEntryMainPanel.toggleTreePanel.toggleTree(EntryComponents.ToggleTreePanel.ToggleMode.Minimum);
                    abstractEditEntryMainPanel.setSelectedValue(object);
                }
            }
        }, "Opening...");
    }

    public static void showSettingsPanel(final BreezeFrame breezeFrame) {
        BreezeProgressDialog.startProgress(breezeFrame, new OpenEntryProgressAction.OpenEntryDialogProgressAction(breezeFrame){

            @Override
            protected EntryMainPanel createOpenPanel() {
                return new MaintenancePanel(this.getProgressManager(), breezeFrame);
            }
        }, "Opening...");
    }

    public static BreezeButton createTextButton(String string, ClickCallBack clickCallBack) {
        return EntryMainHelper.createTextButton(string, null, clickCallBack);
    }

    public static BreezeButton createTextButton(String string, String string2, ClickCallBack clickCallBack) {
        BreezeButton breezeButton = EntryMainHelper.createButton(string2, "", "", clickCallBack);
        breezeButton.setText(string);
        breezeButton.setTextFont(new Font("Tahoma", 0, 14));
        breezeButton.setPreferredSize(new Dimension(80, 25));
        breezeButton.setMinimumSize(new Dimension(80, 25));
        return breezeButton;
    }

    public static BreezeButton createSmallTextButton(String string, ClickCallBack clickCallBack) {
        BreezeButton breezeButton = EntryMainHelper.createTextButton(string, clickCallBack);
        breezeButton.setTextFont(new Font("Tahoma", 0, 12));
        breezeButton.setPreferredSize(new Dimension(65, 22));
        breezeButton.setMinimumSize(new Dimension(65, 22));
        return breezeButton;
    }

    public static BreezeButton createColorButton(String string, BreezeType breezeType, ClickCallBack clickCallBack) {
        return EntryMainHelper.createColorButton(string, breezeType.getIcon(), clickCallBack, breezeType.getColor());
    }

    public static BreezeButton createColorButton(String string, String string2, ClickCallBack clickCallBack, final Color color) {
        final Color color2 = color.darker();
        BreezeButton breezeButton = new BreezeButton(){

            @Override
            protected ImageIcon adaptIconToTheme(ImageIcon imageIcon) {
                return ImageHelper.changeGrayBrightness(imageIcon, 100);
            }

            @Override
            protected ImageIcon createHoverIcon(ImageIcon imageIcon) {
                return ImageHelper.replaceTransparentBackgroundWithColor(imageIcon, color2);
            }

            @Override
            protected void mouseEnteredLocal() {
                super.mouseEnteredLocal();
                super.setBackground(color.darker());
            }

            @Override
            protected void mouseExitedLocal() {
                super.mouseExitedLocal();
                super.setBackground(color);
            }
        };
        breezeButton.setDescForegroundReal(Color.white);
        breezeButton.setName(string.toLowerCase());
        breezeButton.setDesc(string);
        breezeButton.setResourceIcon(string2);
        breezeButton.setPreferredAndMinimumSize(55, 50);
        breezeButton.setBackground(color);
        breezeButton.setBorder(new BreezeButton.RoundedBorder(breezeButton, color, 1, 15));
        if (clickCallBack != null) {
            breezeButton.addClickCallBack(clickCallBack);
        }
        return breezeButton;
    }

    public static BreezeButton createColorNextButton(String string, BreezeType breezeType, ClickCallBack clickCallBack) {
        return EntryMainHelper.createColorNextButton(string, breezeType.getIcon(), clickCallBack, breezeType.getColor());
    }

    public static BreezeButton createColorNextButton(String string, String string2, ClickCallBack clickCallBack, Color color) {
        BreezeButton breezeButton = EntryMainHelper.createColorButton(string, string2, clickCallBack, color);
        breezeButton.setPreferredAndMinimumSize(100, 50);
        breezeButton.setName("next");
        return breezeButton;
    }

    public static BreezeButton createButton(String string, String string2, ClickCallBack clickCallBack) {
        return EntryMainHelper.createButton(null, string, string2, clickCallBack);
    }

    public static BreezeButton createButton(String string, String string2, ClickCallBack clickCallBack, boolean bl) {
        return EntryMainHelper.createButton(null, string, string2, clickCallBack, bl);
    }

    public static BreezeButton createButton(String string, String string2, String string3, ClickCallBack clickCallBack) {
        return EntryMainHelper.createButton(string, string2, string3, clickCallBack, false);
    }

    public static BreezeButton createButton(String string, String string2, String string3, ClickCallBack clickCallBack, boolean bl) {
        BreezeButton breezeButton = new BreezeButton();
        breezeButton.setName(string);
        breezeButton.setDesc(string2);
        if (bl) {
            breezeButton.setDescForegroundReal(BreezeTheme.WHITE_TEXT);
            breezeButton.setIcon(ImageHelper.changeGrayBrightness(ImageHelper.getResourceIcon(string3), 100));
        } else {
            breezeButton.setResourceIcon(string3);
        }
        if (clickCallBack != null) {
            breezeButton.addClickCallBack(clickCallBack);
        }
        return breezeButton;
    }

    public static BreezeButton createApplyButton(EntryMainPanelInterface entryMainPanelInterface, ProgressAction progressAction) {
        BreezeButton breezeButton = EntryMainHelper.createButton("applychanges", "Apply Changes", "applychanges", null);
        breezeButton.addClickCallBack(() -> {
            progressAction.setClickEvent(breezeButton.getClickEvent());
            BreezeProgressDialog.startProgressWithCancel(entryMainPanelInterface.getFrame(), progressAction, "Applying changes");
        });
        return breezeButton;
    }

    public static BreezeButton createApplyButton(final EntryMainPanelInterface entryMainPanelInterface) {
        return EntryMainHelper.createApplyButton(entryMainPanelInterface, new ProgressAction(){

            @Override
            public void runAction() {
                ApplyChanges.applyChanges((BreezeProgress)this.getProgressManager(), Measurement.getMeasurements(((EntryMainPanel)entryMainPanelInterface).getSelectedEntries()));
                entryMainPanelInterface.setDirty(true);
                entryMainPanelInterface.repaintEntryList();
            }
        });
    }

    public static BreezeButton createEditButton(EntryMainPanel entryMainPanel, boolean bl) {
        return EntryMainHelper.createButton("editEntry", (bl ? "Project" : "Model") + " options", "explore/edit", () -> EntryMainHelper.showEditPanel(entryMainPanel, bl));
    }

    public static BreezeButton createSettingsButton(BreezeFrame breezeFrame) {
        return EntryMainHelper.createSettingsButton(breezeFrame, false);
    }

    public static BreezeButton createSettingsButton(BreezeFrame breezeFrame, boolean bl) {
        BreezeButton breezeButton = EntryMainHelper.createButton("settings", "Settings", "material/settings", () -> EntryMainHelper.showSettingsPanel(breezeFrame));
        if (bl) {
            breezeButton.setDescForegroundReal(BreezeTheme.WHITE_TEXT);
            breezeButton.setIcon(ImageHelper.changeGrayBrightness(ImageHelper.getResourceIcon("material/settings"), 100));
        }
        return breezeButton;
    }

    public static BreezeButton createEvinceButton(EntryMainPanel entryMainPanel) {
        Properties properties = new Properties();
        properties.setProperty("closewithhide", "true");
        properties.setProperty("showdataset", "true");
        return EntryMainHelper.createEvinceButton(entryMainPanel, properties);
    }

    public static BreezeButton createEvinceButton(EntryMainPanel entryMainPanel, Properties properties) {
        return EntryMainHelper.createButton("Evince", "evince", () -> {
            try {
                EvinceScriptCommands.show(null, (Properties)properties);
            }
            catch (Exception exception) {
                ErrorHandler.logAndReportException((Throwable)exception);
            }
        });
    }

    public static BreezeButton createOpenMeasurementFromPlotButton(BreezeMainPanel breezeMainPanel, PlotViewPanel plotViewPanel) {
        return EntryMainHelper.createButton("Go to measurement", "explore/tab_move", () -> {
            Sample sample = EntryMainHelper.getSelectedSample((AbstractAxisPlot)plotViewPanel.getVisualization().getMainWindow());
            EntryMainHelper.showMeasurementPanel(breezeMainPanel, sample);
        });
    }

    private static Sample getSelectedSample(AbstractAxisPlot abstractAxisPlot) {
        try {
            int n;
            InteractionArray interactionArray = abstractAxisPlot.getInteractionArray(1);
            if (interactionArray != null && (n = interactionArray.getFirstSet()) >= 0) {
                DataSet dataSet = abstractAxisPlot.getDataSet();
                Case case_ = dataSet.getCase();
                MeasurementDataSource measurementDataSource = (MeasurementDataSource)case_.getDataSource();
                return measurementDataSource.getSampleAt(n);
            }
        }
        catch (Exception exception) {
            Logg.error((String)"Cannot get selected sample", (Throwable)exception);
        }
        return null;
    }

    public static void showMeasurementPanel(BreezeMainPanel breezeMainPanel, Sample sample) {
        if (sample != null) {
            EntryMainHelper.showMeasurementPanel(breezeMainPanel, sample.measurement());
        } else {
            BreezeOptionDialog.showDialog(breezeMainPanel, AbstractBreezeDialog.MessageType.INFORMATION_OPTION, "Information", "No sample selected");
        }
    }

    public static void showMeasurementPanel(BreezeMainPanel breezeMainPanel, Measurement measurement) {
        Object object = breezeMainPanel.getSelectedEntry();
        if (measurement != null) {
            if (object instanceof Group || breezeMainPanel instanceof RecordGroupPanel) {
                breezeMainPanel.selectEntry(measurement.getParent());
                EntryMainHelper.openAndSelect(breezeMainPanel, measurement, measurement.getParent());
            } else if (object instanceof Workflow) {
                Group group = measurement.getParent();
                BreezeMainPanel breezeMainPanel2 = ((EntryMainItemPanel)breezeMainPanel).createOpenPanelPublic(null, object);
                breezeMainPanel2.selectEntry(group);
                breezeMainPanel.getFrame().addPage(breezeMainPanel2);
                EntryMainHelper.openAndSelect(breezeMainPanel2, measurement, group);
            }
        } else {
            BreezeOptionDialog.showDialog(breezeMainPanel, AbstractBreezeDialog.MessageType.INFORMATION_OPTION, "Information", "No measurement selected");
        }
    }

    private static void openAndSelect(EntryMainPanelInterface entryMainPanelInterface, Measurement measurement, Group group) {
        BreezeMainPanel breezeMainPanel = ((EntryMainItemPanel)entryMainPanelInterface).createOpenPanelPublic(null, group);
        breezeMainPanel.selectEntry(measurement);
        entryMainPanelInterface.getFrame().addPage(breezeMainPanel);
    }

    public static void addComponentToPanel(JPanel jPanel, JComponent jComponent, int n, int n2, int n3, int n4, double d, double d2, int n5, Insets insets, int n6) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagConstraints.weightx = d;
        gridBagConstraints.weighty = d2;
        gridBagConstraints.fill = n6;
        gridBagConstraints.anchor = n5;
        gridBagConstraints.insets = insets;
        jPanel.add((Component)jComponent, gridBagConstraints);
    }

    public static String getUniqueName(String string, List<?> list) {
        String string2;
        if (!EntryMainHelper.contains(list, string)) {
            return string;
        }
        String string3 = string;
        int n = string.lastIndexOf("(");
        int n2 = string.lastIndexOf(")");
        if (n > 0 && n2 > n && RtDataFormat.isNumber(string2 = string.substring(n + 1, n2))) {
            string3 = string.substring(0, n).trim();
        }
        int n3 = 1;
        String string4 = string3 + " (" + n3 + ")";
        while (EntryMainHelper.contains(list, string4)) {
            string4 = string3 + " (" + ++n3 + ")";
        }
        return string4;
    }

    private static boolean contains(List<?> list, String string) {
        for (Object obj : list) {
            String string2 = obj.toString();
            if (obj instanceof ThingWithName) {
                string2 = ((ThingWithName)obj).getName();
            }
            if (string2 == null || !string2.equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    public static void checkAndThrowIfExist(List<?> list, String string) {
        if (EntryMainHelper.contains(list, string)) {
            throw new ErrorHandler.InformationMessageException("File name (" + string + ") already exists");
        }
    }

    public static boolean hasVisibleComponents(JComponent jComponent) {
        for (int i = 0; i < jComponent.getComponentCount(); ++i) {
            if (!jComponent.getComponent(i).isVisible()) continue;
            return true;
        }
        return false;
    }

    public static void registerKeyAction(final JComponent jComponent, KeyStroke keyStroke, final Runnable runnable) {
        EntryMainHelper.registerKeyAction(jComponent, KeyStroke.getKeyStroke(127, 0), new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (SwingUtilities.isDescendingFrom(KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner(), jComponent)) {
                    runnable.run();
                }
            }
        });
    }

    public static void registerKeyAction(JComponent jComponent, KeyStroke keyStroke, Action action) {
        InputMap inputMap = jComponent.getInputMap(1);
        String string = "Input_" + inputMap.size();
        inputMap.put(keyStroke, string);
        ActionMap actionMap = jComponent.getActionMap();
        actionMap.put(string, action);
    }

    public static interface ClickCallBack {
        public void doClick();
    }
}

