/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.entry;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import se.prediktera.breeze.common.entry.BasicEntry;
import se.prediktera.breeze.common.entry.BreezeType;
import se.prediktera.breeze.common.entry.ObjectWithChildrenAndParent;
import se.prediktera.breeze.common.util.BreezeProgress;
import se.prediktera.breeze.entry.Entry;
import se.prediktera.breeze.entry.analyse.Analyse;
import se.prediktera.breeze.entry.group.Group;
import se.prediktera.breeze.entry.sample.Sample;
import se.prediktera.breeze.entry.workflow.Workflow;
import se.prediktera.breeze.frontend.BreezeFrame;
import se.prediktera.breeze.frontend.BreezeMainPanel;
import se.prediktera.breeze.frontend.common.ArrayTreeModel;
import se.prediktera.breeze.frontend.common.entry.DeleteEntryCustomPanel;
import se.prediktera.breeze.frontend.common.entry.EntryButtonsPanel;
import se.prediktera.breeze.frontend.common.entry.EntryMainHelper;
import se.prediktera.breeze.frontend.common.entry.EntryMainPanel;
import se.prediktera.breeze.frontend.common.entry.EntryTitlePanel;
import se.prediktera.breeze.frontend.common.swing.BreezeActionListener;
import se.prediktera.breeze.frontend.common.swing.dialog.AbstractBreezeCustomPanel;
import se.prediktera.breeze.frontend.common.swing.dialog.AbstractBreezeDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeOptionDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressManager;
import se.prediktera.breeze.frontend.common.swing.dialog.ProgressAction;
import se.prediktera.breeze.util.UserFriendlyString;

public abstract class EntryMainItemPanel
extends EntryMainPanel {
    public final EntryButtonsPanel buttonsPanel = new EntryButtonsPanel(this);

    public EntryMainItemPanel(BreezeFrame breezeFrame, BreezeType breezeType, String string, boolean bl, boolean bl2) {
        super(breezeFrame, breezeType, string, bl, bl2);
        this.topRightPanel.setMinimumSize(new Dimension(0, 45));
        this.topRightPanel.setPreferredSize(new Dimension(0, 45));
        this.topRightPanel.setMaximumSize(new Dimension(0, 45));
        this.topRightPanel.setVisible(false);
        this.buttonsPanel.setVisible(bl2);
        this.buttonsPanel.setMinimumSize(new Dimension(178, 65));
        this.buttonsPanel.setPreferredSize(new Dimension(178, 65));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        this.leftPanel.add((Component)this.buttonsPanel, gridBagConstraints);
        EntryMainHelper.registerKeyAction((JComponent)this, KeyStroke.getKeyStroke(127, 0), new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner() == EntryMainItemPanel.this.getEntryList()) {
                    EntryMainItemPanel.this.entryDeleteClicked(EntryMainItemPanel.this.getSelectedEntry());
                }
            }
        });
    }

    @Override
    protected Component CreateTitlePanel(String string) {
        return new EntryTitlePanel(this, string);
    }

    protected boolean canAddEntry() {
        return true;
    }

    protected boolean canDuplicateEntry() {
        return this.canAddEntry();
    }

    protected boolean canOpenEntry() {
        return this.canAddEntry();
    }

    @Override
    public void addLeft2Button(JComponent jComponent) {
        this.buttonsPanel.addLeft2Button(jComponent);
    }

    public void addLeftButton(JComponent jComponent) {
        this.buttonsPanel.addLeftButton(jComponent);
    }

    protected void setRemovedEnabled(boolean bl) {
        this.buttonsPanel.setRemovedEnabled(bl);
    }

    public BreezeMainPanel createOpenPanelPublic(BreezeProgress breezeProgress, Object object) {
        return this.createOpenPanel(breezeProgress, object);
    }

    protected BreezeMainPanel createOpenPanel(BreezeProgress breezeProgress, Object object) {
        return null;
    }

    protected void openButtonClicked(Object object) {
    }

    @Override
    protected void entryDoubleClicked(Object object) {
        this.openButtonClicked(object);
    }

    protected Entry duplicateEntry(BreezeProgressManager breezeProgressManager, Object object, String string, boolean bl, boolean bl2) {
        throw new RuntimeException("Duplicate not supported");
    }

    protected void createLocal() {
    }

    public void entryDeleteClicked(Object object) {
        Object object2;
        final List list = this.getSelectedEntries();
        if (list.isEmpty() || object instanceof ArrayTreeModel.RootList) {
            throw new EntryMainPanel.NoEntrySelectedException(this.getEntryName());
        }
        int n = 0;
        Object object3 = "";
        for (Object object4 : list) {
            if (!((String)object3).isEmpty()) {
                object3 = (String)object3 + ", ";
            }
            object3 = (String)object3 + object4.toString();
            if (!(object4 instanceof ObjectWithChildrenAndParent)) continue;
            object2 = (ObjectWithChildrenAndParent)object4;
            n += object2.getChildCount();
        }
        DeleteEntryCustomPanel deleteEntryCustomPanel = this.getFirstDependantMessageBeforeDelete(list);
        if (deleteEntryCustomPanel == null) {
            String string;
            Object object4;
            object4 = "Confirm delete";
            object2 = new UserFriendlyString((String)object3).getFirst(200);
            String string2 = "";
            Object object5 = object;
            int n2 = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Workflow.class, Group.class, Analyse.class}, (Object)object5, n2)) {
                case 0: {
                    string = n == 1 ? "group" : "groups";
                    string2 = "project ";
                    object4 = object4 + " - Project";
                    break;
                }
                case 1: {
                    string = n == 1 ? "measurement" : "measurements";
                    string2 = "group ";
                    object4 = object4 + " - Group";
                    break;
                }
                case 2: {
                    object4 = object4 + " - Analyse";
                    string2 = "analyse ";
                    string = n == 1 ? "model" : "models";
                    break;
                }
                default: {
                    string = "sample(s)";
                }
            }
            object5 = n > 0 ? " and " + n + " " + string : "";
            StringBuilder stringBuilder = new StringBuilder("You are about to delete ").append(string2).append("\"").append((String)object2).append("\"").append((String)object5).append(".\n\nAre you sure you want to continue?");
            BreezeActionListener breezeActionListener = breezeActionEvent -> BreezeProgressDialog.startProgressWithCancel(this.frame, new ProgressAction(this){
                final /* synthetic */ EntryMainItemPanel this$0;
                {
                    this.this$0 = entryMainItemPanel;
                }

                @Override
                public void runAction() throws Exception {
                    ArrayList<BasicEntry> arrayList = this.this$0.deleteEntries(this.getProgressManager(), list);
                    this.this$0.getEntryList().setSelectedValue(null);
                    this.this$0.showEmptyPageIfNoItems();
                    if (!arrayList.isEmpty()) {
                        StringBuilder stringBuilder = new StringBuilder();
                        for (BasicEntry basicEntry : arrayList) {
                            if (!stringBuilder.isEmpty()) {
                                stringBuilder.append(", ");
                            }
                            stringBuilder.append(basicEntry.toString());
                        }
                        BreezeOptionDialog.showDialog(this.this$0, AbstractBreezeDialog.MessageType.ERROR_OPTION, "Cannot delete", "Could not delete item \"" + String.valueOf(stringBuilder) + "\"");
                    }
                }
            }, "Deleting...");
            BreezeOptionDialog.showDialog(this, AbstractBreezeDialog.MessageType.CONFIRM_OPTION, object4, stringBuilder.toString(), breezeActionListener);
        } else {
            BreezeOptionDialog.showDialog(this.getFrame(), this.getPageType().getColor(), AbstractBreezeDialog.MessageType.CONFIRM_OPTION, "Confirm delete", "", (AbstractBreezeCustomPanel)deleteEntryCustomPanel, null, breezeActionEvent -> deleteEntryCustomPanel.delete(this));
        }
    }

    protected ArrayList<BasicEntry> deleteEntries(BreezeProgress breezeProgress, List list) {
        ArrayList<BasicEntry> arrayList = new ArrayList<BasicEntry>();
        breezeProgress.setMaximumAndReset(list.size());
        for (Object e : list) {
            if (breezeProgress.isAborted()) break;
            boolean bl = true;
            if (e instanceof BasicEntry) {
                BasicEntry basicEntry = (BasicEntry)e;
                if (e instanceof Sample) {
                    this.getEntryList().removeItem(e);
                } else {
                    bl = basicEntry.delete(true);
                    if (bl) {
                        this.getEntryList().removeItem(e);
                    }
                }
                if (!bl) {
                    arrayList.add(basicEntry);
                }
            }
            breezeProgress.incStep();
        }
        return arrayList;
    }

    private DeleteEntryCustomPanel getFirstDependantMessageBeforeDelete(List list) {
        for (Object e : list) {
            DeleteEntryCustomPanel deleteEntryCustomPanel = this.getDependantMessageBeforeDelete(e);
            if (deleteEntryCustomPanel == null) continue;
            return deleteEntryCustomPanel;
        }
        return null;
    }

    protected DeleteEntryCustomPanel getDependantMessageBeforeDelete(Object object) {
        return null;
    }

    public String getDuplicateIcon() {
        return "material/folder_copy";
    }
}

