/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.entry;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.apache.commons.lang3.tuple.Pair;
import org.w3c.dom.Node;
import se.prediktera.breeze.common.entry.BreezeType;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionTreeNode;
import se.prediktera.breeze.entry.Entry;
import se.prediktera.breeze.entry.GroupNode;
import se.prediktera.breeze.entry.workflow.VisualisationNode;
import se.prediktera.breeze.entry.workflow.Workflow;
import se.prediktera.breeze.evince.data.queue.UpdateVisualizationJob;
import se.prediktera.breeze.frontend.BreezeFrame;
import se.prediktera.breeze.frontend.BreezeMainPanel;
import se.prediktera.breeze.frontend.common.entry.EntryComponents;
import se.prediktera.breeze.frontend.common.entry.EntryListPanel;
import se.prediktera.breeze.frontend.common.entry.EntryMainHelper;
import se.prediktera.breeze.frontend.common.entry.EntryPanel;
import se.prediktera.breeze.frontend.common.entry.EntryPathPanel;
import se.prediktera.breeze.frontend.common.entry.EntryStatusPanel;
import se.prediktera.breeze.frontend.common.entry.EntryTabPanel;
import se.prediktera.breeze.frontend.common.entry.EntryTitlePanel;
import se.prediktera.breeze.frontend.common.entry.TabPanel;
import se.prediktera.breeze.frontend.common.swing.BreezeButton;
import se.prediktera.breeze.frontend.common.swing.BreezeGradientPanel;
import se.prediktera.breeze.frontend.common.swing.BreezeTheme;
import se.prediktera.breeze.frontend.common.swing.BreezeTree;
import se.prediktera.breeze.frontend.common.swing.dialog.AbstractBreezeCustomPanel;
import se.prediktera.breeze.frontend.common.swing.dialog.AbstractBreezeDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeOptionDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressManager;
import se.prediktera.breeze.frontend.common.util.BreezeProperties;
import se.prediktera.breeze.frontend.common.util.ListHelper;
import se.prediktera.breeze.frontend.common.view.ViewClass;
import se.prediktera.breeze.frontend.main.WelcomePanel;
import se.prediktera.breeze.frontend.wizard.measure.step.WizardStep;
import se.prediktera.breeze.recorder.BreezeRecorder;
import se.prediktera.map.common.SwingTimer;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.main.Project_GUI;

public abstract class EntryMainPanel
extends BreezeMainPanel
implements BreezeFrame.IFrameColor {
    public static final int titleHeight = 65;
    private SwingTimer refreshTimer = null;
    private boolean dirty;
    protected Object entry;
    private ViewClass internalViewClass;
    private boolean hascleanup = false;
    private final BreezeType pageType;
    protected final ViewClass emptyPage = new ViewClass.EmptyPage(this.getEmptyPageMessage());
    private final boolean showViewPanel;
    private Object lastEntry = null;
    private Object lastViewClass = null;
    public final JPanel leftPanel = new JPanel(new GridBagLayout());
    public final EntryComponents.BackButton backButton = new EntryComponents.BackButton(this, this::backButtonClicked);
    public final BreezeGradientPanel bottomRightPanel = new BreezeGradientPanel();
    public final JPanel entryCenterPanel = new JPanel(new BorderLayout());
    public final EntryComponents.EntryContentPanel entryPanel;
    public final EntryListPanel entryListPanel = new EntryListPanel(this);
    protected final EntryTabPanel entryTabPanel;
    protected final BreezeRecorder.ActionButtonPanel verticalButtons = new BreezeRecorder.ActionButtonPanel();
    public final EntryComponents.VerticalLabelPanel verticalLabelPanel = new EntryComponents.VerticalLabelPanel(this.verticalButtons);
    private final JPanel rightButton2Panel = new JPanel(new GridBagLayout());
    private final JPanel rightButtonPanel = new JPanel(new GridBagLayout());
    private final JPanel statusPanel = new JPanel(new BorderLayout());
    public final JPanel middlePanel = new JPanel(new BorderLayout());
    public final BreezeGradientPanel topLeftPanel = new BreezeGradientPanel();
    public final BreezeGradientPanel topRightPanel = new BreezeGradientPanel();
    private EntryStatusPanel panelStatus;
    public EntryPathPanel entryPathPanel;
    public final EntryComponents.ToggleTreePanel toggleTreePanel = new EntryComponents.ToggleTreePanel(this);
    public BreezeOptionDialog.TopPanel topPanel;
    public boolean showLeftPanel = true;
    private final String title;
    protected BreezeButton nextButton = null;
    protected final JPanel rightPanel;

    public EntryMainPanel() {
        this(null, BreezeType.Project, "Title", true, true);
    }

    public EntryMainPanel(BreezeFrame breezeFrame, BreezeType breezeType, String string, boolean bl, boolean bl2) {
        this(breezeFrame, breezeType, string, bl, bl2, BreezeProperties.getInstance().getEntryWidth());
    }

    public EntryMainPanel(BreezeFrame breezeFrame, BreezeType breezeType, String string, boolean bl, boolean bl2, int n) {
        super(breezeFrame);
        this.title = string;
        this.showViewPanel = bl;
        this.pageType = breezeType;
        BreezeTheme breezeTheme = BreezeTheme.getInstance();
        this.topLeftPanel.setMinimumSize(new Dimension(0, 40));
        this.topLeftPanel.setPreferredSize(new Dimension(0, 40));
        this.topLeftPanel.setBackground(breezeTheme.getPanelGradientBackground2());
        this.topLeftPanel.setForeground(breezeTheme.getPanelGradientBackground2());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        this.verticalLabelPanel.topPanel.add((Component)this.backButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.topLeftPanel.add(this.CreateTitlePanel(string), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        this.leftPanel.add((Component)this.topLeftPanel, gridBagConstraints);
        this.entryPanel = new EntryComponents.EntryContentPanel(this, n, this.entryListPanel);
        this.entryCenterPanel.add((Component)this.entryPanel, "Center");
        this.leftPanel.setBackground(breezeTheme.getPanelBackground());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 0);
        this.leftPanel.add((Component)this.entryCenterPanel, gridBagConstraints);
        this.middlePanel.add((Component)this.verticalLabelPanel, "West");
        this.middlePanel.add((Component)this.leftPanel, "Center");
        this.middlePanel.add((Component)this.toggleTreePanel, "East");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        this.add((Component)this.middlePanel, gridBagConstraints);
        this.topRightPanel.setMinimumSize(new Dimension(0, 65));
        this.topRightPanel.setPreferredSize(new Dimension(0, 65));
        this.topRightPanel.setMaximumSize(new Dimension(0, 65));
        this.topRightPanel.setBackground(breezeTheme.getPanelGradientBackground2());
        this.topRightPanel.setForeground(breezeTheme.getPanelGradientBackground1());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.entryPathPanel = new EntryPathPanel(this, string, true);
        this.topRightPanel.add((Component)this.entryPathPanel, gridBagConstraints);
        this.statusPanel.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 20);
        this.topRightPanel.add((Component)this.statusPanel, gridBagConstraints);
        this.bottomRightPanel.setVisible(bl2);
        this.bottomRightPanel.setMinimumSize(new Dimension(0, 65));
        this.bottomRightPanel.setPreferredSize(new Dimension(0, 65));
        this.bottomRightPanel.setBackground(breezeTheme.getPanelGradientBackground1());
        this.bottomRightPanel.setForeground(breezeTheme.getPanelGradientBackground2());
        this.rightButtonPanel.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 20);
        this.bottomRightPanel.add((Component)this.rightButtonPanel, gridBagConstraints);
        this.rightButton2Panel.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        this.bottomRightPanel.add((Component)this.rightButton2Panel, gridBagConstraints);
        this.rightPanel = new JPanel(new BorderLayout());
        this.rightPanel.add((Component)this.topRightPanel, "North");
        this.rightPanel.add((Component)this.bottomRightPanel, "South");
        this.entryTabPanel = new EntryTabPanel(this, bl);
        this.rightPanel.add((Component)((Object)this.entryTabPanel), "Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.rightPanel, gridBagConstraints);
        this.verticalLabelPanel.setColorAndTitle(breezeType.getColor(), string);
        this.addVerticalButtons(true);
    }

    protected void addVerticalButtons(boolean bl) {
        BreezeButton breezeButton = EntryMainHelper.createButton("Help", "material/help", () -> BreezeOptionDialog.showDialog(this.getFrame(), BreezeType.Project.getColor(), AbstractBreezeDialog.MessageType.INFORMATION_OPTION, "Introduction to Breeze", "", (AbstractBreezeCustomPanel)new WelcomePanel(false), null, null));
        if (bl) {
            this.verticalButtons.addComponentLast(breezeButton, 100);
        } else {
            this.verticalButtons.addComponent(breezeButton, 100, 10);
        }
    }

    protected Component CreateTitlePanel(String string) {
        return EntryTitlePanel.createTitleLabel(string);
    }

    public void addRight2Button(JComponent jComponent) {
        EntryMainHelper.addComponent(this.rightButton2Panel, jComponent, true);
    }

    @Override
    public void addRightButton(JComponent jComponent) {
        EntryMainHelper.addComponent(this.rightButtonPanel, jComponent);
    }

    public JPanel getRightButtonPanel() {
        return this.rightButtonPanel;
    }

    public void rightClickOnSelected(MouseEvent mouseEvent) {
    }

    @Override
    public void showSelectedEntry(boolean bl) {
        Pair<ViewClass, Object> pair;
        ViewClass viewClass;
        final Object object = this.getSelectedEntry();
        var var5_5 = new WizardStep.LeaveControlCallback(){
            final /* synthetic */ ViewClass val$viewClass;
            final /* synthetic */ Pair val$viewClassPair;
            final /* synthetic */ EntryMainPanel this$0;
            {
                this.val$viewClass = viewClass;
                this.val$viewClassPair = pair;
                this.this$0 = entryMainPanel;
            }

            @Override
            public void leaveWithControl() {
                if (this.this$0.entryListPanel.list.getItemCount() == 0) {
                    this.this$0.showEmptyPage();
                } else {
                    this.this$0.setFormatedTitle(object);
                    this.this$0.entrySelected(object);
                    this.this$0.setViewClass(this.val$viewClass, this.val$viewClassPair.getRight());
                }
                this.this$0.setDirty(false);
            }
        };
        if (this.entryTabPanel.leaveCurrentPanel(var5_5, viewClass).ok()) {
            var5_5.leaveWithControl();
        }
    }

    private Pair<ViewClass, Object> getViewClassPair(Object object) {
        if (object instanceof ViewClass) {
            ViewClass viewClass = (ViewClass)object;
            return Pair.of((Object)viewClass, null);
        }
        TabPanel.Tab tab = this.entryTabPanel.getSelectedTab();
        if (tab instanceof ViewClass) {
            ViewClass viewClass = (ViewClass)tab;
            return Pair.of((Object)viewClass, (Object)object);
        }
        return Pair.of(null, null);
    }

    protected final void setViewClass(ViewClass viewClass, Object object) {
        this.entryTabPanel.selectTab(viewClass);
        this.updateTitle(viewClass, object);
        this.setCurrentPanel(viewClass, object);
    }

    @Override
    public BreezeTree getEntryList() {
        return this.entryListPanel.list;
    }

    @Override
    public Object getInData(BreezeProgressManager breezeProgressManager, UpdateVisualizationJob updateVisualizationJob, String string) {
        return null;
    }

    @Override
    public BreezeType getPageType() {
        return this.pageType;
    }

    @Override
    public Project_GUI getOrCreateEvinceProject() {
        return this.entryTabPanel.getOrCreateEvinceProject();
    }

    @Override
    public VisualisationNode.ColorScale getColorScale() {
        Workflow workflow = Workflow.getWorkflow(this.getSelectedEntry());
        if (workflow != null) {
            return workflow.getColorScale();
        }
        return BreezeProperties.getInstance().getColorScale();
    }

    @Override
    public <T> List<T> getSelectedEntries() {
        return this.entryListPanel.getSelectedEntries();
    }

    @Override
    public Object getSelectedEntry() {
        return this.entryListPanel.list.getSelectedValue();
    }

    @Override
    public void repaintEntryList() {
        this.entryListPanel.repaint();
        this.entryTabPanel.repaint();
    }

    @Override
    public void selectEntry(Object object) {
        this.selectEntry(object, false);
    }

    public void selectEntry(Object object, boolean bl) {
        this.entryListPanel.list.setSelectedValue(object, bl);
    }

    public void selectFirstItem(boolean bl) {
        this.selectItem(this.getFirstItem(), bl);
    }

    @Override
    public void selectItem(Object object, boolean bl) {
        if (this.entryListPanel.selectItem(object, bl)) {
            if (this.showViewPanel) {
                this.entryTabPanel.showTabs(true);
            }
        } else {
            this.showEmptyPage();
        }
    }

    protected Entry getFirstItem() {
        return null;
    }

    public void setLists(List<ViewClass> list, List list2, String string) {
        this.entryTabPanel.addTabs(list);
        final EntryPanel entryPanel = new EntryPanel(string, this.entryListPanel.getBackground(), this.getMainHeight());
        this.entryListPanel.list.setCellRenderer(entryPanel);
        this.entryListPanel.list.addMouseMotionListener(new MouseMotionAdapter(this){
            final /* synthetic */ EntryMainPanel this$0;
            {
                this.this$0 = entryMainPanel;
            }

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                super.mouseMoved(mouseEvent);
                int n = this.this$0.entryListPanel.list.getRowForLocation(mouseEvent.getX(), mouseEvent.getY());
                if (entryPanel.getHoverIndex() != n) {
                    entryPanel.setHoverIndex(n);
                    this.this$0.entryListPanel.list.repaint();
                }
            }
        });
        this.entryListPanel.list.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ EntryMainPanel this$0;
            {
                this.this$0 = entryMainPanel;
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                super.mouseExited(mouseEvent);
                entryPanel.setHoverIndex(-1);
                this.this$0.entryListPanel.list.repaint();
            }
        });
        this.entryTabPanel.addPage(this.emptyPage);
        this.setEntryListModel(list2);
    }

    @Override
    public void setEntryListModel(List list) {
        BreezeProperties breezeProperties = BreezeProperties.getInstance();
        String string = this.getSortName();
        this.setEntryListModel(list, breezeProperties.getSortType(string), breezeProperties.isSortAscending(string));
    }

    @Override
    public void setEntryListModel(List list, ListHelper.SortType sortType, boolean bl) {
        this.entryListPanel.setEntryListModel(list, sortType, bl);
    }

    protected String getSortName() {
        return "sort";
    }

    protected int getMainHeight() {
        return 100;
    }

    public void setStatusPanel(EntryStatusPanel entryStatusPanel) {
        this.panelStatus = entryStatusPanel;
        if (entryStatusPanel != null) {
            this.statusPanel.add((Component)entryStatusPanel, "Center");
        }
    }

    private void updateDataOnSidePanels(boolean bl) {
        Object object = this.getSelectedEntry();
        if (bl) {
            List list = this.getSelectedEntries();
            if (object != null && list.size() > 1) {
                object = null;
            }
            this.setFormatedTitle(object);
        }
    }

    protected void addCustomButton() {
    }

    public void addEntry(Object object) {
        this.entryListPanel.addEntry(object);
        this.entryTabPanel.showTabs(this.showViewPanel);
    }

    public void backButtonClicked() {
        var var1_1 = new WizardStep.LeaveControlCallback(){

            @Override
            public void leaveWithControl() {
                EntryMainPanel.this.frame.removePage(EntryMainPanel.this);
            }
        };
        WizardStep.LeaveResult leaveResult = this.entryTabPanel.leaveEntry(var1_1);
        if (leaveResult.ok()) {
            var1_1.leaveWithControl();
        }
    }

    protected void entrySelected(Object object) {
    }

    public String getEmptyPageMessage() {
        return "Add new " + this.getEntryName() + " by clicking on the Add button";
    }

    public String getEntryName() {
        return "Entry";
    }

    public String getNextEntryName() {
        return this.getEntryName();
    }

    protected void setCurrentPanel(ViewClass viewClass, Object object) {
        this.internalViewClass = viewClass;
        this.entry = object;
        if (this.entry instanceof GroupNode) {
            this.showEmptyPage();
            return;
        }
        this.entryTabPanel.setCurrentPanel(viewClass, object);
        Object object2 = this.entry;
        if (object2 instanceof Node) {
            Node node = (Node)object2;
            this.entryListPanel.expandTo(node);
        }
        this.updateDataOnSidePanels(false);
        if (this.entry != this.lastEntry || this.internalViewClass != this.lastViewClass) {
            this.rightButtonPanel.removeAll();
            this.rightButton2Panel.removeAll();
            this.entryTabPanel.addButtons(this.rightButton2Panel, this.nextButton);
            this.addCustomButton();
            this.bottomRightPanel.revalidate();
            this.bottomRightPanel.repaint();
            this.lastEntry = this.entry;
            this.lastViewClass = this.internalViewClass;
        }
    }

    protected final BreezeButton getNextButton() {
        return this.nextButton;
    }

    public boolean showEmptyPageIfNoItems() {
        if (this.entryListPanel.list.getItemCount() == 0) {
            this.showEmptyPage();
            return true;
        }
        return false;
    }

    protected void showEmptyPage() {
        this.entryTabPanel.showTabs(false);
        this.setViewClass(this.emptyPage, null);
        this.setCurrentPanel(this.emptyPage, null);
        this.setFormatedTitle(null);
    }

    protected void updateTitle(ViewClass viewClass, Object object) {
        String string = viewClass.getName();
        String string2 = this.getEntryName(object);
        if (string2 != null && !string2.equals(string)) {
            this.setFormatedTitle(object);
        }
    }

    public void setFormatedTitle(Object object) {
        this.entryPathPanel.setFormatedTitle(object);
    }

    protected void showFirstTab() {
        this.entryTabPanel.selectTab(0);
    }

    @Override
    public void selectTab(String string) {
        this.entryTabPanel.setSelectedTab(string);
    }

    protected String getEntryName(Object object) {
        if (object != null) {
            if (object instanceof Node) {
                return ((Node)object).getNodeName();
            }
            if (object instanceof FunctionTreeNode) {
                return ((FunctionTreeNode)object).getAliasOrNodeString();
            }
            return object.toString();
        }
        return "";
    }

    public void onShow() {
        if (this.panelStatus != null) {
            this.panelStatus.onShow();
        }
    }

    public void openFromMainPanel() {
    }

    protected EntryStatusPanel createStatusPanel() {
        return this.createStatusPanel(true);
    }

    protected EntryStatusPanel createStatusPanel(boolean bl) {
        return new EntryStatusPanel(this, bl);
    }

    @Override
    public void setDirty(boolean bl) {
        this.dirty = bl;
        if (bl && this.refreshTimer == null) {
            this.refreshTimer = new SwingTimer(500, actionEvent -> {
                if (this.dirty) {
                    this.showSelectedEntry(false);
                }
            }, true);
            this.refreshTimer.start();
        }
    }

    @Override
    public final synchronized void cleanUp() {
        if (this.hascleanup) {
            return;
        }
        this.removeAll();
        if (this.getParent() != null) {
            this.getParent().remove(this);
        }
        this.setVisible(false);
        this.hascleanup = true;
        if (this.refreshTimer != null) {
            this.refreshTimer.stop();
            this.refreshTimer = null;
        }
        this.entryTabPanel.cleanUp();
        this.entryListPanel.list.cleanUp();
        this.entryTabPanel.cleanUpChild();
    }

    public ViewClass getViewClass() {
        return this.internalViewClass;
    }

    public String getTitle() {
        return this.title;
    }

    protected void entryDoubleClicked(Object object) {
    }

    public void showPanelFullScreen(boolean bl) {
        this.entryTabPanel.setShowViewPanel(!bl);
        this.entryTabPanel.showTabs(!bl);
        this.bottomRightPanel.setVisible(!bl);
        this.topRightPanel.setVisible(!bl);
    }

    public static class NoEntrySelectedException
    extends ErrorHandler.InformationMessageException {
        public NoEntrySelectedException(String string) {
            super("No " + string + " selected\nAdd new " + string + " by clicking on the Add button");
        }
    }
}

