/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.entry;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import javax.swing.JComponent;
import se.prediktera.breeze.backend.WorkspaceManager;
import se.prediktera.breeze.backend.measure.applychanges.ApplyChanges;
import se.prediktera.breeze.common.entry.BreezeType;
import se.prediktera.breeze.entry.Entry;
import se.prediktera.breeze.entry.GroupNode;
import se.prediktera.breeze.entry.group.Group;
import se.prediktera.breeze.entry.workflow.Workflow;
import se.prediktera.breeze.evince.DataSetCache;
import se.prediktera.breeze.frontend.BreezeFrame;
import se.prediktera.breeze.frontend.BreezeMainPanel;
import se.prediktera.breeze.frontend.BreezeViewStack;
import se.prediktera.breeze.frontend.common.ArrayTreeModel;
import se.prediktera.breeze.frontend.common.entry.EntryComponents;
import se.prediktera.breeze.frontend.common.entry.EntryMainHelper;
import se.prediktera.breeze.frontend.common.entry.EntryMainItemPanel;
import se.prediktera.breeze.frontend.common.entry.EntryMainPanel;
import se.prediktera.breeze.frontend.common.entry.EntryMeasurementPanel;
import se.prediktera.breeze.frontend.common.entry.EntryPathPanel;
import se.prediktera.breeze.frontend.common.entry.EntryTitlePanel;
import se.prediktera.breeze.frontend.common.entry.OpenEntryProgressAction;
import se.prediktera.breeze.frontend.common.swing.BreezeActionListener;
import se.prediktera.breeze.frontend.common.swing.BreezeButton;
import se.prediktera.breeze.frontend.common.swing.BreezeSeparator;
import se.prediktera.breeze.frontend.common.swing.GridBagHelper;
import se.prediktera.breeze.frontend.common.swing.dialog.AbstractBreezeCustomPanel;
import se.prediktera.breeze.frontend.common.swing.dialog.AbstractBreezeDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeOptionDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressManager;
import se.prediktera.breeze.frontend.common.util.BreezeFilter;
import se.prediktera.breeze.frontend.main.MainPanel;
import se.prediktera.breeze.frontend.main.model.ModelMainPanel;
import se.prediktera.breeze.frontend.main.play.WorkflowMainPanel;
import se.prediktera.breeze.recorder.BreezeRecorder;
import se.prediktera.map.common.error.ErrorHandler;
import se.prediktera.map.register.RegInfo;

public abstract class EntryMainSwitchPanel
extends EntryMainItemPanel {
    protected final BreezeFilter.AnalyseStudy contextFilter = new BreezeFilter.AnalyseStudy(null);
    private EntryPathPanel pathPanel;

    public EntryMainSwitchPanel(BreezeFrame breezeFrame, BreezeType breezeType) {
        super(breezeFrame, breezeType, breezeType.getTitle(), true, true);
        if (RegInfo.isApplicationFeature()) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridy = 1;
            gridBagConstraints.fill = 1;
            if (WorkspaceManager.GUITEST) {
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 0;
                EntryComponents.SwitchButton switchButton = new EntryComponents.SwitchButton(this, false);
                this.buttonsPanel.add((Component)switchButton, gridBagConstraints);
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 2;
                gridBagConstraints.fill = 1;
                EntryComponents.SwitchButton switchButton2 = new EntryComponents.SwitchButton(this, true);
                this.bottomRightPanel.add((Component)switchButton2, gridBagConstraints);
                switchButton.setType(breezeType.getPrev());
                switchButton2.setType(breezeType.getNext());
            }
        }
        if (this.getPageType().equals((Object)BreezeType.Analyse) && !WorkspaceManager.GUITEST) {
            this.verticalLabelPanel.setVisible(false);
        }
    }

    @Override
    protected Component CreateTitlePanel(String string) {
        this.pathPanel = new EntryPathPanel(this, "", false);
        return new EntryTitlePanel(this, ""){

            @Override
            public JComponent createTitleComponent(String string) {
                return EntryMainSwitchPanel.this.pathPanel;
            }
        };
    }

    @Override
    public void setFormatedTitle(Object object) {
        super.setFormatedTitle(object);
        if (this instanceof EntryMeasurementPanel) {
            this.pathPanel.setFormatedTitle(object);
        }
    }

    @Override
    protected void addVerticalButtons(boolean bl) {
        if (this.getPageType().isWorkflow() && RegInfo.isApplicationFeature()) {
            this.verticalButtons.addComponentInsets(EntryMainHelper.createButton("Model", BreezeType.Analyse.getIcon(), () -> this.openDialog(this.getSelectedEntry(), BreezeType.Analyse, 0.9)), 10, 5);
            if (this.getPageType().equals((Object)BreezeType.Project)) {
                this.verticalButtons.addComponent(EntryMainHelper.createButton("Workflow", BreezeType.Workflow.getIcon(), () -> this.openDialog(this.getSelectedEntry(), BreezeType.Workflow, 1.0)));
            }
        }
        this.nextButton = this.createNextButton();
        BreezeButton breezeButton = EntryMainHelper.createEditButton(this, !(this instanceof ModelMainPanel));
        breezeButton.setDesc("<html>Project<br>options</html>");
        this.verticalButtons.addComponentLast(breezeButton, 98);
        this.verticalButtons.add((Component)new BreezeSeparator(), GridBagHelper.create(99, new Insets(0, 5, 5, 5)));
        super.addVerticalButtons(false);
        this.verticalButtons.addComponent(EntryMainHelper.createSettingsButton(this.frame), 101, 10);
    }

    private void openDialog(Object object, final BreezeType breezeType, double d) {
        BreezeProgressDialog.startProgress(this.getFrame(), new OpenEntryProgressAction(this, this.getFrame(), d){
            final /* synthetic */ EntryMainSwitchPanel this$0;
            {
                this.this$0 = entryMainSwitchPanel;
                super(breezeFrame, d);
            }

            @Override
            protected EntryMainPanel createOpenPanel() throws Exception {
                return MainPanel.createEntryMainPanel(this.this$0.frame, BreezeProgressManager.createEmpty(), breezeType, this.this$0.getStudyContext());
            }
        }, "Opening...");
    }

    protected BreezeButton createNextButton() {
        return EntryMainHelper.createColorNextButton("Recorder", BreezeType.Recorder, () -> {
            Object object = this.getSelectedEntry();
            ApplyChanges.checkLicenseForNode(this.getStudyContext());
            Object object2 = this;
            if (object2 instanceof WorkflowMainPanel) {
                WorkflowMainPanel workflowMainPanel = (WorkflowMainPanel)object2;
                WorkflowMainPanel.getEmptyGroupOrCreateNew(workflowMainPanel, Workflow.getWorkflow(object), "Analyse", group -> this.openBreezeRecorder(this, group, measurement -> DataSetCache.clear(group)));
            } else if (object instanceof Workflow) {
                object2 = (Workflow)object;
                BreezeOptionDialog.showDialog(this.frame, BreezeType.Recorder.getColor(), AbstractBreezeDialog.MessageType.CONFIRM_OPTION, "Select Group", "", (AbstractBreezeCustomPanel)new WorkflowMainPanel.SelectOrCreateGroupPanel((Workflow)object2), null, arg_0 -> this.lambda$createNextButton$3((Workflow)object2, arg_0));
            } else {
                this.openRecorder(this.getGroup());
            }
        });
    }

    private void openRecorder(Group group) {
        if (group == null) {
            throw new ErrorHandler.InformationMessageException("No Group to record into.\nPlease add a Group and try again.");
        }
        this.openBreezeRecorder(this, group, measurement -> {
            DataSetCache.clear(group);
            if (this instanceof EntryMeasurementPanel) {
                if (measurement != null) {
                    this.setEntryListModel(group.getChildList());
                    this.selectEntry(measurement);
                }
            } else {
                this.selectEntry(group);
            }
        });
    }

    public Group getGroup() {
        return Group.getGroup(this.getSelectedEntry());
    }

    public void openBreezeRecorder(final EntryMainPanel entryMainPanel, final Group group, final BreezeRecorder.OnMeasurementCallback onMeasurementCallback) {
        ApplyChanges.checkLicenseForNode(this.getStudyContext());
        final BreezeFrame breezeFrame = entryMainPanel.getFrame();
        BreezeProgressDialog.startProgress(breezeFrame, new OpenEntryProgressAction(this, breezeFrame){

            @Override
            protected BreezeMainPanel createOpenPanel() {
                return new BreezeRecorder(this.getProgressManager(), breezeFrame, entryMainPanel.getPageType(), group, onMeasurementCallback);
            }
        }, "Opening...", 0);
    }

    public void setStudyContext(Workflow workflow) {
        this.contextFilter.setWorkflow(workflow);
        this.getEntryList().setFilter(this.contextFilter, this.getSelectedEntry(), 0);
    }

    public Workflow getStudyContext() {
        BreezeViewStack breezeViewStack = this.getFrame().getViewStack();
        if (breezeViewStack != null) {
            return breezeViewStack.getStudyContext();
        }
        return null;
    }

    protected Entry createEntryLocal(Entry entry, String string) {
        return null;
    }

    @Override
    protected void createLocal() {
        String string = this.getEntryName();
        BreezeOptionDialog.showDialog(this.frame, this.getPageColor(), AbstractBreezeDialog.MessageType.INPUT_OPTION, "New " + string, "Enter name for the new " + string + ":", EntryMainHelper.getUniqueName(this.getNextEntryName(), this.getEntryList().getList()), breezeActionEvent -> {
            this.addEntry(this.createEntryLocal(null, breezeActionEvent.result().toString()));
            this.showFirstTab();
        });
    }

    @Override
    protected void openButtonClicked(final Object object) {
        if (object instanceof GroupNode) {
            return;
        }
        if (object == null || object instanceof ArrayTreeModel.RootList) {
            throw new EntryMainPanel.NoEntrySelectedException(this.getEntryName());
        }
        BreezeProgressDialog.startProgress(this.getFrame(), new OpenEntryProgressAction(this, this.getFrame(), this.getOpenEntrySizePercent()){
            final /* synthetic */ EntryMainSwitchPanel this$0;
            {
                this.this$0 = entryMainSwitchPanel;
                super(breezeFrame, d);
            }

            @Override
            protected BreezeMainPanel createOpenPanel() {
                return this.this$0.createOpenPanel(this.getProgressManager(), object);
            }
        }, "Opening...", 0);
    }

    protected double getOpenEntrySizePercent() {
        return 1.0;
    }

    private /* synthetic */ void lambda$createNextButton$3(Workflow workflow, BreezeActionListener.BreezeActionEvent breezeActionEvent) {
        this.openRecorder(((WorkflowMainPanel.SelectOrCreateGroupPanel)breezeActionEvent.getBreezeCustomPanel()).getOrCreateGroup(workflow));
    }
}

