/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.entry;

import java.awt.Color;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import se.prediktera.breeze.backend.measure.applychanges.ApplyChanges;
import se.prediktera.breeze.common.entry.BasicEntry;
import se.prediktera.breeze.common.entry.BreezeType;
import se.prediktera.breeze.common.util.BreezeProgress;
import se.prediktera.breeze.common.util.FileHelper;
import se.prediktera.breeze.entry.Entry;
import se.prediktera.breeze.entry.group.Group;
import se.prediktera.breeze.entry.measurement.Measurement;
import se.prediktera.breeze.entry.workflow.Workflow;
import se.prediktera.breeze.evince.DataSetCache;
import se.prediktera.breeze.frontend.BreezeMainPanel;
import se.prediktera.breeze.frontend.common.entry.EntryMainHelper;
import se.prediktera.breeze.frontend.common.entry.EntryMainSwitchPanel;
import se.prediktera.breeze.frontend.common.entry.ThumbnailManager;
import se.prediktera.breeze.frontend.common.swing.dialog.AbstractBreezeCustomPanel;
import se.prediktera.breeze.frontend.common.swing.dialog.AbstractBreezeDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeOptionDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressManager;
import se.prediktera.breeze.frontend.common.view.MeasurementViewPanel;
import se.prediktera.breeze.frontend.common.view.preview.MeasurementPopup;
import se.prediktera.breeze.frontend.main.play.WorkflowMainPanel;
import se.prediktera.breeze.frontend.main.record.panel.GroupMainPanel;

public abstract class EntryMeasurementPanel
extends EntryMainSwitchPanel {
    private final Group group;
    protected MeasurementViewPanel measurementViewPanel;
    private final GroupMainPanel groupPanel;

    public EntryMeasurementPanel(BreezeProgress breezeProgress, GroupMainPanel groupMainPanel, BreezeType breezeType, String string, String string2, Group group) {
        super(groupMainPanel.getFrame(), breezeType);
        this.groupPanel = groupMainPanel;
        this.group = group;
        this.emptyPage.setDescription("Press " + string2 + " to create and measure into a new measurement");
        this.setStatusPanel(this.createStatusPanel());
        this.addLeftButton(EntryMainHelper.createButton("Move", "material/move_item", () -> EntryMeasurementPanel.showMoveMeasurementsDialog(this, Measurement.getMeasurements(this.getSelectedEntries()))));
    }

    public static void showMoveMeasurementsDialog(BreezeMainPanel breezeMainPanel, List<Measurement> list) {
        Group group = list.get(0).getParent();
        Workflow workflow = group.getParent();
        Color color = breezeMainPanel.getPageColor();
        BreezeOptionDialog.showDialog(breezeMainPanel.getFrame(), color, AbstractBreezeDialog.MessageType.CONFIRM_OPTION, "Select Group", "", (AbstractBreezeCustomPanel)new WorkflowMainPanel.SelectOrCreateGroupPanel(workflow), null, breezeActionEvent2 -> {
            WorkflowMainPanel.SelectOrCreateGroupPanel selectOrCreateGroupPanel = (WorkflowMainPanel.SelectOrCreateGroupPanel)breezeActionEvent2.getBreezeCustomPanel();
            Group group2 = selectOrCreateGroupPanel.getOrCreateGroup(workflow, breezeMainPanel);
            if (group != group2) {
                if (EntryMeasurementPanel.checkIfMeasurementExists(group2, list)) {
                    BreezeOptionDialog.showDialog(breezeMainPanel.getFrame(), color, AbstractBreezeDialog.MessageType.CONFIRM_OPTION, "Measurement exist", "Measurement name already exists, do you want to replace existing?", null, breezeActionEvent -> EntryMeasurementPanel.moveMeasurements(breezeMainPanel, group2, list));
                } else {
                    EntryMeasurementPanel.moveMeasurements(breezeMainPanel, group2, list);
                }
            }
        });
    }

    private static void moveMeasurements(BreezeMainPanel breezeMainPanel, Group group, List<Measurement> list) {
        Iterator<Measurement> iterator = list.iterator();
        while (iterator.hasNext()) {
            Measurement measurement;
            Measurement measurement2 = measurement = iterator.next();
            File file = new File(group.getFolder(), measurement2.getName());
            file.mkdirs();
            FileHelper.moveFiles(measurement2.getFolder(), file);
            if (breezeMainPanel instanceof EntryMeasurementPanel) {
                breezeMainPanel.getEntryList().removeItem(measurement2);
            }
            measurement.getParent().removeChild(measurement2);
            Measurement measurement3 = group.getMeasurement(measurement2.getName());
            if (measurement3 != null) {
                group.removeChild(measurement3);
            }
            group.addChild(new Measurement(file, group));
            ThumbnailManager.removeMeasurementImageFromCache(measurement2);
            DataSetCache.clearParents(measurement2);
        }
        breezeMainPanel.setDirty(true);
    }

    private static boolean checkIfMeasurementExists(Group group, List<Measurement> list) {
        for (Measurement measurement : list) {
            File file = new File(group.getFolder(), measurement.getName());
            if (!file.exists()) continue;
            return true;
        }
        return false;
    }

    public GroupMainPanel getGroupPanel() {
        return this.groupPanel;
    }

    @Override
    protected String getSortName() {
        return "sortMeasurement";
    }

    public MeasurementViewPanel getMeasurementViewPanel() {
        return this.measurementViewPanel;
    }

    @Override
    protected Entry createEntryLocal(Entry entry, String string) {
        Measurement measurement = new Measurement(string, this.group);
        measurement.save();
        this.group.save();
        return measurement;
    }

    @Override
    protected ArrayList<BasicEntry> deleteEntries(BreezeProgress breezeProgress, List list) {
        ArrayList<BasicEntry> arrayList = super.deleteEntries(breezeProgress, list);
        this.group.performGroupDescriptors();
        this.group.save();
        return arrayList;
    }

    @Override
    protected void entryDoubleClicked(Object object) {
    }

    @Override
    public void rightClickOnSelected(MouseEvent mouseEvent) {
        MeasurementPopup.showMeasurementsPopup(this, this.getSelectedEntries(), mouseEvent);
    }

    @Override
    protected Entry duplicateEntry(BreezeProgressManager breezeProgressManager, Object object, String string, boolean bl, boolean bl2) {
        Measurement measurement = (Measurement)object;
        File file = new File(this.group.getFolder(), string);
        FileHelper.copyFolder(breezeProgressManager, measurement.getFolder(), file);
        Measurement measurement2 = new Measurement(file, this.group);
        File file2 = measurement.getBackupFolder();
        if (file2.exists()) {
            FileHelper.copyFolder(breezeProgressManager, file2, measurement2.getBackupFolder());
        }
        return measurement2;
    }

    @Override
    public String getEntryName() {
        return "Measurement";
    }

    @Override
    public String getNextEntryName() {
        return this.group.nextMeasurementName();
    }

    public void applyChangesRealtime(BreezeProgress breezeProgress) {
        ApplyChanges.applyChanges(breezeProgress, this.getSelectedEntries());
        this.showSelectedEntry(false);
    }

    @Override
    protected boolean canAddEntry() {
        return false;
    }

    @Override
    protected boolean canOpenEntry() {
        return false;
    }

    @Override
    protected boolean canDuplicateEntry() {
        return true;
    }

    @Override
    public Group getGroup() {
        return this.group;
    }

    @Override
    public void backButtonClicked() {
        DataSetCache.clear(this.group);
        super.backButtonClicked();
    }

    @Override
    public String getDuplicateIcon() {
        return "material/content_copy";
    }
}

