/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.entry;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.image.BufferedImage;
import java.io.File;
import java.lang.runtime.SwitchBootstraps;
import java.nio.file.InvalidPathException;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.imgscalr.Scalr;
import se.prediktera.breeze.common.entry.BasicEntry;
import se.prediktera.breeze.common.util.FileHelper;
import se.prediktera.breeze.entry.Entry;
import se.prediktera.breeze.entry.EntryData;
import se.prediktera.breeze.entry.analyse.Analyse;
import se.prediktera.breeze.entry.application.RuntimeWorkflow;
import se.prediktera.breeze.entry.workflow.Workflow;
import se.prediktera.breeze.frontend.BreezeFrame;
import se.prediktera.breeze.frontend.BreezeMainPanel;
import se.prediktera.breeze.frontend.ToastHandler;
import se.prediktera.breeze.frontend.common.entry.EntryMainHelper;
import se.prediktera.breeze.frontend.common.entry.EntryMainPanel;
import se.prediktera.breeze.frontend.common.entry.EntryMainSwitchPanel;
import se.prediktera.breeze.frontend.common.entry.ThumbnailManager;
import se.prediktera.breeze.frontend.common.entry.comment.CommentPanel;
import se.prediktera.breeze.frontend.common.swing.BreezeButton;
import se.prediktera.breeze.frontend.common.swing.BreezeLabelField;
import se.prediktera.breeze.frontend.common.swing.BreezeScrollPane;
import se.prediktera.breeze.frontend.common.swing.BreezeSeparator;
import se.prediktera.breeze.frontend.common.swing.BreezeTheme;
import se.prediktera.breeze.frontend.common.swing.ImageRenderPanel;
import se.prediktera.breeze.frontend.common.swing.dialog.AbstractBreezeDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeOptionDialog;
import se.prediktera.breeze.frontend.common.view.AbstractViewPanel;
import se.prediktera.breeze.frontend.main.model.ModelMainPanel;
import se.prediktera.breeze.frontend.main.record.panel.MeasurementTableInteraction;
import se.prediktera.map.common.error.Logg;

public class EntryOverviewPanel
extends AbstractViewPanel {
    public static int ImageSize = 220;
    private final BreezeScrollPane centerScrollPane;
    protected Image defaultImage;
    private final BreezeButton addCommentButton;
    private final BreezeButton renameButton;
    private final BreezeButton editButton;
    private final BreezeLabelField idLabelField;
    private final BreezeLabelField createdLabelField;
    private final BreezeLabelField modifiedLabelField;
    private final JPanel imagePanel = new JPanel(new BorderLayout());
    private final JPanel customInformationPanel = new JPanel(new GridBagLayout());
    private final JPanel fieldPanel = new JPanel(new GridBagLayout());
    private final CommentPanel.CommentsPanel commentsPanel = new CommentPanel.CommentsPanel(true);
    protected final ImageRenderPanel iconPanel = new ImageRenderPanel();
    private final JLabel nameLabel = new JLabel();
    protected BasicEntry entry;

    protected EntryMainHelper.ClickCallBack getClickCallbackAddNewVariableOrId(int n) {
        return () -> MeasurementTableInteraction.addColumn(this.getMainPanel(), Workflow.getWorkflow(this.entry), n);
    }

    public EntryOverviewPanel(EntryMainPanel entryMainPanel) {
        super(entryMainPanel);
        this.setBackground(new Color(255, 255, 255));
        this.setLayout(new GridBagLayout());
        this.iconPanel.setMinimumSize(new Dimension(ImageSize, ImageSize));
        this.iconPanel.setPreferredSize(new Dimension(ImageSize, ImageSize));
        GroupLayout groupLayout = new GroupLayout(this.iconPanel);
        this.iconPanel.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, ImageSize, Short.MAX_VALUE));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, ImageSize, Short.MAX_VALUE));
        this.imagePanel.add((Component)this.iconPanel, "Center");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        this.add(this.imagePanel, gridBagConstraints);
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setOpaque(false);
        this.nameLabel.setFont(new Font("Tahoma", 0, 22));
        this.nameLabel.setText(" ");
        this.nameLabel.setName("entryLabel");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)this.nameLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        this.renameButton = EntryMainHelper.createButton("renameEntry", "", "explore/edit", () -> EntryOverviewPanel.renameEntry(entryMainPanel, (Entry)this.entry, string -> this.nameLabel.setText(string)));
        jPanel.add((Component)this.renameButton, gridBagConstraints);
        this.renameButton.setToolTipText("Rename");
        this.customInformationPanel.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 0;
        jPanel.add((Component)this.customInformationPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.add(jPanel, gridBagConstraints);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.setBackground(new Color(255, 255, 255));
        this.fieldPanel.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        jPanel2.add((Component)this.fieldPanel, gridBagConstraints);
        this.commentsPanel.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        jPanel2.add((Component)this.commentsPanel, gridBagConstraints);
        this.addCommentButton = this.mainpanel instanceof EntryMainSwitchPanel ? this.commentsPanel.createButton(this.mainpanel) : null;
        JPanel jPanel3 = new JPanel();
        jPanel3.setOpaque(false);
        GroupLayout groupLayout2 = new GroupLayout(jPanel3);
        jPanel3.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 100, Short.MAX_VALUE));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 100, Short.MAX_VALUE));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel2.add((Component)jPanel3, gridBagConstraints);
        this.centerScrollPane = new BreezeScrollPane(jPanel2);
        this.centerScrollPane.setBorder(null);
        this.centerScrollPane.setHorizontalScrollBarPolicy(31);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add(this.centerScrollPane, gridBagConstraints);
        this.idLabelField = this.addLabelField("ID");
        this.createdLabelField = this.addLabelField("Created");
        this.modifiedLabelField = this.addLabelField("Modified");
        this.defaultImage = this.getDefaultImage();
        BreezeTheme breezeTheme = BreezeTheme.getInstance();
        this.setBackground(breezeTheme.getPanelBackground());
        jPanel2.setBackground(breezeTheme.getPanelBackground());
        this.imagePanel.setOpaque(true);
        this.imagePanel.setBackground(breezeTheme.getImageBackground());
        this.imagePanel.setBorder(BorderFactory.createLineBorder(breezeTheme.getPanelBackground150(), 2));
        this.nameLabel.setForeground(breezeTheme.getLabelForeground());
        this.editButton = EntryMainHelper.createEditButton(entryMainPanel, !(entryMainPanel instanceof ModelMainPanel));
    }

    public static void renameEntry(EntryMainPanel entryMainPanel, Entry entry, RenameCallback renameCallback) {
        BreezeFrame breezeFrame = entryMainPanel.getFrame();
        Color color = entryMainPanel.getPageColor();
        BreezeOptionDialog.showDialog(breezeFrame, color, AbstractBreezeDialog.MessageType.INPUT_OPTION, "Rename", "Enter new name:", entry.getName(), breezeActionEvent -> {
            try {
                String string = breezeActionEvent.getInputText();
                if (!string.isEmpty() && !string.equals(entry.getName())) {
                    FileHelper.checkValidNameOrThrow(string);
                    entry.rename(string);
                    renameCallback.onRename(string);
                    entryMainPanel.setFormatedTitle(entry);
                    ToastHandler.getInstance().showToast(breezeFrame, "Renamed");
                }
            }
            catch (InvalidPathException invalidPathException) {
                BreezeOptionDialog.showDialog(breezeFrame, color, AbstractBreezeDialog.MessageType.ERROR_OPTION, "Rename failed", "'" + String.valueOf(entry) + "' could not be renamed on disk since the chosen name is not allowed\n\nAvoid special characters like \\ / : * ? \" < > | ;");
                Logg.error((String)("Renamed failed: " + invalidPathException.getMessage()), (Object[])new Object[0]);
            }
            catch (Exception exception) {
                BreezeOptionDialog.showDialog(breezeFrame, color, AbstractBreezeDialog.MessageType.ERROR_OPTION, "Rename failed", "'" + String.valueOf(entry) + "' could not be renamed on disk\n\nPlease close any explorer window or files that are opened and try again");
                Logg.error((String)("Renamed failed: " + exception.getMessage()), (Object[])new Object[0]);
            }
        });
    }

    protected BreezeLabelField addLabelField(String string) {
        BreezeLabelField breezeLabelField = new BreezeLabelField(string, 140, 20, "", 0, 17, 14);
        breezeLabelField.setName("label" + string);
        EntryMainHelper.addComponentToPanel(this.customInformationPanel, breezeLabelField, 0, this.customInformationPanel.getComponentCount(), 1, 1, 1.0, 0.0, 18, new Insets(10, 0, 0, 0), 1);
        return breezeLabelField;
    }

    protected void addComponentToField(JComponent jComponent) {
        EntryMainHelper.addComponentToPanel(this.fieldPanel, jComponent, 0, this.fieldPanel.getComponentCount(), 1, 1, 1.0, 0.0, 18, new Insets(6, 0, 0, 0), 1);
    }

    protected void addComponentToFieldNoFill(JComponent jComponent) {
        EntryMainHelper.addComponentToPanel(this.fieldPanel, jComponent, 0, this.fieldPanel.getComponentCount(), 1, 1, 1.0, 0.0, 18, new Insets(6, 0, 0, 0), 0);
    }

    @Override
    public String getType() {
        return "EntryOverview";
    }

    protected Image getDefaultImage() {
        return null;
    }

    @Override
    public void showEntry(Object object, Object object2) {
        if (object instanceof BasicEntry) {
            this.entry = (BasicEntry)object;
            this.renameButton.setVisible(this.entry instanceof Entry);
            this.setIcon(this.entry);
            this.nameLabel.setText(this.entry.getName());
            this.idLabelField.setValue(this.entry.getUid());
            this.createdLabelField.setValue(EntryOverviewPanel.getCreatedDate(this.entry));
            this.modifiedLabelField.setValue(EntryOverviewPanel.getModifiedDate(this.entry));
            this.setListsToField(this.entry);
        }
        if (object instanceof Entry) {
            Entry entry = (Entry)object;
            this.commentsPanel.setEntry(this.mainpanel, entry);
        }
        this.centerScrollPane.scrollToTop();
    }

    @Override
    public void addComponent(BreezeMainPanel breezeMainPanel) {
        super.addComponent(breezeMainPanel);
        if (this.addCommentButton != null) {
            if (breezeMainPanel instanceof ModelMainPanel) {
                breezeMainPanel.addRightButton(this.editButton);
                breezeMainPanel.addRightButton(new BreezeSeparator.Vertical());
            }
            breezeMainPanel.addRightButton(this.addCommentButton);
        }
    }

    protected void setIcon(BasicEntry basicEntry) {
        BasicEntry basicEntry2 = basicEntry;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Analyse.class, Entry.class, RuntimeWorkflow.class}, (BasicEntry)basicEntry2, n)) {
            case 0: {
                Analyse analyse = (Analyse)basicEntry2;
                this.iconPanel.setImage(analyse.getIcon());
                break;
            }
            case 1: {
                Entry entry = (Entry)basicEntry2;
                File file = entry.getCustomImageFile();
                if (file != null && file.exists()) {
                    BufferedImage bufferedImage = ThumbnailManager.getInstance(ImageSize).renderCustomImage(file, this.imagePanel.getBackground(), Scalr.Method.BALANCED, this.iconPanel::setImage);
                    this.iconPanel.setImage(bufferedImage, () -> SwingUtilities.invokeLater(() -> this.setIcon(basicEntry)));
                    this.iconPanel.repaint();
                    break;
                }
                this.iconPanel.setImage(this.defaultImage);
                break;
            }
            case 2: {
                RuntimeWorkflow runtimeWorkflow = (RuntimeWorkflow)basicEntry2;
                BufferedImage bufferedImage = runtimeWorkflow.getThumbnail();
                if (bufferedImage != null) {
                    this.iconPanel.setImage(bufferedImage);
                    break;
                }
                this.iconPanel.setImage(this.defaultImage);
                break;
            }
            default: {
                this.iconPanel.setImage(this.defaultImage);
            }
        }
    }

    private static String getCreatedDate(BasicEntry basicEntry) {
        if (basicEntry instanceof Entry) {
            return ((Entry)basicEntry).getEntryData().getViewCreatedDate();
        }
        if (basicEntry instanceof RuntimeWorkflow) {
            return ((RuntimeWorkflow)basicEntry).getViewCreatedDate();
        }
        return "";
    }

    private static String getModifiedDate(BasicEntry basicEntry) {
        if (basicEntry instanceof Entry) {
            File file;
            String string = ((Entry)basicEntry).getEntryData().getViewModifiedDate();
            if (string.equals("NA") && (file = basicEntry.getXml()) != null) {
                return EntryData.viewformat.format(file.lastModified());
            }
            return string;
        }
        if (basicEntry instanceof RuntimeWorkflow) {
            return ((RuntimeWorkflow)basicEntry).getViewCreatedDate();
        }
        return "";
    }

    protected void setListsToField(BasicEntry basicEntry) {
    }

    public JPanel getFieldPanel() {
        return this.fieldPanel;
    }

    public void addComment(String string) {
        this.commentsPanel.addComment(string);
    }

    public static interface RenameCallback {
        public void onRename(String var1);
    }
}

