/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.entry;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.image.BufferedImage;
import java.io.File;
import java.lang.runtime.SwitchBootstraps;
import java.net.URL;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.GrayFilter;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import lombok.Generated;
import org.imgscalr.Scalr;
import org.w3c.dom.Node;
import se.prediktera.breeze.common.entry.BasicEntry;
import se.prediktera.breeze.common.entry.analyse.BasicAnalyse;
import se.prediktera.breeze.common.entry.tree.analysistree.DescriptorTreeNode;
import se.prediktera.breeze.common.util.FileHelper;
import se.prediktera.breeze.common.util.StringHelper;
import se.prediktera.breeze.entry.Entry;
import se.prediktera.breeze.entry.GroupNode;
import se.prediktera.breeze.entry.analyse.Analyse;
import se.prediktera.breeze.entry.application.RuntimeWorkflow;
import se.prediktera.breeze.entry.group.Group;
import se.prediktera.breeze.entry.measurement.Measurement;
import se.prediktera.breeze.entry.workflow.Workflow;
import se.prediktera.breeze.frontend.common.entry.GroupPanel;
import se.prediktera.breeze.frontend.common.entry.ThumbnailManager;
import se.prediktera.breeze.frontend.common.swing.BreezeTheme;
import se.prediktera.breeze.frontend.common.swing.BreezeTree;
import se.prediktera.breeze.frontend.common.swing.ImageRenderPanel;
import se.prediktera.breeze.frontend.common.util.BreezeProperties;
import se.prediktera.breeze.frontend.common.util.ImageHelper;
import se.prediktera.breeze.frontend.common.view.ViewClass;
import se.prediktera.breeze.frontend.main.settings.sensor.SensorPanel;
import se.prediktera.map.main.script.ScriptFile;

public class EntryPanel
extends JPanel
implements ListCellRenderer,
TreeCellRenderer {
    public static boolean measurementNotifications;
    private Color bgColor;
    private Color imageBgColor;
    private BufferedImage icon;
    private Image grayedIcon;
    private final int mainHeight;
    private final int imageSize;
    private int hoverIndex = -1;
    protected final JLabel sub1Label = new JLabel("Sub1");
    protected final JLabel sub2Label = new JLabel("Sub2");
    protected final JLabel textLabel = new JLabel("Text");
    private final JLabel applyChangesLabel = new JLabel();
    private final ImageRenderPanel iconLabel = new ImageRenderPanel();
    private final JPanel iconPanel = new JPanel(new GridBagLayout());
    private final JPanel mainPanel = new JPanel(new GridBagLayout());
    private final JLabel warningLabel = new JLabel();
    private final JLabel errorLabel = new JLabel();
    private JComponent list;
    private final GroupPanel groupPanel;
    private final IndentationPanel indentationPanel;
    private final String imageType;

    public EntryPanel(String string, Color color, int n) {
        super(new GridBagLayout());
        this.imageType = string;
        this.imageSize = (int)((double)n * 0.8);
        this.mainHeight = n;
        BreezeTheme breezeTheme = BreezeTheme.getInstance();
        this.updateTheme(breezeTheme, breezeTheme.getImageBackground(), color);
        this.mainPanel.setOpaque(false);
        this.textLabel.setFont(new Font("Tahoma", 1, n <= 90 ? 14 : 16));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 10, 4, 10);
        this.mainPanel.add((Component)this.textLabel, gridBagConstraints);
        this.sub1Label.setFont(new Font("Tahoma", 0, 10));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.mainPanel.add((Component)this.sub1Label, gridBagConstraints);
        this.sub2Label.setFont(new Font("Tahoma", 2, 10));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(1, 10, 5, 0);
        this.mainPanel.add((Component)this.sub2Label, gridBagConstraints);
        this.warningLabel.setIcon(ImageHelper.replaceTransparentBackgroundWithColor(ImageHelper.getResourceIcon("warning"), new Color(color.getRed(), color.getGreen(), color.getBlue(), 200)));
        this.warningLabel.setToolTipText("Warning");
        this.warningLabel.setMaximumSize(new Dimension(30, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.iconPanel.add((Component)this.warningLabel, gridBagConstraints);
        this.errorLabel.setIcon(ImageHelper.replaceTransparentBackgroundWithColor(ImageHelper.getResourceIcon("error"), new Color(color.getRed(), color.getGreen(), color.getBlue(), 200)));
        this.errorLabel.setToolTipText("Error");
        this.errorLabel.setMaximumSize(new Dimension(30, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.iconPanel.add((Component)this.errorLabel, gridBagConstraints);
        this.applyChangesLabel.setMaximumSize(new Dimension(30, 30));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.iconPanel.add((Component)this.applyChangesLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.iconPanel.add((Component)this.iconLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.insets = new Insets(4, 0, 4, 0);
        this.mainPanel.add((Component)this.iconPanel, gridBagConstraints);
        this.indentationPanel = new IndentationPanel();
        this.indentationPanel.setOpaque(false);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.add((Component)this.indentationPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        this.add((Component)this.mainPanel, gridBagConstraints);
        this.iconLabel.setPreferredSize(new Dimension(this.imageSize, this.imageSize));
        this.iconLabel.setMinimumSize(new Dimension(this.imageSize, this.imageSize));
        this.iconLabel.setMaximumSize(new Dimension(this.imageSize, this.imageSize));
        this.warningLabel.setVisible(false);
        this.errorLabel.setVisible(false);
        this.applyChangesLabel.setVisible(false);
        measurementNotifications = BreezeProperties.getInstance().isShowNotificationOnMeasurements();
        this.groupPanel = new GroupPanel(this);
    }

    public void updateTheme(BreezeTheme breezeTheme, Color color, Color color2) {
        this.bgColor = color2;
        this.imageBgColor = color;
        this.setBackground(color2);
        this.mainPanel.setBackground(color2);
        this.mainPanel.setCursor(new Cursor(0));
        this.iconPanel.setBackground(color);
        this.iconPanel.setBorder(BorderFactory.createLineBorder(breezeTheme.getPanelBackground150(), 2));
        this.applyChangesLabel.setIcon(ImageHelper.replaceTransparentBackgroundWithColor(ImageHelper.getResourceIcon("applychanges"), new Color(color2.getRed(), color2.getGreen(), color2.getBlue(), 200)));
        if (this.imageType != null) {
            URL uRL = null;
            uRL = this.imageType.startsWith("/") ? this.getClass().getResource(this.imageType) : this.getClass().getResource("/images/" + this.imageType + ".png");
            if (uRL != null) {
                this.icon = ImageHelper.getScaledImage(ImageHelper.read(uRL), this.imageSize, this.imageSize, color);
                this.grayedIcon = GrayFilter.createDisabledImage(this.icon);
                this.iconLabel.setImage(this.icon);
            }
        }
    }

    public void updatePanel(JComponent jComponent, Object object, boolean bl, int n) {
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        this.list = jComponent;
        int n2 = this.mainHeight;
        if (bl) {
            object5 = null;
            object4 = null;
            if (jComponent instanceof JList) {
                object3 = (JList)jComponent;
                object5 = ((JList)object3).getSelectionBackground();
                object4 = ((JList)object3).getSelectionForeground();
            } else if (jComponent instanceof BreezeTree) {
                object2 = (BreezeTree)((Object)jComponent);
                object5 = ((BreezeTree)object2).getSelectionBackground();
                object4 = ((BreezeTree)object2).getSelectionForeground();
            }
            this.setBackground((Color)object5);
            this.textLabel.setForeground((Color)object4);
            this.sub1Label.setForeground((Color)object4);
            this.sub2Label.setForeground((Color)object4);
        } else if (n == this.hoverIndex) {
            this.setBackground(BreezeTheme.getInstance().getEntrySelectionHoverBackground());
            this.textLabel.setForeground(jComponent.getForeground());
            this.sub1Label.setForeground(jComponent.getForeground());
            this.sub2Label.setForeground(jComponent.getForeground());
        } else {
            this.setBackground(this.bgColor);
            this.textLabel.setForeground(jComponent.getForeground());
            this.sub1Label.setForeground(jComponent.getForeground());
            this.sub2Label.setForeground(jComponent.getForeground());
        }
        if (object instanceof ViewClass) {
            object5 = (ViewClass)object;
            this.indentationPanel.setIndentation(((ViewClass)object5).getIndentation(), ((ViewClass)object5).getPanel() instanceof SensorPanel);
        } else if (object instanceof Group && ((Workflow)(object3 = ((Group)(object4 = (Group)object)).getParent())).getType().equals((Object)Workflow.WorkflowType.Record)) {
            object2 = ((Workflow)object3).getChildList();
            this.indentationPanel.setIndentation(15, ((Group)object2.getLast()).equals(object4));
        }
        this.setMinimumSize(new Dimension(0, n2));
        this.setPreferredSize(new Dimension(0, n2));
    }

    public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
        this.updatePanel(jList, object, bl, n);
        this.configureRenderer(object);
        return this;
    }

    @Override
    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        if (object instanceof DefaultMutableTreeNode) {
            object = ((DefaultMutableTreeNode)object).getUserObject();
        }
        if (object instanceof GroupNode) {
            return this.groupPanel.update((GroupNode)object, bl2);
        }
        this.updatePanel(jTree, object, bl, n);
        this.configureRenderer(object);
        return this;
    }

    private void configureRenderer(Object object) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        if (object instanceof GroupNode) {
            GroupNode groupNode = (GroupNode)object;
            this.textLabel.setText(groupNode.getName());
            this.sub1Label.setText("Group: " + groupNode.getUid());
            this.sub2Label.setText("");
            this.iconLabel.setImage(this.icon);
        } else if (object instanceof Analyse) {
            Analyse analyse = (Analyse)object;
            BasicAnalyse.ModelMethod modelMethod = analyse.getModelMethod();
            this.textLabel.setText(analyse.getName());
            String string = analyse.getFormatedRating();
            this.sub1Label.setText(modelMethod.getTypeName() + ", " + StringHelper.formatLabel(modelMethod.getMethod()) + ", Rating: " + string);
            this.sub2Label.setText("Modified: " + analyse.getEntryData().getViewModifiedDate());
            this.setCustomImage(analyse, Scalr.Method.ULTRA_QUALITY);
        } else if (object instanceof Entry) {
            Entry entry;
            Entry entry2 = (Entry)object;
            if (measurementNotifications && object instanceof Measurement) {
                entry = (Measurement)object;
                if (entry.hasError()) {
                    bl2 = true;
                } else if (entry.hasCriticalWarning()) {
                    bl = true;
                }
            }
            bl3 = entry2.applyChangesNeeded();
            this.textLabel.setText(entry2.toString());
            Entry entry3 = entry2;
            Objects.requireNonNull(entry3);
            entry = entry3;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Measurement.class, Group.class, Workflow.class}, (Entry)entry, n)) {
                case 0: {
                    Entry entry4 = entry;
                    this.sub1Label.setText(FileHelper.getRawSize(entry4));
                    break;
                }
                case 1: {
                    Group group = (Group)entry;
                    this.sub1Label.setText(StringHelper.pluralize(group.getChildCount(), "measurement"));
                    break;
                }
                case 2: {
                    Workflow workflow = (Workflow)entry;
                    this.sub1Label.setText(StringHelper.pluralize(FileHelper.countSubfoldersWithFile(workflow.getFolder(), "group.xml"), "group"));
                    break;
                }
                default: {
                    this.sub1Label.setText("");
                }
            }
            this.sub2Label.setText("Modified: " + entry2.getEntryData().getViewModifiedDate());
            this.setCustomImage(entry2, Scalr.Method.BALANCED);
        } else if (object instanceof RuntimeWorkflow) {
            RuntimeWorkflow runtimeWorkflow = (RuntimeWorkflow)object;
            this.textLabel.setText(runtimeWorkflow.getName());
            this.sub1Label.setText("Mode: " + runtimeWorkflow.getPredictionMode().toString());
            this.sub2Label.setText("Created: " + runtimeWorkflow.getViewCreatedDate());
            BufferedImage bufferedImage = runtimeWorkflow.getSmallThumbnail(this.icon.getWidth(null), this.icon.getHeight(null));
            if (bufferedImage != null) {
                this.iconLabel.setImage(bufferedImage);
            } else {
                this.setDefaultIcon(runtimeWorkflow);
            }
        } else if (object instanceof ViewClass) {
            ViewClass viewClass = (ViewClass)object;
            this.iconLabel.setImage(this.icon);
            this.textLabel.setText(viewClass.getName());
            this.sub1Label.setText(viewClass.getSubtitle());
            this.sub2Label.setText(viewClass.formattedSubtitle2() + " ");
            if (viewClass.getIcon() != null) {
                this.iconLabel.setImage(viewClass.getIcon().getImage());
            }
        } else if (object instanceof ScriptFile) {
            ScriptFile scriptFile = (ScriptFile)object;
            this.textLabel.setText(scriptFile.getName());
            this.sub1Label.setText(scriptFile.getScriptInfo());
            this.sub2Label.setText("Application");
        } else if (object instanceof Node) {
            Node node = (Node)object;
            this.textLabel.setText(node.getNodeName());
            this.sub1Label.setText("");
            this.sub2Label.setText("");
            this.iconPanel.setVisible(false);
        } else if (object instanceof DescriptorTreeNode) {
            DescriptorTreeNode descriptorTreeNode = (DescriptorTreeNode)object;
            this.textLabel.setText(descriptorTreeNode.getAliasOrNodeString());
            this.sub1Label.setText("");
            this.sub2Label.setText("");
        } else if (object != null) {
            this.textLabel.setText(object.toString());
            this.sub1Label.setText("");
            this.sub2Label.setText("");
        }
        this.warningLabel.setVisible(bl);
        this.errorLabel.setVisible(bl2);
        this.applyChangesLabel.setVisible(bl3);
    }

    protected void setCustomImage(Entry entry, Scalr.Method method) {
        Runnable runnable = () -> SwingUtilities.invokeLater(() -> {
            if (this.list != null && this.list.isShowing()) {
                this.list.repaint();
            }
        });
        File file = entry.getCustomImageFile();
        if (!entry.isGrayed() && file != null && file.exists()) {
            if (entry instanceof Group) {
                BufferedImage bufferedImage2 = ThumbnailManager.getInstance(0).renderCustomImage(file, null, method, bufferedImage -> runnable.run());
                if (bufferedImage2 != null) {
                    this.iconLabel.setImage(ImageHelper.getImageInFolderImageIcon(bufferedImage2));
                } else {
                    this.iconLabel.setImage(null);
                }
            } else {
                BufferedImage bufferedImage3 = ThumbnailManager.getInstance(this.imageSize).renderCustomImage(file, this.imageBgColor, method, bufferedImage -> runnable.run());
                this.iconLabel.setImage(bufferedImage3);
            }
        } else {
            this.setDefaultIcon(entry);
        }
    }

    protected void setDefaultIcon(BasicEntry basicEntry) {
        if (basicEntry.isGrayed()) {
            this.iconLabel.setImage(this.grayedIcon);
        } else {
            this.iconLabel.setImage(this.icon);
        }
    }

    @Generated
    public void setHoverIndex(int n) {
        this.hoverIndex = n;
    }

    @Generated
    public int getHoverIndex() {
        return this.hoverIndex;
    }

    private static class IndentationPanel
    extends JPanel {
        private final BasicStroke stroke = new BasicStroke(2.0f, 1, 0, 10.0f);
        private boolean last;

        public IndentationPanel() {
            super(new BorderLayout());
        }

        @Override
        public void paint(Graphics graphics) {
            super.paint(graphics);
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setStroke(this.stroke);
            graphics2D.setColor(BreezeTheme.getInstance().getPanelBackground150());
            int n = this.getHeight();
            int n2 = this.getWidth();
            int n3 = n2 / 4;
            int n4 = n / 2;
            if (this.last) {
                graphics2D.drawLine(n3, 0, n3, n4);
            } else {
                graphics2D.drawLine(n3, 0, n3, n);
            }
            graphics2D.drawLine(n3, n4, n2, n4);
        }

        public void setIndentation(int n, boolean bl) {
            this.last = bl;
            this.setMinimumSize(new Dimension(n, 0));
            this.setPreferredSize(new Dimension(n, 0));
        }
    }
}

