/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.entry;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.Serializable;
import javax.swing.JLabel;
import javax.swing.JPanel;
import se.prediktera.breeze.entry.group.Group;
import se.prediktera.breeze.entry.measurement.Measurement;
import se.prediktera.breeze.frontend.BreezeMainPanel;
import se.prediktera.breeze.frontend.common.entry.EntryMainHelper;
import se.prediktera.breeze.frontend.common.entry.EntryMainPanel;
import se.prediktera.breeze.frontend.common.entry.EntryMainSwitchPanel;
import se.prediktera.breeze.frontend.common.swing.BreezeLabel;
import se.prediktera.breeze.frontend.common.swing.BreezeTheme;

public class EntryPathPanel
extends JPanel {
    private final BreezeMainPanel mainPanel;
    private final JPanel pathPanel = new JPanel(new GridBagLayout());
    private final JLabel nameLabel = new JLabel();
    private Object[] parentPath;

    public EntryPathPanel(BreezeMainPanel breezeMainPanel, String string, boolean bl) {
        super(new GridBagLayout());
        this.mainPanel = breezeMainPanel;
        this.setOpaque(false);
        BreezeTheme breezeTheme = BreezeTheme.getInstance();
        this.pathPanel.setOpaque(false);
        this.pathPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.insets = new Insets(0, 0, 4, 0);
        this.add((Component)this.pathPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 20);
        if (bl) {
            this.nameLabel.setForeground(breezeTheme.getLabelForeground());
            this.nameLabel.setBackground(new Color(110, 110, 110));
            this.nameLabel.setFont(new Font("Tahoma", 0, 22));
            this.nameLabel.setText(string);
            this.nameLabel.setVerticalAlignment(3);
            this.nameLabel.setVerticalTextPosition(3);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.anchor = 16;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = new Insets(0, 0, 0, 20);
            this.add((Component)this.nameLabel, gridBagConstraints);
        } else {
            this.add((Component)new JLabel(), gridBagConstraints);
        }
    }

    public void setFormatedTitle(Object object) {
        Serializable serializable;
        this.parentPath = this.getParentPath(object);
        this.pathPanel.removeAll();
        Color color = BreezeTheme.getInstance().getLabelForeground();
        Object[] objectArray = this.mainPanel;
        if (objectArray instanceof EntryMainSwitchPanel && (objectArray = ((EntryMainSwitchPanel)(serializable = (EntryMainSwitchPanel)objectArray)).getStudyContext()) != null && object != objectArray && (this.parentPath == null || this.parentPath.length == 0 || this.parentPath[0] != objectArray)) {
            Font font = new Font(this.nameLabel.getFont().getFontName(), 0, 12);
            BreezeLabel breezeLabel = new BreezeLabel(objectArray.toString() + ": ");
            breezeLabel.setFont(font);
            breezeLabel.setForeground(color);
            EntryMainHelper.addComponent(this.pathPanel, breezeLabel, false, this.pathPanel.getComponentCount(), 0);
        }
        if (this.parentPath != null) {
            serializable = new Font(this.nameLabel.getFont().getFontName(), 0, 12);
            for (Object object2 : this.parentPath) {
                if (object2 == null) continue;
                BreezeLabel breezeLabel = new BreezeLabel(object2.toString());
                breezeLabel.setFont((Font)serializable);
                breezeLabel.setForeground(color);
                EntryMainHelper.addComponent(this.pathPanel, breezeLabel, false, this.pathPanel.getComponentCount(), 0);
                JLabel jLabel = new JLabel(" / ");
                jLabel.setFont((Font)serializable);
                jLabel.setForeground(color);
                EntryMainHelper.addComponent(this.pathPanel, jLabel, false, this.pathPanel.getComponentCount(), 0);
            }
        }
        this.pathPanel.validate();
        this.pathPanel.repaint();
        objectArray = this.mainPanel;
        if (objectArray instanceof EntryMainPanel) {
            serializable = (EntryMainPanel)objectArray;
            this.nameLabel.setText(((EntryMainPanel)serializable).getEntryName(object));
        }
    }

    protected Object[] getParentPath(Object object) {
        if (object instanceof Measurement) {
            Measurement measurement = (Measurement)object;
            Group group = measurement.getParent();
            return new Object[]{group.getParent(), group};
        }
        if (object instanceof Group) {
            Group group = (Group)object;
            return new Object[]{group.getParent()};
        }
        return null;
    }

    public String getLabelName() {
        return this.nameLabel.getText();
    }

    public void setLabelName(String string) {
        this.nameLabel.setText(string);
    }

    public String getTitle() {
        String string = this.nameLabel.getText();
        if (this.parentPath != null && this.parentPath.length > 0) {
            return string + " - " + String.valueOf(this.parentPath[0]);
        }
        return string;
    }
}

