/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.entry;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import se.prediktera.breeze.frontend.common.swing.BreezeButton;
import se.prediktera.breeze.frontend.common.swing.BreezeLabel;
import se.prediktera.breeze.frontend.common.swing.BreezeSplitPane;
import se.prediktera.breeze.frontend.common.swing.BreezeTheme;
import se.prediktera.breeze.frontend.common.util.ImageHelper;
import se.prediktera.breeze.frontend.common.view.AbstractViewPanel;

public class EntrySettingsPanel
extends JPanel {
    private final ToggleButton toggleButton;
    private boolean right = true;
    private final AbstractViewPanel viewPanel;
    private final SettingsComponent settingsPanel;
    private final BreezeSplitPane splitPane;
    private boolean isToggled = true;
    private int lastDividerLocation;

    public EntrySettingsPanel(BreezeSplitPane breezeSplitPane, AbstractViewPanel abstractViewPanel, ToggleButton toggleButton, boolean bl) {
        this.splitPane = breezeSplitPane;
        this.viewPanel = abstractViewPanel;
        this.toggleButton = toggleButton;
        this.right = bl;
        BreezeTheme breezeTheme = BreezeTheme.getInstance();
        this.setBackground(breezeTheme.getPanelBackground());
        this.setLayout(new BorderLayout());
        toggleButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                EntrySettingsPanel.this.toggleVisible(!EntrySettingsPanel.this.isToggled);
            }
        });
        if (bl) {
            this.settingsPanel = abstractViewPanel.getRightSettingsPanel(this);
            this.isToggled = abstractViewPanel.showRightSettingsPanel();
        } else {
            this.settingsPanel = abstractViewPanel.getLeftSettingsPanel();
            this.isToggled = abstractViewPanel.showLeftSettingsPanel();
        }
        if (this.settingsPanel != null) {
            toggleButton.setDescription(this.settingsPanel.getDescription());
            this.add(this.settingsPanel.getPanel(), "Center");
            this.toggleVisible(this.isToggled);
            SettingsComponent settingsComponent = this.settingsPanel;
            if (settingsComponent instanceof JPanel) {
                JPanel jPanel = (JPanel)((Object)settingsComponent);
                this.settingsPanel.setChangeListener(() -> {
                    toggleButton.setVisible(jPanel.isVisible());
                    breezeSplitPane.setDividerSize(jPanel.isVisible() ? 5 : 0);
                    if (jPanel.isVisible()) {
                        if (this.lastDividerLocation > 0) {
                            breezeSplitPane.setDividerLocation(this.lastDividerLocation);
                        } else {
                            int n = breezeSplitPane.getWidth() - jPanel.getPreferredSize().width;
                            if (n > 0) {
                                breezeSplitPane.setDividerLocation(n);
                            } else {
                                breezeSplitPane.setDividerLocation(1.0);
                            }
                        }
                    } else {
                        this.lastDividerLocation = breezeSplitPane.getDividerLocation();
                        breezeSplitPane.setDividerLocation(Integer.MAX_VALUE);
                    }
                });
            }
        } else {
            toggleButton.setVisible(false);
            breezeSplitPane.setDividerSize(0);
        }
    }

    public void parentResized() {
        if (!this.isToggled) {
            if (this.right) {
                this.splitPane.setDividerLocation(Integer.MAX_VALUE);
            } else {
                this.splitPane.setDividerLocation(0);
            }
        }
    }

    public void setWeight(int n) {
        this.splitPane.setResizeWeight(n);
    }

    public void showEntry(Object object, Object object2) {
        if (this.settingsPanel != null) {
            this.settingsPanel.showEntry(object, object2, this.isToggled);
        }
    }

    public void toggleVisible(boolean bl) {
        this.isToggled = bl;
        int n = this.getPreferredSize().width;
        this.viewPanel.beginUpdate();
        if (this.right) {
            if (bl) {
                if (this.splitPane.getResizeWeight() == 1.0) {
                    this.splitPane.setDividerLocation(this.splitPane.getSize().width - n);
                } else {
                    this.splitPane.setDividerLocation(n);
                }
            } else {
                this.splitPane.setDividerLocation(Integer.MAX_VALUE);
            }
        } else if (bl) {
            this.splitPane.setDividerLocation(n);
        } else {
            this.splitPane.setDividerLocation(0);
        }
        this.splitPane.setDividerSize(bl ? 5 : 0);
        String string = (bl ? "hide" : "show") + (this.right ? "right" : "left") + ".png";
        ImageIcon imageIcon = new ImageIcon(this.getClass().getResource("/images/" + string));
        if (BreezeTheme.getInstance().isDarkMode()) {
            imageIcon = ImageHelper.changeGrayBrightness(imageIcon, 5);
        }
        this.toggleButton.setIcon(imageIcon);
        this.viewPanel.settingsToggled(this.right, bl);
        SwingUtilities.invokeLater(() -> this.viewPanel.endUpdate());
        if (this.settingsPanel != null) {
            this.settingsPanel.toggled(bl);
        }
    }

    public static class ToggleButton
    extends BreezeButton {
        private final BreezeLabel label = new BreezeLabel("Test", false, 12);

        public ToggleButton(boolean bl) {
            this.setName("toggle" + (bl ? "Right" : "Left"));
            this.setBackground(BreezeTheme.getInstance().getSettingPanelBackground());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridy = 3;
            gridBagConstraints.anchor = 11;
            gridBagConstraints.insets = new Insets(5, 0, 10, 0);
            this.label.setDirection(BreezeLabel.Direction.VERTICAL_UP);
            this.add((Component)this.label, gridBagConstraints);
        }

        public void setDescription(String string) {
            if (string != null) {
                this.setLabelVisible(true);
                this.label.setText(string);
                this.setOpaque(true);
            } else {
                this.setLabelVisible(false);
                this.setOpaque(false);
            }
        }

        public void setLabelVisible(boolean bl) {
            this.label.setVisible(bl && !this.label.getText().isBlank());
        }

        @Override
        protected ImageIcon createHoverIcon(ImageIcon imageIcon) {
            return ImageHelper.changeGrayBrightness(imageIcon, 35);
        }
    }

    public static interface SettingsComponent {
        public Component getPanel();

        default public String getDescription() {
            return null;
        }

        public void toggled(boolean var1);

        public void showEntry(Object var1, Object var2, boolean var3);

        public void setChangeListener(Runnable var1);
    }

    public class EntrySettingsStore {
        public EntrySettingsStore(EntrySettingsPanel entrySettingsPanel) {
        }
    }

    public static class SettingsSidePanel
    extends JPanel
    implements SettingsComponent {
        private Runnable action;

        public SettingsSidePanel() {
            BreezeTheme breezeTheme = BreezeTheme.getInstance();
            this.setBackground(breezeTheme.getPanelBackground());
        }

        public SettingsSidePanel(LayoutManager layoutManager) {
            super(layoutManager);
            BreezeTheme breezeTheme = BreezeTheme.getInstance();
            this.setBackground(breezeTheme.getPanelBackground());
        }

        @Override
        public Component getPanel() {
            return this;
        }

        @Override
        public void showEntry(Object object, Object object2, boolean bl) {
        }

        @Override
        public void toggled(boolean bl) {
        }

        @Override
        public void setVisible(boolean bl) {
            super.setVisible(bl);
            if (this.action != null) {
                this.action.run();
            }
        }

        @Override
        public void setChangeListener(Runnable runnable) {
            this.action = runnable;
        }
    }
}

