/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.entry;

import javax.swing.JPanel;
import se.prediktera.breeze.entry.workflow.VisualisationNode;
import se.prediktera.breeze.evince.data.queue.UpdateVisualizationJob;
import se.prediktera.breeze.frontend.common.entry.EntryMainHelper;
import se.prediktera.breeze.frontend.common.entry.EntryMainPanel;
import se.prediktera.breeze.frontend.common.entry.TabPanel;
import se.prediktera.breeze.frontend.common.pp.PPEntryMainInterface;
import se.prediktera.breeze.frontend.common.swing.BreezeButton;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressManager;
import se.prediktera.breeze.frontend.common.view.AbstractViewPanel;
import se.prediktera.breeze.frontend.common.view.ViewClass;
import se.prediktera.breeze.frontend.wizard.measure.step.WizardStep;
import se.prediktera.map.common.error.Logg;
import se.prediktera.map.main.ProjectProperties;
import se.prediktera.map.main.Project_GUI;

public class EntryTabPanel
extends TabPanel
implements PPEntryMainInterface {
    private Project_GUI evinceProject;
    private final EntryMainPanel mainPanel;
    private boolean showViewPanel;
    protected ViewClass internalViewClass;
    private AbstractViewPanel currentPanel = null;
    private boolean updating;

    public EntryTabPanel(EntryMainPanel entryMainPanel, boolean bl) {
        super(entryMainPanel);
        this.mainPanel = entryMainPanel;
        this.showViewPanel = bl;
        this.showTabs(bl);
        this.setMainpanel(entryMainPanel);
        this.setTabCallback(tab -> {
            if (this.updating) {
                return;
            }
            Object object = entryMainPanel.getSelectedEntry();
            entryMainPanel.setFormatedTitle(object);
            entryMainPanel.setCurrentPanel((ViewClass)tab, object);
        });
    }

    public void setShowViewPanel(boolean bl) {
        this.showViewPanel = bl;
    }

    public void setSelectedTabNoEvent(String string) {
        this.updating = true;
        this.setSelectedTab(string);
        this.updating = false;
    }

    @Override
    public Project_GUI getOrCreateEvinceProject() {
        if (this.evinceProject == null) {
            this.evinceProject = EntryTabPanel.createEvinceProject(this.mainPanel.entryPathPanel.getTitle(), this.mainPanel.getColorScale());
            return this.evinceProject;
        }
        return this.evinceProject;
    }

    public void closeEvinceProject() {
        if (this.evinceProject != null) {
            try {
                this.evinceProject.closeProjectNow();
            }
            catch (Exception exception) {
                Logg.error((String)"Error closing Evince project", (Throwable)exception);
            }
            this.evinceProject = null;
        }
    }

    public static Project_GUI createEvinceProject(String string, VisualisationNode.ColorScale colorScale) {
        Project_GUI project_GUI = Project_GUI.createNewProject((boolean)false);
        project_GUI.suggestProjectName(string);
        ProjectProperties projectProperties = project_GUI.getProperties();
        if (projectProperties != null) {
            projectProperties.setProperty("colorScale", colorScale.name);
            projectProperties.setProperty("reverseColorScale", String.valueOf(colorScale.reverse));
        }
        return project_GUI;
    }

    public void setCurrentPanel(Object object) {
        this.setCurrentPanel(this.internalViewClass, object);
    }

    protected void setCurrentPanel(ViewClass viewClass, Object object) {
        this.internalViewClass = viewClass;
        if (object != null) {
            this.showTabs(this.showViewPanel);
        }
        this.currentPanel = this.internalViewClass.getPanel();
        this.currentPanel.showEntry(object, this.internalViewClass);
        this.currentPanel.showEntrySettings(object, this.internalViewClass);
    }

    public WizardStep.LeaveResult leaveCurrentPanel(WizardStep.LeaveControlCallback leaveControlCallback, ViewClass viewClass) {
        if (this.currentPanel != null && viewClass != this.internalViewClass) {
            return this.currentPanel.leaveEntry(leaveControlCallback);
        }
        return WizardStep.LeaveResult.Ok;
    }

    @Override
    public WizardStep.LeaveResult leaveEntry(WizardStep.LeaveControlCallback leaveControlCallback) {
        this.closeEvinceProject();
        if (this.currentPanel != null) {
            return this.currentPanel.leaveEntry(leaveControlCallback);
        }
        return WizardStep.LeaveResult.Ok;
    }

    protected void showViewClass(ViewClass viewClass) {
        this.selectTab(viewClass);
    }

    @Override
    public Object getInData(BreezeProgressManager breezeProgressManager, UpdateVisualizationJob updateVisualizationJob, String string) {
        return null;
    }

    @Override
    protected void cleanUpChild() {
        super.cleanUpChild();
        this.closeEvinceProject();
        this.currentPanel = null;
    }

    public void addButtons(JPanel jPanel, BreezeButton breezeButton) {
        if (breezeButton != null) {
            EntryMainHelper.addComponent(jPanel, breezeButton, true, 100, EntryMainHelper.DEFAULT_SPACE);
        }
        this.currentPanel.addComponent(this.mainPanel);
    }
}

