/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.entry;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.ListCellRenderer;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import org.w3c.dom.Node;
import se.prediktera.breeze.common.entry.factor.category.CatClass;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionTreeNode;
import se.prediktera.breeze.common.util.FileHelper;
import se.prediktera.breeze.common.util.StringHelper;
import se.prediktera.breeze.frontend.common.swing.BreezeLabel;
import se.prediktera.breeze.frontend.common.swing.BreezeTheme;
import se.prediktera.breeze.frontend.common.swing.BreezeTree;
import se.prediktera.breeze.frontend.common.util.BreezeFilter;

public class LabelEntry
extends JPanel
implements ListCellRenderer,
TreeCellRenderer {
    private final JPanel colorPanel = new JPanel();
    private final JPanel innerPanel = new JPanel(new GridBagLayout());
    private final BreezeLabel label = new BreezeLabel();
    private final int height;

    public LabelEntry() {
        this(150, 16);
    }

    public LabelEntry(int n) {
        this(n, 16);
    }

    public LabelEntry(int n, int n2) {
        this(n, LabelEntry.getHeightFromFontSize(n2), n2, true);
    }

    public LabelEntry(int n, int n2, int n3, boolean bl) {
        super(new GridBagLayout());
        this.height = n2;
        BreezeTheme breezeTheme = BreezeTheme.getInstance();
        this.setBackground(breezeTheme.getPanelBackground());
        this.innerPanel.setMinimumSize(new Dimension(160, n2));
        this.innerPanel.setPreferredSize(new Dimension(160, n2));
        this.colorPanel.setMinimumSize(new Dimension(16, n2 / 2));
        this.colorPanel.setPreferredSize(new Dimension(16, n2 / 2));
        this.colorPanel.setBorder(BorderFactory.createLineBorder(breezeTheme.getLabelForegroundDifuse()));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.innerPanel.add((Component)this.colorPanel, gridBagConstraints);
        this.label.setFontSize(n3);
        this.label.setMinimumSize(new Dimension(150, n2 / 2));
        this.label.setPreferredSize(new Dimension(150, n2 / 2));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.innerPanel.add((Component)this.label, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        if (bl) {
            gridBagConstraints.insets = new Insets(n2 / 5, 0, 0, n2 / 5);
        }
        this.add((Component)this.innerPanel, gridBagConstraints);
        this.setWidth(n);
    }

    public void setWidth(int n) {
        if (n < 0) {
            this.setMinimumSize(null);
            this.setPreferredSize(null);
            this.innerPanel.setPreferredSize(null);
            this.label.setPreferredSize(null);
        } else {
            this.setMinimumSize(new Dimension(n, this.height));
            this.setPreferredSize(new Dimension(n, this.height));
        }
    }

    private static int getHeightFromFontSize(int n) {
        return n >= 16 ? 40 : 28;
    }

    @Override
    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
        return this.getCellRendererComponent(jTree, defaultMutableTreeNode.getUserObject(), n, bl, bl4);
    }

    public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
        return this.getCellRendererComponent(jList, object, n, bl, bl2);
    }

    protected String getText(Object object) {
        if (object instanceof Node) {
            Node node = (Node)object;
            return node.getNodeName();
        }
        if (object instanceof BreezeFilter) {
            BreezeFilter breezeFilter = (BreezeFilter)object;
            return breezeFilter.toString();
        }
        if (object instanceof File) {
            return FileHelper.getFileName((File)object);
        }
        if (object instanceof FunctionTreeNode) {
            return ((FunctionTreeNode)object).getAliasOrNodeString();
        }
        if (object instanceof CatClass) {
            CatClass catClass = (CatClass)object;
            if (catClass.isIncluded()) {
                this.setColor(catClass.getColor());
            } else {
                this.setColor(Color.gray);
            }
            if (catClass.getSubClasses().isEmpty()) {
                return catClass.getName();
            }
            return catClass.getName() + " (" + catClass.getSubClasses().size() + ")";
        }
        if (object != null) {
            if (object instanceof String) {
                return StringHelper.formatLabel(object.toString());
            }
            return object.toString();
        }
        return "NULL";
    }

    protected ImageIcon getIcon(Object object) {
        return null;
    }

    private boolean isIncluded(Object object) {
        if (object instanceof CatClass) {
            return ((CatClass)object).isIncluded();
        }
        return true;
    }

    private Component getCellRendererComponent(JComponent jComponent, Object object, int n, boolean bl, boolean bl2) {
        this.setColor(null);
        boolean bl3 = this.isIncluded(object);
        this.label.setText(this.getText(object));
        this.label.setIcon(this.getIcon(object));
        if (bl) {
            Color color = null;
            Color color2 = Color.black;
            if (jComponent instanceof JList) {
                JList jList = (JList)jComponent;
                color = jList.getSelectionBackground();
                color2 = jList.getSelectionForeground();
            } else if (jComponent instanceof BreezeTree) {
                BreezeTree breezeTree = (BreezeTree)((Object)jComponent);
                color = breezeTree.getSelectionBackground();
                color2 = breezeTree.getSelectionForeground();
            }
            if (!bl3) {
                color2 = Color.GRAY;
            }
            this.innerPanel.setBackground(color);
            this.label.setForeground(color2);
        } else {
            this.innerPanel.setBackground(jComponent.getBackground());
            if (bl3) {
                this.label.setForeground(jComponent.getForeground());
            } else {
                this.label.setForeground(Color.GRAY);
            }
        }
        this.setBackground(jComponent.getBackground());
        return this;
    }

    public void setColor(Color color) {
        if (color != null) {
            this.colorPanel.setBackground(color);
            this.colorPanel.setVisible(true);
        } else {
            this.colorPanel.setVisible(false);
        }
    }
}

