/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.entry;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import se.prediktera.breeze.frontend.common.entry.EntrySettingsPanel;
import se.prediktera.breeze.frontend.common.swing.BreezeSplitPane;
import se.prediktera.breeze.frontend.common.swing.BreezeTheme;
import se.prediktera.breeze.frontend.common.view.AbstractViewPanel;
import se.prediktera.breeze.frontend.common.view.ViewClass;

public class MainViewPanel
extends BreezeSplitPane {
    private final BreezeSplitPane rightSplitPane = new BreezeSplitPane();
    private final EntrySettingsPanel.ToggleButton leftButton = new EntrySettingsPanel.ToggleButton(false);
    private final EntrySettingsPanel.ToggleButton rightButton = new EntrySettingsPanel.ToggleButton(true);
    private final EntrySettingsPanel leftSettingsPanel;
    private final EntrySettingsPanel rightSettingsPanel;
    private final AbstractViewPanel viewPanel;

    public MainViewPanel(AbstractViewPanel abstractViewPanel) {
        this(abstractViewPanel, 10);
    }

    public MainViewPanel(AbstractViewPanel abstractViewPanel, int n) {
        this.viewPanel = abstractViewPanel;
        this.setBackground(Color.white);
        this.rightSplitPane.setResizeWeight(1.0);
        BreezeTheme breezeTheme = BreezeTheme.getInstance();
        JPanel jPanel = new JPanel();
        jPanel.setBackground(breezeTheme.getPanelBackground());
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.add((Component)this.leftButton, gridBagConstraints);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setOpaque(false);
        if (n > 0) {
            jPanel2.setBorder(BorderFactory.createEmptyBorder(n, n, n, n));
        }
        jPanel2.add((Component)((Object)abstractViewPanel), "Center");
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.weighty = 1.0;
        jPanel.add((Component)jPanel2, gridBagConstraints2);
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 2;
        jPanel.add((Component)this.rightButton, gridBagConstraints3);
        this.leftSettingsPanel = new EntrySettingsPanel(this, abstractViewPanel, this.leftButton, false);
        this.rightSettingsPanel = new EntrySettingsPanel(this.rightSplitPane, abstractViewPanel, this.rightButton, true);
        this.setLeftComponent(this.leftSettingsPanel);
        this.setRightComponent(this.rightSplitPane);
        this.rightSplitPane.setLeftComponent(jPanel);
        this.rightSplitPane.setRightComponent(this.rightSettingsPanel);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                MainViewPanel.this.leftSettingsPanel.parentResized();
            }
        });
        this.rightSplitPane.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                MainViewPanel.this.rightSettingsPanel.parentResized();
            }
        });
    }

    public EntrySettingsPanel getLeftSettingsPanel() {
        return this.leftSettingsPanel;
    }

    public EntrySettingsPanel getRightSettingsPanel() {
        return this.rightSettingsPanel;
    }

    public BreezeSplitPane getRightSplitPane() {
        return this.rightSplitPane;
    }

    public void showEntrySettings(Object object, ViewClass viewClass) {
        this.leftSettingsPanel.showEntry(object, viewClass);
        this.rightSettingsPanel.showEntry(object, viewClass);
    }

    public AbstractViewPanel getViewPanel() {
        return this.viewPanel;
    }
}

