/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.entry;

import java.awt.Dimension;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import se.prediktera.breeze.frontend.common.entry.EntrySettingsPanel;
import se.prediktera.breeze.frontend.common.entry.MainViewPanel;
import se.prediktera.breeze.frontend.common.view.AbstractViewPanel;

public class MainViewPanelTest {
    @Test
    public void leftPanelShouldBeShownInButtonClicked() {
        MainViewPanel mainViewPanel = this.createMainViewPanel();
        EntrySettingsPanel entrySettingsPanel = mainViewPanel.getLeftSettingsPanel();
        entrySettingsPanel.setPreferredSize(new Dimension(200, 600));
        entrySettingsPanel.toggleVisible(true);
        MatcherAssert.assertThat((Object)mainViewPanel.getDividerLocation(), (Matcher)CoreMatchers.is((Object)200));
    }

    @Test
    public void rightPanelShouldBeShownInButtonClicked() {
        MainViewPanel mainViewPanel = this.createMainViewPanel();
        mainViewPanel.getRightSplitPane().setSize(600, 600);
        EntrySettingsPanel entrySettingsPanel = mainViewPanel.getRightSettingsPanel();
        entrySettingsPanel.setPreferredSize(new Dimension(200, 600));
        entrySettingsPanel.toggleVisible(true);
        MatcherAssert.assertThat((Object)mainViewPanel.getRightSplitPane().getDividerLocation(), (Matcher)CoreMatchers.is((Object)400));
    }

    private MainViewPanel createMainViewPanel() {
        MainViewPanel mainViewPanel = new MainViewPanel(new EmptyViewPanel());
        mainViewPanel.setSize(600, 600);
        return mainViewPanel;
    }

    private static class EmptyViewPanel
    extends AbstractViewPanel {
        private EmptyViewPanel() {
        }

        @Override
        public void showEntry(Object object, Object object2) {
        }

        @Override
        public String getType() {
            return "Empty";
        }
    }
}

