/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.entry;

import javax.swing.JPanel;
import se.prediktera.breeze.frontend.BreezeFrame;
import se.prediktera.breeze.frontend.BreezeMainPanel;
import se.prediktera.breeze.frontend.common.entry.EntryMainPanel;
import se.prediktera.breeze.frontend.common.swing.dialog.AbstractBreezeDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.ProgressAction;

public abstract class OpenEntryProgressAction
extends ProgressAction {
    private BreezeMainPanel openPanel = null;
    private final BreezeFrame frame;
    private AbstractBreezeDialog.BreezeDialog dialog;
    private final double sizePercent;

    public OpenEntryProgressAction(BreezeFrame breezeFrame) {
        this(breezeFrame, 1.0);
    }

    public OpenEntryProgressAction(BreezeFrame breezeFrame, double d) {
        this.frame = breezeFrame;
        this.sizePercent = d;
    }

    @Override
    public void actionPrepare() {
        if (this.sizePercent < 1.0) {
            this.dialog = new AbstractBreezeDialog.BreezeDialog(this.frame, this.sizePercent);
        }
    }

    @Override
    public void actionComplete() {
        this.addPage(true);
    }

    protected void addPage(boolean bl) {
        if (this.openPanel != null) {
            BreezeMainPanel breezeMainPanel;
            if (bl && (breezeMainPanel = this.openPanel) instanceof EntryMainPanel) {
                EntryMainPanel entryMainPanel = (EntryMainPanel)breezeMainPanel;
                entryMainPanel.selectFirstItem(true);
            } else {
                this.openPanel.showSelectedEntry(false);
            }
            if (this.dialog != null) {
                this.dialog.addPanel(this.openPanel);
                this.openPanel.getFrame().addPage((JPanel)((Object)this.dialog));
            } else {
                this.openPanel.getFrame().addPage(this.openPanel);
            }
        }
    }

    @Override
    public void runAction() throws Exception {
        this.setInfoText("Opening window");
        this.openPanel = this.createOpenPanel();
    }

    protected abstract BreezeMainPanel createOpenPanel() throws Exception;

    public BreezeMainPanel getOpenPanel() {
        return this.openPanel;
    }

    public static abstract class OpenEntryDialogProgressAction
    extends OpenEntryProgressAction {
        public OpenEntryDialogProgressAction(BreezeFrame breezeFrame) {
            super(breezeFrame, 0.9);
        }
    }
}

