/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.entry;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import se.prediktera.breeze.frontend.BreezeMainPanel;
import se.prediktera.breeze.frontend.common.ArrayListModel;
import se.prediktera.breeze.frontend.common.entry.MainCardPanel;
import se.prediktera.breeze.frontend.common.swing.BreezeTheme;
import se.prediktera.breeze.frontend.common.view.AbstractViewPanel;
import se.prediktera.breeze.frontend.common.view.ViewClass;
import se.prediktera.breeze.frontend.common.view.ViewList;

public class TabPanel
extends AbstractViewPanel {
    private final ViewList viewList = new ViewList();
    private final MainCardPanel cardPanel = new MainCardPanel();
    private TabCallback tabCallback;
    private final List<Tab> tabList = new ArrayList<Tab>();

    public TabPanel() {
        this(null);
    }

    public TabPanel(BreezeMainPanel breezeMainPanel) {
        super(breezeMainPanel);
        this.setLayout(new BorderLayout());
        BreezeTheme breezeTheme = BreezeTheme.getInstance();
        this.viewList.addListSelectionListener(listSelectionEvent -> {
            Tab tab;
            if (!listSelectionEvent.getValueIsAdjusting() && this.viewList.isVisible() && (tab = this.getSelectedTab()) != null) {
                this.cardPanel.showPanel(tab.getPanel());
                if (this.tabCallback != null) {
                    this.tabCallback.selected(tab);
                }
            }
        });
        this.viewList.setModel(new ArrayListModel(this.tabList));
        this.viewList.setOpaque(true);
        this.viewList.setBackground(breezeTheme.getPanelTitleBackground());
        this.viewList.setSelectionBackground(breezeTheme.getPanelBackground());
        this.viewList.setLayoutOrientation(2);
        this.viewList.setPreferredSize(new Dimension(0, 40));
        this.viewList.setMinimumSize(new Dimension(0, 40));
        this.viewList.setName("viewList");
        this.viewList.setSelectionForeground(breezeTheme.getLabelForeground());
        this.add(this.viewList, "North");
        this.add(this.cardPanel, "Center");
    }

    public void addTab(Tab tab) {
        this.tabList.add(tab);
        this.cardPanel.addPanel(tab.getPanel());
    }

    public void addPage(Tab tab) {
        this.cardPanel.addPanel(tab.getPanel());
    }

    public void selectTab(Tab tab) {
        this.viewList.setSelectedValue(tab, true);
        this.cardPanel.showPanel(tab.getPanel());
    }

    public void selectTab(int n) {
        this.selectTab((Tab)this.viewList.getObjectAt(n));
    }

    public void setSelectedTab(int n) {
        this.viewList.setSelectedIndex(n);
    }

    public void setSelectedTab(String string) {
        this.setSelectedTab(this.viewList.getIndexOf(string));
    }

    public Tab getSelectedTab() {
        return (Tab)this.viewList.getSelectedValue();
    }

    public void showTabs(boolean bl) {
        this.viewList.setVisible(bl);
    }

    @Override
    protected void cleanUpChild() {
        this.cardPanel.cleanUp();
    }

    public void setTabCallback(TabCallback tabCallback) {
        this.tabCallback = tabCallback;
    }

    @Override
    public String getType() {
        return "TabPanel";
    }

    @Override
    public void showEntry(Object object, Object object2) {
        Tab tab = this.getSelectedTab();
        if (tab != null) {
            tab.getPanel().showEntry(object, object2);
        }
    }

    @Override
    public void setMainpanel(BreezeMainPanel breezeMainPanel) {
        super.setMainpanel(breezeMainPanel);
        this.viewList.setMainPanel(breezeMainPanel);
    }

    public void addTabs(List<ViewClass> list) {
        this.cardPanel.addPanelsFromViewList(list);
        this.tabList.addAll(list);
        this.setSelectedTab(0);
    }

    public static interface Tab {
        public String getName();

        public AbstractViewPanel getPanel();
    }

    public static interface TabCallback {
        public void selected(Tab var1);
    }
}

