/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.entry;

import java.awt.Color;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.LinkedBlockingDeque;
import javax.imageio.ImageIO;
import org.imgscalr.Scalr;
import se.prediktera.breeze.common.util.thread.BreezeThread;
import se.prediktera.breeze.entry.Entry;
import se.prediktera.breeze.entry.analyse.Analyse;
import se.prediktera.breeze.entry.measurement.Measurement;
import se.prediktera.breeze.frontend.common.util.ImageHelper;

public class ThumbnailManager {
    private static final HashMap<Integer, ThumbnailManager> instances = new HashMap();
    private final LinkedHashMap<String, BufferedImage> imageIconHashMap;
    private final RenderQueue renderQueue = new RenderQueue();
    private final int imageSize;

    public static ThumbnailManager getInstance(int n) {
        ThumbnailManager thumbnailManager = instances.get(n);
        if (thumbnailManager == null) {
            thumbnailManager = new ThumbnailManager(n);
            instances.put(n, thumbnailManager);
        }
        return thumbnailManager;
    }

    public ThumbnailManager(int n) {
        this(n, 100);
    }

    public ThumbnailManager(int n, final int n2) {
        this.imageSize = n;
        this.imageIconHashMap = new LinkedHashMap<String, BufferedImage>(this){
            final /* synthetic */ ThumbnailManager this$0;
            {
                this.this$0 = thumbnailManager;
            }

            @Override
            protected boolean removeEldestEntry(Map.Entry<String, BufferedImage> entry) {
                return this.size() > n2;
            }
        };
    }

    public static void clearInstance() {
        for (ThumbnailManager thumbnailManager : instances.values()) {
            thumbnailManager.imageIconHashMap.clear();
        }
        instances.clear();
    }

    public BufferedImage renderCustomImage(File file, Color color, Scalr.Method method, RenderAction renderAction) {
        if (file == null || !file.exists()) {
            return null;
        }
        if (this.imageIconHashMap.containsKey(file.getAbsolutePath())) {
            return this.getImage(file);
        }
        this.renderQueue.push(new RenderValue(file, this.imageSize, this.imageSize, color, method, renderAction));
        return null;
    }

    public BufferedImage getCustomIconImage(File file, Color color) {
        return this.getCustomIconImage(file, color, Scalr.Method.BALANCED);
    }

    public BufferedImage getCustomIconImage(File file, Color color, Scalr.Method method) {
        if (file == null || !file.exists()) {
            return null;
        }
        BufferedImage bufferedImage = ThumbnailManager.getInstance(0).getImage(file);
        String string = file.getAbsolutePath();
        BufferedImage bufferedImage2 = this.imageIconHashMap.get(string);
        if (bufferedImage2 == null && (bufferedImage2 = ImageHelper.getScaledImage(bufferedImage, this.imageSize, this.imageSize, color, method)) != null) {
            this.imageIconHashMap.put(string, bufferedImage2);
        }
        return bufferedImage2;
    }

    public BufferedImage getImage(File file) {
        String string = file.getAbsolutePath();
        BufferedImage bufferedImage = this.imageIconHashMap.get(string);
        if (bufferedImage == null && file.exists()) {
            try {
                if (file instanceof Analyse.FileUrl) {
                    Analyse.FileUrl fileUrl = (Analyse.FileUrl)file;
                    bufferedImage = ImageIO.read(fileUrl.getUrl());
                } else {
                    bufferedImage = ImageIO.read(file);
                }
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
            if (bufferedImage != null) {
                this.imageIconHashMap.put(string, bufferedImage);
            }
        }
        return bufferedImage;
    }

    public Image getClonedImage(File file) {
        BufferedImage bufferedImage = this.getImage(file);
        BufferedImage bufferedImage2 = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), bufferedImage.getType());
        DataBuffer dataBuffer = bufferedImage.getRaster().getDataBuffer();
        if (dataBuffer instanceof DataBufferInt) {
            int[] nArray = ((DataBufferInt)bufferedImage2.getRaster().getDataBuffer()).getData();
            System.arraycopy(((DataBufferInt)bufferedImage.getRaster().getDataBuffer()).getData(), 0, nArray, 0, nArray.length);
        } else {
            byte[] byArray = ((DataBufferByte)bufferedImage2.getRaster().getDataBuffer()).getData();
            System.arraycopy(((DataBufferByte)bufferedImage.getRaster().getDataBuffer()).getData(), 0, byArray, 0, byArray.length);
        }
        return bufferedImage2;
    }

    public static void deleteAndRemoveMeasurementImagesFromCache(List<Measurement> list) {
        for (Measurement measurement : list) {
            ThumbnailManager.deleteAndRemoveMeasurementImageFromCache(measurement);
        }
    }

    public static void deleteAndRemoveMeasurementImageFromCache(Measurement measurement) {
        ThumbnailManager.removeMeasurementImageFromCache(measurement);
        measurement.deleteThumbnail();
    }

    public static void removeMeasurementImageFromCache(Measurement measurement) {
        ThumbnailManager.removeCustomIconImageFromCache(measurement);
        measurement.increaseChanged();
    }

    public static void removeCustomIconImageFromCache(Object object) {
        for (ThumbnailManager thumbnailManager : instances.values()) {
            thumbnailManager.removeCustomIconImageFromCacheLocal(object);
        }
    }

    public boolean hasFile(File file) {
        return this.imageIconHashMap.containsKey(file.getAbsolutePath());
    }

    private void removeCustomIconImageFromCacheLocal(Object object) {
        if (object instanceof Entry) {
            File file = ((Entry)object).getCustomImageFile();
            this.imageIconHashMap.remove(file.getAbsolutePath());
        } else if (object instanceof File) {
            this.imageIconHashMap.remove(((File)object).getAbsolutePath());
        } else {
            this.imageIconHashMap.remove(object);
        }
    }

    public class RenderQueue {
        private final LinkedBlockingDeque<RenderValue> queue = new LinkedBlockingDeque();
        private BreezeThread thread;

        public void push(RenderValue renderValue) {
            if (!this.queue.contains(renderValue)) {
                if (this.queue.size() > 50) {
                    this.queue.removeLast();
                }
                this.queue.addFirst(renderValue);
            }
            if (!this.queue.isEmpty()) {
                this.startThreadIfNotRunning();
            }
        }

        private void startThreadIfNotRunning() {
            if (this.thread == null || !this.thread.isAlive()) {
                this.thread = new BreezeThread(this.getClass().getName(), () -> {
                    RenderValue renderValue = this.queue.poll();
                    while (renderValue != null) {
                        BufferedImage bufferedImage = ThumbnailManager.this.getCustomIconImage(renderValue.file, renderValue.bgColor, renderValue.method);
                        renderValue.action.onRender(bufferedImage);
                        renderValue = this.queue.poll();
                    }
                });
                this.thread.start();
            }
        }
    }

    public static class RenderValue {
        File file;
        int width;
        int height;
        Color bgColor;
        private final Scalr.Method method;
        RenderAction action;

        public RenderValue(File file, int n, int n2, Color color, Scalr.Method method, RenderAction renderAction) {
            this.file = file;
            this.width = n;
            this.height = n2;
            this.bgColor = color;
            this.method = method;
            this.action = renderAction;
        }

        public boolean equals(Object object) {
            if (object instanceof RenderValue) {
                return ((RenderValue)object).file.equals(this.file);
            }
            return false;
        }
    }

    public static interface RenderAction {
        public void onRender(BufferedImage var1);
    }
}

