/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.entry.comment;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.font.TextAttribute;
import java.util.Collections;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.text.View;
import org.apache.commons.lang3.StringUtils;
import org.ocpsoft.prettytime.PrettyTime;
import se.prediktera.breeze.entry.Entry;
import se.prediktera.breeze.entry.EntryData;
import se.prediktera.breeze.entry.comment.Comment;
import se.prediktera.breeze.frontend.BreezeMainPanel;
import se.prediktera.breeze.frontend.common.entry.EntryMainHelper;
import se.prediktera.breeze.frontend.common.entry.EntryMainPanelInterface;
import se.prediktera.breeze.frontend.common.swing.BreezeButton;
import se.prediktera.breeze.frontend.common.swing.BreezeLabel;
import se.prediktera.breeze.frontend.common.swing.BreezeLabelButton;
import se.prediktera.breeze.frontend.common.swing.BreezeTheme;
import se.prediktera.breeze.frontend.common.swing.dialog.AbstractBreezeDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeOptionDialog;
import se.prediktera.breeze.frontend.common.util.BreezeUserManager;
import se.prediktera.breeze.frontend.common.util.ImageHelper;

public class CommentPanel
extends JPanel {
    private final JTextArea textArea;
    private final JPanel readMoreContainerPanel = new JPanel();

    public CommentPanel(Comment comment, EntryMainHelper.ClickCallBack clickCallBack) {
        super(new GridBagLayout());
        JComponent jComponent;
        this.setBorder(new BreezeButton.RoundedBorder(this, BreezeTheme.getInstance().getLabelForegroundMoreDifuse(), 1));
        this.setBackground(BreezeTheme.getInstance().getPanelBackground());
        this.textArea = new JTextArea(comment.getTextContent());
        this.textArea.setBorder(BorderFactory.createLineBorder(BreezeTheme.getInstance().getSettingPanelBackground(), 5));
        this.textArea.setBackground(BreezeTheme.getInstance().getSettingPanelBackground());
        this.textArea.setEditable(false);
        this.textArea.setFont(new Font("Tahoma", 0, 14));
        this.textArea.setForeground(BreezeTheme.getInstance().getLabelForeground());
        this.textArea.setRows(1);
        this.textArea.setLineWrap(true);
        this.textArea.setWrapStyleWord(true);
        int n = this.textArea.getFontMetrics(this.textArea.getFont()).getHeight();
        int n2 = n * 10 + this.textArea.getInsets().top + this.textArea.getInsets().bottom;
        this.textArea.setPreferredSize(new Dimension(600, n2));
        final JLabel jLabel = new JLabel("Read more");
        jLabel.setFont(new Font("Tahoma", 1, 14));
        jLabel.setForeground(this.textArea.getForeground());
        jLabel.setCursor(Cursor.getPredefinedCursor(12));
        this.updateTextAreaVisibility();
        final Font font = jLabel.getFont();
        final Font font2 = font.deriveFont(Collections.singletonMap(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON));
        jLabel.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ CommentPanel this$0;
            {
                this.this$0 = commentPanel;
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                jLabel.setFont(font2);
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                jLabel.setFont(font);
            }

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                this.this$0.readMoreContainerPanel.setVisible(false);
                this.this$0.textArea.setPreferredSize(null);
                this.this$0.textArea.revalidate();
                this.this$0.textArea.repaint();
            }
        });
        this.readMoreContainerPanel.add(jLabel);
        this.readMoreContainerPanel.setOpaque(true);
        this.readMoreContainerPanel.setVisible(false);
        this.readMoreContainerPanel.setBackground(this.textArea.getBackground());
        this.readMoreContainerPanel.setPreferredSize(new Dimension(600, this.textArea.getFontMetrics(jLabel.getFont()).getHeight() * 2));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = -1;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(0, 10, 0, 10);
        this.add((Component)this.readMoreContainerPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        gridBagConstraints.fill = 1;
        this.add((Component)this.textArea, gridBagConstraints);
        if (BreezeUserManager.getInstance().isEnabled()) {
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.insets = new Insets(2, 10, 5, 0);
            jComponent = new BreezeLabel(comment.getCreatedBy(), ImageHelper.getResourceIcon("material/person"));
            ((BreezeLabel)jComponent).setFontSize(12);
            this.add((Component)jComponent, gridBagConstraints);
        }
        jComponent = new BreezeLabelButton("Remove", "delete", clickCallBack);
        ((BreezeLabelButton)jComponent).setFontSize(12);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(2, 10, 5, 0);
        this.add((Component)jComponent, gridBagConstraints);
        BreezeLabel breezeLabel = new BreezeLabel(new PrettyTime().format(comment.getCreatedDate()));
        breezeLabel.setFontSize(12);
        breezeLabel.setToolTipText(EntryData.viewformat.format(comment.getCreatedDate()));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 12;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(5, 0, 5, 10);
        this.add((Component)breezeLabel, gridBagConstraints);
    }

    private void updateTextAreaVisibility() {
        SwingUtilities.invokeLater(() -> {
            View view = this.textArea.getUI().getRootView(this.textArea).getView(0);
            view.setSize(this.textArea.getWidth(), Float.MAX_VALUE);
            float f = view.getPreferredSpan(1);
            int n = this.textArea.getFontMetrics(this.textArea.getFont()).getHeight();
            if (f > (float)(n * 10)) {
                this.readMoreContainerPanel.setVisible(true);
            } else {
                this.textArea.setPreferredSize(null);
            }
        });
    }

    public static class CommentsPanel
    extends JPanel {
        private EntryMainPanelInterface mainPanel;
        private Entry entry;
        private final boolean addTitle;

        public CommentsPanel(boolean bl) {
            super(new GridBagLayout());
            this.addTitle = bl;
            this.setBackground(BreezeTheme.getInstance().getPanelBackground());
        }

        public void addComment(String string) {
            if (this.entry != null && StringUtils.isNotEmpty((CharSequence)string)) {
                this.entry.getComments().add(new Comment(string));
                this.entry.save();
                this.setEntry(this.mainPanel, this.entry);
            }
        }

        public void setEntry(EntryMainPanelInterface entryMainPanelInterface, Entry entry) {
            Object object;
            this.mainPanel = entryMainPanelInterface;
            this.entry = entry;
            this.removeAll();
            if (this.addTitle && !entry.getComments().isEmpty()) {
                object = new BreezeLabel("Comments", false);
                ((BreezeLabel)object).setForeground(BreezeTheme.getInstance().getLabelForegroundMoreDifuse());
                ((BreezeLabel)object).setFontSize(BreezeLabel.FontSize.H2);
                Object object2 = new GridBagConstraints();
                ((GridBagConstraints)object2).fill = 1;
                ((GridBagConstraints)object2).insets = new Insets(5, 0, 5, 0);
                this.add((Component)object, object2);
            }
            for (Object object2 : entry.getComments()) {
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridy = this.getComponentCount();
                gridBagConstraints.fill = 1;
                gridBagConstraints.insets = new Insets(5, 0, 5, 0);
                this.add((Component)new CommentPanel((Comment)object2, () -> this.lambda$setEntry$0(entry, (Comment)object2, entryMainPanelInterface)), gridBagConstraints);
            }
            object = new GridBagConstraints();
            ((GridBagConstraints)object).gridy = this.getComponentCount();
            ((GridBagConstraints)object).weightx = 1.0;
            ((GridBagConstraints)object).weighty = 1.0;
            this.add((Component)new JLabel(""), object);
            this.revalidate();
            this.repaint();
        }

        public BreezeButton createButton(BreezeMainPanel breezeMainPanel) {
            return EntryMainHelper.createButton("addComment", "Add comment", "material/add_comment", () -> BreezeOptionDialog.showDialog(breezeMainPanel, AbstractBreezeDialog.MessageType.INPUT_AREA_OPTION, "Add new comment", null, breezeActionEvent -> this.addComment(breezeActionEvent.result().toString())));
        }

        private /* synthetic */ void lambda$setEntry$0(Entry entry, Comment comment, EntryMainPanelInterface entryMainPanelInterface) {
            entry.getComments().remove(comment);
            entry.save();
            this.setEntry(entryMainPanelInterface, entry);
        }
    }
}

