/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.graphcollection;

import com.mxgraph.model.mxCell;
import com.mxgraph.model.mxGeometry;
import com.mxgraph.swing.mxGraphComponent;
import com.mxgraph.util.mxPoint;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.swing.JToolBar;
import org.apache.commons.text.StringEscapeUtils;
import se.prediktera.breeze.backend.realtime.RtFramePredictor;
import se.prediktera.breeze.common.entry.analyse.BasicAnalyse;
import se.prediktera.breeze.common.entry.factor.category.CatClass;
import se.prediktera.breeze.common.entry.factor.category.CategoryFactor;
import se.prediktera.breeze.common.entry.tree.analysistree.ActionNode;
import se.prediktera.breeze.common.entry.tree.analysistree.SegmentationNode;
import se.prediktera.breeze.common.entry.tree.analysistree.SegmentationPort;
import se.prediktera.breeze.common.entry.tree.evaluatetree.EvaluateNode;
import se.prediktera.breeze.common.entry.tree.evaluatetree.impl.NoneEvaluate;
import se.prediktera.breeze.common.entry.tree.functiontree.AbstractBreezeFunction;
import se.prediktera.breeze.common.entry.tree.functiontree.AbstractFunctionTree;
import se.prediktera.breeze.common.entry.tree.functiontree.AdditionalFactor;
import se.prediktera.breeze.common.entry.tree.functiontree.EvaluateResult;
import se.prediktera.breeze.common.entry.tree.functiontree.EvaluateResultHolder;
import se.prediktera.breeze.common.entry.tree.functiontree.EvaluationTree;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionTreeList;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionTreeNode;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionTreeNodeWithId;
import se.prediktera.breeze.common.realtime.descriptor.DescriptorInterface;
import se.prediktera.breeze.common.realtime.descriptor.model.ConnectionDescriptor;
import se.prediktera.breeze.common.realtime.descriptor.model.PlsPredClassificationDescriptor;
import se.prediktera.breeze.common.realtime.descriptor.spatial.expression.CatClassExpression;
import se.prediktera.breeze.common.realtime.descriptor.spatial.expression.CategoryExpressionParameter;
import se.prediktera.breeze.common.realtime.segmentation.AbstractSegmentation;
import se.prediktera.breeze.common.util.StringHelper;
import se.prediktera.breeze.entry.analyse.Analyse;
import se.prediktera.breeze.entry.analyse.model.ModelProperties;
import se.prediktera.breeze.entry.group.Group;
import se.prediktera.breeze.entry.sample.Sample;
import se.prediktera.breeze.entry.workflow.Workflow;
import se.prediktera.breeze.frontend.common.entry.EntryMainHelper;
import se.prediktera.breeze.frontend.common.graphcollection.TreePanel;
import se.prediktera.breeze.frontend.common.swing.BreezeButton;
import se.prediktera.breeze.frontend.main.play.edit.FunctionParameterCustomInput;
import se.prediktera.map.common.NiceDataFormat;

public class FunctionTreePanel
extends TreePanel {
    private final List<AbstractFunctionTree> functionTreeList = new ArrayList<AbstractFunctionTree>();
    private final List<Object> addedObjects = new ArrayList<Object>();
    private DescriptorInterface entry = null;
    private boolean showTransformations;
    private final int adjustOffsetX = 15;
    private Workflow workflow;

    public FunctionTreePanel(boolean bl, boolean bl2) {
        super(bl, bl2);
    }

    public void addFunctionGraph(AbstractFunctionTree abstractFunctionTree) {
        this.functionTreeList.add(abstractFunctionTree);
    }

    public void addFunctionTree(FunctionTreeList functionTreeList) {
        if (functionTreeList.getName().equals("workflow")) {
            this.setAnalyseGraph();
        }
        for (AbstractFunctionTree abstractFunctionTree : functionTreeList.getChildList()) {
            if (abstractFunctionTree.getRoot() == null) continue;
            this.functionTreeList.add(abstractFunctionTree);
        }
    }

    public void setWorkflowGraph(AbstractFunctionTree abstractFunctionTree) {
        this.clear();
        this.setAnalyseGraph();
        this.functionTreeList.add(abstractFunctionTree);
        this.updateGraph();
    }

    @Override
    public void clear() {
        super.clear();
        this.entry = null;
        this.functionTreeList.clear();
    }

    public void evaluate(Sample sample, Group group) {
        this.clear();
        AbstractFunctionTree abstractFunctionTree = group.getWorkflowSampleTree();
        if (abstractFunctionTree != null) {
            this.setEntry(sample);
            this.addFunctionGraph(abstractFunctionTree);
            this.updateGraph();
        }
    }

    public void setEntry(DescriptorInterface descriptorInterface) {
        this.entry = descriptorInterface;
    }

    public void showTransformations(boolean bl) {
        this.showTransformations = bl;
    }

    @Override
    protected Object updateGraphLocal(Object object) {
        if (this.functionTreeList != null) {
            HashMap<FunctionTreeList, Object> hashMap = new HashMap<FunctionTreeList, Object>();
            Iterator<AbstractFunctionTree> iterator = this.functionTreeList.iterator();
            if (iterator.hasNext()) {
                AbstractFunctionTree abstractFunctionTree = iterator.next();
                Object object2 = object;
                FunctionTreeList functionTreeList = abstractFunctionTree.getParent();
                if (functionTreeList != null && this.functionTreeList.size() > 1 && (object2 = hashMap.get(functionTreeList)) == null) {
                    object2 = this.graph.insertVertex(object, "", (Object)functionTreeList, 0.0, 0.0, 0.0, 0.0, "swimlane".toUpperCase());
                    hashMap.put(functionTreeList, object2);
                }
                Object object3 = this.graph.insertVertex(object2, "", (Object)abstractFunctionTree, 0.0, 0.0, 0.0, 0.0, "swimlane".toUpperCase());
                this.setSroot(object3);
                EvaluateResultHolder evaluateResultHolder = null;
                if (this.entry != null) {
                    evaluateResultHolder = abstractFunctionTree.evaluateAll(this.entry);
                }
                return this.updateGraph(abstractFunctionTree, object3, null, evaluateResultHolder, true);
            }
        }
        return null;
    }

    @Override
    protected void executeLayout(Object object) {
        super.executeLayout(object);
        this.adjustLayout(object, 0, false, false);
    }

    private void adjustLayout(Object object, int n, boolean bl, boolean bl2) {
        if (object instanceof mxCell) {
            mxPoint mxPoint2;
            Object object2;
            boolean bl3;
            mxCell mxCell2 = (mxCell)object;
            if (n != 0) {
                mxGeometry mxGeometry2 = this.graph.getCellGeometry((Object)mxCell2);
                if (mxCell2.isEdge()) {
                    bl3 = false;
                    object2 = mxGeometry2.getPoints();
                    if (object2 != null) {
                        Iterator iterator = object2.iterator();
                        while (iterator.hasNext()) {
                            mxPoint2 = (mxPoint)iterator.next();
                            if (bl && !bl3) {
                                mxPoint2.setX(mxPoint2.getX() + (double)n + 15.0);
                            } else {
                                mxPoint2.setX(mxPoint2.getX() + (double)n);
                            }
                            bl3 += 1;
                        }
                    }
                } else {
                    mxGeometry2.setX(mxGeometry2.getX() + (double)n);
                }
            }
            if (bl2) {
                return;
            }
            boolean bl4 = false;
            bl3 = false;
            object2 = mxCell2.getValue();
            if (object2 instanceof SegmentationNode) {
                bl3 = this.getLinkedSeg((SegmentationNode)object2) != null;
                bl4 = true;
                n -= 15;
            } else if (object2 instanceof ModelProperties.TransformationProperties) {
                bl4 = true;
                n -= 15;
            }
            for (int i = 0; i < mxCell2.getEdgeCount(); ++i) {
                mxPoint2 = (mxCell)mxCell2.getEdgeAt(i);
                if (mxPoint2.getTarget() == mxCell2) continue;
                this.adjustLayout(mxPoint2, n, bl4, bl3);
            }
            if (mxCell2.getTarget() != null) {
                this.adjustLayout(mxCell2.getTarget(), n, false, bl3);
            }
        }
    }

    private FunctionTreeNodeWithId getFunctionTreeNode(String string) {
        for (Object k : this.vertexHashMap.keySet()) {
            if (!(k instanceof FunctionTreeNodeWithId) || !((FunctionTreeNodeWithId)k).getUid().equals(string)) continue;
            return (FunctionTreeNodeWithId)k;
        }
        return null;
    }

    private Object updateGraph(Object object, Object object2, Object object3, EvaluateResultHolder evaluateResultHolder, boolean bl) {
        Object object4 = object3;
        Object object5 = "";
        String string = "";
        if (object instanceof FunctionTreeNode) {
            FunctionTreeNodeWithId functionTreeNodeWithId;
            FunctionTreeNode functionTreeNode = (FunctionTreeNode)object;
            String string2 = functionTreeNode.getShapeType();
            object4 = this.vertexHashMap.get(object);
            if (!functionTreeNode.isEnabled()) {
                bl = false;
            }
            if (object4 == null) {
                Object object6;
                Object object9;
                if (evaluateResultHolder != null && (object9 = evaluateResultHolder.get(object)) != null) {
                    if (((EvaluateResult)object9).hasFail()) {
                        object5 = (String)object5 + ";" + this.warningStyle;
                        string = this.warningStyle;
                    } else {
                        object5 = ";result=" + NiceDataFormat.toString((double)((EvaluateResult)object9).getResult());
                    }
                }
                if (this.useNoSelectionStyle && !FunctionTreePanel.supportSelection(functionTreeNode)) {
                    object5 = (String)object5 + ";" + this.noSelectionStyle;
                }
                if (!bl) {
                    object5 = (String)object5 + ";" + this.disabledStyle;
                } else if (this.workflow != null && functionTreeNode instanceof FunctionTreeNodeWithId && StringHelper.equals((String)this.workflow.functionErrorId, (String)((FunctionTreeNodeWithId)(object9 = (FunctionTreeNodeWithId)functionTreeNode)).getUid())) {
                    object5 = (String)object5 + ";" + this.warningStyle;
                }
                if (this.showTransformations) {
                    List<ModelProperties.TransformationProperties> list;
                    RtFramePredictor.ReferenceConvertTo object8;
                    object9 = functionTreeNode.getFunction();
                    BasicAnalyse basicAnalyse = ((AbstractBreezeFunction)object9).getAnalyse();
                    if (basicAnalyse != null && (object8 = basicAnalyse.getConvertTo()) != null && object8.useReferences()) {
                        Object object7;
                        Iterator<AdditionalFactor> iterator = new StringBuffer(object8.format());
                        if (basicAnalyse instanceof Analyse && ((Analyse)(object7 = (Analyse)basicAnalyse)).getModelInformation() != null && (object6 = ((Analyse)object7).getModelInformation().getFormatedRange(this.workflow, true)) != null) {
                            ((StringBuffer)((Object)iterator)).append("@@");
                            ((StringBuffer)((Object)iterator)).append((String)object6);
                        }
                        object4 = this.graph.insertVertex(object2, null, (Object)((StringBuffer)((Object)iterator)).toString(), 0.0, 0.0, 80.0, 60.0, "transformation".toUpperCase() + (String)object5);
                        this.graph.insertEdge(object2, null, (Object)"", object3, object4, string);
                        object3 = object4;
                    }
                    if ((list = ((AbstractBreezeFunction)object9).getTransformations()) != null) {
                        for (Object object7 : list) {
                            if (!((ModelProperties.TransformationProperties)object7).enabled()) continue;
                            object4 = this.graph.insertVertex(object2, null, object7, 0.0, 0.0, 80.0, 60.0, "transformation".toUpperCase() + (String)object5);
                            this.graph.insertEdge(object2, null, (Object)"", object3, object4, string);
                            object3 = object4;
                        }
                    }
                }
                int n = 150;
                int n2 = 25;
                if (string2.equals("evaluate") || string2.equals("segmentate") || string2.equals("segmentate_bg") || string2.equals("root") || string2.equals("action")) {
                    n = 100;
                    n2 = 100;
                } else if (string2.equals("segmentate_port")) {
                    n = 80;
                }
                object4 = this.graph.insertVertex(object2, null, object, 50.0, 50.0, (double)n, (double)n2, string2.toUpperCase() + (String)object5);
                this.vertexHashMap.put(functionTreeNode, object4);
                this.addClassNodes(object2, object3, object4, (String)object5, string, functionTreeNode, string2, bl);
                List<AdditionalFactor> list = functionTreeNode.getAdditionalFactors();
                if (list != null) {
                    for (Object object7 : list) {
                        if (!((AdditionalFactor)object7).isVisibleInTree()) continue;
                        object6 = this.graph.insertVertex(object2, null, (Object)((AdditionalFactor)object7).getName(), 50.0, 50.0, 150.0, 25.0, "descriptor_additional".toUpperCase() + (String)object5 + ";" + this.noSelectionStyle);
                        this.graph.insertEdge(object2, null, (Object)"", object4, object6, string);
                    }
                }
            }
            if (object2 == null) {
                object2 = object4;
            }
            if (object3 != null) {
                if (string2.equals("segmentate_port")) {
                    string = "strokeWidth=2;endSize=0";
                } else {
                    String string3 = this.getAppliesTo(functionTreeNode);
                    if (string3 != null && string3.length() > 1 && !string3.equalsIgnoreCase("all")) {
                        string = "dashed=1";
                    }
                }
                this.graph.insertEdge(object2, null, (Object)"", object3, object4, string);
            }
            if ((functionTreeNodeWithId = this.getLinkedSeg(functionTreeNode)) instanceof SegmentationNode) {
                SegmentationPort segmentationPort = ((SegmentationNode)functionTreeNodeWithId).getDefaultPort();
                if (object3 != null) {
                    string = "strokeWidth=2;endSize=0";
                    this.graph.insertEdge(object2, null, (Object)"", object4, this.vertexHashMap.get(segmentationPort), string);
                }
                return null;
            }
            for (FunctionTreeNode functionTreeNode2 : functionTreeNode.getChildList()) {
                if (!functionTreeNode2.isVisible()) continue;
                this.updateGraph(functionTreeNode2, object2, object4, evaluateResultHolder, bl);
            }
        } else if (object instanceof EvaluationTree) {
            return this.updateGraph(((EvaluationTree)object).getRoot(), object2, object4, evaluateResultHolder, bl);
        }
        return object4;
    }

    private String getAppliesTo(FunctionTreeNode functionTreeNode) {
        if (functionTreeNode instanceof SegmentationNode) {
            return ((SegmentationNode)functionTreeNode).getFunction().appliesTo();
        }
        return null;
    }

    public FunctionTreeNodeWithId getLinkedSeg(FunctionTreeNode functionTreeNode) {
        AbstractSegmentation abstractSegmentation;
        Object object = functionTreeNode.getFunction();
        if (object instanceof AbstractSegmentation && ((String)(object = (abstractSegmentation = (AbstractSegmentation)object).getLinkedId())).length() > 1 && !((String)object).equalsIgnoreCase("none")) {
            FunctionTreeNodeWithId functionTreeNodeWithId = this.getFunctionTreeNode((String)object);
            if (functionTreeNodeWithId == null) {
                abstractSegmentation.clearLink();
                if (this.workflow != null) {
                    this.workflow.save();
                }
            }
            return functionTreeNodeWithId;
        }
        return null;
    }

    public void addAddShape(FunctionTreeNode functionTreeNode) {
        this.addAddShape(this.getVertexFromObject(functionTreeNode), functionTreeNode);
    }

    public void addAddShape(Object object, FunctionTreeNode functionTreeNode) {
        if (this.addedObjects.size() > 0 || functionTreeNode != null) {
            this.graph.getModel().beginUpdate();
            this.graph.removeCells(this.addedObjects.toArray());
            this.addedObjects.clear();
            if (functionTreeNode != null) {
                if (FunctionTreePanel.support(functionTreeNode, true)) {
                    this.addObject(object, functionTreeNode);
                }
                if (!(functionTreeNode instanceof SegmentationNode) && !(functionTreeNode instanceof SegmentationPort) && functionTreeNode.getParent() != null) {
                    FunctionTreeNode functionTreeNode2 = SegmentationNode.getParentNode(functionTreeNode);
                    this.addObject(this.getVertexFromObject(functionTreeNode2), functionTreeNode2);
                }
            }
            this.executeLayout();
            this.graph.getModel().endUpdate();
        }
    }

    private void addObject(Object object, FunctionTreeNode functionTreeNode) {
        if (functionTreeNode instanceof SegmentationNode) {
            functionTreeNode = ((SegmentationNode)functionTreeNode).getDefaultPort();
            object = this.getVertexFromObject(functionTreeNode);
        }
        Object object2 = this.getSroot();
        String string = ";" + this.noSelectionStyle;
        Object object3 = this.graph.insertVertex(object2, null, (Object)new AddNewFunction(functionTreeNode), 50.0, 50.0, 50.0, 50.0, "add".toUpperCase() + string);
        this.addedObjects.add(object3);
        this.addedObjects.add(this.graph.insertEdge(object2, null, (Object)"", object, object3, "edgeStyle="));
    }

    private void addClassNodes(Object object, Object object2, Object object3, String string, String string2, FunctionTreeNode functionTreeNode, String string3, boolean bl) {
        for (CatClass catClass : FunctionTreePanel.getClasses(functionTreeNode)) {
            StringBuilder stringBuilder = new StringBuilder(";classcolor=").append(catClass.getColorString());
            if (this.useNoSelectionStyle) {
                stringBuilder.append(";").append(this.noSelectionStyle);
            }
            if (!bl) {
                stringBuilder.append(";").append(this.disabledStyle);
            }
            Object object4 = this.graph.insertVertex(object, null, (Object)catClass, 50.0, 50.0, 150.0, 25.0, "catclass".toUpperCase() + String.valueOf(stringBuilder));
            this.graph.insertEdge(object, null, (Object)"", object3, object4, string2);
        }
    }

    private static List<CatClass> getClasses(FunctionTreeNode functionTreeNode) {
        ArrayList<CatClass> arrayList;
        block6: {
            AbstractBreezeFunction abstractBreezeFunction;
            block5: {
                CategoryFactor categoryFactor;
                arrayList = new ArrayList<CatClass>();
                abstractBreezeFunction = functionTreeNode.getFunction();
                if (!(abstractBreezeFunction instanceof PlsPredClassificationDescriptor)) break block5;
                PlsPredClassificationDescriptor plsPredClassificationDescriptor = (PlsPredClassificationDescriptor)abstractBreezeFunction;
                if (functionTreeNode.getIndex() != 0) break block5;
                BasicAnalyse basicAnalyse = plsPredClassificationDescriptor.getAnalyse();
                if (basicAnalyse == null || (categoryFactor = basicAnalyse.getCategoryFactor()) == null) break block6;
                for (CatClass catClass : categoryFactor.getClasses()) {
                    if (catClass.isNoClass() || !catClass.isIncluded() || FunctionTreePanel.hasConnection(catClass, functionTreeNode)) continue;
                    arrayList.add(catClass);
                }
                break block6;
            }
            if (abstractBreezeFunction instanceof FunctionParameterCustomInput.ExpressionClassificationFactorInterface) {
                FunctionParameterCustomInput.ExpressionClassificationFactorInterface expressionClassificationFactorInterface = (FunctionParameterCustomInput.ExpressionClassificationFactorInterface)((Object)abstractBreezeFunction);
                CategoryExpressionParameter categoryExpressionParameter = expressionClassificationFactorInterface.getExpression();
                CategoryFactor categoryFactor = expressionClassificationFactorInterface.getFactor(functionTreeNode);
                if (categoryFactor != null) {
                    for (CatClassExpression catClassExpression : categoryExpressionParameter.getExpressionLists()) {
                        String string;
                        if (catClassExpression == null || (string = catClassExpression.getExpression()) == null || string.length() <= 0) continue;
                        CatClass catClass = catClassExpression.getCatClass();
                        if (catClass == null) {
                            catClass = categoryFactor.getClass(catClassExpression.getId());
                        }
                        if (catClass == null) continue;
                        arrayList.add(catClass);
                    }
                }
            }
        }
        return arrayList;
    }

    private static boolean hasConnection(CatClass catClass, FunctionTreeNode functionTreeNode) {
        for (FunctionTreeNode functionTreeNode2 : functionTreeNode.getChildList()) {
            AbstractBreezeFunction abstractBreezeFunction = functionTreeNode2.getFunction();
            if (!(abstractBreezeFunction instanceof ConnectionDescriptor)) continue;
            ConnectionDescriptor connectionDescriptor = (ConnectionDescriptor)((Object)abstractBreezeFunction);
            if (!catClass.getName().equals(connectionDescriptor.getConnectionClass())) continue;
            return true;
        }
        return false;
    }

    public void setWorkflow(Workflow workflow) {
        this.workflow = workflow;
    }

    @Override
    public void setChangeListener(Runnable runnable) {
    }

    protected String getToolTipTextForCell(MouseEvent mouseEvent, mxCell mxCell2) {
        if (mxCell2 != null) {
            Properties properties;
            Object object = mxCell2.getValue();
            if (object instanceof FunctionTreeNode) {
                StringBuffer stringBuffer = new StringBuffer();
                ((FunctionTreeNode)object).addToolTipText(this.workflow, stringBuffer);
                String string = StringEscapeUtils.escapeHtml4((String)stringBuffer.toString());
                if (string.length() > 0) {
                    return "<html>" + string.replace("@", "<br/>") + "</html>";
                }
            } else if (object instanceof ModelProperties.TransformationProperties && (properties = ((ModelProperties.TransformationProperties)object).getProperties()).size() > 0) {
                StringBuilder stringBuilder = new StringBuilder();
                for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append("<br/>");
                    }
                    stringBuilder.append(entry.getKey()).append(" = ").append(entry.getValue());
                }
                return "<html>" + String.valueOf(stringBuilder) + "</html>";
            }
        }
        return super.getToolTipTextForCell(mouseEvent, mxCell2);
    }

    public static boolean supportSelection(Object object) {
        return FunctionTreePanel.support(object, false);
    }

    public static boolean support(Object object, boolean bl) {
        if (object instanceof FunctionTreeNode) {
            String string;
            AbstractBreezeFunction abstractBreezeFunction;
            if (bl && (abstractBreezeFunction = ((FunctionTreeNode)object).getFunction()) instanceof AbstractSegmentation && (string = ((AbstractSegmentation)abstractBreezeFunction).getLinkedId()).length() > 1 && !string.equalsIgnoreCase("none")) {
                return false;
            }
            if (object instanceof FunctionTreeNodeWithId || object instanceof SegmentationPort) {
                return true;
            }
            if (object instanceof ActionNode) {
                return !bl;
            }
            if (object instanceof EvaluateNode) {
                return ((EvaluateNode)object).getFunction() instanceof NoneEvaluate;
            }
        }
        return false;
    }

    public static class AddNewFunction {
        private final FunctionTreeNode node;

        public AddNewFunction(FunctionTreeNode functionTreeNode) {
            this.node = functionTreeNode;
        }

        public FunctionTreeNode getNode() {
            return this.node;
        }
    }

    public static class FunctionTreeToolbar
    extends JToolBar {
        public FunctionTreeToolbar(FunctionTreePanel functionTreePanel) {
            mxGraphComponent mxGraphComponent2 = functionTreePanel.getGraphComponent();
            this.add(this.createButton("Zoom in", "explore/zoom_in", () -> mxGraphComponent2.zoomIn()));
            this.addSeparator(new Dimension(10, 0));
            this.add(this.createButton("Zoom normal", "explore/zoom_all", () -> mxGraphComponent2.zoomActual()));
            this.addSeparator(new Dimension(10, 0));
            this.add(this.createButton("Zoom to fit window", "explore/zoom_area", () -> FunctionTreeToolbar.zoomToFitWindow(mxGraphComponent2)));
            this.addSeparator(new Dimension(10, 0));
            this.add(this.createButton("Zoom out", "explore/zoom_out", () -> mxGraphComponent2.zoomOut()));
            this.setFloatable(false);
            this.setOpaque(false);
        }

        public static void zoomToFitWindow(mxGraphComponent mxGraphComponent2) {
            mxGraphComponent2.zoomActual();
            mxGraphComponent2.getGraphControl().revalidate();
            double d = (double)mxGraphComponent2.getViewport().getWidth() / (double)mxGraphComponent2.getGraphControl().getPreferredSize().width;
            double d2 = (double)mxGraphComponent2.getViewport().getHeight() / (double)mxGraphComponent2.getGraphControl().getPreferredSize().height;
            double d3 = Math.min(d, d2);
            mxGraphComponent2.zoomTo(d3, true);
        }

        private BreezeButton createButton(String string, String string2, EntryMainHelper.ClickCallBack clickCallBack) {
            BreezeButton breezeButton = EntryMainHelper.createButton("", string2, clickCallBack);
            breezeButton.setToolTipText(string);
            return breezeButton;
        }
    }
}

