/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.graphcollection;

import com.mxgraph.layout.hierarchical.mxHierarchicalLayout;
import com.mxgraph.model.mxCell;
import com.mxgraph.util.mxConstants;
import java.awt.Component;
import java.awt.Point;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionTreeNode;
import se.prediktera.breeze.common.util.RtPerfectSpread;
import se.prediktera.breeze.frontend.common.entry.EntrySettingsPanel;
import se.prediktera.breeze.frontend.common.graphcollection.DefaultTreePanel;
import se.prediktera.breeze.frontend.common.swing.BreezeTheme;

public abstract class TreePanel
extends DefaultTreePanel
implements EntrySettingsPanel.SettingsComponent {
    protected final HashMap<Object, Object> vertexHashMap = new HashMap();
    protected final boolean useNoSelectionStyle;
    protected final String warningStyle;
    protected final String noSelectionStyle;
    protected final String disabledStyle;
    protected Object groot;
    private Object sroot;
    private Object gnode;

    public TreePanel(boolean bl, boolean bl2) {
        super(bl);
        this.useNoSelectionStyle = bl2;
        this.layoutType = "horizontaltree";
        this.layoutType = "verticalhierarchical";
        this.graph.setLabelsVisible(false);
        this.warningStyle = mxConstants.STYLE_STROKEWIDTH + "=5;" + mxConstants.STYLE_STROKECOLOR + "=red";
        this.noSelectionStyle = mxConstants.STYLE_STROKEWIDTH + "=1;" + mxConstants.STYLE_STROKECOLOR + "=" + RtPerfectSpread.getColorToString(BreezeTheme.getInstance().getPanelBackground());
        this.disabledStyle = mxConstants.STYLE_FILLCOLOR + "=gray";
    }

    protected void setAnalyseGraph() {
        Map map = this.graph.getStylesheet().getDefaultEdgeStyle();
        map.put(mxConstants.STYLE_STARTARROW, mxConstants.NONE);
        map.put(mxConstants.STYLE_ENDARROW, "block");
    }

    public void clear() {
        this.vertexHashMap.clear();
    }

    public Object getSroot() {
        return this.sroot;
    }

    public void setSroot(Object object) {
        this.sroot = object;
    }

    @Override
    public void updateGraph() {
        try {
            this.graph.selectAll();
            this.graph.removeCells();
            this.graph.getModel().beginUpdate();
            this.groot = this.graph.getDefaultParent();
            if (this.vertexHashMap != null) {
                this.gnode = this.updateGraphLocal(this.groot);
                this.executeLayout(this.gnode);
            }
            if (this.ispreview) {
                this.graphComponent.zoomTo(1.0, true);
            }
        }
        finally {
            this.graph.getModel().endUpdate();
            if (this.graphOutline != null) {
                this.graphOutline.destroyTripleBuffer();
            }
        }
    }

    public List<FunctionTreeNode> getSelectedNodes() {
        ArrayList<FunctionTreeNode> arrayList = new ArrayList<FunctionTreeNode>();
        for (Object object : this.graph.getSelectionCells()) {
            Object object2;
            if (!(object instanceof mxCell) || !((object2 = ((mxCell)object).getValue()) instanceof FunctionTreeNode)) continue;
            arrayList.add((FunctionTreeNode)object2);
        }
        return arrayList;
    }

    protected abstract Object updateGraphLocal(Object var1);

    protected void executeLayout() {
        this.executeLayout(this.gnode);
    }

    protected void executeLayout(Object object) {
        try {
            mxHierarchicalLayout mxHierarchicalLayout2 = new mxHierarchicalLayout(this.graph, 7);
            mxHierarchicalLayout2.setInterRankCellSpacing(40.0);
            mxHierarchicalLayout2.setIntraCellSpacing(10.0);
            mxHierarchicalLayout2.setParentBorder(50);
            mxHierarchicalLayout2.setFineTuning(true);
            mxHierarchicalLayout2.setInterHierarchySpacing(0.0);
            mxHierarchicalLayout2.execute(this.groot);
            this.createLayout("horizontalstack").execute(this.groot);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    protected void cleanUpChild() {
    }

    @Override
    protected JPopupMenu createPopupMenu(Point point, Object object) {
        JPopupMenu jPopupMenu = super.createPopupMenu(point, object);
        jPopupMenu.add(new JMenuItem("minku"));
        jPopupMenu.show((Component)this.graphComponent, point.x, point.y);
        return jPopupMenu;
    }

    public Object getVertexFromObject(Object object) {
        for (Map.Entry<Object, Object> entry : this.vertexHashMap.entrySet()) {
            if (!entry.getKey().equals(object)) continue;
            return entry.getValue();
        }
        return null;
    }

    @Override
    public Component getPanel() {
        return this;
    }

    @Override
    public void showEntry(Object object, Object object2, boolean bl) {
    }

    @Override
    public void toggled(boolean bl) {
    }
}

