/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.pp;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import se.prediktera.breeze.common.hardware.Hardware;
import se.prediktera.breeze.frontend.RoundedTitledBorder;
import se.prediktera.breeze.frontend.common.entry.EntryMainHelper;
import se.prediktera.breeze.frontend.common.entry.EntrySettingsPanel;
import se.prediktera.breeze.frontend.common.swing.BreezeScrollPane;
import se.prediktera.breeze.frontend.common.swing.BreezeSeparator;
import se.prediktera.breeze.frontend.common.swing.BreezeTheme;
import se.prediktera.breeze.frontend.common.swing.CollapsePanel;
import se.prediktera.breeze.frontend.common.swing.GridBagHelper;
import se.prediktera.breeze.hardware.camera.RemoteCamera;

public class DefaultSettingsPanel
extends JPanel
implements EntrySettingsPanel.SettingsComponent {
    private static final int WIDTH = 240;
    private final JPanel topSettingsPanel = new JPanel(new GridBagLayout());
    protected final JPanel contentPanel = new JPanel(new GridBagLayout());
    public final int settingsWidth;
    private boolean toggled;

    public DefaultSettingsPanel() {
        this(240, false);
    }

    public DefaultSettingsPanel(int n, boolean bl) {
        super(new BorderLayout());
        this.settingsWidth = n;
        this.setPreferredSize(new Dimension(n, 0));
        this.setMinimumSize(new Dimension(n, 0));
        this.topSettingsPanel.setOpaque(false);
        this.add((Component)this.topSettingsPanel, "North");
        JPanel jPanel = new JPanel(new BorderLayout());
        BreezeScrollPane breezeScrollPane = new BreezeScrollPane(jPanel);
        breezeScrollPane.setHorizontalScrollBarPolicy(31);
        this.add((Component)breezeScrollPane, "Center");
        BreezeTheme breezeTheme = BreezeTheme.getInstance();
        this.setBackground(breezeTheme.getSettingPanelBackground());
        jPanel.setBackground(this.getBackground());
        this.contentPanel.setOpaque(false);
        jPanel.add((Component)this.contentPanel, bl ? "Center" : "North");
        if (!bl) {
            JPanel jPanel2 = new JPanel();
            jPanel2.setOpaque(false);
            jPanel.add((Component)jPanel2, "Center");
        }
    }

    public SectionPanel addSection(String string) {
        SectionPanel sectionPanel = new SectionPanel(string, this.settingsWidth);
        int n = this.contentPanel.getComponentCount();
        this.contentPanel.add((Component)sectionPanel, GridBagHelper.createWithWeigthX1(n, new Insets(2, 5, 0, 5)));
        return sectionPanel;
    }

    public SectionPanel addSectionFill(String string) {
        SectionPanel sectionPanel = new SectionPanel(string, this.settingsWidth);
        int n = this.contentPanel.getComponentCount();
        this.contentPanel.add((Component)sectionPanel, GridBagHelper.createLast(n, new Insets(2, 5, 2, 5)));
        return sectionPanel;
    }

    public SectionCollapsePanel addCollapseSection(String string, boolean bl) {
        return this.addCollapseSection(string, bl, true);
    }

    public SectionCollapsePanel addCollapseSection(String string, boolean bl, boolean bl2) {
        int n;
        SectionCollapsePanel sectionCollapsePanel = new SectionCollapsePanel(string, bl, bl2);
        this.contentPanel.add((Component)sectionCollapsePanel, GridBagHelper.createWithWeigthX1(n, new Insets((n = this.contentPanel.getComponentCount()) > 0 ? 20 : 10, 10, 0, 10)));
        return sectionCollapsePanel;
    }

    public JPanel getContentPanel() {
        return this.contentPanel;
    }

    @Override
    public Component getPanel() {
        return this;
    }

    public int getSettingsWidth() {
        return this.settingsWidth;
    }

    @Override
    public void showEntry(Object object, Object object2, boolean bl) {
    }

    @Override
    public void toggled(boolean bl) {
        this.toggled = bl;
    }

    public boolean isToggled() {
        return this.toggled;
    }

    @Override
    public void setChangeListener(Runnable runnable) {
    }

    @Generated
    public JPanel getTopSettingsPanel() {
        return this.topSettingsPanel;
    }

    public static class SectionPanel
    extends JPanel {
        public final JPanel panel = new JPanel(new GridBagLayout());
        private final RoundedTitledBorder roundedTitledBorder;
        private final int settingsWidth;

        public SectionPanel(String string) {
            this(string, 1);
        }

        public SectionPanel(String string, int n) {
            this.settingsWidth = n;
            this.panel.setBackground(BreezeTheme.getInstance().getPanelBackground());
            this.roundedTitledBorder = new RoundedTitledBorder(string, 6);
            if (string != null && string.length() > 0) {
                this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(2, 0, 0, 0), this.roundedTitledBorder));
            } else {
                this.setBorder(BorderFactory.createEmptyBorder(4, 0, 0, 0));
            }
            this.setLayout(new GridBagLayout());
            this.add((Component)this.panel, GridBagHelper.createLast(1, new Insets(0, 0, 0, 0)));
            this.setOpaque(false);
        }

        public void setTitle(String string) {
            this.roundedTitledBorder.setTitle(string);
            this.repaint();
        }

        public void setTitle(Hardware hardware) {
            RemoteCamera.HardwareIcon hardwareIcon = null;
            if (hardware != null) {
                this.setTitleAbbreviated(hardware.getDisplayName());
                hardwareIcon = RemoteCamera.HardwareIcon.create(hardware);
            } else {
                this.setTitle("");
            }
            this.roundedTitledBorder.setIcon(hardwareIcon);
        }

        public void setTitleAbbreviated(String string) {
            this.roundedTitledBorder.setTitle(StringUtils.abbreviate((String)string, (int)Math.max(this.settingsWidth - 20, this.getWidth())));
        }

        public void addComponent(JComponent jComponent) {
            int n;
            EntryMainHelper.addComponent(this.panel, jComponent, false, n, (n = this.panel.getComponentCount()) > 0 ? 10 : 0);
        }

        public void addSeparator() {
            this.addComponent(new BreezeSeparator.Vertical());
        }

        public void addComponentLast(JComponent jComponent) {
            int n;
            EntryMainHelper.addComponent(this.panel, jComponent, false, n, (n = this.panel.getComponentCount()) > 0 ? 10 : 0, 1, 1);
        }

        public void addComponentRight(JComponent jComponent) {
            int n = this.panel.getComponentCount();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = n;
            gridBagConstraints.anchor = 13;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            this.panel.add((Component)jComponent, gridBagConstraints);
        }

        public void addComponentHorizontal(JComponent jComponent) {
            this.addComponentHorizontal(jComponent, 10);
        }

        public void addComponentHorizontal(JComponent jComponent, int n) {
            int n2;
            this.panel.add((Component)jComponent, GridBagHelper.createWithWeigthX1(n2, new Insets((n2 = this.panel.getComponentCount()) > 0 ? n : 0, 0, 0, 0)));
        }

        public void addComponentHorizontalNoFill(JComponent jComponent) {
            GridBagConstraints gridBagConstraints = GridBagHelper.createWithWeigthX1(this.panel.getComponentCount(), new Insets(10, 0, 0, 0));
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 17;
            this.panel.add((Component)jComponent, gridBagConstraints);
        }

        public void addComponentVertical(JComponent jComponent) {
            this.addComponentVertical(jComponent, 10);
        }

        public void addComponentVertical(JComponent jComponent, int n) {
            int n2;
            EntryMainHelper.addComponentVertical(this.panel, jComponent, false, n2, (n2 = this.panel.getComponentCount()) > 0 ? n : 0, 1, 0);
        }

        public void clear() {
            this.panel.removeAll();
        }

        public void update() {
            this.panel.revalidate();
            this.panel.repaint();
        }

        public boolean hideIfEmpty() {
            boolean bl = this.hasVisibleComponents();
            this.setVisible(bl);
            return bl;
        }

        public boolean hasVisibleComponents() {
            return CollapsePanel.hasVisibleComponents(this.panel);
        }

        @Override
        public void setEnabled(boolean bl) {
            for (int i = 0; i < this.panel.getComponentCount(); ++i) {
                this.panel.getComponent(i).setEnabled(bl);
                Component component = this.panel.getComponent(i);
                if (!(component instanceof JPanel)) continue;
                JPanel jPanel = (JPanel)component;
                for (int j = 0; j < jPanel.getComponentCount(); ++j) {
                    jPanel.getComponent(j).setEnabled(bl);
                }
            }
        }

        @Generated
        public JPanel getPanel() {
            return this.panel;
        }

        @Generated
        public RoundedTitledBorder getRoundedTitledBorder() {
            return this.roundedTitledBorder;
        }
    }

    public static class SectionCollapsePanel
    extends CollapsePanel {
        public SectionCollapsePanel(String string, boolean bl, boolean bl2) {
            super(string, bl2);
            this.setCollapsed(bl);
        }

        public void addComponent(JComponent jComponent) {
            int n = this.getPanel().getComponentCount();
            EntryMainHelper.addComponent(this.getPanel(), jComponent, false, n, n > 0 ? 10 : 0);
        }

        public void addComponentLast(JComponent jComponent) {
            int n = this.getPanel().getComponentCount();
            EntryMainHelper.addComponent(this.getPanel(), jComponent, false, n, n > 0 ? 10 : 0, 1, 1);
        }

        public void addComponentHorizontal(JComponent jComponent) {
            this.addComponentHorizontal(jComponent, 10);
        }

        public void addComponentHorizontal(JComponent jComponent, int n) {
            this.getPanel().add((Component)jComponent, GridBagHelper.createWithWeigthX1(this.getPanel().getComponentCount(), new Insets(n, 0, 0, 0)));
        }

        public void addComponentHorizontalNoFill(JComponent jComponent) {
            GridBagConstraints gridBagConstraints = GridBagHelper.createWithWeigthX1(this.getPanel().getComponentCount(), new Insets(10, 0, 0, 0));
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 17;
            this.getPanel().add((Component)jComponent, gridBagConstraints);
        }

        public void addComponentHorizontalLeft(JComponent jComponent) {
            this.getPanel().add((Component)jComponent, GridBagHelper.createLeft(this.getPanel().getComponentCount(), new Insets(10, 0, 0, 0)));
        }

        public void addComponentVertical(JComponent jComponent) {
            int n = this.getPanel().getComponentCount();
            EntryMainHelper.addComponentVertical(this.getPanel(), jComponent, false, n, n > 0 ? 10 : 0);
        }

        public void clear() {
            this.getPanel().removeAll();
        }

        public void update() {
            this.getPanel().revalidate();
            this.getPanel().repaint();
        }
    }
}

