/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.pp;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileFilter;
import javax.swing.plaf.FileChooserUI;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.text.EditorKit;
import javax.swing.text.JTextComponent;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import se.prediktera.breeze.common.util.thread.ThreadUtil;
import se.prediktera.breeze.frontend.BreezeMainPanel;
import se.prediktera.breeze.frontend.common.swing.BreezeLabel;
import se.prediktera.breeze.frontend.common.swing.BreezeTabbedPanel;
import se.prediktera.breeze.frontend.common.swing.BreezeTheme;
import se.prediktera.breeze.frontend.common.swing.dialog.AbstractBreezeDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeOptionDialog;
import se.prediktera.breeze.frontend.common.view.AbstractViewPanel;
import se.prediktera.breeze.frontend.wizard.measure.step.WizardStep;
import se.prediktera.map.common.error.Logg;
import se.prediktera.map.common.opensave.PreviewInterface;
import se.prediktera.map.common.swing.filechooser.ExtensionFilter;
import se.prediktera.map.common.swing.filechooser.jopensaveDialog;
import se.prediktera.map.common.wizard.FilePreview;
import se.prediktera.map.dataimport.AbstractImportInfo;
import se.prediktera.map.dataimport.ImportHelper;
import se.prediktera.map.dataimport.mat.HdfImportInfo;
import se.prediktera.map.dataimport.mat.MatImportInfo;
import se.prediktera.map.dataimport.raw.RawImportInfo;

public class FileChooserPanel
extends AbstractViewPanel {
    private File defaultFile;
    private final boolean checkFileExists;
    private final jopensaveDialog fileChooser = new jopensaveDialog(){

        public void cancelSelection() {
            Container container;
            if (FileChooserPanel.this.mainpanel != null && (container = FileChooserPanel.this.mainpanel.getParent()) instanceof AbstractBreezeDialog) {
                AbstractBreezeDialog abstractBreezeDialog = (AbstractBreezeDialog)((Object)container);
                abstractBreezeDialog.close(false, "");
            }
        }
    };

    public FileChooserPanel() {
        this(null, "Text", false);
    }

    public FileChooserPanel(BreezeMainPanel breezeMainPanel, String string, boolean bl) {
        super(breezeMainPanel);
        GridBagConstraints gridBagConstraints;
        BreezeLabel breezeLabel;
        this.checkFileExists = bl;
        BreezeTheme breezeTheme = BreezeTheme.getInstance();
        this.setBackground(breezeTheme.getPanelBackground());
        this.setLayout(new GridBagLayout());
        if (string != null) {
            breezeLabel = new BreezeLabel(string);
            breezeLabel.setFont(new Font("Tahoma", 0, 18));
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(20, 20, 0, 0);
            this.add(breezeLabel, gridBagConstraints);
        }
        this.fileChooser.setDialogType(2);
        this.fileChooser.setApproveButtonText("Select");
        this.fileChooser.setFileSelectionMode(2);
        this.fileChooser.addActionListener(this::fileChooserActionPerformed);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(20, 0, 0, 0);
        this.add((Component)this.fileChooser, gridBagConstraints);
        breezeLabel = new FilePreview();
        this.fileChooser.setPreview((PreviewInterface)breezeLabel, true);
        this.fileChooser.checkComponentSize((Container)this.fileChooser);
        this.formatChooserRecursive((JComponent)this.fileChooser);
    }

    public void setCurrentDirectory(File file) {
        try {
            SwingUtilities.invokeAndWait(() -> {
                if (!this.trySetCurrentDirectory(file)) {
                    Logg.trace((String)"Cannot set directory, waiting 200 ms and trying again", (Object[])new Object[0]);
                    ThreadUtil.sleep(200L);
                    this.trySetCurrentDirectory(file);
                }
            });
        }
        catch (InterruptedException | InvocationTargetException exception) {
            exception.printStackTrace();
        }
    }

    public boolean trySetCurrentDirectory(File file) {
        try {
            this.fileChooser.setCurrentDirectory(file);
            return true;
        }
        catch (Exception exception) {
            Logg.error((String)"Cannot set current directory: {}", (Object[])new Object[]{file, exception});
            return false;
        }
    }

    public void addAllSupported() {
        this.fileChooser.addAllSupported();
        this.fileChooser.addFiltersIntoDialog();
    }

    public void addFiltersIntoDialog() {
        this.fileChooser.addFiltersIntoDialog();
    }

    public void setMultiSelectionEnabled(boolean bl) {
        this.fileChooser.setMultiSelectionEnabled(bl);
    }

    private void formatChooserRecursive(JComponent jComponent) {
        for (int i = 0; i < jComponent.getComponentCount(); ++i) {
            this.formatComponent(jComponent.getComponent(i));
        }
    }

    private void formatComponent(Component component) {
        BreezeTheme breezeTheme = BreezeTheme.getInstance();
        if (component instanceof JButton) {
            JButton jButton = (JButton)component;
            String string = jButton.getText();
            if (string != null && (string.equals("Select") || string.equals("Cancel"))) {
                jButton.setVisible(false);
            }
        } else if (!(component instanceof JToggleButton)) {
            if (component instanceof JComboBox) {
                JComboBox jComboBox = (JComboBox)component;
                jComboBox.getEditor().getEditorComponent().setForeground(breezeTheme.getLabelForeground());
                jComboBox.getEditor().getEditorComponent().setBackground(breezeTheme.getSettingPanelBackground());
                jComboBox.setPreferredSize(new Dimension(0, 30));
                jComboBox.setFont(new Font("Tahoma", 0, 14));
            } else if (component instanceof JComponent) {
                Serializable serializable;
                Component component2;
                Border border;
                component.setBackground(breezeTheme.getPanelBackground());
                component.setForeground(breezeTheme.getLabelForeground());
                if (component instanceof JTextField) {
                    ((JTextField)component).setCaretColor(breezeTheme.getLabelForeground());
                }
                if ((border = ((JComponent)component).getBorder()) instanceof TitledBorder) {
                    ((TitledBorder)border).setTitleColor(breezeTheme.getLabelForeground());
                }
                if (component instanceof JEditorPane) {
                    component2 = (JEditorPane)component;
                    serializable = new HTMLEditorKit();
                    ((JEditorPane)component2).setEditorKit((EditorKit)serializable);
                    StyleSheet styleSheet = ((HTMLEditorKit)serializable).getStyleSheet();
                    String string = breezeTheme.isDarkMode() ? "white" : "black";
                    styleSheet.addRule("body {color:" + string + "; font-family: Arial; margin: 4px; }");
                    ((JTextComponent)component2).setDocument(((HTMLEditorKit)serializable).createDefaultDocument());
                }
                if (component instanceof JTabbedPane) {
                    component2 = (JTabbedPane)component;
                    for (int i = 0; i < ((JTabbedPane)component2).getTabCount(); ++i) {
                        ((JTabbedPane)component2).setBackgroundAt(i, component.getBackground());
                    }
                    ((JComponent)component2).setBorder(BorderFactory.createEmptyBorder());
                    ((JTabbedPane)component2).setUI(new BreezeTabbedPanel.BreezeTabbedPaneUI());
                }
                if (component instanceof JSplitPane && (component2 = ((JSplitPane)component).getComponent(0)) instanceof BasicSplitPaneDivider) {
                    serializable = (BasicSplitPaneDivider)component2;
                    ((Component)serializable).setBackground(breezeTheme.getSettingPanelBackground());
                    ((BasicSplitPaneDivider)serializable).setBorder(BorderFactory.createEmptyBorder());
                }
                this.formatChooserRecursive((JComponent)component);
                component.setFont(new Font("Tahoma", 0, 14));
            }
        }
    }

    @Override
    public WizardStep.LeaveResult checkValidContent(WizardStep.WizardControlCallback wizardControlCallback) {
        if (this.fileChooser.getFileSelectionMode() == 1) {
            if (this.getCurrentDirectory() != null) {
                return WizardStep.LeaveResult.Ok;
            }
        } else {
            File file = this.getSelectedFile();
            if (file != null) {
                if (this.checkFileExists && file.exists()) {
                    BreezeOptionDialog.showDialog(this.mainpanel, AbstractBreezeDialog.MessageType.CONFIRM_OPTION, "File exists", "A file named \"" + file.getName() + "\" already exists in the export folder. It will be overwritten when the export wizard completes.\n\nDo you want to continue?", breezeActionEvent -> wizardControlCallback.leaveWithControl());
                    return WizardStep.LeaveResult.Control;
                }
                return WizardStep.LeaveResult.Ok;
            }
        }
        BreezeOptionDialog.showDialog(this.mainpanel, AbstractBreezeDialog.MessageType.INFORMATION_OPTION, "No file(s) selected", "At least one file must be selected");
        return WizardStep.LeaveResult.Failed;
    }

    public void setSelectedFile(File file) {
        this.defaultFile = file;
        this.fileChooser.setSelectedFile(file);
    }

    public void setSelectedFiles(File[] fileArray) {
        this.fileChooser.setSelectedFiles(fileArray);
    }

    public File approveSelectionAndGetSelectedFile() {
        FileChooserUI fileChooserUI = this.fileChooser.getUI();
        JButton jButton = fileChooserUI.getDefaultButton((JFileChooser)this.fileChooser);
        if (jButton != null) {
            jButton.doClick(0);
        } else {
            this.fileChooser.approveSelection();
        }
        return this.fileChooser.getLegalFileWithExtension(this.getSelectedFile());
    }

    public File approveSelectionAndGetSelectedFolder() {
        JButton jButton = this.fileChooser.getUI().getDefaultButton((JFileChooser)this.fileChooser);
        if (jButton != null) {
            jButton.doClick(0);
        }
        int n = this.fileChooser.getFileSelectionMode();
        File file = this.getSelectedFile();
        if (n == 1) {
            if (file != null && file.isDirectory()) {
                return this.normalizeChooserToDirectory(file);
            }
            if (file != null && !file.exists() && file.mkdirs()) {
                return this.normalizeChooserToDirectory(file);
            }
            return this.normalizeChooserToDirectory(this.fileChooser.getCurrentDirectory());
        }
        if (n == 0) {
            if (file != null && file.isFile()) {
                return file.getParentFile();
            }
            if (file != null && !file.exists()) {
                if (file.getParentFile() != null && file.getParentFile().mkdirs()) {
                    return file.getParentFile();
                }
                return file.getParentFile() != null ? file.getParentFile() : this.fileChooser.getCurrentDirectory();
            }
            return this.fileChooser.getCurrentDirectory();
        }
        if (file != null && file.isDirectory()) {
            return this.normalizeChooserToDirectory(file);
        }
        if (file != null && !file.exists() && file.mkdirs()) {
            return this.normalizeChooserToDirectory(file);
        }
        return this.normalizeChooserToDirectory(this.fileChooser.getCurrentDirectory());
    }

    private File normalizeChooserToDirectory(File file) {
        this.fileChooser.setCurrentDirectory(file);
        this.fileChooser.setSelectedFile(null);
        this.fileChooser.rescanCurrentDirectory();
        return file;
    }

    public File getSelectedFile() {
        File file;
        List<File> list = this.getSelectedFiles();
        if (list != null && list.size() > 0) {
            return list.get(0);
        }
        if (list == null && this.defaultFile != null && (file = this.getCurrentDirectory()) != null) {
            return new File(file, this.defaultFile.getName());
        }
        return null;
    }

    public List<File> getSelectedFiles() {
        Object object;
        if (this.fileChooser.isMultiSelectionEnabled() && (object = this.fileChooser.getSelectedFiles()) != null && ((File[])object).length > 0) {
            return new ArrayList<File>(Arrays.asList(object));
        }
        object = this.fileChooser.getSelectedFile();
        if (object != null) {
            return List.of(object);
        }
        return null;
    }

    public File getCurrentDirectory() {
        return this.fileChooser.getCurrentDirectory();
    }

    @Override
    public String getType() {
        return "FileChooserPanel";
    }

    @Override
    public void showEntry(Object object, Object object2) {
    }

    public void addDataFileFilters(FilterType filterType) {
        FileChooserPanel.addDataFileFilters(this.fileChooser, filterType);
    }

    public static void addDataFileFilters(jopensaveDialog jopensaveDialog2, FilterType filterType) {
        Vector vector = ImportHelper.getExternImportInfo();
        for (AbstractImportInfo abstractImportInfo : vector) {
            boolean bl = abstractImportInfo.isMultiLayerPublic();
            if (filterType.equals((Object)FilterType.IMAGE) ? !bl && !(abstractImportInfo instanceof MatImportInfo) && !(abstractImportInfo instanceof HdfImportInfo) : (filterType.equals((Object)FilterType.DATA2D) ? bl : filterType.equals((Object)FilterType.HS) && (!bl || !abstractImportInfo.requireHeaderFile()))) continue;
            jopensaveDialog2.addExtension(abstractImportInfo.getExt(), abstractImportInfo.getDescription(), (byte)0, (Object)abstractImportInfo);
        }
    }

    public FileFilter addExtension(String[] stringArray, String string) {
        return this.fileChooser.addExtension(stringArray, string, (byte)0, null);
    }

    public void setFileSelectionMode(int n) {
        this.fileChooser.setFileSelectionMode(n);
    }

    private void fileChooserActionPerformed(ActionEvent actionEvent) {
    }

    public AbstractImportInfo getMatchingFilter() {
        ExtensionFilter extensionFilter = this.fileChooser.getMatchingFilter();
        if (extensionFilter == null) {
            return new RawImportInfo();
        }
        return (AbstractImportInfo)extensionFilter.object;
    }

    public static enum FilterType {
        IMAGE,
        DATA2D,
        HS;

    }
}

