/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.pp;

import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Arrays;
import javax.swing.JTextArea;
import org.apache.commons.io.FilenameUtils;
import se.prediktera.breeze.common.entry.analyse.BasicAnalyse;
import se.prediktera.breeze.frontend.common.pp.FileChooserPanel;
import se.prediktera.breeze.frontend.common.pp.wizard.PPImportModel;
import se.prediktera.breeze.frontend.common.swing.BreezeComboBoxInputField;
import se.prediktera.breeze.frontend.common.swing.BreezeTheme;
import se.prediktera.breeze.frontend.common.view.AbstractViewPanel;
import se.prediktera.breeze.frontend.common.view.ViewClass;
import se.prediktera.breeze.frontend.wizard.measure.step.WizardStep;

public class ImportSettingsPanel
extends AbstractViewPanel
implements WizardStep {
    private final FileChooserPanel fileSelectionPanel;
    private final PPImportModel.OnnxImportData onnxImportData;

    public ImportSettingsPanel(FileChooserPanel fileChooserPanel, PPImportModel.OnnxImportData onnxImportData) {
        this.fileSelectionPanel = fileChooserPanel;
        this.onnxImportData = onnxImportData;
        this.setLayout(new GridBagLayout());
        JTextArea jTextArea = new JTextArea();
        jTextArea.setEditable(false);
        jTextArea.setColumns(20);
        jTextArea.setFont(new Font("Tahoma", 0, 16));
        jTextArea.setLineWrap(false);
        jTextArea.setRows(1);
        jTextArea.setText("Settings for import model. Press Finish to complete import.");
        jTextArea.setWrapStyleWord(true);
        jTextArea.setCaretColor(BreezeTheme.getInstance().getPanelBackground());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.add(jTextArea, gridBagConstraints);
    }

    private void updateAvailableSettings() {
        if (this.isOnnxImport()) {
            this.onnxImportData.setModelMethod(BasicAnalyse.ModelMethod.ClassificationRuntime);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridy = 1;
            gridBagConstraints.fill = 1;
            gridBagConstraints.insets = new Insets(10, 10, 0, 0);
            this.add(new BreezeComboBoxInputField<String>("ONNX Model type", Arrays.asList("Classification", "Quantification"), "Classification", string -> {
                if (string.equalsIgnoreCase("Classification")) {
                    this.onnxImportData.setModelMethod(BasicAnalyse.ModelMethod.ClassificationRuntime);
                } else {
                    this.onnxImportData.setModelMethod(BasicAnalyse.ModelMethod.QuantificationRuntime);
                }
            }), gridBagConstraints);
        } else {
            this.onnxImportData.setModelMethod(null);
        }
    }

    private boolean isOnnxImport() {
        return this.fileSelectionPanel.getSelectedFile() != null && FilenameUtils.isExtension((String)this.fileSelectionPanel.getSelectedFile().getName(), (String)"onnx");
    }

    @Override
    public void enterStep() {
    }

    @Override
    public WizardStep.LeaveResult leaveStep(WizardStep.WizardControlCallback wizardControlCallback, boolean bl) {
        return WizardStep.LeaveResult.Ok;
    }

    @Override
    public ViewClass getViewClass() {
        return null;
    }

    @Override
    public String getType() {
        return "Settings";
    }

    @Override
    public void showEntry(Object object, Object object2) {
        this.updateAvailableSettings();
    }
}

