/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.pp;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import se.prediktera.breeze.frontend.common.swing.BreezeLabel;
import se.prediktera.breeze.frontend.common.swing.BreezeScrollPane;
import se.prediktera.breeze.frontend.common.swing.BreezeSeparator;
import se.prediktera.breeze.frontend.common.swing.BreezeTheme;
import se.prediktera.breeze.frontend.common.view.AbstractViewPanel;

public class PPDescriptionPanel
extends AbstractViewPanel {
    protected final BreezeScrollPane scrollPane;
    private final JTextArea textArea = new JTextArea();
    private final JPanel optionsPanel = new JPanel(new GridBagLayout());

    public PPDescriptionPanel() {
        this("");
    }

    public PPDescriptionPanel(String string) {
        this(string, true, null);
    }

    public PPDescriptionPanel(String string, boolean bl) {
        this(string, bl, null);
    }

    public PPDescriptionPanel(String string, boolean bl, Insets insets) {
        GridBagConstraints gridBagConstraints;
        Color color = BreezeTheme.getInstance().getPanelBackground();
        this.setLayout(new GridBagLayout());
        this.setOpaque(true);
        if (!string.isEmpty()) {
            this.textArea.setEditable(false);
            this.textArea.setColumns(20);
            this.textArea.setFont(new Font("Tahoma", 0, 16));
            this.textArea.setLineWrap(true);
            this.textArea.setRows(1);
            this.setDescription(string);
            this.textArea.setWrapStyleWord(true);
            this.textArea.setCaretColor(color);
            this.textArea.setBackground(BreezeTheme.getInstance().getDialogBackground());
            this.textArea.setForeground(BreezeTheme.getInstance().getLabelForeground());
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridy = 0;
            gridBagConstraints.fill = 1;
            gridBagConstraints.insets = insets == null ? new Insets(10, 10, 10, 0) : insets;
            this.add(this.textArea, gridBagConstraints);
        }
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 20, 0, 0);
        this.optionsPanel.setBackground(color);
        this.scrollPane = new BreezeScrollPane(this.optionsPanel);
        this.add(this.scrollPane, gridBagConstraints);
        if (bl) {
            JPanel jPanel = new JPanel(new BorderLayout());
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 100;
            gridBagConstraints.weighty = 1.0;
            this.optionsPanel.add((Component)jPanel, gridBagConstraints);
        }
    }

    public void setDescription(String string) {
        this.textArea.setText(string);
    }

    public String getDescription() {
        return this.textArea.getText();
    }

    public void addOption(JComponent jComponent) {
        this.addOptionLocal(jComponent, this.optionsPanel.getComponentCount(), 2, null);
    }

    public void addOptionIndent(JComponent jComponent) {
        int n;
        this.addOptionLocal(jComponent, n, 2, new Insets((n = this.optionsPanel.getComponentCount()) > 1 ? 10 : 0, 10, 0, 0));
    }

    public void addOptionIndentNoFill(JComponent jComponent) {
        int n;
        this.addOptionLocal(jComponent, n, 0, new Insets((n = this.optionsPanel.getComponentCount()) > 1 ? 10 : 0, 10, 0, 0));
    }

    public void addHorizontalSiblings(ArrayList<JComponent> arrayList) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout());
        jPanel.setOpaque(false);
        for (JComponent jComponent : arrayList) {
            jComponent.setAlignmentX(0.0f);
            jPanel.add(jComponent);
        }
        this.addOptionLocal(jPanel, this.optionsPanel.getComponentCount(), 0, new Insets(0, 0, 0, 0));
    }

    public void addOption(JComponent jComponent, Insets insets) {
        this.addOptionLocal(jComponent, this.optionsPanel.getComponentCount(), 2, insets);
    }

    public void addOptionNoFill(JComponent jComponent) {
        this.addOptionLocal(jComponent, this.optionsPanel.getComponentCount(), 0, null);
    }

    public void addBottomOption(JComponent jComponent) {
        this.addOptionLocal(jComponent, this.optionsPanel.getComponentCount() + 100, 2, null);
    }

    public void addOptionFillBoth(JComponent jComponent) {
        this.addOptionLocal(jComponent, this.optionsPanel.getComponentCount(), 1, null);
    }

    private void addOptionLocal(JComponent jComponent, int n, int n2, Insets insets) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.fill = n2;
        gridBagConstraints.weightx = 1.0;
        if (n2 == 1) {
            gridBagConstraints.weighty = 1.0;
        }
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = insets != null ? insets : new Insets(n > 1 ? 10 : 0, 0, 0, 0);
        this.optionsPanel.add((Component)jComponent, gridBagConstraints);
    }

    public void addSeparator(String string) {
        this.addOption(new BreezeLabel(string));
    }

    public void addSeparator() {
        this.addOption(new BreezeSeparator());
    }

    @Override
    public String getType() {
        return "PPDescriptionPanel";
    }

    @Override
    public void showEntry(Object object, Object object2) {
    }
}

