/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.pp;

import java.util.List;
import javax.swing.ImageIcon;
import se.prediktera.breeze.entry.EntryData;
import se.prediktera.breeze.entry.analyse.Analyse;
import se.prediktera.breeze.entry.util.WizardInfo;
import se.prediktera.breeze.frontend.common.view.ViewClass;

public class PPViewClass
extends ViewClass {
    private WizardInfo ppInfo;
    private Analyse analyse;

    public PPViewClass(WizardInfo wizardInfo) {
        this(wizardInfo, null, null);
    }

    public PPViewClass(WizardInfo wizardInfo, Analyse analyse, List<Analyse> list) {
        this.ppInfo = wizardInfo;
        this.analyse = analyse;
        this.setSubtitle(wizardInfo.getDescription());
        this.setValue(wizardInfo.getPPClass());
        if (analyse == null) {
            this.setName(wizardInfo.getName());
            this.setSubtitle2("");
        } else {
            this.setName(analyse.getName() + " (" + wizardInfo.getName() + ")");
            this.setIcon(new ImageIcon(this.getClass().getResource("/images/ModelTree.png")));
            EntryData entryData = analyse.getEntryData();
            this.setSubtitle2(analyse.getUid() + ", " + entryData.getCreatedBy() + ", " + entryData.getViewCreatedDate());
        }
    }

    public PPViewClass(String string) {
        this.setName(string);
    }

    public Analyse getAnalyse() {
        return this.analyse;
    }

    public WizardInfo getPpInfo() {
        return this.ppInfo;
    }

    @Override
    public String getTitle() {
        if (this.ppInfo != null) {
            return this.ppInfo.getName();
        }
        return super.getTitle();
    }

    public String getShortName() {
        if (this.ppInfo != null) {
            return this.ppInfo.getShortName();
        }
        return this.getTitle();
    }
}

