/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.pp;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import se.prediktera.breeze.common.util.StringHelper;
import se.prediktera.breeze.entry.workflow.Workflow;
import se.prediktera.breeze.frontend.BreezeMainPanel;
import se.prediktera.breeze.frontend.common.entry.EntryMainPanel;
import se.prediktera.breeze.frontend.common.entry.EntryMainPanelInterface;
import se.prediktera.breeze.frontend.common.entry.OpenEntryProgressAction;
import se.prediktera.breeze.frontend.common.pp.PPViewClass;
import se.prediktera.breeze.frontend.common.pp.wizard.PPImportMeasurement;
import se.prediktera.breeze.frontend.common.pp.wizard.PPImportSpectra;
import se.prediktera.breeze.frontend.common.pp.wizard.PPInfo;
import se.prediktera.breeze.frontend.common.pp.wizard.importdata.PPImportData;
import se.prediktera.breeze.frontend.common.swing.BreezeButton;
import se.prediktera.breeze.frontend.common.swing.BreezeLabel;
import se.prediktera.breeze.frontend.common.swing.BreezeScrollPane;
import se.prediktera.breeze.frontend.common.swing.BreezeTheme;
import se.prediktera.breeze.frontend.common.swing.GridBagHelper;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressDialog;
import se.prediktera.breeze.frontend.common.util.ImageHelper;
import se.prediktera.breeze.frontend.common.view.AbstractViewPanel;
import se.prediktera.breeze.frontend.main.play.WorkflowMainPanel;

public abstract class PostProcessingPanel
extends AbstractViewPanel {
    private Object rootEntry;
    private final JPanel postProcessingListImport = new JPanel(new GridBagLayout());
    private final JPanel postProcessingListExport = new JPanel(new GridBagLayout());

    public PostProcessingPanel(EntryMainPanel entryMainPanel) {
        super(entryMainPanel);
        this.setBackground(new Color(255, 255, 255));
        this.setLayout(new GridBagLayout());
        BreezeTheme breezeTheme = BreezeTheme.getInstance();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 20, 0, 0);
        BreezeLabel breezeLabel = new BreezeLabel("Import", ImageHelper.getResourceIcon("material/download_2"));
        breezeLabel.setFontSize(BreezeLabel.FontSize.H1);
        this.add(breezeLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        BreezeLabel breezeLabel2 = new BreezeLabel("Export", ImageHelper.getResourceIcon("material/upload_2"));
        breezeLabel2.setFontSize(BreezeLabel.FontSize.H1);
        this.add(breezeLabel2, gridBagConstraints);
        this.postProcessingListImport.setName("ppListImport");
        this.postProcessingListImport.setBackground(breezeTheme.getPanelBackground());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.add(new BreezeScrollPane.VerticalOnly(this.postProcessingListImport), gridBagConstraints);
        this.postProcessingListExport.setName("ppListExport");
        this.postProcessingListExport.setBackground(breezeTheme.getPanelBackground());
        gridBagConstraints.gridx = 1;
        this.add(new BreezeScrollPane.VerticalOnly(this.postProcessingListExport), gridBagConstraints);
        this.setBackground(breezeTheme.getPanelBackground());
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                PostProcessingPanel.this.showEntry(PostProcessingPanel.this.rootEntry, null);
            }
        });
    }

    @Override
    public String getType() {
        return "PostProcessing";
    }

    @Override
    public void showEntry(Object object, Object object2) {
        this.rootEntry = object;
        ArrayList<PPViewClass> arrayList = new ArrayList<PPViewClass>();
        ArrayList<PPViewClass> arrayList2 = new ArrayList<PPViewClass>();
        this.addPPToList(arrayList, arrayList2, object);
        this.addButtons(this.postProcessingListImport, arrayList, "Import");
        this.addButtons(this.postProcessingListExport, arrayList2, "Export");
    }

    private void addButtons(JPanel jPanel, List<PPViewClass> list, String string) {
        Container container;
        jPanel.removeAll();
        for (PPViewClass object2 : list) {
            jPanel.add((Component)new PostProcessingButton(this.mainpanel, this.rootEntry, object2, string), GridBagHelper.create(jPanel.getComponentCount(), new Insets(0, 20, 10, 20)));
        }
        jPanel.add((Component)new JLabel(""), GridBagHelper.createLast(jPanel.getComponentCount(), new Insets(0, 0, 0, 0)));
        jPanel.revalidate();
        jPanel.repaint();
        if (jPanel.getParent() != null && (container = jPanel.getParent().getParent()) instanceof JScrollPane) {
            JScrollPane jScrollPane = (JScrollPane)container;
            SwingUtilities.invokeLater(() -> jScrollPane.getVerticalScrollBar().setValue(0));
        }
    }

    @Override
    public boolean showNextButton() {
        return false;
    }

    protected abstract void addPPToList(List<PPViewClass> var1, List<PPViewClass> var2, Object var3);

    public static class PostProcessingButton
    extends JPanel {
        private final Color baseBorderColor = BreezeTheme.getInstance().getLabelForegroundMoreDifuse();
        private final Color bgColor = BreezeTheme.getInstance().getDialogBackground();
        private final BreezeButton.RoundedBorder border = new BreezeButton.RoundedBorder(this, this.baseBorderColor, 1);
        private final BreezeMainPanel mainpanel;
        private final Object rootEntry;
        private final PPViewClass viewClass;
        private final String type;

        public PostProcessingButton(BreezeMainPanel breezeMainPanel, Object object, PPViewClass pPViewClass, String string) {
            super(new GridBagLayout());
            this.mainpanel = breezeMainPanel;
            this.rootEntry = object;
            this.viewClass = pPViewClass;
            this.type = string;
            this.setName("pp" + pPViewClass.getName());
            this.setBackground(this.bgColor);
            this.setCursor(Cursor.getPredefinedCursor(12));
            GridBagConstraints gridBagConstraints = GridBagHelper.create(0, new Insets(10, 5, 0, 0));
            gridBagConstraints.gridheight = 2;
            gridBagConstraints.anchor = 11;
            String string2 = StringHelper.removeAllNonXmlTagCharacters(pPViewClass.getName().toLowerCase());
            JLabel jLabel = new JLabel(ImageHelper.getResourceIcon("pp_icons/" + string2));
            jLabel.setPreferredSize(new Dimension(48, 48));
            this.add((Component)jLabel, gridBagConstraints);
            GridBagConstraints gridBagConstraints2 = GridBagHelper.create(0, new Insets(10, 5, 0, 0));
            gridBagConstraints2.gridx = 1;
            this.add((Component)new BreezeLabel(pPViewClass.getName(), true, 14), gridBagConstraints2);
            GridBagConstraints gridBagConstraints3 = GridBagHelper.create(1, new Insets(6, 5, 10, 10));
            gridBagConstraints3.gridx = 1;
            gridBagConstraints3.weightx = 1.0;
            gridBagConstraints3.weighty = 1.0;
            JTextArea jTextArea = new JTextArea(pPViewClass.getSubtitle());
            jTextArea.setFont(new Font("Tahoma", 0, 12));
            jTextArea.setForeground(BreezeTheme.getInstance().getLabelForeground());
            jTextArea.setWrapStyleWord(true);
            jTextArea.setRows(2);
            jTextArea.setLineWrap(true);
            jTextArea.setOpaque(false);
            jTextArea.setCursor(Cursor.getPredefinedCursor(12));
            this.add((Component)jTextArea, gridBagConstraints3);
            this.setBorder(BorderFactory.createCompoundBorder(this.border, BorderFactory.createEmptyBorder(0, 0, 0, 0)));
            MouseAdapter mouseAdapter = new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    this.open();
                }

                @Override
                public void mouseEntered(MouseEvent mouseEvent) {
                    this.setBackground(BreezeTheme.getInstance().isDarkMode() ? bgColor.brighter() : bgColor.darker());
                    border.setColor(BreezeTheme.getInstance().isDarkMode() ? baseBorderColor.brighter() : baseBorderColor.darker());
                }

                @Override
                public void mouseExited(MouseEvent mouseEvent) {
                    this.setBackground(bgColor);
                    border.setColor(baseBorderColor);
                }
            };
            jTextArea.addMouseListener(mouseAdapter);
            this.addMouseListener(mouseAdapter);
        }

        public void open() {
            Object object;
            PPInfo pPInfo = (PPInfo)this.viewClass.getPpInfo();
            if ((pPInfo instanceof PPImportData.Info || pPInfo instanceof PPImportSpectra.Info || pPInfo instanceof PPImportMeasurement.Info) && (object = this.rootEntry) instanceof Workflow) {
                Workflow workflow = (Workflow)object;
                WorkflowMainPanel.getEmptyGroupOrCreateNew(this.mainpanel, workflow, pPInfo.getShortName(), group -> PostProcessingButton.openWizard(this.mainpanel, this.type + " - " + this.viewClass.getShortName(), pPInfo, group));
            } else {
                PostProcessingButton.openWizard(this.mainpanel, this.type + " - " + this.viewClass.getShortName(), pPInfo, this.rootEntry);
            }
        }

        public static void openWizard(final EntryMainPanelInterface entryMainPanelInterface, final String string, final PPInfo pPInfo, final Object object) {
            BreezeProgressDialog.startProgress(entryMainPanelInterface.getFrame(), new OpenEntryProgressAction.OpenEntryDialogProgressAction(entryMainPanelInterface.getFrame()){

                @Override
                protected BreezeMainPanel createOpenPanel() {
                    return pPInfo.createWizard((EntryMainPanel)entryMainPanelInterface, string, object);
                }
            }, "Opening...");
        }
    }

    public static enum BreezeLevel {
        Workflow(true),
        Group(true),
        Measurement(false);

        private final boolean multiple;

        private BreezeLevel(boolean bl) {
            this.multiple = bl;
        }

        public boolean isMultiple() {
            return this.multiple;
        }
    }
}

