/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.pp.wizard;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import se.prediktera.breeze.common.entry.factor.Factor;
import se.prediktera.breeze.common.entry.factor.FactorHolder;
import se.prediktera.breeze.common.entry.factor.category.CategoryFactor;
import se.prediktera.breeze.common.entry.factor.category.CategoryList;
import se.prediktera.breeze.common.entry.factor.property.PropertyFactor;
import se.prediktera.breeze.common.entry.factor.property.PropertyList;
import se.prediktera.breeze.common.entry.sample.BasicSample;
import se.prediktera.breeze.common.util.FileHelper;
import se.prediktera.breeze.common.util.StringHelper;
import se.prediktera.breeze.entry.identifier.Identifier;
import se.prediktera.breeze.entry.identifier.IdentifierList;
import se.prediktera.breeze.entry.measurement.Measurement;
import se.prediktera.breeze.entry.sample.Sample;
import se.prediktera.breeze.entry.sample.SampleSegmentationColumn;
import se.prediktera.breeze.entry.workflow.Workflow;
import se.prediktera.breeze.frontend.common.pp.wizard.PPImportValues;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressManager;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.datasetcontainer.datainfo.Description;
import se.prediktera.map.datasetcontainer.datainfo.InnerColumnString;
import se.prediktera.map.datasetcontainer.dataset.DataSet;
import se.prediktera.map.datasetcontainer.matrix.AbstractDataMatrix;
import se.prediktera.map.main.script.EvinceScriptCommands;

public class ImportFromEvince {
    public ImportFromEvince(List<DataSet> list, Workflow workflow, List<Measurement> list2, List<DataInfo> list3, int n, boolean bl) {
        DataInfo dataInfo = this.getMeasurementInfo(list3);
        for (DataSet dataSet : list) {
            AbstractDataMatrix abstractDataMatrix = dataSet.getOriginalMatrix();
            for (DataInfo dataInfo2 : list3) {
                switch (dataInfo2.type.ordinal()) {
                    case 7: {
                        this.importCategoryFactors(workflow, list2, dataInfo, abstractDataMatrix, dataInfo2, n, bl);
                        break;
                    }
                    case 5: {
                        this.importIdentifiers(workflow, list2, dataInfo, abstractDataMatrix, dataInfo2, n, bl);
                        break;
                    }
                    case 6: {
                        this.importPropertyFactors(workflow, list2, dataInfo, abstractDataMatrix, dataInfo2, n, bl);
                        break;
                    }
                }
            }
        }
    }

    private DataInfo getMeasurementInfo(List<DataInfo> list) {
        for (DataInfo dataInfo : list) {
            if (!dataInfo.type.isPrimary()) continue;
            return dataInfo;
        }
        throw new RuntimeException("No measurement name, sample index/name/class selected");
    }

    private void importIdentifiers(Workflow workflow, List<Measurement> list, DataInfo dataInfo, AbstractDataMatrix abstractDataMatrix, DataInfo dataInfo2, int n, boolean bl) {
        Description description;
        String string;
        IdentifierList identifierList = workflow.getIdentifiers();
        Identifier identifier = identifierList.getIdentifier(string = (description = abstractDataMatrix.getRowDescription()).getColumnName(dataInfo2.column));
        if (identifier == null) {
            identifier = identifierList.add(new Identifier(string));
        }
        if (identifier != null) {
            InnerColumnString innerColumnString = (InnerColumnString)abstractDataMatrix.getRowDescription().getColumn(dataInfo2.column);
            int n2 = 0;
            for (Measurement measurement : list) {
                SampleSegmentationColumn sampleSegmentationColumn;
                MeasurementIndexList measurementIndexList = this.getRowsIndex(abstractDataMatrix, measurement, dataInfo, sampleSegmentationColumn = measurement.getSamples(n), n2, bl);
                if (measurementIndexList.getNumberOfIndex() > 0) {
                    if (measurementIndexList.getNumberOfIndex() > 1 && sampleSegmentationColumn.size() > 1) {
                        for (int i = 0; i < sampleSegmentationColumn.size(); ++i) {
                            this.setIdentifierValueRecursive(identifier, this.getValueOrNull(innerColumnString, measurementIndexList.getIndex(i)), (Sample)sampleSegmentationColumn.get(i));
                        }
                    } else if (sampleSegmentationColumn.size() > 0) {
                        String string2 = this.getValueOrNull(innerColumnString, measurementIndexList.getFirst());
                        for (Sample sample : sampleSegmentationColumn) {
                            this.setIdentifierValueRecursive(identifier, string2, sample);
                        }
                        Object object = (Sample)sampleSegmentationColumn.get(0);
                        while (((BasicSample)object).getParent() != null) {
                            object = (Sample)((BasicSample)object).getParent();
                            this.setIdentifierValueRecursive(identifier, string2, (Sample)object);
                        }
                    }
                }
                measurement.save();
                n2 += sampleSegmentationColumn.size();
            }
        }
    }

    private String getValueOrNull(InnerColumnString innerColumnString, int n) {
        if (n < 0 || n >= innerColumnString.getSize()) {
            return null;
        }
        String string = innerColumnString.getValueLocal(n);
        if (string.equals("MV")) {
            return null;
        }
        return string;
    }

    private void importPropertyFactors(Workflow workflow, List<Measurement> list, DataInfo dataInfo, AbstractDataMatrix abstractDataMatrix, DataInfo dataInfo2, int n, boolean bl) {
        PropertyList propertyList = workflow.getPropertyFactors();
        Description description = abstractDataMatrix.getColumnDescription();
        InnerColumnString innerColumnString = (InnerColumnString)description.getPrimaryColumn();
        String string = innerColumnString.getValueLocal(dataInfo2.column);
        PropertyFactor propertyFactor = (PropertyFactor)FactorHolder.getFactorByName(string, propertyList);
        if (propertyFactor == null) {
            propertyFactor = propertyList.add(new PropertyFactor(string));
            propertyFactor.setUnit("");
        }
        this.setValues(list, dataInfo, propertyFactor, abstractDataMatrix, dataInfo2.column, true, n, bl);
    }

    private void importCategoryFactors(Workflow workflow, List<Measurement> list, DataInfo dataInfo, AbstractDataMatrix abstractDataMatrix, DataInfo dataInfo2, int n, boolean bl) {
        CategoryList categoryList = workflow.getCategoryFactors();
        Description description = abstractDataMatrix.getRowDescription();
        String string = description.getColumnName(dataInfo2.column);
        CategoryFactor categoryFactor = (CategoryFactor)FactorHolder.getFactorByName(string, categoryList);
        if (categoryFactor == null) {
            categoryFactor = categoryList.add(new CategoryFactor(string));
        }
        if (categoryFactor != null) {
            this.setValues(list, dataInfo, categoryFactor, abstractDataMatrix, dataInfo2.column, false, n, bl);
        }
    }

    private void setValues(List<Measurement> list, DataInfo dataInfo, Factor factor, AbstractDataMatrix abstractDataMatrix, int n, boolean bl, int n2, boolean bl2) {
        int n3 = 0;
        for (Measurement measurement : list) {
            SampleSegmentationColumn sampleSegmentationColumn;
            MeasurementIndexList measurementIndexList = this.getRowsIndex(abstractDataMatrix, measurement, dataInfo, sampleSegmentationColumn = measurement.getSamples(n2), n3, bl2);
            if (measurementIndexList.getNumberOfIndex() > 0) {
                if (measurementIndexList.getNumberOfIndex() > 1 && sampleSegmentationColumn.size() > 1) {
                    for (int i = 0; i < sampleSegmentationColumn.size(); ++i) {
                        this.setFactorValueRecursive(factor, this.getValueOrClass(abstractDataMatrix, measurementIndexList.getIndex(i), n, bl), (Sample)sampleSegmentationColumn.get(i));
                    }
                } else if (sampleSegmentationColumn.size() > 0) {
                    String string = this.getValueOrClass(abstractDataMatrix, measurementIndexList.getFirst(), n, bl);
                    for (Sample sample : sampleSegmentationColumn) {
                        this.setFactorValueRecursive(factor, string, sample);
                    }
                    Object object = (Sample)sampleSegmentationColumn.get(0);
                    while (((BasicSample)object).getParent() != null) {
                        object = (Sample)((BasicSample)object).getParent();
                        this.setFactorValueRecursive(factor, string, (Sample)object);
                    }
                }
                measurement.save();
            }
            n3 += sampleSegmentationColumn.size();
        }
    }

    private MeasurementIndexList getRowsIndex(AbstractDataMatrix abstractDataMatrix, Measurement measurement, DataInfo dataInfo, List<Sample> list, int n, boolean bl) {
        MeasurementIndexList measurementIndexList;
        block6: {
            block9: {
                block8: {
                    block7: {
                        block5: {
                            measurementIndexList = new MeasurementIndexList();
                            if (dataInfo.type != ImportType.MeasurementName) break block5;
                            for (int i = 0; i < abstractDataMatrix.getN(); ++i) {
                                if (!ImportFromEvince.equals(measurement.getName(), abstractDataMatrix.getRowDescription(i, dataInfo.column), bl)) continue;
                                measurementIndexList.add(new MeasurementIndex(i));
                            }
                            break block6;
                        }
                        if (dataInfo.type != ImportType.SampleIndex) break block7;
                        for (int i = 0; i < list.size(); ++i) {
                            measurementIndexList.add(new MeasurementIndex(n + i));
                        }
                        break block6;
                    }
                    if (dataInfo.type != ImportType.SampleName) break block8;
                    for (int i = 0; i < list.size(); ++i) {
                        ImportFromEvince.addRowIndexFromSampleName(abstractDataMatrix, dataInfo, measurementIndexList, list.get(i).getRecursiveName(Sample.DefaultSampleLabel.IDX_SAMPLE), bl);
                    }
                    break block6;
                }
                if (dataInfo.type != ImportType.SampleIdentifier) break block9;
                for (int i = 0; i < list.size(); ++i) {
                    ImportFromEvince.addRowIndexFromSampleName(abstractDataMatrix, dataInfo, measurementIndexList, dataInfo.identifier.getTextValue(list.get(i)), bl);
                }
                break block6;
            }
            if (dataInfo.type != ImportType.SampleClass) break block6;
            for (int i = 0; i < list.size(); ++i) {
                ImportFromEvince.addRowIndexFromSampleName(abstractDataMatrix, dataInfo, measurementIndexList, dataInfo.category.getStringValue(list.get(i)), bl);
            }
        }
        return measurementIndexList;
    }

    private static void addRowIndexFromSampleName(AbstractDataMatrix abstractDataMatrix, DataInfo dataInfo, MeasurementIndexList measurementIndexList, String string, boolean bl) {
        for (int i = 0; i < abstractDataMatrix.getN(); ++i) {
            if (!ImportFromEvince.equals(string, abstractDataMatrix.getRowDescription(i, dataInfo.column), bl)) continue;
            measurementIndexList.add(new MeasurementIndex(i));
            return;
        }
        measurementIndexList.add(new MeasurementIndex(-1));
    }

    private static boolean equals(String string, String string2, boolean bl) {
        if (bl) {
            return string.equals(string2);
        }
        return string.equalsIgnoreCase(string2);
    }

    private String getValueOrClass(AbstractDataMatrix abstractDataMatrix, int n, int n2, boolean bl) {
        if (n < 0 || n >= abstractDataMatrix.getN()) {
            return null;
        }
        if (bl) {
            if (abstractDataMatrix.isMissing(n, n2)) {
                return null;
            }
            return String.valueOf(abstractDataMatrix.getValue(n, n2));
        }
        InnerColumnString innerColumnString = (InnerColumnString)abstractDataMatrix.getRowDescription().getColumn(n2);
        if (innerColumnString == null) {
            return null;
        }
        String string = innerColumnString.getValueLocal(n);
        if (string == null || string.equals("MV")) {
            return null;
        }
        return string;
    }

    private void setIdentifierValueRecursive(Identifier identifier, String string, Sample sample) {
        sample.setID(identifier, string);
        for (BasicSample basicSample : sample.getChildList()) {
            this.setIdentifierValueRecursive(identifier, string, (Sample)basicSample);
        }
    }

    private void setFactorValueRecursive(Factor factor, String string, Sample sample) {
        factor.setValue(string, sample);
        for (BasicSample basicSample : sample.getChildList()) {
            this.setFactorValueRecursive(factor, string, (Sample)basicSample);
        }
    }

    public static DataSet loadFile(BreezeProgressManager breezeProgressManager, File file, PPImportValues.Delimiter delimiter) {
        Properties properties = new Properties();
        properties.put("autoidentify", "true");
        properties.put("removezerovariance", "false");
        properties.put("autoexclude", "false");
        properties.put("primaryrow", "1");
        properties.put("primarycolumn", "1");
        properties.put("forcerowdata", "true");
        if (delimiter.isAuto()) {
            String string = FileHelper.getFileExtension(file);
            if (string.equalsIgnoreCase("txt") || string.equalsIgnoreCase("csv")) {
                try {
                    PPImportValues.Delimiter delimiter2 = ImportFromEvince.getDelimiter(Files.readAllLines(file.toPath()));
                    if (!delimiter2.isAuto()) {
                        properties.put("delimiter", delimiter2.getStringValue());
                    }
                }
                catch (IOException iOException) {}
            }
        } else {
            properties.put("delimiter", delimiter.getStringValue());
        }
        return (DataSet)EvinceScriptCommands.load((ProgressManager)breezeProgressManager, (String)file.getAbsolutePath(), (Double[])new Double[]{1.0}, (Double[])new Double[]{1.0}, (Properties)properties);
    }

    public static PPImportValues.Delimiter getDelimiter(List<String> list) {
        for (String string : list) {
            if (string.length() <= 0) continue;
            String string2 = string.toLowerCase();
            int n = string2.indexOf("measurement");
            int n2 = "measurement".length();
            if (n > 0) {
                return PPImportValues.Delimiter.from(string2.charAt(n - 1));
            }
            if (n + n2 + 1 >= string2.length()) continue;
            return PPImportValues.Delimiter.from(string2.charAt(n + n2));
        }
        return PPImportValues.Delimiter.Auto;
    }

    public static class DataInfo {
        public String name;
        public boolean data;
        public int column;
        public Identifier identifier;
        public CategoryFactor category;
        public ImportType type;

        public String toString() {
            return this.name;
        }
    }

    public static enum ImportType {
        MeasurementName,
        SampleIndex,
        SampleName,
        SampleIdentifier,
        SampleClass,
        Identifier,
        PropertyQuantification,
        Category,
        Exclude;


        public String toString() {
            return StringHelper.formatLabel(this.name());
        }

        public boolean isPrimary() {
            return this.equals((Object)MeasurementName) || this.equals((Object)SampleIndex) || this.equals((Object)SampleName) || this.equals((Object)SampleIdentifier) || this.equals((Object)SampleClass);
        }
    }

    private static class MeasurementIndexList {
        public List<MeasurementIndex> indexList = new ArrayList<MeasurementIndex>();

        private MeasurementIndexList() {
        }

        public void add(MeasurementIndex measurementIndex) {
            this.indexList.add(measurementIndex);
        }

        public int getFirst() {
            return this.indexList.get((int)0).row;
        }

        public int getIndex(int n) {
            if (n < this.indexList.size()) {
                return this.indexList.get((int)n).row;
            }
            return -1;
        }

        public int getNumberOfIndex() {
            return this.indexList.size();
        }
    }

    private static class MeasurementIndex {
        public int row;

        public MeasurementIndex(int n) {
            this.row = n;
        }
    }
}

