/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.frontend.common.pp.wizard;

import java.awt.Component;
import java.awt.Font;
import java.awt.image.BufferedImage;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import se.prediktera.breeze.InitClass;
import se.prediktera.breeze.backend.WorkspaceManager;
import se.prediktera.breeze.backend.entry.RtPredictionMode;
import se.prediktera.breeze.backend.realtime.RtFramePredictor;
import se.prediktera.breeze.common.entry.analyse.BasicAnalyse;
import se.prediktera.breeze.common.entry.tree.evaluatetree.impl.NoneEvaluate;
import se.prediktera.breeze.common.entry.tree.functiontree.EvaluationTree;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionHelper;
import se.prediktera.breeze.common.util.BreezeProgress;
import se.prediktera.breeze.common.util.FileHelper;
import se.prediktera.breeze.common.util.RtDataFormat;
import se.prediktera.breeze.common.util.StrayLightManager;
import se.prediktera.breeze.common.util.UniqueUID;
import se.prediktera.breeze.common.util.type.FrameCount;
import se.prediktera.breeze.common.util.xmlproperties.XmlParserHelper;
import se.prediktera.breeze.entry.analyse.model.EvinceModelParameters;
import se.prediktera.breeze.entry.application.RuntimePredictionMode;
import se.prediktera.breeze.entry.measurement.Measurement;
import se.prediktera.breeze.entry.workflow.VisualisationNode;
import se.prediktera.breeze.entry.workflow.Workflow;
import se.prediktera.breeze.frontend.BreezeMainPanel;
import se.prediktera.breeze.frontend.ToastHandler;
import se.prediktera.breeze.frontend.common.entry.EntryMainPanel;
import se.prediktera.breeze.frontend.common.entry.EntryOverviewPanel;
import se.prediktera.breeze.frontend.common.entry.ThumbnailManager;
import se.prediktera.breeze.frontend.common.pp.FileChooserPanel;
import se.prediktera.breeze.frontend.common.pp.PPDescriptionPanel;
import se.prediktera.breeze.frontend.common.pp.wizard.PPExportHtml;
import se.prediktera.breeze.frontend.common.pp.wizard.PPExportSegmentation;
import se.prediktera.breeze.frontend.common.pp.wizard.PPInfo;
import se.prediktera.breeze.frontend.common.pp.wizard.PPTextHelper;
import se.prediktera.breeze.frontend.common.pp.wizard.WizardComponents;
import se.prediktera.breeze.frontend.common.swing.BreezeComboBoxInputField;
import se.prediktera.breeze.frontend.common.swing.BreezeExternalLinkPanel;
import se.prediktera.breeze.frontend.common.swing.BreezeInputField;
import se.prediktera.breeze.frontend.common.swing.BreezeInputFieldHelper;
import se.prediktera.breeze.frontend.common.swing.BreezeTextAreaInputField;
import se.prediktera.breeze.frontend.common.swing.dialog.AbstractBreezeDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeOptionDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressDialog;
import se.prediktera.breeze.frontend.common.swing.dialog.BreezeProgressManager;
import se.prediktera.breeze.frontend.common.swing.validator.NumericMinMaxValidator;
import se.prediktera.breeze.frontend.common.swing.validator.ValidatorResult;
import se.prediktera.breeze.frontend.common.util.BreezeProperties;
import se.prediktera.breeze.frontend.common.util.ImageHelper;
import se.prediktera.breeze.frontend.common.util.xmlproperties.XmlProperties;
import se.prediktera.breeze.frontend.common.view.ViewClass;
import se.prediktera.breeze.frontend.wizard.AbstractWizardPanel;
import se.prediktera.breeze.frontend.wizard.measure.step.WizardStep;
import se.prediktera.breeze.util.ZipManager;
import se.prediktera.map.common.swing.filechooser.jopensaveDialog;

public class PPExportBreezeRuntime
extends AbstractWizardPanel.AbstractExportWizard {
    private final FileChooserPanel fileSelectionPanel;
    private final PPExportSegmentation.SegmentationInputField segmentationComboBox = new PPExportSegmentation.SegmentationInputField();
    private final WizardComponents.ExportInputField<ObjectProcessing> typeComboBox = new WizardComponents.ExportInputField("Object processing");
    private final BreezeInputField nameInputField;
    private final BreezeTextAreaInputField descriptionInputField;
    private final List<BreezeInputField.Number> mandatoryInputFields = new ArrayList<BreezeInputField.Number>();

    public PPExportBreezeRuntime(final EntryMainPanel entryMainPanel, String string, Object object) {
        super(entryMainPanel, entryMainPanel.getPageType(), string, Workflow.getWorkflow(object));
        Object object22;
        Workflow workflow = Workflow.getWorkflow(object);
        this.fileSelectionPanel = new FileChooserPanel(this, "Specify a unique file name for the Runtime workflow", true);
        this.fileSelectionPanel.addExtension(new String[]{"xml"}, "Breeze Runtime xml format");
        this.fileSelectionPanel.addFiltersIntoDialog();
        this.fileSelectionPanel.setMultiSelectionEnabled(false);
        this.fileSelectionPanel.setFileSelectionMode(0);
        File file = new File(WorkspaceManager.getInstance().getWorkspace().getRuntimePath(), PPExportHtml.createDefaultExportFileName(workflow, "xml"));
        file.getParentFile().mkdirs();
        this.fileSelectionPanel.setCurrentDirectory(file.getParentFile());
        this.fileSelectionPanel.setSelectedFile(file);
        this.viewClassList.add(new ViewClass("Export file", PPTextHelper.getChooseFolderDefaultText(), this.fileSelectionPanel));
        PPDescriptionPanel pPDescriptionPanel = new PPDescriptionPanel(this, "Specify segmentation and other settings for the exported workflow snapshot, to use standalone with the Runtime."){
            final /* synthetic */ PPExportBreezeRuntime this$0;
            {
                this.this$0 = pPExportBreezeRuntime;
                super(string);
            }

            @Override
            public void showEntry(Object object, Object object2) {
                super.showEntry(object, object2);
                File file = this.this$0.fileSelectionPanel.approveSelectionAndGetSelectedFile();
                if (file != null) {
                    this.this$0.nameInputField.setText(FileHelper.getFileName(file));
                }
            }

            @Override
            public WizardStep.LeaveResult checkValidContent(WizardStep.WizardControlCallback wizardControlCallback) {
                for (BreezeInputField.Number number : this.this$0.mandatoryInputFields) {
                    boolean bl = PPExportBreezeRuntime.validateField(entryMainPanel, number);
                    if (bl) continue;
                    return WizardStep.LeaveResult.Failed;
                }
                return super.checkValidContent(wizardControlCallback);
            }
        };
        this.viewClassList.add(new ViewClass("Workflow settings", "Setting for export properties", pPDescriptionPanel));
        this.segmentationComboBox.setLabelWidth(120);
        this.segmentationComboBox.init(workflow);
        pPDescriptionPanel.addOption(this.segmentationComboBox);
        pPDescriptionPanel.addOption(this.typeComboBox);
        this.typeComboBox.addItem(ObjectProcessing.Sequential);
        this.typeComboBox.addItem(ObjectProcessing.Parallel);
        this.typeComboBox.selectAndRemember(ObjectProcessing.Parallel);
        this.nameInputField = new BreezeInputField("Name", workflow.getName(), "", BreezeInputFieldHelper.Format.OneRow);
        pPDescriptionPanel.addOption(this.nameInputField);
        this.nameInputField.setLabelWidth(120);
        BreezeComboBoxInputField<RtPredictionMode.PredictionMode> breezeComboBoxInputField = new BreezeComboBoxInputField<RtPredictionMode.PredictionMode>("Data stream mode");
        breezeComboBoxInputField.setRenderer(new RtPredictionMode.PredictionMode.PredictionModeCellRenderer());
        breezeComboBoxInputField.setLabelWidth(120);
        pPDescriptionPanel.addOption(breezeComboBoxInputField);
        for (Object object22 : RtPredictionMode.PredictionMode.values()) {
            breezeComboBoxInputField.addItem((RtPredictionMode.PredictionMode)((Object)object22));
        }
        RuntimePredictionMode runtimePredictionMode = new RuntimePredictionMode(workflow);
        breezeComboBoxInputField.setSelectedItem(runtimePredictionMode.getMode());
        breezeComboBoxInputField.setEnabled(false);
        JLabel jLabel = new JLabel("Change Data stream mode in the project's Options, and learn more about exporting to Runtime in help.");
        Font font = jLabel.getFont();
        jLabel.setFont(new Font(font.getFontName(), font.getStyle(), 14));
        object22 = new BreezeExternalLinkPanel(jLabel, "introduction-to-breeze-runtime-development", true);
        pPDescriptionPanel.addOption((JComponent)object22);
        for (MandatoryRuntimeParameter mandatoryRuntimeParameter : BreezeProperties.getInstance().getParameters(workflow)) {
            BreezeInputField.Number number = new BreezeInputField.Number(mandatoryRuntimeParameter.name, "", mandatoryRuntimeParameter.unit);
            number.addValidator(new NumericMinMaxValidator(mandatoryRuntimeParameter.min, mandatoryRuntimeParameter.max));
            pPDescriptionPanel.addOption(number);
            this.mandatoryInputFields.add(number);
        }
        this.descriptionInputField = new BreezeTextAreaInputField("Description", workflow.getDescription(), true);
        pPDescriptionPanel.addOption(this.descriptionInputField);
        this.setLists(this.viewClassList);
    }

    @Override
    protected void finishWizard() {
        final File file = this.fileSelectionPanel.approveSelectionAndGetSelectedFile();
        if (file != null) {
            BreezeProgressDialog.startProgress(this.getFrame(), new AbstractWizardPanel.WizardProgressAction(this, this){
                final /* synthetic */ PPExportBreezeRuntime this$0;
                {
                    this.this$0 = pPExportBreezeRuntime;
                    super(abstractWizardPanel);
                }

                @Override
                public void runAction() {
                    this.setInfoText("Exporting workflow and connected models to Runtime");
                    String string = this.this$0.nameInputField.getValue();
                    Workflow workflow = Workflow.getWorkflow(this.this$0.entryData);
                    PPExportBreezeRuntime.export(this.getProgressManager(), workflow, string, this.this$0.descriptionInputField.getValue(), file, this.this$0.segmentationComboBox.getSegmentationLevel(), (ObjectProcessing)((Object)this.this$0.typeComboBox.getSelectedItem()), workflow != null && workflow.isIncludeChildObjects(), false, this.this$0.mandatoryInputFields);
                    this.this$0.typeComboBox.remember();
                }
            }, "Export workflow");
        }
    }

    public static void export(BreezeProgress breezeProgress, Workflow workflow, String string, String string2, File file, int n, ObjectProcessing objectProcessing, boolean bl) {
        PPExportBreezeRuntime.export(breezeProgress, workflow, string, string2, file, new RuntimePredictionMode(workflow), n, objectProcessing, bl, true, null, true, true, null);
    }

    public static void export(BreezeProgress breezeProgress, Workflow workflow, String string, String string2, File file, int n, ObjectProcessing objectProcessing, boolean bl, boolean bl2, List<BreezeInputField.Number> list) {
        PPExportBreezeRuntime.export(breezeProgress, workflow, string, string2, file, new RuntimePredictionMode(workflow), n, objectProcessing, bl, bl2, list, true, true, null);
    }

    public static void export(BreezeProgress breezeProgress, Workflow workflow, String string, String string2, File file, RtPredictionMode rtPredictionMode, int n, ObjectProcessing objectProcessing, boolean bl, boolean bl2, List<BreezeInputField.Number> list, boolean bl3, boolean bl4, List<FrameCount> list2) {
        BufferedImage bufferedImage;
        Object object;
        Element element;
        Document document = XmlParserHelper.createXMLdoc();
        Element element2 = XmlParserHelper.addRoot("breezeapi", document);
        element2.setAttribute("id", UniqueUID.getUniqueId());
        element2.setAttribute("sourceversion", InitClass.getBreezeVersion().format(false));
        element2.setAttribute("createdby", BreezeProperties.getInstance().getLoginUser().getUsername());
        element2.setAttribute("createddate", new SimpleDateFormat("yyyyMMddHHmmss").format(new Date()));
        element2.setAttribute("name", string);
        element2.setAttribute("xmlns:xsi", "Prediktera.XML.BreezeAPIXml");
        Element element3 = XmlParserHelper.addElement(element2, "settings");
        XmlParserHelper.addElement((Node)element3, "maxlines", String.valueOf(PPExportBreezeRuntime.getMaxLines(workflow.getMaxLines(), list2)));
        XmlParserHelper.addElement((Node)element3, "minPixels", String.valueOf(workflow.getMinPixels()));
        XmlParserHelper.addElement((Node)element3, "parallelMeasurementSegmentation", String.valueOf(objectProcessing.boolValue()));
        XmlParserHelper.addElement((Node)element3, "segmentationLevel", String.valueOf(n));
        XmlParserHelper.addElement((Node)element3, "studyId", workflow.getStudyId());
        XmlParserHelper.addElement((Node)element3, "defaultUnit", workflow.getDefaultUnit().name());
        XmlParserHelper.addElement((Node)element3, "description", string2);
        XmlParserHelper.addElement((Node)element3, "applyValueCorrection", String.valueOf(workflow.isValueCorrectionPixels()));
        VisualisationNode.ColorScale colorScale = workflow.getColorScale();
        Element element4 = XmlParserHelper.addElement((Node)element3, "colorScale", colorScale.name);
        XmlParserHelper.setAttribute((Node)element4, "reverse", colorScale.reverse);
        Element element5 = XmlParserHelper.addElement((Node)element3, "imageHistogram", RtDataFormat.toString(workflow.getImageHistogramPerctage()));
        XmlParserHelper.setAttribute((Node)element5, "bucketSize", workflow.getImageHistogramBucketSize());
        XmlParserHelper.setAttribute((Node)element5, "normalizeMin", workflow.getImageHistogramNormalizeMin());
        XmlParserHelper.setAttribute((Node)element5, "strechAll", workflow.getImageHistogramStrechAll());
        XmlParserHelper.setAttribute((Node)element5, "range", workflow.getImageHistogramRange());
        XmlParserHelper.setAttribute((Node)element5, "enable", workflow.getImageHistogramEnable());
        XmlParserHelper.setAttribute((Node)element5, "minBands", workflow.getImageHistogramMinBands());
        XmlParserHelper.addElement((Node)element3, "includeChildObjects", String.valueOf(bl));
        Element element6 = XmlParserHelper.addElement((Node)element3, "referenceConvertTo", String.valueOf((Object)workflow.getReferenceConvertTo()));
        XmlParserHelper.setAttribute((Node)element6, "maxSaturatedBand", workflow.getMaxSaturatedBand());
        XmlParserHelper.addElement((Node)element3, "compressReferences", String.valueOf(workflow.isCompressReferences()));
        String string3 = workflow.getStrayLightFile();
        if (string3 != null && !string3.isEmpty()) {
            StrayLightManager.addStraylightToElement(string3, element3);
        }
        if (list != null && !list.isEmpty()) {
            element = XmlParserHelper.addElement(element3, "mandatoryFields");
            for (BreezeInputField.Number object22 : list) {
                object = XmlParserHelper.addElement((Node)element, "field", object22.getValue());
                object.setAttribute("name", object22.getDescription());
                object.setAttribute("unit", object22.getUnit());
            }
        }
        rtPredictionMode.save(element3);
        element = XmlParserHelper.addElement(element3, "visualization");
        element.setAttribute("direction", workflow.getVisualisationDirection());
        element.setAttribute("horizontalDirection", workflow.getVisualisationHorizontalDirection());
        element.setAttribute("verticalDirection", workflow.getVisualisationVerticalDirection());
        Measurement measurement = workflow.getFirstMeasurementWithData();
        if (measurement != null && bl4 && (bufferedImage = ThumbnailManager.getInstance(EntryOverviewPanel.ImageSize).getCustomIconImage(measurement.getThumbnailFile(), null)) != null) {
            XmlParserHelper.addElement((Node)element3, "thumbnail", ImageHelper.imgToBase64String(bufferedImage));
        }
        List<BasicAnalyse> list3 = workflow.getConnectedAnalysis(bl2);
        workflow.getComments().addComments(element2);
        workflow.getIdentifiers().addIdentifiers(element2);
        workflow.getFactorHolder().addVariableDef(element2);
        if (bl3) {
            object = workflow.getAnalyseTree();
            ((EvaluationTree)object).save(element2, bl2);
            for (BasicAnalyse basicAnalyse : list3) {
                basicAnalyse.checkFullyParsed();
                EvinceModelParameters evinceModelParameters = new EvinceModelParameters(breezeProgress, workflow, basicAnalyse);
                Element element7 = XmlParserHelper.addElement(element2, "analyse");
                element7.setAttribute("name", basicAnalyse.getName());
                element7.setAttribute("id", basicAnalyse.getUid());
                element7.setAttribute("version", String.valueOf(basicAnalyse.getVersion()));
                element7.setAttribute("method", basicAnalyse.getModelMethod().name());
                RtFramePredictor.ReferenceConvertTo referenceConvertTo = basicAnalyse.getConvertTo();
                if (referenceConvertTo != null) {
                    element7.setAttribute("convertTo", referenceConvertTo.name());
                }
                basicAnalyse.getFactorHolder().addVariableDef(element7);
                evinceModelParameters.save(element7);
            }
            ((EvaluationTree)object).forEveryFunction((functionTreeNode, abstractBreezeFunction) -> {
                if (functionTreeNode.isEnabled()) {
                    abstractBreezeFunction.preRequisiteRuntimeExport(breezeProgress);
                }
            });
        } else {
            new EvaluationTree(FunctionHelper.createNew(new NoneEvaluate.Info())).save(element2, bl2);
        }
        XmlProperties.createDirectoriesAndOutputXML(file, document);
    }

    private static int getMaxLines(int n, List<FrameCount> list) {
        int n2;
        if (list != null && !list.isEmpty() && (n2 = list.stream().mapToInt(FrameCount::getValue).max().orElse(0)) > 0) {
            return Math.min(n2, n);
        }
        return n;
    }

    public static boolean validateField(EntryMainPanel entryMainPanel, BreezeInputField.Number number) {
        if (number.getValue().isEmpty()) {
            BreezeOptionDialog.showDialog(entryMainPanel, AbstractBreezeDialog.MessageType.INFORMATION_OPTION, "Mandatory field", number.getDescription() + " is a mandatory input field", breezeActionEvent -> SwingUtilities.invokeLater(number::requestFocusAndSelectAll));
            return false;
        }
        ValidatorResult validatorResult = number.getTextField().validateText(number.getValue());
        if (validatorResult != null) {
            BreezeOptionDialog.showDialog(entryMainPanel, AbstractBreezeDialog.MessageType.INFORMATION_OPTION, "Input is not valid", number.getDescription() + " input is not valid\n\nReason: " + validatorResult.getResult(), breezeActionEvent -> SwingUtilities.invokeLater(number::requestFocusAndSelectAll));
            return false;
        }
        return true;
    }

    public static void exportRuntimeWorkspace(EntryMainPanel entryMainPanel) {
        jopensaveDialog jopensaveDialog2 = new jopensaveDialog("Export Breeze Runtime workspace", (Component)entryMainPanel);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd_HH_mm");
        jopensaveDialog2.setFileName("BreezeRuntime_Workspace_" + simpleDateFormat.format(new Date()) + ".zip");
        if (jopensaveDialog2.saveshow()) {
            WorkspaceManager.Workspace workspace = WorkspaceManager.getInstance().getWorkspace();
            File file = jopensaveDialog2.getSelectedFile();
            ZipManager zipManager = new ZipManager(file);
            zipManager.addFile(workspace.getBreezeProperties());
            zipManager.addFolder(workspace.getRuntimePath(), "Data");
            zipManager.perform(BreezeProgressManager.createEmpty());
            ToastHandler.getInstance().showToast(entryMainPanel.getFrame(), "Breeze Runtime workspace exported");
            FileHelper.openExplorerOnPath(file.getParentFile());
        }
    }

    public static enum ObjectProcessing {
        Sequential,
        Parallel;


        public static ObjectProcessing parse(boolean bl) {
            if (bl) {
                return Parallel;
            }
            return Sequential;
        }

        public boolean boolValue() {
            return this.equals((Object)Parallel);
        }
    }

    public static class MandatoryRuntimeParameter {
        public String name;
        public String unit;
        public float min;
        public float max;
        public float step;
        public float value;

        public MandatoryRuntimeParameter(String string, float f, float f2, float f3, float f4, String string2) {
            this.name = string;
            this.min = f;
            this.max = f2;
            this.unit = string2;
            this.value = f4;
        }

        public String toString() {
            return this.name + " " + RtDataFormat.toString(this.value) + this.unit;
        }
    }

    public static class Info
    extends PPInfo.PPExportInfo {
        @Override
        public String getDescription() {
            return "A snapshot of the workflow and connected models are exported to run standalone in Breeze Runtime";
        }

        @Override
        public String getName() {
            return "Breeze Runtime";
        }

        @Override
        public BreezeMainPanel createWizard(EntryMainPanel entryMainPanel, String string, Object object) {
            return new PPExportBreezeRuntime(entryMainPanel, string, object);
        }
    }
}

